import typing, clr, abc
from System import ReadOnlySpan_1, Array_1, Span_1, ArgumentException, Exception, ICloneable, ISpanFormattable, IEquatable_1, IComparable_1, IComparable, Decimal, ReadOnlyMemory_1, IFormatProvider
from System.Collections import IDictionary
from System.Reflection import MethodBase
from System.IO import Stream
from System.Collections.Generic import IEnumerable_1, IEnumerator_1
from System.Buffers import OperationStatus
from System.Globalization import UnicodeCategory, CultureInfo
from System.Runtime.Serialization import ISerializable

class ASCIIEncoding(Encoding):
    def __init__(self) -> None: ...
    @property
    def BodyName(self) -> str: ...
    @property
    def CodePage(self) -> int: ...
    @property
    def DecoderFallback(self) -> DecoderFallback: ...
    @DecoderFallback.setter
    def DecoderFallback(self, value: DecoderFallback) -> DecoderFallback: ...
    @property
    def EncoderFallback(self) -> EncoderFallback: ...
    @EncoderFallback.setter
    def EncoderFallback(self, value: EncoderFallback) -> EncoderFallback: ...
    @property
    def EncodingName(self) -> str: ...
    @property
    def HeaderName(self) -> str: ...
    @property
    def IsBrowserDisplay(self) -> bool: ...
    @property
    def IsBrowserSave(self) -> bool: ...
    @property
    def IsMailNewsDisplay(self) -> bool: ...
    @property
    def IsMailNewsSave(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @IsReadOnly.setter
    def IsReadOnly(self, value: bool) -> bool: ...
    @property
    def IsSingleByte(self) -> bool: ...
    @property
    def Preamble(self) -> ReadOnlySpan_1[int]: ...
    @property
    def WebName(self) -> str: ...
    @property
    def WindowsCodePage(self) -> int: ...
    def GetDecoder(self) -> Decoder: ...
    def GetEncoder(self) -> Encoder: ...
    def GetMaxByteCount(self, charCount: int) -> int: ...
    def GetMaxCharCount(self, byteCount: int) -> int: ...
    def GetString(self, bytes: Array_1[int], byteIndex: int, byteCount: int) -> str: ...
    # Skipped GetByteCount due to it being static, abstract and generic.

    GetByteCount : GetByteCount_MethodGroup
    class GetByteCount_MethodGroup:
        @typing.overload
        def __call__(self, chars: ReadOnlySpan_1[str]) -> int:...
        @typing.overload
        def __call__(self, chars: str) -> int:...
        @typing.overload
        def __call__(self, chars: clr.Reference[str], count: int) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], index: int, count: int) -> int:...

    # Skipped GetBytes due to it being static, abstract and generic.

    GetBytes : GetBytes_MethodGroup
    class GetBytes_MethodGroup:
        @typing.overload
        def __call__(self, chars: ReadOnlySpan_1[str], bytes: Span_1[int]) -> int:...
        @typing.overload
        def __call__(self, chars: clr.Reference[str], charCount: int, bytes: clr.Reference[int], byteCount: int) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int) -> int:...
        @typing.overload
        def __call__(self, chars: str, charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int) -> int:...

    # Skipped GetCharCount due to it being static, abstract and generic.

    GetCharCount : GetCharCount_MethodGroup
    class GetCharCount_MethodGroup:
        @typing.overload
        def __call__(self, bytes: ReadOnlySpan_1[int]) -> int:...
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], count: int) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], index: int, count: int) -> int:...

    # Skipped GetChars due to it being static, abstract and generic.

    GetChars : GetChars_MethodGroup
    class GetChars_MethodGroup:
        @typing.overload
        def __call__(self, bytes: ReadOnlySpan_1[int], chars: Span_1[str]) -> int:...
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], byteCount: int, chars: clr.Reference[str], charCount: int) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], byteIndex: int, byteCount: int, chars: Array_1[str], charIndex: int) -> int:...



class Decoder(abc.ABC):
    @property
    def Fallback(self) -> DecoderFallback: ...
    @Fallback.setter
    def Fallback(self, value: DecoderFallback) -> DecoderFallback: ...
    @property
    def FallbackBuffer(self) -> DecoderFallbackBuffer: ...
    def Reset(self) -> None: ...
    # Skipped Convert due to it being static, abstract and generic.

    Convert : Convert_MethodGroup
    class Convert_MethodGroup:
        @typing.overload
        def __call__(self, bytes: ReadOnlySpan_1[int], chars: Span_1[str], flush: bool, bytesUsed: clr.Reference[int], charsUsed: clr.Reference[int], completed: clr.Reference[bool]) -> None:...
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], byteCount: int, chars: clr.Reference[str], charCount: int, flush: bool, bytesUsed: clr.Reference[int], charsUsed: clr.Reference[int], completed: clr.Reference[bool]) -> None:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], byteIndex: int, byteCount: int, chars: Array_1[str], charIndex: int, charCount: int, flush: bool, bytesUsed: clr.Reference[int], charsUsed: clr.Reference[int], completed: clr.Reference[bool]) -> None:...

    # Skipped GetCharCount due to it being static, abstract and generic.

    GetCharCount : GetCharCount_MethodGroup
    class GetCharCount_MethodGroup:
        @typing.overload
        def __call__(self, bytes: ReadOnlySpan_1[int], flush: bool) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], index: int, count: int) -> int:...
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], count: int, flush: bool) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], index: int, count: int, flush: bool) -> int:...

    # Skipped GetChars due to it being static, abstract and generic.

    GetChars : GetChars_MethodGroup
    class GetChars_MethodGroup:
        @typing.overload
        def __call__(self, bytes: ReadOnlySpan_1[int], chars: Span_1[str], flush: bool) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], byteIndex: int, byteCount: int, chars: Array_1[str], charIndex: int) -> int:...
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], byteCount: int, chars: clr.Reference[str], charCount: int, flush: bool) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], byteIndex: int, byteCount: int, chars: Array_1[str], charIndex: int, flush: bool) -> int:...



class DecoderExceptionFallback(DecoderFallback):
    def __init__(self) -> None: ...
    @property
    def MaxCharCount(self) -> int: ...
    def CreateFallbackBuffer(self) -> DecoderFallbackBuffer: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...


class DecoderExceptionFallbackBuffer(DecoderFallbackBuffer):
    def __init__(self) -> None: ...
    @property
    def Remaining(self) -> int: ...
    def Fallback(self, bytesUnknown: Array_1[int], index: int) -> bool: ...
    def GetNextChar(self) -> str: ...
    def MovePrevious(self) -> bool: ...


class DecoderFallback(abc.ABC):
    @classmethod
    @property
    def ExceptionFallback(cls) -> DecoderFallback: ...
    @property
    def MaxCharCount(self) -> int: ...
    @classmethod
    @property
    def ReplacementFallback(cls) -> DecoderFallback: ...
    @abc.abstractmethod
    def CreateFallbackBuffer(self) -> DecoderFallbackBuffer: ...


class DecoderFallbackBuffer(abc.ABC):
    @property
    def Remaining(self) -> int: ...
    @abc.abstractmethod
    def Fallback(self, bytesUnknown: Array_1[int], index: int) -> bool: ...
    @abc.abstractmethod
    def GetNextChar(self) -> str: ...
    @abc.abstractmethod
    def MovePrevious(self) -> bool: ...
    def Reset(self) -> None: ...


class DecoderFallbackException(ArgumentException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, bytesUnknown: Array_1[int], index: int) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def BytesUnknown(self) -> Array_1[int]: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def Index(self) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def ParamName(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class DecoderReplacementFallback(DecoderFallback):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, replacement: str) -> None: ...
    @property
    def DefaultString(self) -> str: ...
    @property
    def MaxCharCount(self) -> int: ...
    def CreateFallbackBuffer(self) -> DecoderFallbackBuffer: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...


class DecoderReplacementFallbackBuffer(DecoderFallbackBuffer):
    def __init__(self, fallback: DecoderReplacementFallback) -> None: ...
    @property
    def Remaining(self) -> int: ...
    def Fallback(self, bytesUnknown: Array_1[int], index: int) -> bool: ...
    def GetNextChar(self) -> str: ...
    def MovePrevious(self) -> bool: ...
    def Reset(self) -> None: ...


class Encoder(abc.ABC):
    @property
    def Fallback(self) -> EncoderFallback: ...
    @Fallback.setter
    def Fallback(self, value: EncoderFallback) -> EncoderFallback: ...
    @property
    def FallbackBuffer(self) -> EncoderFallbackBuffer: ...
    def Reset(self) -> None: ...
    # Skipped Convert due to it being static, abstract and generic.

    Convert : Convert_MethodGroup
    class Convert_MethodGroup:
        @typing.overload
        def __call__(self, chars: ReadOnlySpan_1[str], bytes: Span_1[int], flush: bool, charsUsed: clr.Reference[int], bytesUsed: clr.Reference[int], completed: clr.Reference[bool]) -> None:...
        @typing.overload
        def __call__(self, chars: clr.Reference[str], charCount: int, bytes: clr.Reference[int], byteCount: int, flush: bool, charsUsed: clr.Reference[int], bytesUsed: clr.Reference[int], completed: clr.Reference[bool]) -> None:...
        @typing.overload
        def __call__(self, chars: Array_1[str], charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int, byteCount: int, flush: bool, charsUsed: clr.Reference[int], bytesUsed: clr.Reference[int], completed: clr.Reference[bool]) -> None:...

    # Skipped GetByteCount due to it being static, abstract and generic.

    GetByteCount : GetByteCount_MethodGroup
    class GetByteCount_MethodGroup:
        @typing.overload
        def __call__(self, chars: ReadOnlySpan_1[str], flush: bool) -> int:...
        @typing.overload
        def __call__(self, chars: clr.Reference[str], count: int, flush: bool) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], index: int, count: int, flush: bool) -> int:...

    # Skipped GetBytes due to it being static, abstract and generic.

    GetBytes : GetBytes_MethodGroup
    class GetBytes_MethodGroup:
        @typing.overload
        def __call__(self, chars: ReadOnlySpan_1[str], bytes: Span_1[int], flush: bool) -> int:...
        @typing.overload
        def __call__(self, chars: clr.Reference[str], charCount: int, bytes: clr.Reference[int], byteCount: int, flush: bool) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int, flush: bool) -> int:...



class EncoderExceptionFallback(EncoderFallback):
    def __init__(self) -> None: ...
    @property
    def MaxCharCount(self) -> int: ...
    def CreateFallbackBuffer(self) -> EncoderFallbackBuffer: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...


class EncoderExceptionFallbackBuffer(EncoderFallbackBuffer):
    def __init__(self) -> None: ...
    @property
    def Remaining(self) -> int: ...
    def GetNextChar(self) -> str: ...
    def MovePrevious(self) -> bool: ...
    # Skipped Fallback due to it being static, abstract and generic.

    Fallback : Fallback_MethodGroup
    class Fallback_MethodGroup:
        @typing.overload
        def __call__(self, charUnknown: str, index: int) -> bool:...
        @typing.overload
        def __call__(self, charUnknownHigh: str, charUnknownLow: str, index: int) -> bool:...



class EncoderFallback(abc.ABC):
    @classmethod
    @property
    def ExceptionFallback(cls) -> EncoderFallback: ...
    @property
    def MaxCharCount(self) -> int: ...
    @classmethod
    @property
    def ReplacementFallback(cls) -> EncoderFallback: ...
    @abc.abstractmethod
    def CreateFallbackBuffer(self) -> EncoderFallbackBuffer: ...


class EncoderFallbackBuffer(abc.ABC):
    @property
    def Remaining(self) -> int: ...
    @abc.abstractmethod
    def GetNextChar(self) -> str: ...
    @abc.abstractmethod
    def MovePrevious(self) -> bool: ...
    def Reset(self) -> None: ...
    # Skipped Fallback due to it being static, abstract and generic.

    Fallback : Fallback_MethodGroup
    class Fallback_MethodGroup:
        @typing.overload
        def __call__(self, charUnknown: str, index: int) -> bool:...
        @typing.overload
        def __call__(self, charUnknownHigh: str, charUnknownLow: str, index: int) -> bool:...



class EncoderFallbackException(ArgumentException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def CharUnknown(self) -> str: ...
    @property
    def CharUnknownHigh(self) -> str: ...
    @property
    def CharUnknownLow(self) -> str: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def Index(self) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def ParamName(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...
    def IsUnknownSurrogate(self) -> bool: ...


class EncoderReplacementFallback(EncoderFallback):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, replacement: str) -> None: ...
    @property
    def DefaultString(self) -> str: ...
    @property
    def MaxCharCount(self) -> int: ...
    def CreateFallbackBuffer(self) -> EncoderFallbackBuffer: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetHashCode(self) -> int: ...


class EncoderReplacementFallbackBuffer(EncoderFallbackBuffer):
    def __init__(self, fallback: EncoderReplacementFallback) -> None: ...
    @property
    def Remaining(self) -> int: ...
    def GetNextChar(self) -> str: ...
    def MovePrevious(self) -> bool: ...
    def Reset(self) -> None: ...
    # Skipped Fallback due to it being static, abstract and generic.

    Fallback : Fallback_MethodGroup
    class Fallback_MethodGroup:
        @typing.overload
        def __call__(self, charUnknown: str, index: int) -> bool:...
        @typing.overload
        def __call__(self, charUnknownHigh: str, charUnknownLow: str, index: int) -> bool:...



class Encoding(ICloneable, abc.ABC):
    @classmethod
    @property
    def ASCII(cls) -> Encoding: ...
    @classmethod
    @property
    def BigEndianUnicode(cls) -> Encoding: ...
    @property
    def BodyName(self) -> str: ...
    @property
    def CodePage(self) -> int: ...
    @property
    def DecoderFallback(self) -> DecoderFallback: ...
    @DecoderFallback.setter
    def DecoderFallback(self, value: DecoderFallback) -> DecoderFallback: ...
    @classmethod
    @property
    def Default(cls) -> Encoding: ...
    @property
    def EncoderFallback(self) -> EncoderFallback: ...
    @EncoderFallback.setter
    def EncoderFallback(self, value: EncoderFallback) -> EncoderFallback: ...
    @property
    def EncodingName(self) -> str: ...
    @property
    def HeaderName(self) -> str: ...
    @property
    def IsBrowserDisplay(self) -> bool: ...
    @property
    def IsBrowserSave(self) -> bool: ...
    @property
    def IsMailNewsDisplay(self) -> bool: ...
    @property
    def IsMailNewsSave(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @IsReadOnly.setter
    def IsReadOnly(self, value: bool) -> bool: ...
    @property
    def IsSingleByte(self) -> bool: ...
    @classmethod
    @property
    def Latin1(cls) -> Encoding: ...
    @property
    def Preamble(self) -> ReadOnlySpan_1[int]: ...
    @classmethod
    @property
    def Unicode(cls) -> Encoding: ...
    @classmethod
    @property
    def UTF32(cls) -> Encoding: ...
    @classmethod
    @property
    def UTF7(cls) -> Encoding: ...
    @classmethod
    @property
    def UTF8(cls) -> Encoding: ...
    @property
    def WebName(self) -> str: ...
    @property
    def WindowsCodePage(self) -> int: ...
    def Clone(self) -> typing.Any: ...
    @staticmethod
    def CreateTranscodingStream(innerStream: Stream, innerStreamEncoding: Encoding, outerStreamEncoding: Encoding, leaveOpen: bool = ...) -> Stream: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetDecoder(self) -> Decoder: ...
    def GetEncoder(self) -> Encoder: ...
    @staticmethod
    def GetEncodings() -> Array_1[EncodingInfo]: ...
    def GetHashCode(self) -> int: ...
    @abc.abstractmethod
    def GetMaxByteCount(self, charCount: int) -> int: ...
    @abc.abstractmethod
    def GetMaxCharCount(self, byteCount: int) -> int: ...
    def GetPreamble(self) -> Array_1[int]: ...
    @staticmethod
    def RegisterProvider(provider: EncodingProvider) -> None: ...
    # Skipped Convert due to it being static, abstract and generic.

    Convert : Convert_MethodGroup
    class Convert_MethodGroup:
        @typing.overload
        def __call__(self, srcEncoding: Encoding, dstEncoding: Encoding, bytes: Array_1[int]) -> Array_1[int]:...
        @typing.overload
        def __call__(self, srcEncoding: Encoding, dstEncoding: Encoding, bytes: Array_1[int], index: int, count: int) -> Array_1[int]:...

    # Skipped GetByteCount due to it being static, abstract and generic.

    GetByteCount : GetByteCount_MethodGroup
    class GetByteCount_MethodGroup:
        @typing.overload
        def __call__(self, chars: Array_1[str]) -> int:...
        @typing.overload
        def __call__(self, chars: ReadOnlySpan_1[str]) -> int:...
        @typing.overload
        def __call__(self, s: str) -> int:...
        @typing.overload
        def __call__(self, chars: clr.Reference[str], count: int) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], index: int, count: int) -> int:...
        @typing.overload
        def __call__(self, s: str, index: int, count: int) -> int:...

    # Skipped GetBytes due to it being static, abstract and generic.

    GetBytes : GetBytes_MethodGroup
    class GetBytes_MethodGroup:
        @typing.overload
        def __call__(self, chars: Array_1[str]) -> Array_1[int]:...
        @typing.overload
        def __call__(self, s: str) -> Array_1[int]:...
        @typing.overload
        def __call__(self, chars: ReadOnlySpan_1[str], bytes: Span_1[int]) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], index: int, count: int) -> Array_1[int]:...
        @typing.overload
        def __call__(self, s: str, index: int, count: int) -> Array_1[int]:...
        @typing.overload
        def __call__(self, chars: clr.Reference[str], charCount: int, bytes: clr.Reference[int], byteCount: int) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int) -> int:...
        @typing.overload
        def __call__(self, s: str, charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int) -> int:...

    # Skipped GetCharCount due to it being static, abstract and generic.

    GetCharCount : GetCharCount_MethodGroup
    class GetCharCount_MethodGroup:
        @typing.overload
        def __call__(self, bytes: Array_1[int]) -> int:...
        @typing.overload
        def __call__(self, bytes: ReadOnlySpan_1[int]) -> int:...
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], count: int) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], index: int, count: int) -> int:...

    # Skipped GetChars due to it being static, abstract and generic.

    GetChars : GetChars_MethodGroup
    class GetChars_MethodGroup:
        @typing.overload
        def __call__(self, bytes: Array_1[int]) -> Array_1[str]:...
        @typing.overload
        def __call__(self, bytes: ReadOnlySpan_1[int], chars: Span_1[str]) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], index: int, count: int) -> Array_1[str]:...
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], byteCount: int, chars: clr.Reference[str], charCount: int) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], byteIndex: int, byteCount: int, chars: Array_1[str], charIndex: int) -> int:...

    # Skipped GetEncoding due to it being static, abstract and generic.

    GetEncoding : GetEncoding_MethodGroup
    class GetEncoding_MethodGroup:
        @typing.overload
        def __call__(self, codepage: int) -> Encoding:...
        @typing.overload
        def __call__(self, name: str) -> Encoding:...
        @typing.overload
        def __call__(self, codepage: int, encoderFallback: EncoderFallback, decoderFallback: DecoderFallback) -> Encoding:...
        @typing.overload
        def __call__(self, name: str, encoderFallback: EncoderFallback, decoderFallback: DecoderFallback) -> Encoding:...

    # Skipped GetString due to it being static, abstract and generic.

    GetString : GetString_MethodGroup
    class GetString_MethodGroup:
        @typing.overload
        def __call__(self, bytes: Array_1[int]) -> str:...
        @typing.overload
        def __call__(self, bytes: ReadOnlySpan_1[int]) -> str:...
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], byteCount: int) -> str:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], index: int, count: int) -> str:...

    # Skipped IsAlwaysNormalized due to it being static, abstract and generic.

    IsAlwaysNormalized : IsAlwaysNormalized_MethodGroup
    class IsAlwaysNormalized_MethodGroup:
        @typing.overload
        def __call__(self) -> bool:...
        @typing.overload
        def __call__(self, form: NormalizationForm) -> bool:...



class EncodingInfo:
    def __init__(self, provider: EncodingProvider, codePage: int, name: str, displayName: str) -> None: ...
    @property
    def CodePage(self) -> int: ...
    @property
    def DisplayName(self) -> str: ...
    @property
    def Name(self) -> str: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetEncoding(self) -> Encoding: ...
    def GetHashCode(self) -> int: ...


class EncodingProvider(abc.ABC):
    def __init__(self) -> None: ...
    def GetEncodings(self) -> IEnumerable_1[EncodingInfo]: ...
    # Skipped GetEncoding due to it being static, abstract and generic.

    GetEncoding : GetEncoding_MethodGroup
    class GetEncoding_MethodGroup:
        @typing.overload
        def __call__(self, codepage: int) -> Encoding:...
        @typing.overload
        def __call__(self, name: str) -> Encoding:...
        @typing.overload
        def __call__(self, codepage: int, encoderFallback: EncoderFallback, decoderFallback: DecoderFallback) -> Encoding:...
        @typing.overload
        def __call__(self, name: str, encoderFallback: EncoderFallback, decoderFallback: DecoderFallback) -> Encoding:...



class NormalizationForm(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    FormC : NormalizationForm # 1
    FormD : NormalizationForm # 2
    FormKC : NormalizationForm # 5
    FormKD : NormalizationForm # 6


class Rune(ISpanFormattable, IEquatable_1[Rune], IComparable_1[Rune], IComparable_0):
    # Constructor .ctor(value : UInt32) was skipped since it collides with above method
    @typing.overload
    def __init__(self, ch: str) -> None: ...
    @typing.overload
    def __init__(self, highSurrogate: str, lowSurrogate: str) -> None: ...
    @typing.overload
    def __init__(self, value: int) -> None: ...
    @property
    def IsAscii(self) -> bool: ...
    @property
    def IsBmp(self) -> bool: ...
    @property
    def Plane(self) -> int: ...
    @classmethod
    @property
    def ReplacementChar(cls) -> Rune: ...
    @property
    def Utf16SequenceLength(self) -> int: ...
    @property
    def Utf8SequenceLength(self) -> int: ...
    @property
    def Value(self) -> int: ...
    def CompareTo(self, other: Rune) -> int: ...
    @staticmethod
    def DecodeFromUtf16(source: ReadOnlySpan_1[str], result: clr.Reference[Rune], charsConsumed: clr.Reference[int]) -> OperationStatus: ...
    @staticmethod
    def DecodeFromUtf8(source: ReadOnlySpan_1[int], result: clr.Reference[Rune], bytesConsumed: clr.Reference[int]) -> OperationStatus: ...
    @staticmethod
    def DecodeLastFromUtf16(source: ReadOnlySpan_1[str], result: clr.Reference[Rune], charsConsumed: clr.Reference[int]) -> OperationStatus: ...
    @staticmethod
    def DecodeLastFromUtf8(source: ReadOnlySpan_1[int], value: clr.Reference[Rune], bytesConsumed: clr.Reference[int]) -> OperationStatus: ...
    def EncodeToUtf16(self, destination: Span_1[str]) -> int: ...
    def EncodeToUtf8(self, destination: Span_1[int]) -> int: ...
    def GetHashCode(self) -> int: ...
    @staticmethod
    def GetNumericValue(value: Rune) -> float: ...
    @staticmethod
    def GetRuneAt(input: str, index: int) -> Rune: ...
    @staticmethod
    def GetUnicodeCategory(value: Rune) -> UnicodeCategory: ...
    @staticmethod
    def IsControl(value: Rune) -> bool: ...
    @staticmethod
    def IsDigit(value: Rune) -> bool: ...
    @staticmethod
    def IsLetter(value: Rune) -> bool: ...
    @staticmethod
    def IsLetterOrDigit(value: Rune) -> bool: ...
    @staticmethod
    def IsLower(value: Rune) -> bool: ...
    @staticmethod
    def IsNumber(value: Rune) -> bool: ...
    @staticmethod
    def IsPunctuation(value: Rune) -> bool: ...
    @staticmethod
    def IsSeparator(value: Rune) -> bool: ...
    @staticmethod
    def IsSymbol(value: Rune) -> bool: ...
    @staticmethod
    def IsUpper(value: Rune) -> bool: ...
    @staticmethod
    def IsWhiteSpace(value: Rune) -> bool: ...
    def __eq__(self, left: Rune, right: Rune) -> bool: ...
    # Operator not supported op_Explicit(ch: Char)
    # Operator not supported op_Explicit(value: UInt32)
    # Operator not supported op_Explicit(value: Int32)
    def __gt__(self, left: Rune, right: Rune) -> bool: ...
    def __ge__(self, left: Rune, right: Rune) -> bool: ...
    def __ne__(self, left: Rune, right: Rune) -> bool: ...
    def __lt__(self, left: Rune, right: Rune) -> bool: ...
    def __le__(self, left: Rune, right: Rune) -> bool: ...
    @staticmethod
    def ToLower(value: Rune, culture: CultureInfo) -> Rune: ...
    @staticmethod
    def ToLowerInvariant(value: Rune) -> Rune: ...
    def ToString(self) -> str: ...
    @staticmethod
    def ToUpper(value: Rune, culture: CultureInfo) -> Rune: ...
    @staticmethod
    def ToUpperInvariant(value: Rune) -> Rune: ...
    def TryEncodeToUtf16(self, destination: Span_1[str], charsWritten: clr.Reference[int]) -> bool: ...
    def TryEncodeToUtf8(self, destination: Span_1[int], bytesWritten: clr.Reference[int]) -> bool: ...
    @staticmethod
    def TryGetRuneAt(input: str, index: int, value: clr.Reference[Rune]) -> bool: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, other: Rune) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any) -> bool:...

    # Skipped IsValid due to it being static, abstract and generic.

    IsValid : IsValid_MethodGroup
    class IsValid_MethodGroup:
        def __call__(self, value: int) -> bool:...
        # Method IsValid(value : UInt32) was skipped since it collides with above method

    # Skipped TryCreate due to it being static, abstract and generic.

    TryCreate : TryCreate_MethodGroup
    class TryCreate_MethodGroup:
        @typing.overload
        def __call__(self, ch: str, result: clr.Reference[Rune]) -> bool:...
        @typing.overload
        def __call__(self, value: int, result: clr.Reference[Rune]) -> bool:...
        # Method TryCreate(value : UInt32, result : Rune&) was skipped since it collides with above method
        @typing.overload
        def __call__(self, highSurrogate: str, lowSurrogate: str, result: clr.Reference[Rune]) -> bool:...



class SpanLineEnumerator:
    @property
    def Current(self) -> ReadOnlySpan_1[str]: ...
    def GetEnumerator(self) -> SpanLineEnumerator: ...
    def MoveNext(self) -> bool: ...


class SpanRuneEnumerator:
    @property
    def Current(self) -> Rune: ...
    def GetEnumerator(self) -> SpanRuneEnumerator: ...
    def MoveNext(self) -> bool: ...


class StringBuilder(ISerializable):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, capacity: int) -> None: ...
    @typing.overload
    def __init__(self, capacity: int, maxCapacity: int) -> None: ...
    @typing.overload
    def __init__(self, value: str) -> None: ...
    @typing.overload
    def __init__(self, value: str, capacity: int) -> None: ...
    @typing.overload
    def __init__(self, value: str, startIndex: int, length: int, capacity: int) -> None: ...
    @property
    def Capacity(self) -> int: ...
    @Capacity.setter
    def Capacity(self, value: int) -> int: ...
    @property
    def Chars(self) -> str: ...
    @Chars.setter
    def Chars(self, value: str) -> str: ...
    @property
    def Length(self) -> int: ...
    @Length.setter
    def Length(self, value: int) -> int: ...
    @property
    def MaxCapacity(self) -> int: ...
    def Clear(self) -> StringBuilder: ...
    def EnsureCapacity(self, capacity: int) -> int: ...
    def GetChunks(self) -> StringBuilder.ChunkEnumerator: ...
    def Remove(self, startIndex: int, length: int) -> StringBuilder: ...
    # Skipped Append due to it being static, abstract and generic.

    Append : Append_MethodGroup
    class Append_MethodGroup:
        @typing.overload
        def __call__(self, value: float) -> StringBuilder:...
        # Method Append(value : Double) was skipped since it collides with above method
        @typing.overload
        def __call__(self, value: str) -> StringBuilder:...
        # Method Append(value : SByte) was skipped since it collides with above method
        # Method Append(value : Byte) was skipped since it collides with above method
        # Method Append(value : Int16) was skipped since it collides with above method
        # Method Append(value : Int32) was skipped since it collides with above method
        # Method Append(value : Int64) was skipped since it collides with above method
        # Method Append(value : UInt16) was skipped since it collides with above method
        # Method Append(value : UInt32) was skipped since it collides with above method
        # Method Append(value : UInt64) was skipped since it collides with above method
        @typing.overload
        def __call__(self, value: Decimal) -> StringBuilder:...
        @typing.overload
        def __call__(self, value: Array_1[str]) -> StringBuilder:...
        @typing.overload
        def __call__(self, value: ReadOnlySpan_1[str]) -> StringBuilder:...
        @typing.overload
        def __call__(self, value: ReadOnlyMemory_1[str]) -> StringBuilder:...
        # Method Append(value : String) was skipped since it collides with above method
        # Method Append(value : Boolean) was skipped since it collides with above method
        @typing.overload
        def __call__(self, value: StringBuilder) -> StringBuilder:...
        @typing.overload
        def __call__(self, handler: clr.Reference[StringBuilder.AppendInterpolatedStringHandler]) -> StringBuilder:...
        @typing.overload
        def __call__(self, value: typing.Any) -> StringBuilder:...
        @typing.overload
        def __call__(self, value: str, repeatCount: int) -> StringBuilder:...
        @typing.overload
        def __call__(self, value: clr.Reference[str], valueCount: int) -> StringBuilder:...
        @typing.overload
        def __call__(self, provider: IFormatProvider, handler: clr.Reference[StringBuilder.AppendInterpolatedStringHandler]) -> StringBuilder:...
        @typing.overload
        def __call__(self, value: Array_1[str], startIndex: int, charCount: int) -> StringBuilder:...
        @typing.overload
        def __call__(self, value: str, startIndex: int, count: int) -> StringBuilder:...
        @typing.overload
        def __call__(self, value: StringBuilder, startIndex: int, count: int) -> StringBuilder:...

    # Skipped AppendFormat due to it being static, abstract and generic.

    AppendFormat : AppendFormat_MethodGroup
    class AppendFormat_MethodGroup:
        @typing.overload
        def __call__(self, format: str, args: Array_1[typing.Any]) -> StringBuilder:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any) -> StringBuilder:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any, arg1: typing.Any) -> StringBuilder:...
        @typing.overload
        def __call__(self, provider: IFormatProvider, format: str, args: Array_1[typing.Any]) -> StringBuilder:...
        @typing.overload
        def __call__(self, provider: IFormatProvider, format: str, arg0: typing.Any) -> StringBuilder:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any, arg1: typing.Any, arg2: typing.Any) -> StringBuilder:...
        @typing.overload
        def __call__(self, provider: IFormatProvider, format: str, arg0: typing.Any, arg1: typing.Any) -> StringBuilder:...
        @typing.overload
        def __call__(self, provider: IFormatProvider, format: str, arg0: typing.Any, arg1: typing.Any, arg2: typing.Any) -> StringBuilder:...

    # Skipped AppendJoin due to it being static, abstract and generic.

    AppendJoin : AppendJoin_MethodGroup
    class AppendJoin_MethodGroup:
        def __getitem__(self, t:typing.Type[AppendJoin_1_T1]) -> AppendJoin_1[AppendJoin_1_T1]: ...

        AppendJoin_1_T1 = typing.TypeVar('AppendJoin_1_T1')
        class AppendJoin_1(typing.Generic[AppendJoin_1_T1]):
            AppendJoin_1_T = StringBuilder.AppendJoin_MethodGroup.AppendJoin_1_T1
            def __call__(self, separator: str, values: IEnumerable_1[AppendJoin_1_T]) -> StringBuilder:...
            # Method AppendJoin(separator : Char, values : IEnumerable`1) was skipped since it collides with above method

        @typing.overload
        def __call__(self, separator: str, values: Array_1[str]) -> StringBuilder:...
        # Method AppendJoin(separator : Char, values : String[]) was skipped since it collides with above method
        @typing.overload
        def __call__(self, separator: str, values: Array_1[typing.Any]) -> StringBuilder:...
        # Method AppendJoin(separator : Char, values : Object[]) was skipped since it collides with above method

    # Skipped AppendLine due to it being static, abstract and generic.

    AppendLine : AppendLine_MethodGroup
    class AppendLine_MethodGroup:
        @typing.overload
        def __call__(self) -> StringBuilder:...
        @typing.overload
        def __call__(self, value: str) -> StringBuilder:...
        @typing.overload
        def __call__(self, handler: clr.Reference[StringBuilder.AppendInterpolatedStringHandler]) -> StringBuilder:...
        @typing.overload
        def __call__(self, provider: IFormatProvider, handler: clr.Reference[StringBuilder.AppendInterpolatedStringHandler]) -> StringBuilder:...

    # Skipped CopyTo due to it being static, abstract and generic.

    CopyTo : CopyTo_MethodGroup
    class CopyTo_MethodGroup:
        @typing.overload
        def __call__(self, sourceIndex: int, destination: Span_1[str], count: int) -> None:...
        @typing.overload
        def __call__(self, sourceIndex: int, destination: Array_1[str], destinationIndex: int, count: int) -> None:...

    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, span: ReadOnlySpan_1[str]) -> bool:...
        @typing.overload
        def __call__(self, sb: StringBuilder) -> bool:...

    # Skipped Insert due to it being static, abstract and generic.

    Insert : Insert_MethodGroup
    class Insert_MethodGroup:
        @typing.overload
        def __call__(self, index: int, value: float) -> StringBuilder:...
        # Method Insert(index : Int32, value : Single) was skipped since it collides with above method
        # Method Insert(index : Int32, value : UInt16) was skipped since it collides with above method
        # Method Insert(index : Int32, value : UInt32) was skipped since it collides with above method
        # Method Insert(index : Int32, value : UInt64) was skipped since it collides with above method
        # Method Insert(index : Int32, value : SByte) was skipped since it collides with above method
        # Method Insert(index : Int32, value : Byte) was skipped since it collides with above method
        # Method Insert(index : Int32, value : Int16) was skipped since it collides with above method
        @typing.overload
        def __call__(self, index: int, value: str) -> StringBuilder:...
        # Method Insert(index : Int32, value : Int32) was skipped since it collides with above method
        # Method Insert(index : Int32, value : Int64) was skipped since it collides with above method
        @typing.overload
        def __call__(self, index: int, value: Decimal) -> StringBuilder:...
        @typing.overload
        def __call__(self, index: int, value: Array_1[str]) -> StringBuilder:...
        @typing.overload
        def __call__(self, index: int, value: ReadOnlySpan_1[str]) -> StringBuilder:...
        # Method Insert(index : Int32, value : String) was skipped since it collides with above method
        # Method Insert(index : Int32, value : Boolean) was skipped since it collides with above method
        @typing.overload
        def __call__(self, index: int, value: typing.Any) -> StringBuilder:...
        @typing.overload
        def __call__(self, index: int, value: str, count: int) -> StringBuilder:...
        @typing.overload
        def __call__(self, index: int, value: Array_1[str], startIndex: int, charCount: int) -> StringBuilder:...

    # Skipped Replace due to it being static, abstract and generic.

    Replace : Replace_MethodGroup
    class Replace_MethodGroup:
        @typing.overload
        def __call__(self, oldChar: str, newChar: str) -> StringBuilder:...
        # Method Replace(oldValue : String, newValue : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, oldChar: str, newChar: str, startIndex: int, count: int) -> StringBuilder:...
        # Method Replace(oldValue : String, newValue : String, startIndex : Int32, count : Int32) was skipped since it collides with above method

    # Skipped ToString due to it being static, abstract and generic.

    ToString : ToString_MethodGroup
    class ToString_MethodGroup:
        @typing.overload
        def __call__(self) -> str:...
        @typing.overload
        def __call__(self, startIndex: int, length: int) -> str:...


    class AppendInterpolatedStringHandler:
        @typing.overload
        def __init__(self, literalLength: int, formattedCount: int, stringBuilder: StringBuilder) -> None: ...
        @typing.overload
        def __init__(self, literalLength: int, formattedCount: int, stringBuilder: StringBuilder, provider: IFormatProvider) -> None: ...
        def AppendLiteral(self, value: str) -> None: ...
        # Skipped AppendFormatted due to it being static, abstract and generic.

        AppendFormatted : AppendFormatted_MethodGroup
        class AppendFormatted_MethodGroup:
            def __getitem__(self, t:typing.Type[AppendFormatted_1_T1]) -> AppendFormatted_1[AppendFormatted_1_T1]: ...

            AppendFormatted_1_T1 = typing.TypeVar('AppendFormatted_1_T1')
            class AppendFormatted_1(typing.Generic[AppendFormatted_1_T1]):
                AppendFormatted_1_T = StringBuilder.AppendInterpolatedStringHandler.AppendFormatted_MethodGroup.AppendFormatted_1_T1
                @typing.overload
                def __call__(self, value: AppendFormatted_1_T) -> None:...
                @typing.overload
                def __call__(self, value: AppendFormatted_1_T, alignment: int) -> None:...
                @typing.overload
                def __call__(self, value: AppendFormatted_1_T, format: str) -> None:...
                @typing.overload
                def __call__(self, value: AppendFormatted_1_T, alignment: int, format: str) -> None:...

            @typing.overload
            def __call__(self, value: ReadOnlySpan_1[str]) -> None:...
            @typing.overload
            def __call__(self, value: str) -> None:...
            @typing.overload
            def __call__(self, value: ReadOnlySpan_1[str], alignment: int = ..., format: str = ...) -> None:...
            @typing.overload
            def __call__(self, value: str, alignment: int = ..., format: str = ...) -> None:...
            @typing.overload
            def __call__(self, value: typing.Any, alignment: int = ..., format: str = ...) -> None:...



    class ChunkEnumerator:
        @property
        def Current(self) -> ReadOnlyMemory_1[str]: ...
        def GetEnumerator(self) -> StringBuilder.ChunkEnumerator: ...
        def MoveNext(self) -> bool: ...



class StringRuneEnumerator(IEnumerator_1[Rune], IEnumerable_1[Rune]):
    @property
    def Current(self) -> Rune: ...
    def GetEnumerator(self) -> StringRuneEnumerator: ...
    def MoveNext(self) -> bool: ...


class UnicodeEncoding(Encoding):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, bigEndian: bool, byteOrderMark: bool) -> None: ...
    @typing.overload
    def __init__(self, bigEndian: bool, byteOrderMark: bool, throwOnInvalidBytes: bool) -> None: ...
    CharSize : int
    @property
    def BodyName(self) -> str: ...
    @property
    def CodePage(self) -> int: ...
    @property
    def DecoderFallback(self) -> DecoderFallback: ...
    @DecoderFallback.setter
    def DecoderFallback(self, value: DecoderFallback) -> DecoderFallback: ...
    @property
    def EncoderFallback(self) -> EncoderFallback: ...
    @EncoderFallback.setter
    def EncoderFallback(self, value: EncoderFallback) -> EncoderFallback: ...
    @property
    def EncodingName(self) -> str: ...
    @property
    def HeaderName(self) -> str: ...
    @property
    def IsBrowserDisplay(self) -> bool: ...
    @property
    def IsBrowserSave(self) -> bool: ...
    @property
    def IsMailNewsDisplay(self) -> bool: ...
    @property
    def IsMailNewsSave(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @IsReadOnly.setter
    def IsReadOnly(self, value: bool) -> bool: ...
    @property
    def IsSingleByte(self) -> bool: ...
    @property
    def Preamble(self) -> ReadOnlySpan_1[int]: ...
    @property
    def WebName(self) -> str: ...
    @property
    def WindowsCodePage(self) -> int: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetDecoder(self) -> Decoder: ...
    def GetEncoder(self) -> Encoder: ...
    def GetHashCode(self) -> int: ...
    def GetMaxByteCount(self, charCount: int) -> int: ...
    def GetMaxCharCount(self, byteCount: int) -> int: ...
    def GetPreamble(self) -> Array_1[int]: ...
    def GetString(self, bytes: Array_1[int], index: int, count: int) -> str: ...
    # Skipped GetByteCount due to it being static, abstract and generic.

    GetByteCount : GetByteCount_MethodGroup
    class GetByteCount_MethodGroup:
        @typing.overload
        def __call__(self, s: str) -> int:...
        @typing.overload
        def __call__(self, chars: clr.Reference[str], count: int) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], index: int, count: int) -> int:...

    # Skipped GetBytes due to it being static, abstract and generic.

    GetBytes : GetBytes_MethodGroup
    class GetBytes_MethodGroup:
        @typing.overload
        def __call__(self, chars: clr.Reference[str], charCount: int, bytes: clr.Reference[int], byteCount: int) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int) -> int:...
        @typing.overload
        def __call__(self, s: str, charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int) -> int:...

    # Skipped GetCharCount due to it being static, abstract and generic.

    GetCharCount : GetCharCount_MethodGroup
    class GetCharCount_MethodGroup:
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], count: int) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], index: int, count: int) -> int:...

    # Skipped GetChars due to it being static, abstract and generic.

    GetChars : GetChars_MethodGroup
    class GetChars_MethodGroup:
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], byteCount: int, chars: clr.Reference[str], charCount: int) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], byteIndex: int, byteCount: int, chars: Array_1[str], charIndex: int) -> int:...



class UTF32Encoding(Encoding):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, bigEndian: bool, byteOrderMark: bool) -> None: ...
    @typing.overload
    def __init__(self, bigEndian: bool, byteOrderMark: bool, throwOnInvalidCharacters: bool) -> None: ...
    @property
    def BodyName(self) -> str: ...
    @property
    def CodePage(self) -> int: ...
    @property
    def DecoderFallback(self) -> DecoderFallback: ...
    @DecoderFallback.setter
    def DecoderFallback(self, value: DecoderFallback) -> DecoderFallback: ...
    @property
    def EncoderFallback(self) -> EncoderFallback: ...
    @EncoderFallback.setter
    def EncoderFallback(self, value: EncoderFallback) -> EncoderFallback: ...
    @property
    def EncodingName(self) -> str: ...
    @property
    def HeaderName(self) -> str: ...
    @property
    def IsBrowserDisplay(self) -> bool: ...
    @property
    def IsBrowserSave(self) -> bool: ...
    @property
    def IsMailNewsDisplay(self) -> bool: ...
    @property
    def IsMailNewsSave(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @IsReadOnly.setter
    def IsReadOnly(self, value: bool) -> bool: ...
    @property
    def IsSingleByte(self) -> bool: ...
    @property
    def Preamble(self) -> ReadOnlySpan_1[int]: ...
    @property
    def WebName(self) -> str: ...
    @property
    def WindowsCodePage(self) -> int: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetDecoder(self) -> Decoder: ...
    def GetEncoder(self) -> Encoder: ...
    def GetHashCode(self) -> int: ...
    def GetMaxByteCount(self, charCount: int) -> int: ...
    def GetMaxCharCount(self, byteCount: int) -> int: ...
    def GetPreamble(self) -> Array_1[int]: ...
    def GetString(self, bytes: Array_1[int], index: int, count: int) -> str: ...
    # Skipped GetByteCount due to it being static, abstract and generic.

    GetByteCount : GetByteCount_MethodGroup
    class GetByteCount_MethodGroup:
        @typing.overload
        def __call__(self, s: str) -> int:...
        @typing.overload
        def __call__(self, chars: clr.Reference[str], count: int) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], index: int, count: int) -> int:...

    # Skipped GetBytes due to it being static, abstract and generic.

    GetBytes : GetBytes_MethodGroup
    class GetBytes_MethodGroup:
        @typing.overload
        def __call__(self, chars: clr.Reference[str], charCount: int, bytes: clr.Reference[int], byteCount: int) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int) -> int:...
        @typing.overload
        def __call__(self, s: str, charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int) -> int:...

    # Skipped GetCharCount due to it being static, abstract and generic.

    GetCharCount : GetCharCount_MethodGroup
    class GetCharCount_MethodGroup:
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], count: int) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], index: int, count: int) -> int:...

    # Skipped GetChars due to it being static, abstract and generic.

    GetChars : GetChars_MethodGroup
    class GetChars_MethodGroup:
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], byteCount: int, chars: clr.Reference[str], charCount: int) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], byteIndex: int, byteCount: int, chars: Array_1[str], charIndex: int) -> int:...



class UTF7Encoding(Encoding):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, allowOptionals: bool) -> None: ...
    @property
    def BodyName(self) -> str: ...
    @property
    def CodePage(self) -> int: ...
    @property
    def DecoderFallback(self) -> DecoderFallback: ...
    @DecoderFallback.setter
    def DecoderFallback(self, value: DecoderFallback) -> DecoderFallback: ...
    @property
    def EncoderFallback(self) -> EncoderFallback: ...
    @EncoderFallback.setter
    def EncoderFallback(self, value: EncoderFallback) -> EncoderFallback: ...
    @property
    def EncodingName(self) -> str: ...
    @property
    def HeaderName(self) -> str: ...
    @property
    def IsBrowserDisplay(self) -> bool: ...
    @property
    def IsBrowserSave(self) -> bool: ...
    @property
    def IsMailNewsDisplay(self) -> bool: ...
    @property
    def IsMailNewsSave(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @IsReadOnly.setter
    def IsReadOnly(self, value: bool) -> bool: ...
    @property
    def IsSingleByte(self) -> bool: ...
    @property
    def Preamble(self) -> ReadOnlySpan_1[int]: ...
    @property
    def WebName(self) -> str: ...
    @property
    def WindowsCodePage(self) -> int: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetDecoder(self) -> Decoder: ...
    def GetEncoder(self) -> Encoder: ...
    def GetHashCode(self) -> int: ...
    def GetMaxByteCount(self, charCount: int) -> int: ...
    def GetMaxCharCount(self, byteCount: int) -> int: ...
    def GetString(self, bytes: Array_1[int], index: int, count: int) -> str: ...
    # Skipped GetByteCount due to it being static, abstract and generic.

    GetByteCount : GetByteCount_MethodGroup
    class GetByteCount_MethodGroup:
        @typing.overload
        def __call__(self, s: str) -> int:...
        @typing.overload
        def __call__(self, chars: clr.Reference[str], count: int) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], index: int, count: int) -> int:...

    # Skipped GetBytes due to it being static, abstract and generic.

    GetBytes : GetBytes_MethodGroup
    class GetBytes_MethodGroup:
        @typing.overload
        def __call__(self, chars: clr.Reference[str], charCount: int, bytes: clr.Reference[int], byteCount: int) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int) -> int:...
        @typing.overload
        def __call__(self, s: str, charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int) -> int:...

    # Skipped GetCharCount due to it being static, abstract and generic.

    GetCharCount : GetCharCount_MethodGroup
    class GetCharCount_MethodGroup:
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], count: int) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], index: int, count: int) -> int:...

    # Skipped GetChars due to it being static, abstract and generic.

    GetChars : GetChars_MethodGroup
    class GetChars_MethodGroup:
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], byteCount: int, chars: clr.Reference[str], charCount: int) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], byteIndex: int, byteCount: int, chars: Array_1[str], charIndex: int) -> int:...



class UTF8Encoding(Encoding):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, encoderShouldEmitUTF8Identifier: bool) -> None: ...
    @typing.overload
    def __init__(self, encoderShouldEmitUTF8Identifier: bool, throwOnInvalidBytes: bool) -> None: ...
    @property
    def BodyName(self) -> str: ...
    @property
    def CodePage(self) -> int: ...
    @property
    def DecoderFallback(self) -> DecoderFallback: ...
    @DecoderFallback.setter
    def DecoderFallback(self, value: DecoderFallback) -> DecoderFallback: ...
    @property
    def EncoderFallback(self) -> EncoderFallback: ...
    @EncoderFallback.setter
    def EncoderFallback(self, value: EncoderFallback) -> EncoderFallback: ...
    @property
    def EncodingName(self) -> str: ...
    @property
    def HeaderName(self) -> str: ...
    @property
    def IsBrowserDisplay(self) -> bool: ...
    @property
    def IsBrowserSave(self) -> bool: ...
    @property
    def IsMailNewsDisplay(self) -> bool: ...
    @property
    def IsMailNewsSave(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @IsReadOnly.setter
    def IsReadOnly(self, value: bool) -> bool: ...
    @property
    def IsSingleByte(self) -> bool: ...
    @property
    def Preamble(self) -> ReadOnlySpan_1[int]: ...
    @property
    def WebName(self) -> str: ...
    @property
    def WindowsCodePage(self) -> int: ...
    def Equals(self, value: typing.Any) -> bool: ...
    def GetDecoder(self) -> Decoder: ...
    def GetEncoder(self) -> Encoder: ...
    def GetHashCode(self) -> int: ...
    def GetMaxByteCount(self, charCount: int) -> int: ...
    def GetMaxCharCount(self, byteCount: int) -> int: ...
    def GetPreamble(self) -> Array_1[int]: ...
    def GetString(self, bytes: Array_1[int], index: int, count: int) -> str: ...
    # Skipped GetByteCount due to it being static, abstract and generic.

    GetByteCount : GetByteCount_MethodGroup
    class GetByteCount_MethodGroup:
        @typing.overload
        def __call__(self, chars: ReadOnlySpan_1[str]) -> int:...
        @typing.overload
        def __call__(self, chars: str) -> int:...
        @typing.overload
        def __call__(self, chars: clr.Reference[str], count: int) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], index: int, count: int) -> int:...

    # Skipped GetBytes due to it being static, abstract and generic.

    GetBytes : GetBytes_MethodGroup
    class GetBytes_MethodGroup:
        @typing.overload
        def __call__(self, chars: ReadOnlySpan_1[str], bytes: Span_1[int]) -> int:...
        @typing.overload
        def __call__(self, chars: clr.Reference[str], charCount: int, bytes: clr.Reference[int], byteCount: int) -> int:...
        @typing.overload
        def __call__(self, chars: Array_1[str], charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int) -> int:...
        @typing.overload
        def __call__(self, s: str, charIndex: int, charCount: int, bytes: Array_1[int], byteIndex: int) -> int:...

    # Skipped GetCharCount due to it being static, abstract and generic.

    GetCharCount : GetCharCount_MethodGroup
    class GetCharCount_MethodGroup:
        @typing.overload
        def __call__(self, bytes: ReadOnlySpan_1[int]) -> int:...
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], count: int) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], index: int, count: int) -> int:...

    # Skipped GetChars due to it being static, abstract and generic.

    GetChars : GetChars_MethodGroup
    class GetChars_MethodGroup:
        @typing.overload
        def __call__(self, bytes: ReadOnlySpan_1[int], chars: Span_1[str]) -> int:...
        @typing.overload
        def __call__(self, bytes: clr.Reference[int], byteCount: int, chars: clr.Reference[str], charCount: int) -> int:...
        @typing.overload
        def __call__(self, bytes: Array_1[int], byteIndex: int, byteCount: int, chars: Array_1[str], charIndex: int) -> int:...


