import sys
from ctypes import *
import platform
from .types import *
from ._platform import DLL_PATH, is_windows


def load_libtiepie():
    """Load libtiepie library and import all functions."""

    if is_windows:
        from ctypes.wintypes import HANDLE, HWND, LPARAM, WPARAM

    api = CDLL(DLL_PATH)

    api.LibInit.restype = None
    api.LibInit.argtypes = []
    api.LibIsInitialized.restype = c_uint8
    api.LibIsInitialized.argtypes = []
    api.LibExit.restype = None
    api.LibExit.argtypes = []
    api.LibGetVersion.restype = c_uint64
    api.LibGetVersion.argtypes = []
    api.LibGetVersionExtra.restype = c_char_p
    api.LibGetVersionExtra.argtypes = []
    api.LibGetConfig.restype = c_uint32
    api.LibGetConfig.argtypes = [c_void_p, c_uint32]
    api.LibGetLastStatus.restype = c_int32
    api.LibGetLastStatus.argtypes = []
    api.LibGetLastStatusStr.restype = c_char_p
    api.LibGetLastStatusStr.argtypes = []
    api.LstUpdate.restype = None
    api.LstUpdate.argtypes = []
    api.LstGetCount.restype = c_uint32
    api.LstGetCount.argtypes = []
    api.LstOpenDevice.restype = c_uint32
    api.LstOpenDevice.argtypes = [c_uint32, c_uint32, c_uint32]
    api.LstOpenOscilloscope.restype = c_uint32
    api.LstOpenOscilloscope.argtypes = [c_uint32, c_uint32]
    api.LstOpenGenerator.restype = c_uint32
    api.LstOpenGenerator.argtypes = [c_uint32, c_uint32]
    api.LstOpenI2CHost.restype = c_uint32
    api.LstOpenI2CHost.argtypes = [c_uint32, c_uint32]
    api.LstCreateCombinedDevice.restype = c_uint32
    api.LstCreateCombinedDevice.argtypes = [c_void_p, c_uint32]
    api.LstCreateAndOpenCombinedDevice.restype = c_uint32
    api.LstCreateAndOpenCombinedDevice.argtypes = [c_void_p, c_uint32]
    api.LstRemoveDevice.restype = None
    api.LstRemoveDevice.argtypes = [c_uint32]
    api.LstDevCanOpen.restype = c_uint8
    api.LstDevCanOpen.argtypes = [c_uint32, c_uint32, c_uint32]
    api.LstDevGetProductId.restype = c_uint32
    api.LstDevGetProductId.argtypes = [c_uint32, c_uint32]
    api.LstDevGetVendorId.restype = c_uint32
    api.LstDevGetVendorId.argtypes = [c_uint32, c_uint32]
    api.LstDevGetName.restype = c_uint32
    api.LstDevGetName.argtypes = [c_uint32, c_uint32, c_char_p, c_uint32]
    api.LstDevGetNameShort.restype = c_uint32
    api.LstDevGetNameShort.argtypes = [c_uint32, c_uint32, c_char_p, c_uint32]
    api.LstDevGetNameShortest.restype = c_uint32
    api.LstDevGetNameShortest.argtypes = [c_uint32, c_uint32, c_char_p, c_uint32]
    api.LstDevGetDriverVersion.restype = c_uint64
    api.LstDevGetDriverVersion.argtypes = [c_uint32, c_uint32]
    api.LstDevGetRecommendedDriverVersion.restype = c_uint64
    api.LstDevGetRecommendedDriverVersion.argtypes = [c_uint32, c_uint32]
    api.LstDevGetFirmwareVersion.restype = c_uint64
    api.LstDevGetFirmwareVersion.argtypes = [c_uint32, c_uint32]
    api.LstDevGetRecommendedFirmwareVersion.restype = c_uint64
    api.LstDevGetRecommendedFirmwareVersion.argtypes = [c_uint32, c_uint32]
    api.LstDevGetCalibrationDate.restype = c_uint32
    api.LstDevGetCalibrationDate.argtypes = [c_uint32, c_uint32]
    api.LstDevGetSerialNumber.restype = c_uint32
    api.LstDevGetSerialNumber.argtypes = [c_uint32, c_uint32]
    api.LstDevGetIPv4Address.restype = c_uint32
    api.LstDevGetIPv4Address.argtypes = [c_uint32, c_uint32]
    api.LstDevGetIPPort.restype = c_uint16
    api.LstDevGetIPPort.argtypes = [c_uint32, c_uint32]
    api.LstDevHasServer.restype = c_uint8
    api.LstDevHasServer.argtypes = [c_uint32, c_uint32]
    api.LstDevGetServer.restype = c_uint32
    api.LstDevGetServer.argtypes = [c_uint32, c_uint32]
    api.LstDevGetTypes.restype = c_uint32
    api.LstDevGetTypes.argtypes = [c_uint32, c_uint32]
    api.LstDevGetContainedSerialNumbers.restype = c_uint32
    api.LstDevGetContainedSerialNumbers.argtypes = [c_uint32, c_uint32, c_void_p, c_uint32]
    api.LstCbDevGetProductId.restype = c_uint32
    api.LstCbDevGetProductId.argtypes = [c_uint32, c_uint32, c_uint32]
    api.LstCbDevGetVendorId.restype = c_uint32
    api.LstCbDevGetVendorId.argtypes = [c_uint32, c_uint32, c_uint32]
    api.LstCbDevGetName.restype = c_uint32
    api.LstCbDevGetName.argtypes = [c_uint32, c_uint32, c_uint32, c_char_p, c_uint32]
    api.LstCbDevGetNameShort.restype = c_uint32
    api.LstCbDevGetNameShort.argtypes = [c_uint32, c_uint32, c_uint32, c_char_p, c_uint32]
    api.LstCbDevGetNameShortest.restype = c_uint32
    api.LstCbDevGetNameShortest.argtypes = [c_uint32, c_uint32, c_uint32, c_char_p, c_uint32]
    api.LstCbDevGetDriverVersion.restype = c_uint64
    api.LstCbDevGetDriverVersion.argtypes = [c_uint32, c_uint32, c_uint32]
    api.LstCbDevGetFirmwareVersion.restype = c_uint64
    api.LstCbDevGetFirmwareVersion.argtypes = [c_uint32, c_uint32, c_uint32]
    api.LstCbDevGetCalibrationDate.restype = c_uint32
    api.LstCbDevGetCalibrationDate.argtypes = [c_uint32, c_uint32, c_uint32]
    api.LstCbScpGetChannelCount.restype = c_uint16
    api.LstCbScpGetChannelCount.argtypes = [c_uint32, c_uint32, c_uint32]
    api.LstSetCallbackDeviceAdded.restype = None
    api.LstSetCallbackDeviceAdded.argtypes = [CallbackDeviceList, c_void_p]
    api.LstSetCallbackDeviceRemoved.restype = None
    api.LstSetCallbackDeviceRemoved.argtypes = [CallbackDeviceList, c_void_p]
    api.LstSetCallbackDeviceCanOpenChanged.restype = None
    api.LstSetCallbackDeviceCanOpenChanged.argtypes = [CallbackDeviceList, c_void_p]
    if platform.system() == 'Linux':
        api.LstSetEventDeviceAdded.restype = None
        api.LstSetEventDeviceAdded.argtypes = [c_int]
        api.LstSetEventDeviceRemoved.restype = None
        api.LstSetEventDeviceRemoved.argtypes = [c_int]
        api.LstSetEventDeviceCanOpenChanged.restype = None
        api.LstSetEventDeviceCanOpenChanged.argtypes = [c_int]
    if platform.system() == 'Windows':
        api.LstSetEventDeviceAdded.restype = None
        api.LstSetEventDeviceAdded.argtypes = [HANDLE]
        api.LstSetEventDeviceRemoved.restype = None
        api.LstSetEventDeviceRemoved.argtypes = [HANDLE]
        api.LstSetEventDeviceCanOpenChanged.restype = None
        api.LstSetEventDeviceCanOpenChanged.argtypes = [HANDLE]
        api.LstSetMessageDeviceAdded.restype = None
        api.LstSetMessageDeviceAdded.argtypes = [HWND]
        api.LstSetMessageDeviceRemoved.restype = None
        api.LstSetMessageDeviceRemoved.argtypes = [HWND]
        api.LstSetMessageDeviceCanOpenChanged.restype = None
        api.LstSetMessageDeviceCanOpenChanged.argtypes = [HWND]
    api.NetGetAutoDetectEnabled.restype = c_uint8
    api.NetGetAutoDetectEnabled.argtypes = []
    api.NetSetAutoDetectEnabled.restype = c_uint8
    api.NetSetAutoDetectEnabled.argtypes = [c_uint8]
    api.NetSrvAdd.restype = c_uint8
    api.NetSrvAdd.argtypes = [c_char_p, c_uint32, c_void_p]
    api.NetSrvRemove.restype = c_uint8
    api.NetSrvRemove.argtypes = [c_char_p, c_uint32, c_uint8]
    api.NetSrvGetCount.restype = c_uint32
    api.NetSrvGetCount.argtypes = []
    api.NetSrvGetByIndex.restype = c_uint32
    api.NetSrvGetByIndex.argtypes = [c_uint32]
    api.NetSrvGetByURL.restype = c_uint32
    api.NetSrvGetByURL.argtypes = [c_char_p, c_uint32]
    api.NetSrvSetCallbackAdded.restype = None
    api.NetSrvSetCallbackAdded.argtypes = [CallbackHandle, c_void_p]
    if platform.system() == 'Linux':
        api.NetSrvSetEventAdded.restype = None
        api.NetSrvSetEventAdded.argtypes = [c_int]
    if platform.system() == 'Windows':
        api.NetSrvSetEventAdded.restype = None
        api.NetSrvSetEventAdded.argtypes = [HANDLE]
        api.NetSrvSetMessageAdded.restype = None
        api.NetSrvSetMessageAdded.argtypes = [HWND]
    api.ObjClose.restype = None
    api.ObjClose.argtypes = [c_uint32]
    api.ObjIsRemoved.restype = c_uint8
    api.ObjIsRemoved.argtypes = [c_uint32]
    api.ObjGetInterfaces.restype = c_uint64
    api.ObjGetInterfaces.argtypes = [c_uint32]
    api.ObjSetEventCallback.restype = None
    api.ObjSetEventCallback.argtypes = [c_uint32, CallbackEvent, c_void_p]
    api.ObjGetEvent.restype = c_uint8
    api.ObjGetEvent.argtypes = [c_uint32, c_void_p, c_void_p]
    if platform.system() == 'Linux':
        api.ObjSetEventEvent.restype = None
        api.ObjSetEventEvent.argtypes = [c_uint32, c_int]
    if platform.system() == 'Windows':
        api.ObjSetEventEvent.restype = None
        api.ObjSetEventEvent.argtypes = [c_uint32, HANDLE]
        api.ObjSetEventWindowHandle.restype = None
        api.ObjSetEventWindowHandle.argtypes = [c_uint32, HWND]
    api.DevClose.restype = None
    api.DevClose.argtypes = [c_uint32]
    api.DevIsRemoved.restype = c_uint8
    api.DevIsRemoved.argtypes = [c_uint32]
    api.DevGetDriverVersion.restype = c_uint64
    api.DevGetDriverVersion.argtypes = [c_uint32]
    api.DevGetFirmwareVersion.restype = c_uint64
    api.DevGetFirmwareVersion.argtypes = [c_uint32]
    api.DevGetCalibrationDate.restype = c_uint32
    api.DevGetCalibrationDate.argtypes = [c_uint32]
    api.DevGetCalibrationToken.restype = c_uint32
    api.DevGetCalibrationToken.argtypes = [c_uint32, c_char_p, c_uint32]
    api.DevGetSerialNumber.restype = c_uint32
    api.DevGetSerialNumber.argtypes = [c_uint32]
    api.DevGetIPv4Address.restype = c_uint32
    api.DevGetIPv4Address.argtypes = [c_uint32]
    api.DevGetIPPort.restype = c_uint16
    api.DevGetIPPort.argtypes = [c_uint32]
    api.DevGetProductId.restype = c_uint32
    api.DevGetProductId.argtypes = [c_uint32]
    api.DevGetVendorId.restype = c_uint32
    api.DevGetVendorId.argtypes = [c_uint32]
    api.DevGetType.restype = c_uint32
    api.DevGetType.argtypes = [c_uint32]
    api.DevGetName.restype = c_uint32
    api.DevGetName.argtypes = [c_uint32, c_char_p, c_uint32]
    api.DevGetNameShort.restype = c_uint32
    api.DevGetNameShort.argtypes = [c_uint32, c_char_p, c_uint32]
    api.DevGetNameShortest.restype = c_uint32
    api.DevGetNameShortest.argtypes = [c_uint32, c_char_p, c_uint32]
    api.DevHasBattery.restype = c_uint8
    api.DevHasBattery.argtypes = [c_uint32]
    api.DevGetBatteryCharge.restype = c_int8
    api.DevGetBatteryCharge.argtypes = [c_uint32]
    api.DevGetBatteryTimeToEmpty.restype = c_int32
    api.DevGetBatteryTimeToEmpty.argtypes = [c_uint32]
    api.DevGetBatteryTimeToFull.restype = c_int32
    api.DevGetBatteryTimeToFull.argtypes = [c_uint32]
    api.DevIsBatteryChargerConnected.restype = c_uint8
    api.DevIsBatteryChargerConnected.argtypes = [c_uint32]
    api.DevIsBatteryCharging.restype = c_uint8
    api.DevIsBatteryCharging.argtypes = [c_uint32]
    api.DevIsBatteryBroken.restype = c_uint8
    api.DevIsBatteryBroken.argtypes = [c_uint32]
    api.DevSetCallbackRemoved.restype = None
    api.DevSetCallbackRemoved.argtypes = [c_uint32, Callback, c_void_p]
    if platform.system() == 'Linux':
        api.DevSetEventRemoved.restype = None
        api.DevSetEventRemoved.argtypes = [c_uint32, c_int]
    if platform.system() == 'Windows':
        api.DevSetEventRemoved.restype = None
        api.DevSetEventRemoved.argtypes = [c_uint32, HANDLE]
        api.DevSetMessageRemoved.restype = None
        api.DevSetMessageRemoved.argtypes = [c_uint32, HWND, WPARAM, LPARAM]
    api.DevTrGetInputCount.restype = c_uint16
    api.DevTrGetInputCount.argtypes = [c_uint32]
    api.DevTrGetInputIndexById.restype = c_uint16
    api.DevTrGetInputIndexById.argtypes = [c_uint32, c_uint32]
    api.ScpTrInIsTriggered.restype = c_uint8
    api.ScpTrInIsTriggered.argtypes = [c_uint32, c_uint16]
    api.DevTrInGetEnabled.restype = c_uint8
    api.DevTrInGetEnabled.argtypes = [c_uint32, c_uint16]
    api.DevTrInSetEnabled.restype = c_uint8
    api.DevTrInSetEnabled.argtypes = [c_uint32, c_uint16, c_uint8]
    api.DevTrInGetKinds.restype = c_uint64
    api.DevTrInGetKinds.argtypes = [c_uint32, c_uint16]
    api.ScpTrInGetKindsEx.restype = c_uint64
    api.ScpTrInGetKindsEx.argtypes = [c_uint32, c_uint16, c_uint32]
    api.DevTrInGetKind.restype = c_uint64
    api.DevTrInGetKind.argtypes = [c_uint32, c_uint16]
    api.DevTrInSetKind.restype = c_uint64
    api.DevTrInSetKind.argtypes = [c_uint32, c_uint16, c_uint64]
    api.DevTrInIsAvailable.restype = c_uint8
    api.DevTrInIsAvailable.argtypes = [c_uint32, c_uint16]
    api.ScpTrInIsAvailableEx.restype = c_uint8
    api.ScpTrInIsAvailableEx.argtypes = [c_uint32, c_uint16, c_uint32]
    api.DevTrInGetId.restype = c_uint32
    api.DevTrInGetId.argtypes = [c_uint32, c_uint16]
    api.DevTrInGetName.restype = c_uint32
    api.DevTrInGetName.argtypes = [c_uint32, c_uint16, c_char_p, c_uint32]
    api.DevTrGetOutputCount.restype = c_uint16
    api.DevTrGetOutputCount.argtypes = [c_uint32]
    api.DevTrGetOutputIndexById.restype = c_uint16
    api.DevTrGetOutputIndexById.argtypes = [c_uint32, c_uint32]
    api.DevTrOutGetEnabled.restype = c_uint8
    api.DevTrOutGetEnabled.argtypes = [c_uint32, c_uint16]
    api.DevTrOutSetEnabled.restype = c_uint8
    api.DevTrOutSetEnabled.argtypes = [c_uint32, c_uint16, c_uint8]
    api.DevTrOutGetEvents.restype = c_uint64
    api.DevTrOutGetEvents.argtypes = [c_uint32, c_uint16]
    api.DevTrOutGetEvent.restype = c_uint64
    api.DevTrOutGetEvent.argtypes = [c_uint32, c_uint16]
    api.DevTrOutSetEvent.restype = c_uint64
    api.DevTrOutSetEvent.argtypes = [c_uint32, c_uint16, c_uint64]
    api.DevTrOutGetId.restype = c_uint32
    api.DevTrOutGetId.argtypes = [c_uint32, c_uint16]
    api.DevTrOutGetName.restype = c_uint32
    api.DevTrOutGetName.argtypes = [c_uint32, c_uint16, c_char_p, c_uint32]
    api.DevTrOutTrigger.restype = c_uint8
    api.DevTrOutTrigger.argtypes = [c_uint32, c_uint16]
    api.ScpGetChannelCount.restype = c_uint16
    api.ScpGetChannelCount.argtypes = [c_uint32]
    api.ScpChIsAvailable.restype = c_uint8
    api.ScpChIsAvailable.argtypes = [c_uint32, c_uint16]
    api.ScpChIsAvailableEx.restype = c_uint8
    api.ScpChIsAvailableEx.argtypes = [c_uint32, c_uint16, c_uint32, c_double, c_uint8, c_void_p, c_uint16]
    api.ScpChGetConnectorType.restype = c_uint32
    api.ScpChGetConnectorType.argtypes = [c_uint32, c_uint16]
    api.ScpChIsDifferential.restype = c_uint8
    api.ScpChIsDifferential.argtypes = [c_uint32, c_uint16]
    api.ScpChGetImpedance.restype = c_double
    api.ScpChGetImpedance.argtypes = [c_uint32, c_uint16]
    api.ScpChGetBandwidths.restype = c_uint32
    api.ScpChGetBandwidths.argtypes = [c_uint32, c_uint16, c_void_p, c_uint32]
    api.ScpChGetBandwidth.restype = c_double
    api.ScpChGetBandwidth.argtypes = [c_uint32, c_uint16]
    api.ScpChSetBandwidth.restype = c_double
    api.ScpChSetBandwidth.argtypes = [c_uint32, c_uint16, c_double]
    api.ScpChGetCouplings.restype = c_uint64
    api.ScpChGetCouplings.argtypes = [c_uint32, c_uint16]
    api.ScpChGetCoupling.restype = c_uint64
    api.ScpChGetCoupling.argtypes = [c_uint32, c_uint16]
    api.ScpChSetCoupling.restype = c_uint64
    api.ScpChSetCoupling.argtypes = [c_uint32, c_uint16, c_uint64]
    api.ScpChGetEnabled.restype = c_uint8
    api.ScpChGetEnabled.argtypes = [c_uint32, c_uint16]
    api.ScpChSetEnabled.restype = c_uint8
    api.ScpChSetEnabled.argtypes = [c_uint32, c_uint16, c_uint8]
    api.ScpChGetProbeGain.restype = c_double
    api.ScpChGetProbeGain.argtypes = [c_uint32, c_uint16]
    api.ScpChSetProbeGain.restype = c_double
    api.ScpChSetProbeGain.argtypes = [c_uint32, c_uint16, c_double]
    api.ScpChGetProbeOffset.restype = c_double
    api.ScpChGetProbeOffset.argtypes = [c_uint32, c_uint16]
    api.ScpChSetProbeOffset.restype = c_double
    api.ScpChSetProbeOffset.argtypes = [c_uint32, c_uint16, c_double]
    api.ScpChGetAutoRanging.restype = c_uint8
    api.ScpChGetAutoRanging.argtypes = [c_uint32, c_uint16]
    api.ScpChSetAutoRanging.restype = c_uint8
    api.ScpChSetAutoRanging.argtypes = [c_uint32, c_uint16, c_uint8]
    api.ScpChGetRanges.restype = c_uint32
    api.ScpChGetRanges.argtypes = [c_uint32, c_uint16, c_void_p, c_uint32]
    api.ScpChGetRangesEx.restype = c_uint32
    api.ScpChGetRangesEx.argtypes = [c_uint32, c_uint16, c_uint64, c_void_p, c_uint32]
    api.ScpChGetRange.restype = c_double
    api.ScpChGetRange.argtypes = [c_uint32, c_uint16]
    api.ScpChSetRange.restype = c_double
    api.ScpChSetRange.argtypes = [c_uint32, c_uint16, c_double]
    api.ScpChHasSafeGround.restype = c_uint8
    api.ScpChHasSafeGround.argtypes = [c_uint32, c_uint16]
    api.ScpChGetSafeGroundEnabled.restype = c_uint8
    api.ScpChGetSafeGroundEnabled.argtypes = [c_uint32, c_uint16]
    api.ScpChSetSafeGroundEnabled.restype = c_uint8
    api.ScpChSetSafeGroundEnabled.argtypes = [c_uint32, c_uint16, c_uint8]
    api.ScpChGetSafeGroundThresholdMin.restype = c_double
    api.ScpChGetSafeGroundThresholdMin.argtypes = [c_uint32, c_uint16]
    api.ScpChGetSafeGroundThresholdMax.restype = c_double
    api.ScpChGetSafeGroundThresholdMax.argtypes = [c_uint32, c_uint16]
    api.ScpChGetSafeGroundThreshold.restype = c_double
    api.ScpChGetSafeGroundThreshold.argtypes = [c_uint32, c_uint16]
    api.ScpChSetSafeGroundThreshold.restype = c_double
    api.ScpChSetSafeGroundThreshold.argtypes = [c_uint32, c_uint16, c_double]
    api.ScpChVerifySafeGroundThreshold.restype = c_double
    api.ScpChVerifySafeGroundThreshold.argtypes = [c_uint32, c_uint16, c_double]
    api.ScpChHasTrigger.restype = c_uint8
    api.ScpChHasTrigger.argtypes = [c_uint32, c_uint16]
    api.ScpChHasTriggerEx.restype = c_uint8
    api.ScpChHasTriggerEx.argtypes = [c_uint32, c_uint16, c_uint32]
    api.ScpChTrIsAvailable.restype = c_uint8
    api.ScpChTrIsAvailable.argtypes = [c_uint32, c_uint16]
    api.ScpChTrIsAvailableEx.restype = c_uint8
    api.ScpChTrIsAvailableEx.argtypes = [c_uint32, c_uint16, c_uint32, c_double, c_uint8, c_void_p, c_void_p, c_uint16]
    api.ScpChTrIsTriggered.restype = c_uint8
    api.ScpChTrIsTriggered.argtypes = [c_uint32, c_uint16]
    api.ScpChTrGetEnabled.restype = c_uint8
    api.ScpChTrGetEnabled.argtypes = [c_uint32, c_uint16]
    api.ScpChTrSetEnabled.restype = c_uint8
    api.ScpChTrSetEnabled.argtypes = [c_uint32, c_uint16, c_uint8]
    api.ScpChTrGetKinds.restype = c_uint64
    api.ScpChTrGetKinds.argtypes = [c_uint32, c_uint16]
    api.ScpChTrGetKindsEx.restype = c_uint64
    api.ScpChTrGetKindsEx.argtypes = [c_uint32, c_uint16, c_uint32]
    api.ScpChTrGetKind.restype = c_uint64
    api.ScpChTrGetKind.argtypes = [c_uint32, c_uint16]
    api.ScpChTrSetKind.restype = c_uint64
    api.ScpChTrSetKind.argtypes = [c_uint32, c_uint16, c_uint64]
    api.ScpChTrGetLevelModes.restype = c_uint32
    api.ScpChTrGetLevelModes.argtypes = [c_uint32, c_uint16]
    api.ScpChTrGetLevelMode.restype = c_uint32
    api.ScpChTrGetLevelMode.argtypes = [c_uint32, c_uint16]
    api.ScpChTrSetLevelMode.restype = c_uint32
    api.ScpChTrSetLevelMode.argtypes = [c_uint32, c_uint16, c_uint32]
    api.ScpChTrGetLevelCount.restype = c_uint32
    api.ScpChTrGetLevelCount.argtypes = [c_uint32, c_uint16]
    api.ScpChTrGetLevel.restype = c_double
    api.ScpChTrGetLevel.argtypes = [c_uint32, c_uint16, c_uint32]
    api.ScpChTrSetLevel.restype = c_double
    api.ScpChTrSetLevel.argtypes = [c_uint32, c_uint16, c_uint32, c_double]
    api.ScpChTrGetHysteresisCount.restype = c_uint32
    api.ScpChTrGetHysteresisCount.argtypes = [c_uint32, c_uint16]
    api.ScpChTrGetHysteresis.restype = c_double
    api.ScpChTrGetHysteresis.argtypes = [c_uint32, c_uint16, c_uint32]
    api.ScpChTrSetHysteresis.restype = c_double
    api.ScpChTrSetHysteresis.argtypes = [c_uint32, c_uint16, c_uint32, c_double]
    api.ScpChTrGetConditions.restype = c_uint32
    api.ScpChTrGetConditions.argtypes = [c_uint32, c_uint16]
    api.ScpChTrGetConditionsEx.restype = c_uint32
    api.ScpChTrGetConditionsEx.argtypes = [c_uint32, c_uint16, c_uint32, c_uint64]
    api.ScpChTrGetCondition.restype = c_uint32
    api.ScpChTrGetCondition.argtypes = [c_uint32, c_uint16]
    api.ScpChTrSetCondition.restype = c_uint32
    api.ScpChTrSetCondition.argtypes = [c_uint32, c_uint16, c_uint32]
    api.ScpChTrGetTimeCount.restype = c_uint32
    api.ScpChTrGetTimeCount.argtypes = [c_uint32, c_uint16]
    api.ScpChTrGetTime.restype = c_double
    api.ScpChTrGetTime.argtypes = [c_uint32, c_uint16, c_uint32]
    api.ScpChTrSetTime.restype = c_double
    api.ScpChTrSetTime.argtypes = [c_uint32, c_uint16, c_uint32, c_double]
    api.ScpChTrVerifyTime.restype = c_double
    api.ScpChTrVerifyTime.argtypes = [c_uint32, c_uint16, c_uint32, c_double]
    api.ScpChTrVerifyTimeEx2.restype = c_double
    api.ScpChTrVerifyTimeEx2.argtypes = [c_uint32, c_uint16, c_uint32, c_double, c_uint32, c_double, c_uint64, c_uint32]
    api.ScpGetData.restype = c_uint64
    api.ScpGetData.argtypes = [c_uint32, c_void_p, c_uint16, c_uint64, c_uint64]
    api.ScpGetData1Ch.restype = c_uint64
    api.ScpGetData1Ch.argtypes = [c_uint32, c_void_p, c_uint64, c_uint64]
    api.ScpGetData2Ch.restype = c_uint64
    api.ScpGetData2Ch.argtypes = [c_uint32, c_void_p, c_void_p, c_uint64, c_uint64]
    api.ScpGetData3Ch.restype = c_uint64
    api.ScpGetData3Ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.ScpGetData4Ch.restype = c_uint64
    api.ScpGetData4Ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.ScpGetValidPreSampleCount.restype = c_uint64
    api.ScpGetValidPreSampleCount.argtypes = [c_uint32]
    api.ScpChGetDataValueRange.restype = None
    api.ScpChGetDataValueRange.argtypes = [c_uint32, c_uint16, c_void_p, c_void_p]
    api.ScpChGetDataValueMin.restype = c_double
    api.ScpChGetDataValueMin.argtypes = [c_uint32, c_uint16]
    api.ScpChGetDataValueMax.restype = c_double
    api.ScpChGetDataValueMax.argtypes = [c_uint32, c_uint16]
    api.ScpGetDataRaw.restype = c_uint64
    api.ScpGetDataRaw.argtypes = [c_uint32, c_void_p, c_uint16, c_uint64, c_uint64]
    api.ScpGetDataRaw1Ch.restype = c_uint64
    api.ScpGetDataRaw1Ch.argtypes = [c_uint32, c_void_p, c_uint64, c_uint64]
    api.ScpGetDataRaw2Ch.restype = c_uint64
    api.ScpGetDataRaw2Ch.argtypes = [c_uint32, c_void_p, c_void_p, c_uint64, c_uint64]
    api.ScpGetDataRaw3Ch.restype = c_uint64
    api.ScpGetDataRaw3Ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.ScpGetDataRaw4Ch.restype = c_uint64
    api.ScpGetDataRaw4Ch.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p, c_void_p, c_uint64, c_uint64]
    api.ScpChGetDataRawType.restype = c_uint32
    api.ScpChGetDataRawType.argtypes = [c_uint32, c_uint16]
    api.ScpChGetDataRawValueRange.restype = None
    api.ScpChGetDataRawValueRange.argtypes = [c_uint32, c_uint16, c_void_p, c_void_p, c_void_p]
    api.ScpChGetDataRawValueMin.restype = c_int64
    api.ScpChGetDataRawValueMin.argtypes = [c_uint32, c_uint16]
    api.ScpChGetDataRawValueZero.restype = c_int64
    api.ScpChGetDataRawValueZero.argtypes = [c_uint32, c_uint16]
    api.ScpChGetDataRawValueMax.restype = c_int64
    api.ScpChGetDataRawValueMax.argtypes = [c_uint32, c_uint16]
    api.ScpChIsRangeMaxReachable.restype = c_uint8
    api.ScpChIsRangeMaxReachable.argtypes = [c_uint32, c_uint16]
    api.ScpIsGetDataAsyncCompleted.restype = c_uint8
    api.ScpIsGetDataAsyncCompleted.argtypes = [c_uint32]
    api.ScpStartGetDataAsync.restype = c_uint8
    api.ScpStartGetDataAsync.argtypes = [c_uint32, c_void_p, c_uint16, c_uint64, c_uint64]
    api.ScpStartGetDataAsyncRaw.restype = c_uint8
    api.ScpStartGetDataAsyncRaw.argtypes = [c_uint32, c_void_p, c_uint16, c_uint64, c_uint64]
    api.ScpCancelGetDataAsync.restype = c_uint8
    api.ScpCancelGetDataAsync.argtypes = [c_uint32]
    api.ScpSetCallbackDataReady.restype = None
    api.ScpSetCallbackDataReady.argtypes = [c_uint32, Callback, c_void_p]
    api.ScpSetCallbackDataOverflow.restype = None
    api.ScpSetCallbackDataOverflow.argtypes = [c_uint32, Callback, c_void_p]
    api.ScpSetCallbackConnectionTestCompleted.restype = None
    api.ScpSetCallbackConnectionTestCompleted.argtypes = [c_uint32, Callback, c_void_p]
    api.ScpSetCallbackTriggered.restype = None
    api.ScpSetCallbackTriggered.argtypes = [c_uint32, Callback, c_void_p]
    if platform.system() == 'Linux':
        api.ScpSetEventDataReady.restype = None
        api.ScpSetEventDataReady.argtypes = [c_uint32, c_int]
        api.ScpSetEventDataOverflow.restype = None
        api.ScpSetEventDataOverflow.argtypes = [c_uint32, c_int]
        api.ScpSetEventConnectionTestCompleted.restype = None
        api.ScpSetEventConnectionTestCompleted.argtypes = [c_uint32, c_int]
        api.ScpSetEventTriggered.restype = None
        api.ScpSetEventTriggered.argtypes = [c_uint32, c_int]
    if platform.system() == 'Windows':
        api.ScpSetEventDataReady.restype = None
        api.ScpSetEventDataReady.argtypes = [c_uint32, HANDLE]
        api.ScpSetEventDataOverflow.restype = None
        api.ScpSetEventDataOverflow.argtypes = [c_uint32, HANDLE]
        api.ScpSetEventConnectionTestCompleted.restype = None
        api.ScpSetEventConnectionTestCompleted.argtypes = [c_uint32, HANDLE]
        api.ScpSetEventTriggered.restype = None
        api.ScpSetEventTriggered.argtypes = [c_uint32, HANDLE]
        api.ScpSetMessageDataReady.restype = None
        api.ScpSetMessageDataReady.argtypes = [c_uint32, HWND, WPARAM, LPARAM]
        api.ScpSetMessageDataOverflow.restype = None
        api.ScpSetMessageDataOverflow.argtypes = [c_uint32, HWND, WPARAM, LPARAM]
        api.ScpSetMessageConnectionTestCompleted.restype = None
        api.ScpSetMessageConnectionTestCompleted.argtypes = [c_uint32, HWND, WPARAM, LPARAM]
        api.ScpSetMessageTriggered.restype = None
        api.ScpSetMessageTriggered.argtypes = [c_uint32, HWND, WPARAM, LPARAM]
    api.ScpStart.restype = c_uint8
    api.ScpStart.argtypes = [c_uint32]
    api.ScpStop.restype = c_uint8
    api.ScpStop.argtypes = [c_uint32]
    api.ScpForceTrigger.restype = c_uint8
    api.ScpForceTrigger.argtypes = [c_uint32]
    api.ScpGetMeasureModes.restype = c_uint32
    api.ScpGetMeasureModes.argtypes = [c_uint32]
    api.ScpGetMeasureMode.restype = c_uint32
    api.ScpGetMeasureMode.argtypes = [c_uint32]
    api.ScpSetMeasureMode.restype = c_uint32
    api.ScpSetMeasureMode.argtypes = [c_uint32, c_uint32]
    api.ScpIsRunning.restype = c_uint8
    api.ScpIsRunning.argtypes = [c_uint32]
    api.ScpIsTriggered.restype = c_uint8
    api.ScpIsTriggered.argtypes = [c_uint32]
    api.ScpIsTimeOutTriggered.restype = c_uint8
    api.ScpIsTimeOutTriggered.argtypes = [c_uint32]
    api.ScpIsForceTriggered.restype = c_uint8
    api.ScpIsForceTriggered.argtypes = [c_uint32]
    api.ScpIsDataReady.restype = c_uint8
    api.ScpIsDataReady.argtypes = [c_uint32]
    api.ScpIsDataOverflow.restype = c_uint8
    api.ScpIsDataOverflow.argtypes = [c_uint32]
    api.ScpGetAutoResolutionModes.restype = c_uint32
    api.ScpGetAutoResolutionModes.argtypes = [c_uint32]
    api.ScpGetAutoResolutionMode.restype = c_uint32
    api.ScpGetAutoResolutionMode.argtypes = [c_uint32]
    api.ScpSetAutoResolutionMode.restype = c_uint32
    api.ScpSetAutoResolutionMode.argtypes = [c_uint32, c_uint32]
    api.ScpGetResolutions.restype = c_uint32
    api.ScpGetResolutions.argtypes = [c_uint32, c_void_p, c_uint32]
    api.ScpGetResolution.restype = c_uint8
    api.ScpGetResolution.argtypes = [c_uint32]
    api.ScpSetResolution.restype = c_uint8
    api.ScpSetResolution.argtypes = [c_uint32, c_uint8]
    api.ScpIsResolutionEnhanced.restype = c_uint8
    api.ScpIsResolutionEnhanced.argtypes = [c_uint32]
    api.ScpIsResolutionEnhancedEx.restype = c_uint8
    api.ScpIsResolutionEnhancedEx.argtypes = [c_uint32, c_uint8]
    api.ScpGetClockSources.restype = c_uint32
    api.ScpGetClockSources.argtypes = [c_uint32]
    api.ScpGetClockSource.restype = c_uint32
    api.ScpGetClockSource.argtypes = [c_uint32]
    api.ScpSetClockSource.restype = c_uint32
    api.ScpSetClockSource.argtypes = [c_uint32, c_uint32]
    api.ScpGetClockSourceFrequencies.restype = c_uint32
    api.ScpGetClockSourceFrequencies.argtypes = [c_uint32, c_void_p, c_uint32]
    api.ScpGetClockSourceFrequenciesEx.restype = c_uint32
    api.ScpGetClockSourceFrequenciesEx.argtypes = [c_uint32, c_uint32, c_void_p, c_uint32]
    api.ScpGetClockSourceFrequency.restype = c_double
    api.ScpGetClockSourceFrequency.argtypes = [c_uint32]
    api.ScpSetClockSourceFrequency.restype = c_double
    api.ScpSetClockSourceFrequency.argtypes = [c_uint32, c_double]
    api.ScpGetClockOutputs.restype = c_uint32
    api.ScpGetClockOutputs.argtypes = [c_uint32]
    api.ScpGetClockOutput.restype = c_uint32
    api.ScpGetClockOutput.argtypes = [c_uint32]
    api.ScpSetClockOutput.restype = c_uint32
    api.ScpSetClockOutput.argtypes = [c_uint32, c_uint32]
    api.ScpGetClockOutputFrequencies.restype = c_uint32
    api.ScpGetClockOutputFrequencies.argtypes = [c_uint32, c_void_p, c_uint32]
    api.ScpGetClockOutputFrequenciesEx.restype = c_uint32
    api.ScpGetClockOutputFrequenciesEx.argtypes = [c_uint32, c_uint32, c_void_p, c_uint32]
    api.ScpGetClockOutputFrequency.restype = c_double
    api.ScpGetClockOutputFrequency.argtypes = [c_uint32]
    api.ScpSetClockOutputFrequency.restype = c_double
    api.ScpSetClockOutputFrequency.argtypes = [c_uint32, c_double]
    api.ScpGetSampleFrequencyMax.restype = c_double
    api.ScpGetSampleFrequencyMax.argtypes = [c_uint32]
    api.ScpGetSampleFrequency.restype = c_double
    api.ScpGetSampleFrequency.argtypes = [c_uint32]
    api.ScpSetSampleFrequency.restype = c_double
    api.ScpSetSampleFrequency.argtypes = [c_uint32, c_double]
    api.ScpVerifySampleFrequency.restype = c_double
    api.ScpVerifySampleFrequency.argtypes = [c_uint32, c_double]
    api.ScpVerifySampleFrequencyEx.restype = c_double
    api.ScpVerifySampleFrequencyEx.argtypes = [c_uint32, c_double, c_uint32, c_uint8, c_void_p, c_uint16]
    api.ScpVerifySampleFrequenciesEx.restype = None
    api.ScpVerifySampleFrequenciesEx.argtypes = [c_uint32, c_void_p, c_uint32, c_uint32, c_uint32, c_uint8, c_void_p, c_uint16]
    api.ScpGetRecordLengthMax.restype = c_uint64
    api.ScpGetRecordLengthMax.argtypes = [c_uint32]
    api.ScpGetRecordLengthMaxEx.restype = c_uint64
    api.ScpGetRecordLengthMaxEx.argtypes = [c_uint32, c_uint32, c_uint8]
    api.ScpGetRecordLength.restype = c_uint64
    api.ScpGetRecordLength.argtypes = [c_uint32]
    api.ScpSetRecordLength.restype = c_uint64
    api.ScpSetRecordLength.argtypes = [c_uint32, c_uint64]
    api.ScpVerifyRecordLength.restype = c_uint64
    api.ScpVerifyRecordLength.argtypes = [c_uint32, c_uint64]
    api.ScpVerifyRecordLengthEx.restype = c_uint64
    api.ScpVerifyRecordLengthEx.argtypes = [c_uint32, c_uint64, c_uint32, c_uint8, c_void_p, c_uint16]
    api.ScpGetPreSampleRatio.restype = c_double
    api.ScpGetPreSampleRatio.argtypes = [c_uint32]
    api.ScpSetPreSampleRatio.restype = c_double
    api.ScpSetPreSampleRatio.argtypes = [c_uint32, c_double]
    api.ScpGetSegmentCountMax.restype = c_uint32
    api.ScpGetSegmentCountMax.argtypes = [c_uint32]
    api.ScpGetSegmentCountMaxEx.restype = c_uint32
    api.ScpGetSegmentCountMaxEx.argtypes = [c_uint32, c_uint32]
    api.ScpGetSegmentCount.restype = c_uint32
    api.ScpGetSegmentCount.argtypes = [c_uint32]
    api.ScpSetSegmentCount.restype = c_uint32
    api.ScpSetSegmentCount.argtypes = [c_uint32, c_uint32]
    api.ScpVerifySegmentCount.restype = c_uint32
    api.ScpVerifySegmentCount.argtypes = [c_uint32, c_uint32]
    api.ScpVerifySegmentCountEx2.restype = c_uint32
    api.ScpVerifySegmentCountEx2.argtypes = [c_uint32, c_uint32, c_uint32, c_uint64, c_void_p, c_uint16]
    api.ScpHasTrigger.restype = c_uint8
    api.ScpHasTrigger.argtypes = [c_uint32]
    api.ScpHasTriggerEx.restype = c_uint8
    api.ScpHasTriggerEx.argtypes = [c_uint32, c_uint32]
    api.ScpGetTriggerTimeOut.restype = c_double
    api.ScpGetTriggerTimeOut.argtypes = [c_uint32]
    api.ScpSetTriggerTimeOut.restype = c_double
    api.ScpSetTriggerTimeOut.argtypes = [c_uint32, c_double]
    api.ScpVerifyTriggerTimeOut.restype = c_double
    api.ScpVerifyTriggerTimeOut.argtypes = [c_uint32, c_double]
    api.ScpVerifyTriggerTimeOutEx.restype = c_double
    api.ScpVerifyTriggerTimeOutEx.argtypes = [c_uint32, c_double, c_uint32, c_double]
    api.ScpHasTriggerDelay.restype = c_uint8
    api.ScpHasTriggerDelay.argtypes = [c_uint32]
    api.ScpHasTriggerDelayEx.restype = c_uint8
    api.ScpHasTriggerDelayEx.argtypes = [c_uint32, c_uint32]
    api.ScpGetTriggerDelayMax.restype = c_double
    api.ScpGetTriggerDelayMax.argtypes = [c_uint32]
    api.ScpGetTriggerDelayMaxEx.restype = c_double
    api.ScpGetTriggerDelayMaxEx.argtypes = [c_uint32, c_uint32, c_double]
    api.ScpGetTriggerDelay.restype = c_double
    api.ScpGetTriggerDelay.argtypes = [c_uint32]
    api.ScpSetTriggerDelay.restype = c_double
    api.ScpSetTriggerDelay.argtypes = [c_uint32, c_double]
    api.ScpVerifyTriggerDelay.restype = c_double
    api.ScpVerifyTriggerDelay.argtypes = [c_uint32, c_double]
    api.ScpVerifyTriggerDelayEx.restype = c_double
    api.ScpVerifyTriggerDelayEx.argtypes = [c_uint32, c_double, c_uint32, c_double]
    api.ScpHasTriggerHoldOff.restype = c_uint8
    api.ScpHasTriggerHoldOff.argtypes = [c_uint32]
    api.ScpHasTriggerHoldOffEx.restype = c_uint8
    api.ScpHasTriggerHoldOffEx.argtypes = [c_uint32, c_uint32]
    api.ScpGetTriggerHoldOffCountMax.restype = c_uint64
    api.ScpGetTriggerHoldOffCountMax.argtypes = [c_uint32]
    api.ScpGetTriggerHoldOffCountMaxEx.restype = c_uint64
    api.ScpGetTriggerHoldOffCountMaxEx.argtypes = [c_uint32, c_uint32]
    api.ScpGetTriggerHoldOffCount.restype = c_uint64
    api.ScpGetTriggerHoldOffCount.argtypes = [c_uint32]
    api.ScpSetTriggerHoldOffCount.restype = c_uint64
    api.ScpSetTriggerHoldOffCount.argtypes = [c_uint32, c_uint64]
    api.ScpHasConnectionTest.restype = c_uint8
    api.ScpHasConnectionTest.argtypes = [c_uint32]
    api.ScpChHasConnectionTest.restype = c_uint8
    api.ScpChHasConnectionTest.argtypes = [c_uint32, c_uint16]
    api.ScpStartConnectionTest.restype = c_uint8
    api.ScpStartConnectionTest.argtypes = [c_uint32]
    api.ScpStartConnectionTestEx.restype = c_uint8
    api.ScpStartConnectionTestEx.argtypes = [c_uint32, c_void_p, c_uint16]
    api.ScpIsConnectionTestCompleted.restype = c_uint8
    api.ScpIsConnectionTestCompleted.argtypes = [c_uint32]
    api.ScpGetConnectionTestData.restype = c_uint16
    api.ScpGetConnectionTestData.argtypes = [c_uint32, c_void_p, c_uint16]
    api.GenGetConnectorType.restype = c_uint32
    api.GenGetConnectorType.argtypes = [c_uint32]
    api.GenIsDifferential.restype = c_uint8
    api.GenIsDifferential.argtypes = [c_uint32]
    api.GenGetImpedance.restype = c_double
    api.GenGetImpedance.argtypes = [c_uint32]
    api.GenGetResolution.restype = c_uint8
    api.GenGetResolution.argtypes = [c_uint32]
    api.GenGetOutputValueMin.restype = c_double
    api.GenGetOutputValueMin.argtypes = [c_uint32]
    api.GenGetOutputValueMax.restype = c_double
    api.GenGetOutputValueMax.argtypes = [c_uint32]
    api.GenGetOutputValueMinMax.restype = None
    api.GenGetOutputValueMinMax.argtypes = [c_uint32, c_void_p, c_void_p]
    api.GenIsControllable.restype = c_uint8
    api.GenIsControllable.argtypes = [c_uint32]
    api.GenIsRunning.restype = c_uint8
    api.GenIsRunning.argtypes = [c_uint32]
    api.GenGetStatus.restype = c_uint32
    api.GenGetStatus.argtypes = [c_uint32]
    api.GenGetOutputOn.restype = c_uint8
    api.GenGetOutputOn.argtypes = [c_uint32]
    api.GenSetOutputOn.restype = c_uint8
    api.GenSetOutputOn.argtypes = [c_uint32, c_uint8]
    api.GenHasOutputInvert.restype = c_uint8
    api.GenHasOutputInvert.argtypes = [c_uint32]
    api.GenGetOutputInvert.restype = c_uint8
    api.GenGetOutputInvert.argtypes = [c_uint32]
    api.GenSetOutputInvert.restype = c_uint8
    api.GenSetOutputInvert.argtypes = [c_uint32, c_uint8]
    api.GenStart.restype = c_uint8
    api.GenStart.argtypes = [c_uint32]
    api.GenStop.restype = c_uint8
    api.GenStop.argtypes = [c_uint32]
    api.GenGetSignalTypes.restype = c_uint32
    api.GenGetSignalTypes.argtypes = [c_uint32]
    api.GenGetSignalType.restype = c_uint32
    api.GenGetSignalType.argtypes = [c_uint32]
    api.GenSetSignalType.restype = c_uint32
    api.GenSetSignalType.argtypes = [c_uint32, c_uint32]
    api.GenHasAmplitude.restype = c_uint8
    api.GenHasAmplitude.argtypes = [c_uint32]
    api.GenHasAmplitudeEx.restype = c_uint8
    api.GenHasAmplitudeEx.argtypes = [c_uint32, c_uint32]
    api.GenGetAmplitudeMin.restype = c_double
    api.GenGetAmplitudeMin.argtypes = [c_uint32]
    api.GenGetAmplitudeMax.restype = c_double
    api.GenGetAmplitudeMax.argtypes = [c_uint32]
    api.GenGetAmplitudeMinMaxEx.restype = None
    api.GenGetAmplitudeMinMaxEx.argtypes = [c_uint32, c_uint32, c_void_p, c_void_p]
    api.GenGetAmplitude.restype = c_double
    api.GenGetAmplitude.argtypes = [c_uint32]
    api.GenSetAmplitude.restype = c_double
    api.GenSetAmplitude.argtypes = [c_uint32, c_double]
    api.GenVerifyAmplitude.restype = c_double
    api.GenVerifyAmplitude.argtypes = [c_uint32, c_double]
    api.GenVerifyAmplitudeEx.restype = c_double
    api.GenVerifyAmplitudeEx.argtypes = [c_uint32, c_double, c_uint32, c_uint32, c_double]
    api.GenGetAmplitudeRanges.restype = c_uint32
    api.GenGetAmplitudeRanges.argtypes = [c_uint32, c_void_p, c_uint32]
    api.GenGetAmplitudeRange.restype = c_double
    api.GenGetAmplitudeRange.argtypes = [c_uint32]
    api.GenSetAmplitudeRange.restype = c_double
    api.GenSetAmplitudeRange.argtypes = [c_uint32, c_double]
    api.GenGetAmplitudeAutoRanging.restype = c_uint8
    api.GenGetAmplitudeAutoRanging.argtypes = [c_uint32]
    api.GenSetAmplitudeAutoRanging.restype = c_uint8
    api.GenSetAmplitudeAutoRanging.argtypes = [c_uint32, c_uint8]
    api.GenHasOffset.restype = c_uint8
    api.GenHasOffset.argtypes = [c_uint32]
    api.GenHasOffsetEx.restype = c_uint8
    api.GenHasOffsetEx.argtypes = [c_uint32, c_uint32]
    api.GenGetOffsetMin.restype = c_double
    api.GenGetOffsetMin.argtypes = [c_uint32]
    api.GenGetOffsetMax.restype = c_double
    api.GenGetOffsetMax.argtypes = [c_uint32]
    api.GenGetOffsetMinMaxEx.restype = None
    api.GenGetOffsetMinMaxEx.argtypes = [c_uint32, c_uint32, c_void_p, c_void_p]
    api.GenGetOffset.restype = c_double
    api.GenGetOffset.argtypes = [c_uint32]
    api.GenSetOffset.restype = c_double
    api.GenSetOffset.argtypes = [c_uint32, c_double]
    api.GenVerifyOffset.restype = c_double
    api.GenVerifyOffset.argtypes = [c_uint32, c_double]
    api.GenVerifyOffsetEx.restype = c_double
    api.GenVerifyOffsetEx.argtypes = [c_uint32, c_double, c_uint32, c_double]
    api.GenGetFrequencyModes.restype = c_uint32
    api.GenGetFrequencyModes.argtypes = [c_uint32]
    api.GenGetFrequencyModesEx.restype = c_uint32
    api.GenGetFrequencyModesEx.argtypes = [c_uint32, c_uint32]
    api.GenGetFrequencyMode.restype = c_uint32
    api.GenGetFrequencyMode.argtypes = [c_uint32]
    api.GenSetFrequencyMode.restype = c_uint32
    api.GenSetFrequencyMode.argtypes = [c_uint32, c_uint32]
    api.GenHasFrequency.restype = c_uint8
    api.GenHasFrequency.argtypes = [c_uint32]
    api.GenHasFrequencyEx.restype = c_uint8
    api.GenHasFrequencyEx.argtypes = [c_uint32, c_uint32, c_uint32]
    api.GenGetFrequencyMin.restype = c_double
    api.GenGetFrequencyMin.argtypes = [c_uint32]
    api.GenGetFrequencyMax.restype = c_double
    api.GenGetFrequencyMax.argtypes = [c_uint32]
    api.GenGetFrequencyMinMax.restype = None
    api.GenGetFrequencyMinMax.argtypes = [c_uint32, c_uint32, c_void_p, c_void_p]
    api.GenGetFrequencyMinMaxEx.restype = None
    api.GenGetFrequencyMinMaxEx.argtypes = [c_uint32, c_uint32, c_uint32, c_void_p, c_void_p]
    api.GenGetFrequency.restype = c_double
    api.GenGetFrequency.argtypes = [c_uint32]
    api.GenSetFrequency.restype = c_double
    api.GenSetFrequency.argtypes = [c_uint32, c_double]
    api.GenVerifyFrequency.restype = c_double
    api.GenVerifyFrequency.argtypes = [c_uint32, c_double]
    api.GenVerifyFrequencyEx2.restype = c_double
    api.GenVerifyFrequencyEx2.argtypes = [c_uint32, c_double, c_uint32, c_uint32, c_uint64, c_double]
    api.GenHasPhase.restype = c_uint8
    api.GenHasPhase.argtypes = [c_uint32]
    api.GenHasPhaseEx.restype = c_uint8
    api.GenHasPhaseEx.argtypes = [c_uint32, c_uint32]
    api.GenGetPhaseMin.restype = c_double
    api.GenGetPhaseMin.argtypes = [c_uint32]
    api.GenGetPhaseMax.restype = c_double
    api.GenGetPhaseMax.argtypes = [c_uint32]
    api.GenGetPhaseMinMaxEx.restype = None
    api.GenGetPhaseMinMaxEx.argtypes = [c_uint32, c_uint32, c_void_p, c_void_p]
    api.GenGetPhase.restype = c_double
    api.GenGetPhase.argtypes = [c_uint32]
    api.GenSetPhase.restype = c_double
    api.GenSetPhase.argtypes = [c_uint32, c_double]
    api.GenVerifyPhase.restype = c_double
    api.GenVerifyPhase.argtypes = [c_uint32, c_double]
    api.GenVerifyPhaseEx.restype = c_double
    api.GenVerifyPhaseEx.argtypes = [c_uint32, c_double, c_uint32]
    api.GenHasSymmetry.restype = c_uint8
    api.GenHasSymmetry.argtypes = [c_uint32]
    api.GenHasSymmetryEx.restype = c_uint8
    api.GenHasSymmetryEx.argtypes = [c_uint32, c_uint32]
    api.GenGetSymmetryMin.restype = c_double
    api.GenGetSymmetryMin.argtypes = [c_uint32]
    api.GenGetSymmetryMax.restype = c_double
    api.GenGetSymmetryMax.argtypes = [c_uint32]
    api.GenGetSymmetryMinMaxEx.restype = None
    api.GenGetSymmetryMinMaxEx.argtypes = [c_uint32, c_uint32, c_void_p, c_void_p]
    api.GenGetSymmetry.restype = c_double
    api.GenGetSymmetry.argtypes = [c_uint32]
    api.GenSetSymmetry.restype = c_double
    api.GenSetSymmetry.argtypes = [c_uint32, c_double]
    api.GenVerifySymmetry.restype = c_double
    api.GenVerifySymmetry.argtypes = [c_uint32, c_double]
    api.GenVerifySymmetryEx.restype = c_double
    api.GenVerifySymmetryEx.argtypes = [c_uint32, c_double, c_uint32]
    api.GenHasWidth.restype = c_uint8
    api.GenHasWidth.argtypes = [c_uint32]
    api.GenHasWidthEx.restype = c_uint8
    api.GenHasWidthEx.argtypes = [c_uint32, c_uint32]
    api.GenGetWidthMin.restype = c_double
    api.GenGetWidthMin.argtypes = [c_uint32]
    api.GenGetWidthMax.restype = c_double
    api.GenGetWidthMax.argtypes = [c_uint32]
    api.GenGetWidthMinMaxEx.restype = None
    api.GenGetWidthMinMaxEx.argtypes = [c_uint32, c_uint32, c_double, c_void_p, c_void_p]
    api.GenGetWidth.restype = c_double
    api.GenGetWidth.argtypes = [c_uint32]
    api.GenSetWidth.restype = c_double
    api.GenSetWidth.argtypes = [c_uint32, c_double]
    api.GenVerifyWidth.restype = c_double
    api.GenVerifyWidth.argtypes = [c_uint32, c_double]
    api.GenVerifyWidthEx.restype = c_double
    api.GenVerifyWidthEx.argtypes = [c_uint32, c_double, c_uint32, c_double]
    api.GenHasEdgeTime.restype = c_uint8
    api.GenHasEdgeTime.argtypes = [c_uint32]
    api.GenHasEdgeTimeEx.restype = c_uint8
    api.GenHasEdgeTimeEx.argtypes = [c_uint32, c_uint32]
    api.GenGetLeadingEdgeTimeMin.restype = c_double
    api.GenGetLeadingEdgeTimeMin.argtypes = [c_uint32]
    api.GenGetLeadingEdgeTimeMax.restype = c_double
    api.GenGetLeadingEdgeTimeMax.argtypes = [c_uint32]
    api.GenGetLeadingEdgeTimeMinMaxEx.restype = None
    api.GenGetLeadingEdgeTimeMinMaxEx.argtypes = [c_uint32, c_uint32, c_double, c_double, c_double, c_double, c_void_p, c_void_p]
    api.GenGetLeadingEdgeTime.restype = c_double
    api.GenGetLeadingEdgeTime.argtypes = [c_uint32]
    api.GenSetLeadingEdgeTime.restype = c_double
    api.GenSetLeadingEdgeTime.argtypes = [c_uint32, c_double]
    api.GenVerifyLeadingEdgeTime.restype = c_double
    api.GenVerifyLeadingEdgeTime.argtypes = [c_uint32, c_double]
    api.GenVerifyLeadingEdgeTimeEx.restype = c_double
    api.GenVerifyLeadingEdgeTimeEx.argtypes = [c_uint32, c_double, c_uint32, c_double, c_double, c_double, c_double]
    api.GenGetTrailingEdgeTimeMin.restype = c_double
    api.GenGetTrailingEdgeTimeMin.argtypes = [c_uint32]
    api.GenGetTrailingEdgeTimeMax.restype = c_double
    api.GenGetTrailingEdgeTimeMax.argtypes = [c_uint32]
    api.GenGetTrailingEdgeTimeMinMaxEx.restype = None
    api.GenGetTrailingEdgeTimeMinMaxEx.argtypes = [c_uint32, c_uint32, c_double, c_double, c_double, c_double, c_void_p, c_void_p]
    api.GenGetTrailingEdgeTime.restype = c_double
    api.GenGetTrailingEdgeTime.argtypes = [c_uint32]
    api.GenSetTrailingEdgeTime.restype = c_double
    api.GenSetTrailingEdgeTime.argtypes = [c_uint32, c_double]
    api.GenVerifyTrailingEdgeTime.restype = c_double
    api.GenVerifyTrailingEdgeTime.argtypes = [c_uint32, c_double]
    api.GenVerifyTrailingEdgeTimeEx.restype = c_double
    api.GenVerifyTrailingEdgeTimeEx.argtypes = [c_uint32, c_double, c_uint32, c_double, c_double, c_double, c_double]
    api.GenHasData.restype = c_uint8
    api.GenHasData.argtypes = [c_uint32]
    api.GenHasDataEx.restype = c_uint8
    api.GenHasDataEx.argtypes = [c_uint32, c_uint32]
    api.GenGetDataLengthMin.restype = c_uint64
    api.GenGetDataLengthMin.argtypes = [c_uint32]
    api.GenGetDataLengthMax.restype = c_uint64
    api.GenGetDataLengthMax.argtypes = [c_uint32]
    api.GenGetDataLengthMinMaxEx.restype = None
    api.GenGetDataLengthMinMaxEx.argtypes = [c_uint32, c_uint32, c_void_p, c_void_p]
    api.GenGetDataLength.restype = c_uint64
    api.GenGetDataLength.argtypes = [c_uint32]
    api.GenVerifyDataLength.restype = c_uint64
    api.GenVerifyDataLength.argtypes = [c_uint32, c_uint64]
    api.GenVerifyDataLengthEx.restype = c_uint64
    api.GenVerifyDataLengthEx.argtypes = [c_uint32, c_uint64, c_uint32]
    api.GenSetData.restype = None
    api.GenSetData.argtypes = [c_uint32, c_void_p, c_uint64]
    api.GenSetDataEx.restype = None
    api.GenSetDataEx.argtypes = [c_uint32, c_void_p, c_uint64, c_uint32, c_uint32]
    api.GenGetDataRawType.restype = c_uint32
    api.GenGetDataRawType.argtypes = [c_uint32]
    api.GenGetDataRawValueRange.restype = None
    api.GenGetDataRawValueRange.argtypes = [c_uint32, c_void_p, c_void_p, c_void_p]
    api.GenGetDataRawValueMin.restype = c_int64
    api.GenGetDataRawValueMin.argtypes = [c_uint32]
    api.GenGetDataRawValueZero.restype = c_int64
    api.GenGetDataRawValueZero.argtypes = [c_uint32]
    api.GenGetDataRawValueMax.restype = c_int64
    api.GenGetDataRawValueMax.argtypes = [c_uint32]
    api.GenSetDataRaw.restype = None
    api.GenSetDataRaw.argtypes = [c_uint32, c_void_p, c_uint64]
    api.GenSetDataRawEx.restype = None
    api.GenSetDataRawEx.argtypes = [c_uint32, c_void_p, c_uint64, c_uint32, c_uint32]
    api.GenGetModes.restype = c_uint64
    api.GenGetModes.argtypes = [c_uint32]
    api.GenGetModesEx.restype = c_uint64
    api.GenGetModesEx.argtypes = [c_uint32, c_uint32, c_uint32]
    api.GenGetModesNative.restype = c_uint64
    api.GenGetModesNative.argtypes = [c_uint32]
    api.GenGetMode.restype = c_uint64
    api.GenGetMode.argtypes = [c_uint32]
    api.GenSetMode.restype = c_uint64
    api.GenSetMode.argtypes = [c_uint32, c_uint64]
    api.GenIsBurstActive.restype = c_uint8
    api.GenIsBurstActive.argtypes = [c_uint32]
    api.GenGetBurstCountMin.restype = c_uint64
    api.GenGetBurstCountMin.argtypes = [c_uint32]
    api.GenGetBurstCountMax.restype = c_uint64
    api.GenGetBurstCountMax.argtypes = [c_uint32]
    api.GenGetBurstCountMinMaxEx.restype = None
    api.GenGetBurstCountMinMaxEx.argtypes = [c_uint32, c_uint64, c_void_p, c_void_p]
    api.GenGetBurstCount.restype = c_uint64
    api.GenGetBurstCount.argtypes = [c_uint32]
    api.GenSetBurstCount.restype = c_uint64
    api.GenSetBurstCount.argtypes = [c_uint32, c_uint64]
    api.GenGetBurstSampleCountMin.restype = c_uint64
    api.GenGetBurstSampleCountMin.argtypes = [c_uint32]
    api.GenGetBurstSampleCountMax.restype = c_uint64
    api.GenGetBurstSampleCountMax.argtypes = [c_uint32]
    api.GenGetBurstSampleCountMinMaxEx.restype = None
    api.GenGetBurstSampleCountMinMaxEx.argtypes = [c_uint32, c_uint64, c_void_p, c_void_p]
    api.GenGetBurstSampleCount.restype = c_uint64
    api.GenGetBurstSampleCount.argtypes = [c_uint32]
    api.GenSetBurstSampleCount.restype = c_uint64
    api.GenSetBurstSampleCount.argtypes = [c_uint32, c_uint64]
    api.GenGetBurstSegmentCountMin.restype = c_uint64
    api.GenGetBurstSegmentCountMin.argtypes = [c_uint32]
    api.GenGetBurstSegmentCountMax.restype = c_uint64
    api.GenGetBurstSegmentCountMax.argtypes = [c_uint32]
    api.GenGetBurstSegmentCountMinMaxEx.restype = None
    api.GenGetBurstSegmentCountMinMaxEx.argtypes = [c_uint32, c_uint64, c_uint32, c_uint32, c_double, c_uint64, c_void_p, c_void_p]
    api.GenGetBurstSegmentCount.restype = c_uint64
    api.GenGetBurstSegmentCount.argtypes = [c_uint32]
    api.GenSetBurstSegmentCount.restype = c_uint64
    api.GenSetBurstSegmentCount.argtypes = [c_uint32, c_uint64]
    api.GenVerifyBurstSegmentCount.restype = c_uint64
    api.GenVerifyBurstSegmentCount.argtypes = [c_uint32, c_uint64]
    api.GenVerifyBurstSegmentCountEx.restype = c_uint64
    api.GenVerifyBurstSegmentCountEx.argtypes = [c_uint32, c_uint64, c_uint64, c_uint32, c_uint32, c_double, c_uint64]
    api.GenSetCallbackBurstCompleted.restype = None
    api.GenSetCallbackBurstCompleted.argtypes = [c_uint32, Callback, c_void_p]
    if platform.system() == 'Linux':
        api.GenSetEventBurstCompleted.restype = None
        api.GenSetEventBurstCompleted.argtypes = [c_uint32, c_int]
    if platform.system() == 'Windows':
        api.GenSetEventBurstCompleted.restype = None
        api.GenSetEventBurstCompleted.argtypes = [c_uint32, HANDLE]
        api.GenSetMessageBurstCompleted.restype = None
        api.GenSetMessageBurstCompleted.argtypes = [c_uint32, HWND, WPARAM, LPARAM]
    api.GenSetCallbackControllableChanged.restype = None
    api.GenSetCallbackControllableChanged.argtypes = [c_uint32, Callback, c_void_p]
    if platform.system() == 'Linux':
        api.GenSetEventControllableChanged.restype = None
        api.GenSetEventControllableChanged.argtypes = [c_uint32, c_int]
    if platform.system() == 'Windows':
        api.GenSetEventControllableChanged.restype = None
        api.GenSetEventControllableChanged.argtypes = [c_uint32, HANDLE]
        api.GenSetMessageControllableChanged.restype = None
        api.GenSetMessageControllableChanged.argtypes = [c_uint32, HWND, WPARAM, LPARAM]
    api.I2CIsInternalAddress.restype = c_uint8
    api.I2CIsInternalAddress.argtypes = [c_uint32, c_uint16]
    api.I2CGetInternalAddresses.restype = c_uint32
    api.I2CGetInternalAddresses.argtypes = [c_uint32, c_void_p, c_uint32]
    api.I2CRead.restype = c_uint8
    api.I2CRead.argtypes = [c_uint32, c_uint16, c_void_p, c_uint32, c_uint8]
    api.I2CReadByte.restype = c_uint8
    api.I2CReadByte.argtypes = [c_uint32, c_uint16, c_void_p]
    api.I2CReadWord.restype = c_uint8
    api.I2CReadWord.argtypes = [c_uint32, c_uint16, c_void_p]
    api.I2CWrite.restype = c_uint8
    api.I2CWrite.argtypes = [c_uint32, c_uint16, c_void_p, c_uint32, c_uint8]
    api.I2CWriteByte.restype = c_uint8
    api.I2CWriteByte.argtypes = [c_uint32, c_uint16, c_uint8]
    api.I2CWriteByteByte.restype = c_uint8
    api.I2CWriteByteByte.argtypes = [c_uint32, c_uint16, c_uint8, c_uint8]
    api.I2CWriteByteWord.restype = c_uint8
    api.I2CWriteByteWord.argtypes = [c_uint32, c_uint16, c_uint8, c_uint16]
    api.I2CWriteWord.restype = c_uint8
    api.I2CWriteWord.argtypes = [c_uint32, c_uint16, c_uint16]
    api.I2CWriteRead.restype = c_uint8
    api.I2CWriteRead.argtypes = [c_uint32, c_uint16, c_void_p, c_uint32, c_void_p, c_uint32]
    api.I2CGetSpeedMax.restype = c_double
    api.I2CGetSpeedMax.argtypes = [c_uint32]
    api.I2CGetSpeed.restype = c_double
    api.I2CGetSpeed.argtypes = [c_uint32]
    api.I2CSetSpeed.restype = c_double
    api.I2CSetSpeed.argtypes = [c_uint32, c_double]
    api.I2CVerifySpeed.restype = c_double
    api.I2CVerifySpeed.argtypes = [c_uint32, c_double]
    api.SrvConnect.restype = c_uint8
    api.SrvConnect.argtypes = [c_uint32, c_uint8]
    api.SrvDisconnect.restype = c_uint8
    api.SrvDisconnect.argtypes = [c_uint32, c_uint8]
    api.SrvRemove.restype = c_uint8
    api.SrvRemove.argtypes = [c_uint32, c_uint8]
    api.SrvGetStatus.restype = c_uint32
    api.SrvGetStatus.argtypes = [c_uint32]
    api.SrvGetLastError.restype = c_uint32
    api.SrvGetLastError.argtypes = [c_uint32]
    api.SrvGetURL.restype = c_uint32
    api.SrvGetURL.argtypes = [c_uint32, c_char_p, c_uint32]
    api.SrvGetID.restype = c_uint32
    api.SrvGetID.argtypes = [c_uint32, c_char_p, c_uint32]
    api.SrvGetIPv4Address.restype = c_uint32
    api.SrvGetIPv4Address.argtypes = [c_uint32]
    api.SrvGetIPPort.restype = c_uint16
    api.SrvGetIPPort.argtypes = [c_uint32]
    api.SrvGetName.restype = c_uint32
    api.SrvGetName.argtypes = [c_uint32, c_char_p, c_uint32]
    api.SrvGetDescription.restype = c_uint32
    api.SrvGetDescription.argtypes = [c_uint32, c_char_p, c_uint32]
    api.SrvGetVersion.restype = c_uint64
    api.SrvGetVersion.argtypes = [c_uint32]
    api.SrvGetVersionExtra.restype = c_uint32
    api.SrvGetVersionExtra.argtypes = [c_uint32, c_char_p, c_uint32]
    api.HlpPointerArrayNew.restype = c_void_p
    api.HlpPointerArrayNew.argtypes = [c_uint32]
    api.HlpPointerArraySet.restype = None
    api.HlpPointerArraySet.argtypes = [c_void_p, c_uint32, c_void_p]
    api.HlpPointerArrayDelete.restype = None
    api.HlpPointerArrayDelete.argtypes = [c_void_p]

    return api


if 'sphinx' in sys.modules:
    class API:
        def LibInit(self):
            pass

        def LibExit(self):
            pass

    api = API()
else:
    api = load_libtiepie()
