# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src',
 'keycloak': 'src/keycloak',
 'keycloak.authorization': 'src/keycloak/authorization'}

packages = \
['keycloak', 'keycloak.authorization']

package_data = \
{'': ['*']}

install_requires = \
['python-jose>=3.3.0,<4.0.0',
 'requests-toolbelt>=0.9.1,<0.10.0',
 'requests>=2.20.0,<3.0.0',
 'urllib3>=1.26.0,<2.0.0']

extras_require = \
{'docs': ['mock>=4.0.3,<5.0.0',
          'alabaster>=0.7.12,<0.8.0',
          'commonmark>=0.9.1,<0.10.0',
          'recommonmark>=0.7.1,<0.8.0',
          'Sphinx>=5.0.2,<6.0.0',
          'sphinx-rtd-theme>=1.0.0,<2.0.0',
          'readthedocs-sphinx-ext>=2.1.8,<3.0.0',
          'm2r2>=0.3.2,<0.4.0',
          'sphinx-autoapi>=1.8.4,<2.0.0']}

setup_kwargs = {
    'name': 'python-keycloak',
    'version': '2.6.0',
    'description': 'python-keycloak is a Python package providing access to the Keycloak API.',
    'long_description': '[![CircleCI](https://github.com/marcospereirampj/python-keycloak/actions/workflows/daily.yaml/badge.svg)](https://github.com/marcospereirampj/python-keycloak/)\n[![Documentation Status](https://readthedocs.org/projects/python-keycloak/badge/?version=latest)](http://python-keycloak.readthedocs.io/en/latest/?badge=latest)\n\n# Python Keycloak\n\nFor review- see https://github.com/marcospereirampj/python-keycloak\n\n**python-keycloak** is a Python package providing access to the Keycloak API.\n\n## Installation\n\n### Via Pypi Package:\n\n`$ pip install python-keycloak`\n\n### Manually\n\n`$ python setup.py install`\n\n## Dependencies\n\npython-keycloak depends on:\n\n- Python 3\n- [requests](https://requests.readthedocs.io)\n- [python-jose](http://python-jose.readthedocs.io/en/latest/)\n- [urllib3](https://urllib3.readthedocs.io/en/stable/)\n\n### Tests Dependencies\n\n- [tox](https://tox.readthedocs.io/)\n- [pytest](https://docs.pytest.org/en/latest/)\n- [pytest-cov](https://github.com/pytest-dev/pytest-cov)\n- [wheel](https://github.com/pypa/wheel)\n\n## Bug reports\n\nPlease report bugs and feature requests at\nhttps://github.com/marcospereirampj/python-keycloak/issues\n\n## Documentation\n\nThe documentation for python-keycloak is available on [readthedocs](http://python-keycloak.readthedocs.io).\n\n## Contributors\n\n- [Agriness Team](http://www.agriness.com/pt/)\n- [Marcos Pereira](marcospereira.mpj@gmail.com)\n- [Martin Devlin](https://bitbucket.org/devlinmpearson/)\n- [Shon T. Urbas](https://bitbucket.org/surbas/)\n- [Markus Spanier](https://bitbucket.org/spanierm/)\n- [Remco Kranenburg](https://bitbucket.org/Remco47/)\n- [Armin](https://bitbucket.org/arminfelder/)\n- [njordr](https://bitbucket.org/njordr/)\n- [Josha Inglis](https://bitbucket.org/joshainglis/)\n- [Alex](https://bitbucket.org/alex_zel/)\n- [Ewan Jone](https://bitbucket.org/kisamoto/)\n- [Lukas Martini](https://github.com/lutoma)\n- [Adamatics](https://www.adamatics.com)\n\n## Usage\n\n```python\nfrom keycloak import KeycloakOpenID\n\n# Configure client\nkeycloak_openid = KeycloakOpenID(server_url="http://localhost:8080/auth/",\n                                 client_id="example_client",\n                                 realm_name="example_realm",\n                                 client_secret_key="secret")\n\n# Get WellKnow\nconfig_well_known = keycloak_openid.well_known()\n\n# Get Code With Oauth Authorization Request\nauth_url = keycloak_openid.auth_url(\n    redirect_uri="your_call_back_url",\n    scope="email",\n    state="your_state_info")\n\n# Get Access Token With Code\naccess_token = keycloak_openid.token(\n    grant_type=\'authorization_code\',\n    code=\'the_code_you_get_from_auth_url_callback\',\n    redirect_uri="your_call_back_url")\n\n\n# Get Token\ntoken = keycloak_openid.token("user", "password")\ntoken = keycloak_openid.token("user", "password", totp="012345")\n\n# Get token using Token Exchange\ntoken = keycloak_openid.exchange_token(token[\'access_token\'], "my_client", "other_client", "some_user")\n\n# Get Userinfo\nuserinfo = keycloak_openid.userinfo(token[\'access_token\'])\n\n# Refresh token\ntoken = keycloak_openid.refresh_token(token[\'refresh_token\'])\n\n# Logout\nkeycloak_openid.logout(token[\'refresh_token\'])\n\n# Get Certs\ncerts = keycloak_openid.certs()\n\n# Get RPT (Entitlement)\ntoken = keycloak_openid.token("user", "password")\nrpt = keycloak_openid.entitlement(token[\'access_token\'], "resource_id")\n\n# Instropect RPT\ntoken_rpt_info = keycloak_openid.introspect(keycloak_openid.introspect(token[\'access_token\'], rpt=rpt[\'rpt\'],\n                                                                       token_type_hint="requesting_party_token"))\n\n# Introspect Token\ntoken_info = keycloak_openid.introspect(token[\'access_token\'])\n\n# Decode Token\nKEYCLOAK_PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----\\n" + keycloak_openid.public_key() + "\\n-----END PUBLIC KEY-----"\noptions = {"verify_signature": True, "verify_aud": True, "verify_exp": True}\ntoken_info = keycloak_openid.decode_token(token[\'access_token\'], key=KEYCLOAK_PUBLIC_KEY, options=options)\n\n# Get permissions by token\ntoken = keycloak_openid.token("user", "password")\nkeycloak_openid.load_authorization_config("example-authz-config.json")\npolicies = keycloak_openid.get_policies(token[\'access_token\'], method_token_info=\'decode\', key=KEYCLOAK_PUBLIC_KEY)\npermissions = keycloak_openid.get_permissions(token[\'access_token\'], method_token_info=\'introspect\')\n\n# Get UMA-permissions by token\ntoken = keycloak_openid.token("user", "password")\npermissions = keycloak_openid.uma_permissions(token[\'access_token\'])\n\n# Get UMA-permissions by token with specific resource and scope requested\ntoken = keycloak_openid.token("user", "password")\npermissions = keycloak_openid.uma_permissions(token[\'access_token\'], permissions="Resource#Scope")\n\n# Get auth status for a specific resource and scope by token\ntoken = keycloak_openid.token("user", "password")\nauth_status = keycloak_openid.has_uma_access(token[\'access_token\'], "Resource#Scope")\n\n\n# KEYCLOAK ADMIN\n\nfrom keycloak import KeycloakAdmin\n\nkeycloak_admin = KeycloakAdmin(server_url="http://localhost:8080/auth/",\n                               username=\'example-admin\',\n                               password=\'secret\',\n                               realm_name="master",\n                               user_realm_name="only_if_other_realm_than_master",\n                               client_secret_key="client-secret",\n                               verify=True)\n\n# Add user\nnew_user = keycloak_admin.create_user({"email": "example@example.com",\n                                       "username": "example@example.com",\n                                       "enabled": True,\n                                       "firstName": "Example",\n                                       "lastName": "Example"})\n\n# Add user and raise exception if username already exists\n# exist_ok currently defaults to True for backwards compatibility reasons\nnew_user = keycloak_admin.create_user({"email": "example@example.com",\n                                       "username": "example@example.com",\n                                       "enabled": True,\n                                       "firstName": "Example",\n                                       "lastName": "Example"},\n                                      exist_ok=False)\n\n# Add user and set password\nnew_user = keycloak_admin.create_user({"email": "example@example.com",\n                                       "username": "example@example.com",\n                                       "enabled": True,\n                                       "firstName": "Example",\n                                       "lastName": "Example",\n                    "credentials": [{"value": "secret","type": "password",}]})\n\n# Add user and specify a locale\nnew_user = keycloak_admin.create_user({"email": "example@example.fr",\n                                       "username": "example@example.fr",\n                                       "enabled": True,\n                                       "firstName": "Example",\n                                       "lastName": "Example",\n                                       "attributes": {\n                                           "locale": ["fr"]\n                                       }})\n\n# User counter\ncount_users = keycloak_admin.users_count()\n\n# Get users Returns a list of users, filtered according to query parameters\nusers = keycloak_admin.get_users({})\n\n# Get user ID from username\nuser_id_keycloak = keycloak_admin.get_user_id("username-keycloak")\n\n# Get User\nuser = keycloak_admin.get_user("user-id-keycloak")\n\n# Update User\nresponse = keycloak_admin.update_user(user_id="user-id-keycloak",\n                                      payload={\'firstName\': \'Example Update\'})\n\n# Update User Password\nresponse = keycloak_admin.set_user_password(user_id="user-id-keycloak", password="secret", temporary=True)\n\n# Get User Credentials\ncredentials = keycloak_admin.get_credentials(user_id=\'user_id\')\n\n# Get User Credential by ID\ncredential = keycloak_admin.get_credential(user_id=\'user_id\', credential_id=\'credential_id\')\n\n# Delete User Credential\nresponse = keycloak_admin.delete_credential(user_id=\'user_id\', credential_id=\'credential_id\')\n\n# Delete User\nresponse = keycloak_admin.delete_user(user_id="user-id-keycloak")\n\n# Get consents granted by the user\nconsents = keycloak_admin.consents_user(user_id="user-id-keycloak")\n\n# Send User Action\nresponse = keycloak_admin.send_update_account(user_id="user-id-keycloak",\n                                              payload=[\'UPDATE_PASSWORD\'])\n\n# Send Verify Email\nresponse = keycloak_admin.send_verify_email(user_id="user-id-keycloak")\n\n# Get sessions associated with the user\nsessions = keycloak_admin.get_sessions(user_id="user-id-keycloak")\n\n# Get themes, social providers, auth providers, and event listeners available on this server\nserver_info = keycloak_admin.get_server_info()\n\n# Get clients belonging to the realm Returns a list of clients belonging to the realm\nclients = keycloak_admin.get_clients()\n\n# Get client - id (not client-id) from client by name\nclient_id = keycloak_admin.get_client_id("my-client")\n\n# Get representation of the client - id of client (not client-id)\nclient = keycloak_admin.get_client(client_id="client_id")\n\n# Get all roles for the realm or client\nrealm_roles = keycloak_admin.get_realm_roles()\n\n# Get all roles for the client\nclient_roles = keycloak_admin.get_client_roles(client_id="client_id")\n\n# Get client role\nrole = keycloak_admin.get_client_role(client_id="client_id", role_name="role_name")\n\n# Warning: Deprecated\n# Get client role id from name\nrole_id = keycloak_admin.get_client_role_id(client_id="client_id", role_name="test")\n\n# Create client role\nkeycloak_admin.create_client_role(client_role_id=\'client_id\', payload={\'name\': \'roleName\', \'clientRole\': True})\n\n# Assign client role to user. Note that BOTH role_name and role_id appear to be required.\nkeycloak_admin.assign_client_role(client_id="client_id", user_id="user_id", role_id="role_id", role_name="test")\n\n# Retrieve client roles of a user.\nkeycloak_admin.get_client_roles_of_user(user_id="user_id", client_id="client_id")\n\n# Retrieve available client roles of a user.\nkeycloak_admin.get_available_client_roles_of_user(user_id="user_id", client_id="client_id")\n\n# Retrieve composite client roles of a user.\nkeycloak_admin.get_composite_client_roles_of_user(user_id="user_id", client_id="client_id")\n\n# Delete client roles of a user.\nkeycloak_admin.delete_client_roles_of_user(client_id="client_id", user_id="user_id", roles={"id": "role-id"})\nkeycloak_admin.delete_client_roles_of_user(client_id="client_id", user_id="user_id", roles=[{"id": "role-id_1"}, {"id": "role-id_2"}])\n\n# Get all client authorization resources\nclient_resources = get_client_authz_resources(client_id="client_id")\n\n# Get all client authorization scopes\nclient_scopes = get_client_authz_scopes(client_id="client_id")\n\n# Get all client authorization permissions\nclient_permissions = get_client_authz_permissions(client_id="client_id")\n\n# Get all client authorization policies\nclient_policies = get_client_authz_policies(client_id="client_id")\n\n# Create new group\ngroup = keycloak_admin.create_group({"name": "Example Group"})\n\n# Get all groups\ngroups = keycloak_admin.get_groups()\n\n# Get group\ngroup = keycloak_admin.get_group(group_id=\'group_id\')\n\n# Get group by name\ngroup = keycloak_admin.get_group_by_path(path=\'/group/subgroup\', search_in_subgroups=True)\n\n# Function to trigger user sync from provider\nsync_users(storage_id="storage_di", action="action")\n\n# Get client role id from name\nrole_id = keycloak_admin.get_client_role_id(client_id=client_id, role_name="test")\n\n# Get all roles for the realm or client\nrealm_roles = keycloak_admin.get_roles()\n\n# Assign client role to user. Note that BOTH role_name and role_id appear to be required.\nkeycloak_admin.assign_client_role(client_id=client_id, user_id=user_id, role_id=role_id, role_name="test")\n\n# Assign realm roles to user\nkeycloak_admin.assign_realm_roles(user_id=user_id, roles=realm_roles)\n\n# Assign realm roles to client\'s scope\nkeycloak_admin.assign_realm_roles_to_client_scope(client_id=client_id, roles=realm_roles)\n\n# Get realm roles assigned to client\'s scope\nkeycloak_admin.get_realm_roles_of_client_scope(client_id=client_id)\n\n# Remove realm roles assigned to client\'s scope\nkeycloak_admin.delete_realm_roles_of_client_scope(client_id=client_id, roles=realm_roles)\n\nanother_client_id = keycloak_admin.get_client_id("my-client-2")\n\n# Assign client roles to client\'s scope\nkeycloak_admin.assign_client_roles_to_client_scope(client_id=another_client_id, client_roles_owner_id=client_id, roles=client_roles)\n\n# Get client roles assigned to client\'s scope\nkeycloak_admin.get_client_roles_of_client_scope(client_id=another_client_id, client_roles_owner_id=client_id)\n\n# Remove client roles assigned to client\'s scope\nkeycloak_admin.delete_client_roles_of_client_scope(client_id=another_client_id, client_roles_owner_id=client_id, roles=client_roles)\n\n# Get all ID Providers\nidps = keycloak_admin.get_idps()\n\n# Create a new Realm\nkeycloak_admin.create_realm(payload={"realm": "demo"}, skip_exists=False)\n\n# Changing Realm\nkeycloak_admin = KeycloakAdmin(realm_name="main", ...)\nkeycloak_admin.get_users() # Get user in main realm\nkeycloak_admin.realm_name = "demo" # Change realm to \'demo\'\nkeycloak_admin.get_users() # Get users in realm \'demo\'\nkeycloak_admin.create_user(...) # Creates a new user in \'demo\'\n```\n',
    'author': 'Marcos Pereira',
    'author_email': 'marcospereira.mpj@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
