from setuptools import setup, find_packages

setup(
    name="yapytf",
    description="Yet Another Python Terraform Wrapper",
    long_description=open("README.md").read(),  # no "with..." will do for setup.py
    long_description_content_type="text/markdown; charset=UTF-8; variant=GFM",
    license="MIT",
    author="Kyrylo Shpytsya",
    author_email="kshpitsa@gmail.com",
    url="https://github.com/kshpytsya/yapytf",
    install_requires=[
        "click>=7.1.1,<8",
        "click-log>=0.3.2,<1",
        "dataclasses>=0.6,<1; python_version < '3.7'",
        "implements>=0.1.4,<1",
        # "jinja2>=2.11.1,<3",
        "jsonschema>=3.2.0,<4",
        "mypy>=0.770,<1",
        # "pytypes @ git+ssh://git@github.com/Stewori/pytypes1449eff#egg=pytypes",
        "PyYAML>=5.3.1,<6",
        "requests>=2.23.0,<3",
        "toposort>=1.5,<2",
        "tqdm>=4.45.0,<5",
        "typeguard>=2.7.1,<3",
        "typing-inspect>=0.5.0,<1",
        "xdgappdirs>=1.4.5,<2",
    ],
    setup_requires=["setuptools_scm"],
    use_scm_version=True,
    python_requires=">=3.6, <3.9",
    packages=find_packages(where="src"),
    package_dir={"": "src"},
    zip_safe=False,
    entry_points={
        "console_scripts": ["yapytf = yapytf._cli:main"]
    },
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Intended Audience :: Information Technology",
        "Intended Audience :: System Administrators",
        "License :: OSI Approved :: MIT License",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
        "Operating System :: POSIX :: BSD :: FreeBSD",
        "Operating System :: POSIX :: BSD :: OpenBSD",
        "Operating System :: POSIX :: Linux",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Topic :: System :: Systems Administration",
    ],
)
