# coding=utf-8
"""
    DB Constants
"""

JSON_APPROVER_STR = 'approver'

# SystemIds
SYSTEM_NECTAR_UUID = 'NeCTAR_UUID'
SYSTEM_NECTAR_CREATED_BY = 'NeCTAR_Created_By'
SYSTEM_NECTAR_DB_ID = 'NeCTAR_DB_Id'
SYSTEM_NECTAR = 'NeCTAR'
SYSTEM_VICNODE = 'VicNode'
SYSTEM_RACMON_SONAS = 'SONAS'
SYSTEM_HPC = 'HPC'

# eResearch Body
eRESEARCH_BODY_RACMON = 'RaCMon'
eRESEARCH_BODY_HPC = 'HPC'

# eResearch Systems
eSYSTEM_NECTAR = 'NeCTAR'
eSYSTEM_RACMON_MONASH = 'RaCMon-Monash'
eSYSTEM_VICNODE = 'VicNode'
eSYSTEM_MASSIVE = 'MASSIVE'
eSYSTEM_CVL = 'CVL'
eSYSTEM_MONARCH = 'MonARCH'

# Allocation Home
ALLOCATION_HOME_MONASH = 'Monash'

# ERB IdKeys
ERB_ID_NECTAR_TENANT_ID = 'NECTAR_TENANT_ID'

# Contact Role
APPLICANT = 'Applicant'
CHIEF_INVESTIGATOR = 'Chief Investigator'
INVITEE = 'Invitee'
DATA_CUSTODIAN = 'Data Custodian'
TECHNICAL_CONTACT = 'Technical Contact'

# ERB IDs
HPC_POSIX_USERID = 'HPC_POSIX_USERID'
HPC_POSIX_GROUP_ID = 'HPC_POSIX_GROUP_ID'
HPC_SOFTWARE_GROUP_ID = 'HPC_SOFTWARE_GROUP_ID'

# Request Status Codes
REQUEST_STATUS_NEW = 'N'
REQUEST_STATUS_SUBMITTED = 'E'
REQUEST_STATUS_UPDATE_OR_EXTEND = 'X'
REQUEST_STATUS_APPROVED = 'A'
REQUEST_STATUS_DECLINED = 'R'
REQUEST_STATUS_PARTIAL_PROVISIONED = '_PP'
REQUEST_STATUS_PROVISIONED = 'P'
REQUEST_STATUS_UPDATE_OR_EXTEND_DECLINED = 'J'
REQUEST_STATUS_LEGACY_SUB = 'L'
REQUEST_STATUS_LEGACY_APPROVED = 'M'
REQUEST_STATUS_LEGACY_DECLINED = 'O'
REQUEST_STATUS_APPLICATION_UPDATED = 'U'

REQUEST_STATUS_EXTEND_DRAFT = 'D'
DRAFT_PERMISSIBLE_STATES = [REQUEST_STATUS_NEW,
                            REQUEST_STATUS_PROVISIONED,
                            REQUEST_STATUS_EXTEND_DRAFT]
DRAFT_STATES = [REQUEST_STATUS_NEW, REQUEST_STATUS_EXTEND_DRAFT]
EDIT_STATUS = DRAFT_STATES + [REQUEST_STATUS_SUBMITTED,
                              REQUEST_STATUS_DECLINED,
                              REQUEST_STATUS_UPDATE_OR_EXTEND_DECLINED,
                              REQUEST_STATUS_UPDATE_OR_EXTEND]

LEGACY_STATES = [REQUEST_STATUS_LEGACY_DECLINED,
                 REQUEST_STATUS_LEGACY_APPROVED, REQUEST_STATUS_LEGACY_SUB]
NON_ADMIN_STATES = [REQUEST_STATUS_NEW, REQUEST_STATUS_SUBMITTED,
                    REQUEST_STATUS_UPDATE_OR_EXTEND, REQUEST_STATUS_LEGACY_SUB]

APPROVAL_STATES = [REQUEST_STATUS_APPROVED, REQUEST_STATUS_LEGACY_APPROVED]

NEW_REQUEST_STATUS = [REQUEST_STATUS_NEW, REQUEST_STATUS_SUBMITTED, REQUEST_STATUS_DECLINED]
DECLINED_STATES = [
    REQUEST_STATUS_DECLINED,
    REQUEST_STATUS_UPDATE_OR_EXTEND_DECLINED,
    REQUEST_STATUS_LEGACY_DECLINED]
ADMIN_STATES = APPROVAL_STATES + DECLINED_STATES + [REQUEST_STATUS_PROVISIONED]
QUOTA_CHANGE_STATES = ADMIN_STATES  # approved + declined + provisioned states

# Notification Contact ROLEs
E_RESEARCH_BODY_ADMIN = 'E_RESEARCH_BODY Admin'
E_RESEARCH_BODY_SYSTEM_ADMIN = 'E_RESEARCH_BODY_SYSTEM Admin'
E_RESEARCH_SYSTEM_DELEGATE = 'E_RESEARCH_SYSTEM_DELEGATE'
E_RESEARCH_BODY_SYSTEM_APPROVER = 'E_RESEARCH_BODY_SYSTEM_Approver'
E_RESEARCH_BODY_SYSTEM_PROVISIONER = 'E_RESEARCH_BODY_SYSTEM_Provisioner'

NOTIFY_CONTACT = 'NOTIFY_CONTACT'
NOTIFY_PROJECT_LEADER ='NOTIFY_PROJECT_LEADER'
NOTIFY_NON_READONLY_PROJECT_CONTACT = 'NOTIFY_NON_READONLY_PROJECT_CONTACT'
NOTIFY_READ_ONLY_PROJECT_CONTACT = 'NOTIFY_READ_ONLY_PROJECT_CONTACT'

PRODUCT_NAME_MAPPING = []

