# coding: utf-8

"""
    Storage API

     The storage service is an Agentverse service that makes it easier for users and agents to transfer assets.  For this initial use case, we will not be support the agent to agent use case.  In this way, users of Agentverse can create assets and set permissions for these assets to other users.  Importantly only the User ↔ [Agent] interactions are supported.  The user is always in control and must always create the asset which can the agents are interacting with.  This is an ephemeral storage engine, and is only expected to be used for short periods of time. 

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class NewAsset(BaseModel):
    """
    NewAsset
    """ # noqa: E501
    lifetime_hours: Annotated[int, Field(le=24, strict=True, ge=1)] = Field(description="Asset lifetime in hours (1–24).")
    mime_type: Optional[StrictStr] = None
    contents: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["lifetime_hours", "mime_type", "contents", "name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NewAsset from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if mime_type (nullable) is None
        # and model_fields_set contains the field
        if self.mime_type is None and "mime_type" in self.model_fields_set:
            _dict['mime_type'] = None

        # set to None if contents (nullable) is None
        # and model_fields_set contains the field
        if self.contents is None and "contents" in self.model_fields_set:
            _dict['contents'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NewAsset from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "lifetime_hours": obj.get("lifetime_hours"),
            "mime_type": obj.get("mime_type"),
            "contents": obj.get("contents"),
            "name": obj.get("name")
        })
        return _obj


