# coding: utf-8

"""
    Agent Hosting API

      ## Overview  The Agent Hosting API helps users deploy agents to the cloud  ## Authentication  The entire API requires that the user authenticate with the ecosystem first before accessing the api 

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PublicAgent(BaseModel):
    """
    PublicAgent
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the agent.")
    author_username: StrictStr = Field(description="Username of the agent's author.")
    address: StrictStr = Field(description="Bech32 address of the agent.")
    domain: Optional[StrictStr] = None
    prefix: Optional[StrictStr] = None
    running: StrictBool = Field(description="Indicates if the agent is currently running.")
    readme: Optional[StrictStr] = None
    short_description: Optional[StrictStr] = None
    total_interactions: StrictInt = Field(description="Number of total interactions the agent has had.")
    last_updated_at: datetime = Field(description="Timestamp when the agent was last updated.")
    created_at: datetime = Field(description="Timestamp when the agent was created.")
    maintainer_id: Optional[StrictStr] = None
    avatar_url: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["name", "author_username", "address", "domain", "prefix", "running", "readme", "short_description", "total_interactions", "last_updated_at", "created_at", "maintainer_id", "avatar_url"]

    @field_validator('prefix')
    def prefix_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['agent', 'test-agent']):
            raise ValueError("must be one of enum values ('agent', 'test-agent')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PublicAgent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if domain (nullable) is None
        # and model_fields_set contains the field
        if self.domain is None and "domain" in self.model_fields_set:
            _dict['domain'] = None

        # set to None if prefix (nullable) is None
        # and model_fields_set contains the field
        if self.prefix is None and "prefix" in self.model_fields_set:
            _dict['prefix'] = None

        # set to None if readme (nullable) is None
        # and model_fields_set contains the field
        if self.readme is None and "readme" in self.model_fields_set:
            _dict['readme'] = None

        # set to None if short_description (nullable) is None
        # and model_fields_set contains the field
        if self.short_description is None and "short_description" in self.model_fields_set:
            _dict['short_description'] = None

        # set to None if maintainer_id (nullable) is None
        # and model_fields_set contains the field
        if self.maintainer_id is None and "maintainer_id" in self.model_fields_set:
            _dict['maintainer_id'] = None

        # set to None if avatar_url (nullable) is None
        # and model_fields_set contains the field
        if self.avatar_url is None and "avatar_url" in self.model_fields_set:
            _dict['avatar_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PublicAgent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "author_username": obj.get("author_username"),
            "address": obj.get("address"),
            "domain": obj.get("domain"),
            "prefix": obj.get("prefix"),
            "running": obj.get("running"),
            "readme": obj.get("readme"),
            "short_description": obj.get("short_description"),
            "total_interactions": obj.get("total_interactions"),
            "last_updated_at": obj.get("last_updated_at"),
            "created_at": obj.get("created_at"),
            "maintainer_id": obj.get("maintainer_id"),
            "avatar_url": obj.get("avatar_url")
        })
        return _obj


