# agentverse-client
An API for our smart search engine that provides the agent that best fits your needs.

The `agentverse_client.search.aio` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- Package version: 1.0.0
- Generator version: 7.11.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

In this README.md we will cover the **async** version of this client, in case you are looking for the **sync** version,
please, check the following [README.md](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search_README.md).

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.25.3, < 3.0.0
* python-dateutil >= 2.8.2
* aiohttp >= 3.8.4
* aiohttp-retry >= 2.8.3
* pydantic >= 2
* typing-extensions >= 4.7.1

## Getting Started

In your own code, to use this library to connect and interact with agentverse-client,
you can run the following:

```python
import asyncio

from agentverse_client.search.aio import (
    SearchApi,
    ApiClient,
    AgentSearchRequest,
    AgentSearchResponse,
    SortType,
    Direction,
    SearchFeedbackRequest
)
from agentverse_client.search.aio.rest import ApiException
from pprint import pprint

async def main():
    # Defining the host is optional and defaults to https://agentverse.ai

    # Enter a context with an instance of the API client
    async with ApiClient() as api_client:
        # Create an instance of the API class
        api_instance = SearchApi(api_client)

        # Notice in that request you could add some filters if you wish, the options are many.
        agent_search_request = AgentSearchRequest(
            search_text="Financial advisor",
            sort=SortType.RELEVANCY,
            direction=Direction.ASC,  # Please, notice that ASC and DESC work reversed of what you could expect.
            offset=0,
            limit=10,
        )
        try:
            search_response: AgentSearchResponse = await api_instance.search_agents(agent_search_request)
            print("The response of SearchApi->search_agents:\n")
            pprint(search_response)
        except ApiException as e:
            print("Exception when calling SearchApi->search_agents: %s\n" % e)

        search_response_d: dict = search_response.model_dump()
        page_index: int = search_response_d.get("offset") // search_response_d.get("num_hits")
        search_feedback_request: SearchFeedbackRequest = SearchFeedbackRequest(
            search_id=search_response_d.get("search_id"),
            page_index=page_index,
            address=search_response_d.get("agents")[0].get("address"),
        )

        try:
            await api_instance.feedback(search_feedback_request)
            print("Successful request to SearchApi->feedback\n")
        except Exception as e:
            print("Exception when calling SearchApi->feedback: %s\n" % e)
            raise

if __name__ == "__main__":
    asyncio.run(main())
```

## Documentation for API Endpoints

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*SearchApi* | [**feedback**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/SearchApi.md#feedback) | **POST** /v1/search/agents/click | Feedback
*SearchApi* | [**get_agent_interactions_count**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/SearchApi.md#get_agent_interactions_count) | **GET** /v1/search/agents/interactions/{address} | Get Interaction Counts Of Agent
*SearchApi* | [**get_agent_search_terms_analytics**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/SearchApi.md#get_agent_search_terms_analytics) | **POST** /v1/search/analytics/agents/terms | Get Agent Search Term Analytics
*SearchApi* | [**get_agent_searches_analytics**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/SearchApi.md#get_agent_searches_analytics) | **POST** /v1/search/analytics/agents | Get Agent Search Analytics
*SearchApi* | [**get_function_interactions**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/SearchApi.md#get_function_interactions) | **GET** /v1/search/functions/interactions/{function_id} | Get Recent Interactions Of Function
*SearchApi* | [**search_agent_by_geolocation**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/SearchApi.md#search_agent_by_geolocation) | **POST** /v1/search/agents/geo | Search Agent By Geolocation
*SearchApi* | [**search_agent_tags**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/SearchApi.md#search_agent_tags) | **GET** /v1/search/agents/tags | Search Agent Tags
*SearchApi* | [**search_agents**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/SearchApi.md#search_agents) | **POST** /v1/search/agents | Search Agents
*SearchApi* | [**search_functions**](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/SearchApi.md#search_functions) | **POST** /v1/search/functions | Search Functions


## Documentation For Models

 - [Agent](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/Agent.md)
 - [AgentAllTimeInteractionCounts](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentAllTimeInteractionCounts.md)
 - [AgentCategory](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentCategory.md)
 - [AgentSearchRequest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentSearchRequest.md)
 - [AgentFilters](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentFilters.md)
 - [AgentGeoFilter](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentGeoFilter.md)
 - [AgentGeoLocation](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentGeoLocation.md)
 - [AgentGeoSearchRequest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentGeoSearchRequest.md)
 - [AgentInteractionCountsResponse](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentInteractionCountsResponse.md)
 - [AgentSearchAnalyticsRequest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentSearchAnalyticsRequest.md)
 - [AgentSearchAnalyticsResponse](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentSearchAnalyticsResponse.md)
 - [AgentSearchRequest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentSearchRequest.md)
 - [AgentSearchResponse](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentSearchResponse.md)
 - [AgentSearchTermAnalyticsRequest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentSearchTermAnalyticsRequest.md)
 - [AgentSearchTermAnalyticsResponse](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentSearchTermAnalyticsResponse.md)
 - [AgentTag](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentTag.md)
 - [AgentTagSearchResponse](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentTagSearchResponse.md)
 - [AgentType](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/AgentType.md)
 - [Direction](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/Direction.md)
 - [Function](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/Function.md)
 - [FunctionFilters](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/FunctionFilters.md)
 - [FunctionLast30daysInteractions](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/FunctionLast30daysInteractions.md)
 - [FunctionSearchRequest](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/FunctionSearchRequest.md)
 - [FunctionSearchResponse](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/FunctionSearchResponse.md)
 - [FunctionType](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/FunctionType.md)
 - [HTTPValidationError](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/HTTPValidationError.md)
 - [InteractionsThreshold](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/InteractionsThreshold.md)
 - [LocationInner](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/LocationInner.md)
 - [NetProtocol](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/NetProtocol.md)
 - [Protocol](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/Protocol.md)
 - [RelevancyCutoff](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/RelevancyCutoff.md)
 - [SearchTermPercentage](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/SearchTermPercentage.md)
 - [SortType](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/SortType.md)
 - [StatusType](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/StatusType.md)
 - [ValidationError](https://github.com/fetchai/api-clients/blob/main/agentverse-client/agentverse_client/search/aio/docs/ValidationError.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author



