# Ask Sage Python Client

This is the official Python client for the Ask Sage API. It allows you to interact with the Ask Sage service, providing a simple and pythonic way to make requests to the service.

Check Ask Sage API documentation here:

Ask Sage User API: https://app.swaggerhub.com/apis-docs/NICOLASCHAILLAN_1/user-api/1.0

Ask Sage Server API: https://app.swaggerhub.com/apis-docs/NICOLASCHAILLAN_1/server_ask-sage_api/1.0

## Installation

You can install the Ask Sage Python client via pip:

pip install asksageclient

## Usage

First, import the client:

from asksageclient import AskSageClient

Then, instantiate the client:

client = AskSageClient('your_email_here', 'your_api_key_here')

Now, you can use the client to interact with the Ask Sage service. For example, to interact with the main endpoint:

response = client.query(message='Who is Nic Chaillan?')

print(response)


## Endpoints

The client provides methods for all the Ask Sage API endpoints:

- `add_dataset`
- `delete_dataset`
- `assign_dataset`
- `get_user_logs`
- `get_user_logins`
- `query`
- `query_with_file`
- `query_plugin`
- `follow_up_questions`
- `tokenizer`
- `get_personas`
- `get_datasets`
- `get_plugins`
- `count_monthly_tokens`
- `count_monthly_teach_tokens`
- `train`
- `file`

Each method corresponds to an endpoint of the Ask Sage API. The `content` parameter should be a dictionary containing the data you want to send in the request body.

## Error Handling

The client includes basic error handling. If a request fails, it will print an error message and return `None`.

## Contributing

Contributions are welcome! Please submit a pull request or create an issue to contribute to this project.

## License

See the LICENSE file for details.
