#
# Copyright 2016 Goldman Sachs.
#
# Licensed under the Apache License, Version 2.0 (the "License") you may not use self file except in compliance with the License.
#
# You may obtain a copy of the License at
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations under the License.
#
from jdmn.runtime.annotation import DRGElementKind, ExpressionKind
from jdmn.runtime.annotation.HitPolicy import HitPolicy


class DRGElement:
    def __init__(self, namespace: str, name: str, label: str, elementKind: DRGElementKind, expressionKind: ExpressionKind, hitPolicy: HitPolicy, rulesCount: int):
        self.namespace = namespace
        self.name = name
        self.label = label
        self.elementKind = elementKind
        self.expressionKind = expressionKind
        self.hitPolicy = hitPolicy
        self.rulesCount = rulesCount
