import io
import unittest

from installed_packages_diff.differ import create_diff
from installed_packages_diff.package import Package
from installed_packages_diff.printing import print_diff

input1 = """aaa_base-11-6.115.1
acl-2.2.47-30.36.1
acpid-1.0.6-91.25.20
adaptec-firmware-1.35-2.15.4
aspell-0.60.6-26.22
aspell-en-6.0-160.7
aspell-ispell-0.60.6-26.22
at-3.1.8-1069.22.30.1
atk-1.28.0-1.4.1
atk-lang-1.28.0-1.4.1
atmel-firmware-1.3-139.15.4
attr-2.4.43-1.18
audit-1.8-0.34.26
audit-libs-1.8-0.34.26
audit-libs-32bit-1.8-0.34.26
augeas-lenses-0.9.0-3.21.6.1
autoconf-2.63-1.160.2
autofs-5.0.6-42.8.26
automake-1.10.1-4.131.9.1
autoyast2-2.17.82-5.1
autoyast2-installation-2.17.82-5.1
bash-3.2-152.1
bash-doc-3.2-152.1
bc-1.06-838.15
bind-libs-9.9.6P1-0.51.26.1
bind-utils-9.9.6P1-0.51.26.1
binutils-2.25.0-5.5
bison-2.3-127.112
blktrace-1.0.3-0.7.1
boost-license-1.36.0-12.8.1
bootcycle-0.3-225.18
bootsplash-3.3-146.24.12
bootsplash-branding-SLES-3.1-47.22
branding-SLES-11-3.20.30
bridge-utils-1.4-23.18.3.2
brocade-firmware-3.2.3.0-0.11.35
bzip2-1.0.5-34.256.8.1
cairo-1.8.8-2.3.7.1
cairo-32bit-1.8.8-2.3.7.1
cdrkit-cdrtools-compat-1.1.8-3.34.3.1
checkmedia-3.0-0.9.1
cifs-utils-5.1-0.14.46
command-not-found-0.1.0-29.9.29
ConsoleKit-0.2.10-64.69.1
ConsoleKit-32bit-0.2.10-64.69.1
convmv-1.12-1.22
coreutils-8.12-6.25.33.3.1
coreutils-lang-8.12-6.25.33.3.1
cpio-2.9-75.80.1
cpio-lang-2.9-75.80.1
cpp33-3.3.3-11.9
cpp43-4.3.4_20091019-37.9.1
cpp-4.3-62.200.2
cpufrequtils-004-35.20
cpupower-3.19-2.23.3
cracklib-2.8.12-56.13.1
cracklib-32bit-2.8.12-56.13.1
cracklib-dict-full-2.8.12-43.16
crash-7.0.9-30.9.1
crash-eppic-7.0.9-30.9.1
cron-4.1-194.211.213.1
cryptconfig-0.3-68.8.17
cryptsetup-1.1.3-2.10
ctags-2013.10.2-0.3.1
cups-client-1.3.9-8.46.56.18.1
cups-libs-1.3.9-8.46.56.18.1
cups-libs-32bit-1.3.9-8.46.56.18.1
curl-7.37.0-70.66.1
cvs-1.12.12-144.23.5.3.1
cyrus-sasl-2.1.22-182.26.4.1
cyrus-sasl-32bit-2.1.22-182.26.4.1
cyrus-sasl-digestmd5-2.1.22-182.26.4.1
cyrus-sasl-gssapi-2.1.22-182.26.4.1
cyrus-sasl-openssl1-2.1.22-182.26.4.1
cyrus-sasl-plain-2.1.22-182.26.4.1
cyrus-sasl-saslauthd-2.1.22-182.26.4.1
dbus-1-1.2.10-3.34.8.1
dbus-1-32bit-1.2.10-3.34.8.1
dbus-1-glib-0.76-34.22.1
dbus-1-python-0.83.0-27.1.43
db-utils-4.5.20-97.5
delayacct-utils-2.6.32.12-3.3.38
deltarpm-3.6.1-4.11.1
desktop-data-SLED-11-29.22.58
desktop-translations-11.1-10.50.1
device-mapper-1.02.77-0.15.14
dhcpcd-3.2.3-45.5.3
diffutils-2.8.7-143.23.1
DirectFB-1.2.3-6.32
dirmngr-1.0.2-1.19
dmapi-2.2.10-8.7.2
dmraid-1.0.0.rc16-0.15.3
dos2unix-3.1-438.22.1
dosfstools-3.0.26-3.1
ds_agent-9.5.3-2754
e2fsprogs-1.41.9-2.16.1
ed-0.2-1001.30.3.4
efibootmgr-0.6.0-2.23
eject-2.1.0-115.19.2.1
elfutils-0.152-4.9.17
elilo-3.14-0.39.3.1
emacs-22.3-42.6.1
emacs-info-22.3-42.6.1
emacs-x11-22.3-42.6.1
ethtool-6.2.6.39-0.29.3
expat-2.0.1-88.42.3.2
expect-5.44.1.11-1.241.1
facter-1.6.18-0.3.1
fastjar-0.95-1.24.1
fbset-2.1-919.22
file-4.24-43.27.1
filesystem-11.1-3.5.3
fillup-1.42-242.21
findutils-4.4.0-38.26.1
finger-1.3-104.22
FirmwareUpdateKit-1.1-2.17
flex-2.5.35-43.98
fontconfig-2.6.0-10.20.5.2
fontconfig-32bit-2.6.0-10.20.5.2
fping-2.4b2-97.5
freetype2-2.3.7-25.45.8.1
freetype2-32bit-2.3.7-25.45.8.1
fuse-2.8.7-0.11.3.1
gawk-3.1.8-2.6.1
gcc33-32bit-3.3.3-11.9
gcc33-3.3.3-11.9
gcc43-32bit-4.3.4_20091019-37.9.1
gcc43-4.3.4_20091019-37.9.1
gcc-4.3-62.200.2
gcc43-c++-4.3.4_20091019-37.9.1
gcc43-info-4.3.4_20091019-37.9.1
gcc43-locale-4.3.4_20091019-37.9.1
gcc-c++-4.3-62.200.2
gcc-info-4.3-62.200.2
gcc-locale-4.3-62.200.2
gconf2-2.28.0-1.8.1
gconf2-branding-SLES-2.25-0.13.31
gconf2-lang-2.28.0-1.8.1
gd-2.0.36.RC1-52.33.5.1
gdb-7.9.1-8.2
gdbm-1.8.3-374.25
gdbm-devel-1.8.3-374.25
genisoimage-1.1.8-3.34.3.1
gettext-runtime-0.17-61.40
gfxboot-4.1.34-0.5.44
gfxboot-branding-SLES-4.1.34-0.5.44
giflib-4.1.6-21.1
git-1.7.12.4-0.18.17.1
git-core-1.7.12.4-0.18.17.1
glib2-2.22.5-0.8.39.1
glib2-branding-SLES-2.16-47.3
glib2-lang-2.22.5-0.8.39.1
glibc-2.11.3-17.110.33.1
glibc-32bit-2.11.3-17.110.33.1
glibc-devel-2.11.3-17.110.33.1
glibc-devel-32bit-2.11.3-17.110.33.1
glibc-i18ndata-2.11.3-17.110.33.1
glibc-info-2.11.3-17.110.33.1
glibc-locale-2.11.3-17.110.33.1
gmp-4.2.3-10.99
gnome-icon-theme-2.28.0-1.2.11
gnome-keyring-2.28.2-1.14.30
gnome-keyring-lang-2.28.2-1.14.30
gnuplot-4.2.3-5.34
gpart-0.1h-565.22
gpg2-2.0.9-25.33.42.3.1
gpg2-lang-2.0.9-25.33.42.3.1
gpgme-1.1.6-25.32.1
gpg-pubkey-257a4686-60101325
gpg-pubkey-257a4686-60101325
gpg-pubkey-307e3d54-4be01a65
gpg-pubkey-39db7c82-510a966b
gpg-pubkey-3d25d3d9-36e12d04
gpg-pubkey-50a3dd1c-50f35137
gpg-pubkey-9c800aca-4be01999
gpg-pubkey-b37b98a9-4be01a1a
gpg-pubkey-de57bfbe-53a9be98
gpm-1.20.1-452.83
grep-2.7-5.7.1
groff-1.18.1.1-167.18.61
growpart-0.27-0.7.16
grub-0.97-172.3.2
gtk2-2.18.9-0.45.8.1
gtk2-32bit-2.18.9-0.45.8.1
gtk2-branding-SLED-11.1-1.26
gtk2-engines-2.16.1-4.26
gtk2-engines-32bit-2.16.1-4.26
gtk2-lang-2.18.9-0.45.8.1
gtk2-theme-SLED-11.1-1.29.82
gvfs-1.4.3-0.17.21.1
gvfs-backends-1.4.3-0.17.21.1
gvfs-fuse-1.4.3-0.17.21.1
gvfs-lang-1.4.3-0.17.21.1
gzip-1.3.12-69.23.1
hal-0.5.12-23.76.1
haveged-1.3-0.6.1
hdparm-9.27-1.6.39
hicolor-icon-theme-0.10-102.22
hwinfo-15.57-0.12.2
icedax-1.1.8-3.34.3.1
icmpinfo-1.11-691.22
icom-firmware-1.0-124.28.4
ifplugd-0.28-210.20
info-4.12-1.86
initviocons-0.5-55.21
insserv-1.12.0-25.11.47
inst-source-utils-2013.1.25-0.20.10
iotop-0.4.3-7.8.1
ipmitool-1.8.15-0.30.3.1
iproute2-3.0-5.3.2
iptables-1.4.16.3-1.37
iputils-ss021109-292.28.1
ipw-firmware-9-1.6.4
irqbalance-1.0.4-0.23.2
ivman-0.6.14-201.31.1
joe-3.5-92.22
kbd-1.14.1-16.33.1
kdump-0.8.4-56.6.1
kernel-default-3.0.101-108.126.1
kernel-default-3.0.101-108.129.1
kernel-default-base-3.0.101-108.126.1
kernel-default-base-3.0.101-108.129.1
kernel-default-devel-3.0.101-108.126.1
kernel-default-devel-3.0.101-108.129.1
kernel-firmware-20110923-0.59.3.1
kernel-source-3.0.101-108.126.1
kernel-source-3.0.101-108.129.1
kexec-tools-2.0.3-0.20.2
keyutils-1.2-107.29.15
keyutils-libs-1.2-107.29.15
keyutils-libs-32bit-1.2-107.29.15
klogd-1.4.1-708.44.32
kpartx-0.4.9-123.8.1
krb5-1.6.3-133.49.113.13.1
krb5-32bit-1.6.3-133.49.113.13.1
ksh-93u-0.37.1
ksymoops-2.4.11-117.22
lcms-1.17-77.16.1
less-424b-10.24.1
lgtoclnt-19.5.0.1-1
lgtoman-19.5.0.1-1
lgtonmda-19.5.0.1-1
lgtoxtdclnt-19.5.0.1-1
libacl-2.2.47-30.36.1
libaio-0.3.109-0.1.46
libaio-32bit-0.3.109-0.1.46
libaio-devel-0.3.109-0.1.46
libaio-devel-32bit-0.3.109-0.1.46
libapr1-1.3.3-11.18.19.13.2
libapr-util1-1.3.4-12.22.23.3.2
libarchive2-2.5.5-9.1
libasm1-0.152-4.9.17
libasound2-1.0.18-16.24.1
libatk-1_0-0-1.28.0-1.4.1
libatk-1_0-0-32bit-1.28.0-1.4.1
libattr-2.4.43-1.18
libaugeas0-0.9.0-3.21.6.1
libavahi-client3-0.6.23-35.6.2
libavahi-common3-0.6.23-35.6.2
libavahi-glib1-0.6.23-35.6.1
libblkid1-2.19.1-6.72.1
libblocxx6-2.1.0.342-122.6
libbluetooth3-4.99-0.12.35
libboost_regex1_36_0-1.36.0-12.8.1
libbz2-1-1.0.5-34.256.8.1
libcap1-1.10-6.10
libcap2-2.11-2.17.1
libcdio7-0.80-6.11
libcdio_cdda0-0.80-6.11
libcdio_paranoia0-0.80-6.11
libcom_err2-1.41.9-2.16.1
libcom_err2-32bit-1.41.9-2.16.1
libcroco-0_6-3-0.6.1-120.16
libcryptsetup0-1.0.5_SVNr46-58.37.3
libcryptsetup1-1.1.3-2.10
libcurl4-7.37.0-70.66.1
libdb-4_5-32bit-4.5.20-97.5
libdb-4_5-4.5.20-97.5
libdw1-0.152-4.9.17
libebl1-0.152-4.9.17
libelf0-0.8.12-1.1.52
libelf1-0.152-4.9.17
libesmtp-1.0.4-157.17.2
libevent-1_4-2-1.4.5-24.24.3.1
libexif-0.6.17-2.14.7.2
libexpat1-2.0.1-88.42.3.2
libexpat1-32bit-2.0.1-88.42.3.2
libext2fs2-1.41.9-2.16.1
libfprint0-0.0.6-18.22.136
libfuse2-2.8.7-0.11.3.1
libgcc43-32bit-4.6.9-0.14.1.9
libgcc43-4.6.9-0.14.1.9
libgcc46-4.6.9-0.13.22
libgcc_s1-32bit-5.3.1+r233831-14.1
libgcc_s1-5.3.1+r233831-14.1
libgcrypt11-1.5.0-0.26.6.1
libgio-2_0-0-2.22.5-0.8.39.1
libgio-2_0-0-32bit-2.22.5-0.8.39.1
libglib-2_0-0-2.22.5-0.8.39.1
libglib-2_0-0-32bit-2.22.5-0.8.39.1
libgmodule-2_0-0-2.22.5-0.8.39.1
libgmodule-2_0-0-32bit-2.22.5-0.8.39.1
libgnutls26-2.4.1-24.39.70.1
libgobject-2_0-0-2.22.5-0.8.39.1
libgobject-2_0-0-32bit-2.22.5-0.8.39.1
libgomp1-32bit-5.3.1+r233831-14.1
libgomp1-5.3.1+r233831-14.1
libgomp43-32bit-4.6.9-0.14.1.9
libgomp46-32bit-4.6.9-0.13.22
libgpg-error0-1.10-0.7.29
libgpgme11-1.1.6-25.32.1
libgphoto2-2.4.3-3.27.1
libgphoto2-lang-2.4.3-3.27.1
libgsf-1-114-1.14.9-2.27
libgssglue1-0.1-20.2.1
libgthread-2_0-0-2.22.5-0.8.39.1
libgthread-2_0-0-32bit-2.22.5-0.8.39.1
libgvfscommon0-1.4.3-0.17.21.1
libHX13-1.23-4.13.1
libicu-4.0-47.6.1
libidl-0.8.13-1.1.57
libidn-1.10-7.3.1
libiniparser0-2.17-87.17
libiniparser0-32bit-2.17-87.17
libiptc0-1.4.16.3-1.37
libjpeg-32bit-6.2.0-879.12.7.1
libjpeg-6.2.0-879.12.7.1
libksba-1.0.4-1.25.1
liblcms1-1.17-77.16.1
libldap-2_4-2-2.4.26-0.74.26.1
libldap-2_4-2-32bit-2.4.26-0.74.26.1
libldapcpp1-0.3.0-0.9.29
libldap-openssl1-2_4-2-2.4.26-0.74.26.1
libldb1-3.6.3-94.34.1
libltdl7-2.2.6-2.133.1
liblzma5-5.0.3-0.12.3.1
liblzmadec0-4.32.7-1.25
liblzo2-2-2.03-12.3.1
libMagickCore1-6.4.3.6-78.135.1
libmng-1.0.10-46.18
libmpfr1-2.3.2-3.118.2
libmspack0-0.0.20060920alpha-74.11.6.1
libncurses5-32bit-5.6-93.15.1
libncurses5-5.6-93.15.1
libncurses6-5.6-93.15.1
libneon27-0.29.6-6.7.1
libnet-1.1.2.1-140.24.1
libnewt0_52-0.52.10-1.35.113
libnfnetlink0-1.0.0+git1-9.5.56
libnl-1.1-49.22.6.1
libnscd-2.0.2-73.18
libnuma1-2.0.10-0.9.31
libopenct1-0.6.15-5.20
libopenobex1-1.5-8.9.7
libopensc2-0.11.6-5.27.3.1
libopenssl0_9_8-0.9.8j-0.106.37.1
libopenssl0_9_8-32bit-0.9.8j-0.106.37.1
libopenssl1_0_0-1.0.1g-0.58.33.1
libpcap0-0.9.8-50.10.1
libpixman-1-0-0.24.4-0.15.1
libpixman-1-0-32bit-0.24.4-0.15.1
libpng12-0-1.2.31-5.43.1
libpng12-0-32bit-1.2.31-5.43.1
libproxy0-0.3.1-2.6.1
libproxy0-config-gnome-0.3.1-2.6.3
libpython2_6-1_0-2.6.9-40.48.1
libpython2_6-1_0-32bit-2.6.9-40.48.1
libreadline5-5.2-152.1
libreiserfs-0.3.0.5-143.3
librpcsecgss-0.18-1.15
librsvg-2.26.0-2.5.1
libselinux1-2.0.91-4.2.1
libselinux1-32bit-2.0.91-4.2.1
libsensors3-2.10.6-10.15
libsepol1-2.0.41-2.2.9
libsmbclient0-3.6.3-94.34.1
libsmbios2-2.0.2-11.8.4
libsnmp15-5.4.2.1-8.12.31.1
libsoup-2_4-1-2.32.2-4.15.1
libsqlite3-0-3.7.6.3-1.4.7.15.1
libssh2-1-1.4.3-17.12.1
libstdc++33-32bit-3.3.3-11.9
libstdc++33-3.3.3-11.9
libstdc++43-4.6.9-0.14.1.9
libstdc++43-devel-4.3.4_20091019-37.9.1
libstdc++46-4.6.9-0.13.22
libstdc++6-32bit-5.3.1+r233831-14.1
libstdc++6-5.3.1+r233831-14.1
libstdc++-devel-4.3-62.200.2
libtalloc2-32bit-3.6.3-94.34.1
libtalloc2-3.6.3-94.34.1
libtasn1-1.5-1.34.1
libtasn1-3-1.5-1.34.1
libtdb1-32bit-3.6.3-94.34.1
libtdb1-3.6.3-94.34.1
libtevent0-32bit-3.6.3-94.34.1
libtevent0-3.6.3-94.34.1
libtiff3-32bit-3.8.2-141.169.31.1
libtiff3-3.8.2-141.169.31.1
libtirpc1-0.2.1-1.13.6.1
libtool-2.2.6-2.133.1
libudev0-147-0.111.5.1
libusb-0_1-4-0.1.12-139.1.1
libusb-1_0-0-1.0.9-8.4.4.1
libuuid1-2.19.1-6.72.1
libuuid1-32bit-2.19.1-6.72.1
libwbclient0-32bit-3.6.3-94.34.1
libwbclient0-3.6.3-94.34.1
libx86-1.1-13.17
libxcrypt-3.0.3-0.6.1
libxcrypt-32bit-3.0.3-0.6.1
libxml2-2.7.6-0.77.36.1
libxml2-python-2.7.6-0.77.36.1
libxslt-1.1.24-19.33.1
libxtables9-1.4.16.3-1.37
libyaml-0-2-0.1.3-0.10.21.2
libzio-0.9-5.77
libzmq3-4.0.4-3.3.1
libzypp-9.40.5-19.1
licenses-20070810-2.15
limal-1.5.3-0.2.11
limal-ca-mgm-1.5.24-0.3.2
limal-ca-mgm-perl-1.5.24-0.3.2
limal-nfs-server-1.5.3-0.2.11
limal-nfs-server-perl-1.5.3-0.2.11
limal-perl-1.5.3-0.2.11
linux-kernel-headers-3.0-19.18
login-3.41-0.4.2
logrotate-3.7.7-10.30.7.1
lsof-4.80-1.33.1
lsscsi-0.23-0.12.1
lukemftp-1.5-725.17
lvm2-2.02.98-0.42.3
lzma-4.32.7-1.25
m4-1.4.12-1.19
mailx-12.5-1.11.2
make-3.81-128.20
makedumpfile-1.5.6-2.29
man-2.5.2-17.16
man-pages-3.15-2.29.1
master-boot-code-1.14-70.11
mcelog-1.0.2014.12.20-0.24.3.1
mdadm-3.3.1-10.27.4
mercurial-2.3.2-0.18.9.1
metamail-2.7.19-1244.20
microcode_ctl-1.17-102.83.71.1
mingetty-1.0.7s-92.22
mkinitrd-2.4.2-106.11.1
module-init-tools-3.11.1-31.25
mpt-firmware-1.0-236.22
mtools-3.9.11-165.31
multipath-tools-0.4.9-123.8.1
mutt-1.5.17-42.56.1
ncurses-devel-5.6-93.15.1
ncurses-utils-5.6-93.15.1
netcat-1.10-1005.22
netcfg-11.2-0.8.1
netdate-1.2-713.22
net-tools-1.60-725.35.1
newt-0.52.10-1.35.113
nfs-client-1.2.3-18.48.8.1
nfsidmap-0.25-0.13.1
nscd-2.11.3-17.110.33.1
nss_ldap-262-11.32.39.1
nss_ldap-32bit-262-11.32.39.1
ntp-4.2.8p15-64.16.1
numactl-2.0.10-0.9.31
obex-data-server-0.4.6-2.7.90
og-update-info-1-202108
openct-0.6.15-5.20
OpenIPMI-2.0.16-0.15.1
open-iscsi-2.0.873-0.42.6.16
openldap2-client-2.4.26-0.74.26.1
opensc-0.11.6-5.27.3.1
openslp-1.2.0-172.27.3.1
openssh-6.6p1-36.23.1
openssh-helpers-6.6p1-36.23.1
openssl-0.9.8j-0.106.37.1
openssl1-1.0.1g-0.58.33.1
openssl-certs-2.44-0.7.21.1
opie-2.4-662.18.1
orbit2-2.14.17-2.7.8
pam-1.1.5-0.17.2
pam-32bit-1.1.5-0.17.2
pam-config-0.79-2.10.3.1
pam_ldap-184-147.20
pam_ldap-32bit-184-147.20
pam-modules-11-1.27.3.1
pam_mount-0.47-13.16.1
pango-1.26.2-1.9.2
pango-32bit-1.26.2-1.9.2
parted-2.3-10.51.1
patch-2.5.9-252.22.10.1
pax-3.4-135.21
pciutils-3.1.7-11.13.1
pciutils-ids-2018.02.08-4.3.1
pcre-32bit-7.8-2.18
pcre-7.8-2.18
pcsc-lite-1.4.102-1.37.3
perl-5.10.0-64.81.13.1
perl-base-5.10.0-64.81.13.1
perl-Bit-Vector-6.4-1.14
perl-Bootloader-0.4.89.72-3.1
perl-Carp-Clan-6.00-1.16
perl-Config-Crontab-1.21-73.21
perl-Config-IniFiles-2.39-1.24.1
perl-Crypt-SmbHash-0.12-132.17
perl-Date-Calc-5.4-137.14
perl-Digest-HMAC-1.01-436.17
perl-Digest-MD4-1.5-1.22
perl-Digest-SHA1-2.11-1.22
perl-doc-5.10.0-64.81.13.1
perl-Error-0.17015-1.13
perl-gettext-1.05-91.95
perl-HTML-Parser-3.56-1.18.1
perl-HTML-Tagset-3.20-1.22
perl-Module-Build-0.2808.01-0.81.13.1
perl-Net-SSLeay-1.64-0.9.1
perl-NetxAP-0.02-604.22
perl-Parse-RecDescent-1.96.0-1.22
perl-satsolver-0.44.5-0.5.194
perl-Socket6-0.22-1.24.1
perl-Test-Simple-0.72-0.81.13.1
perl-TimeDate-1.16-71.22
perl-URI-1.37-1.22
perl-WWW-Curl-4.09-2.1.72
perl-X500-DN-0.29-78.22
perl-XML-LibXML-1.66-3.3.1
perl-XML-LibXML-Common-0.13-70.7
perl-XML-NamespaceSupport-1.09-1.22
perl-XML-Parser-2.36-1.18
perl-XML-SAX-0.96-2.7
perl-XML-Simple-2.18-1.15
perl-XML-Writer-0.604-2.10
perl-XML-XPath-1.13-74.15
permissions-2013.1.7-0.6.12.1
pinentry-0.7.5-61.33.1
pkg-config-0.23-1.22
plotutils-2.5-197.19
pm-profiler-0.1-28.7.1
pmtools-20071116-44.35.1
pm-utils-0.99.4.20071229-12.14.1
PolicyKit-0.9-14.43.1
PolicyKit-doc-0.9-14.43.1
polkit-default-privs-0.1_200812111413-3.6
popt-1.7-37.63.64.1
postfix-openssl1-2.9.4-0.28.2
ppp-2.4.5.git-2.32.3.1
pptp-1.7.2-1.22
prctl-1.3-488.22
procinfo-18-198.16.1
procmail-3.22-240.8.3.1
procps-3.2.7-152.31.1
providers-2006.11.21-105.21
psmisc-22.7-7.3.1
pth-2.0.7-102.22
puppet-2.7.26-0.5.3.1
pwdutils-3.2.15-0.17.28
python-2.6.9-40.48.1
python2-rhnlib-4.2.3-12.31.1
python-argparse-1.2.1-2.5.65
python-backports.ssl_match_hostname-3.4.0.2-2.2
python-base-2.6.9-40.48.1
python-certifi-2015.9.6.2-2.2
python-curses-2.6.9-40.48.1
python-dmidecode-3.10.11-0.12.1
python-ethtool-0.7-0.15.15.1
python-futures-2.1.3-0.5.2
python-jabberpy-0.5-0.10.1
python-Jinja2-2.6-2.19.5.1
python-MarkupSafe-0.18-0.7.2
python-msgpack-python-0.4.6-2.2
python-newt-0.52.10-1.35.113
python-openssl-0.7.0-1.17.2
python-psutil-1.2.1-0.5.2
python-pycrypto-2.6.1-5.1
python-PyYAML-3.10-0.13.8
python-pyzmq-14.0.0-2.2
python-requests-2.0.1-0.13.2
python-satsolver-0.44.5-0.5.194
python-selinux-2.0.91-4.2.1
python-simplejson-2.1.1-1.9.1
python-tornado-4.2.1-5.1
python-xml-2.6.9-40.48.1
quota-3.16-51.1.0
rcs-5.7-1005.22
readline-doc-5.2-152.1
rear-2.00-1.fc25
recode-3.6-635.18
reiserfs-3.6.21-1.15.1
release-notes-sles-11.4.31-0.39.9.1
rpcbind-0.1.6+git20080930-6.27.2
rpm-4.4.2.3-37.63.64.1
rpm-python-4.4.2.3-37.63.64.2
rsh-0.17-706.22.1
rsync-3.0.4-2.53.9.26
ruby-1.8.7.p357-0.9.19.1
salt-2016.11.10-43.75.1
salt-minion-2016.11.10-43.75.1
samba-client-32bit-3.6.3-94.34.1
samba-client-3.6.3-94.34.1
samba-krb-printing-3.6.3-94.34.1
samba-winbind-32bit-3.6.3-94.34.1
samba-winbind-3.6.3-94.34.1
sash-3.7-170.1.30
satsolver-tools-0.17.9-0.5.2
scout-0.1.0-29.9.29
scpm-1.1.7-1.19
screen-4.0.2-162.19.2.1
SDL-1.2.13-106.11.1
sed-4.1.5-85.33.3.1
setserial-2.17-716.22
sg3_utils-1.40-0.29.1
sharutils-4.6.3-3.19
slang-2.1.1-58.18
sle-hae-release-11.4-1.54
sle-hae-release-cd-11.4-1.54
sle-sdk-release-11.4-1.55
sle-sdk-release-SDK-11.4-1.55
sles-manuals_en-11.4-0.33.1
sles-release-11.4-1.109
sles-release-DVD-11.4-1.109
smartmontools-6.3-0.10.3.4
snmp-mibs-5.4.2.1-8.12.31.1
sound-theme-freedesktop-0.2-1.17
splashy-0.3.8-106.21
splunkforwarder-6.5.1-f74036626f0c
sqlite3-3.7.6.3-1.4.7.15.1
star-1.5final-28.23.27.1
strace-4.5.18-10.26.19
subscription-tools-1.0-0.21.1
subversion-1.6.17-1.36.9.1
sudo-1.7.6p2-0.30.8.1
supportutils-1.21-122.12.1
supportutils-plugin-susemanager-client-4.2.2-9.21.1
suse-build-key-1.0-907.47.3.1
SuSEfirewall2-3.6_SVNr208-2.18.6.1
suseRegister-1.6-1.40.7.1
suse-sam-0.8.5-0.4.9
suse-sam-data-0.8.5-0.4.9
suspend-0.80.20081103-1.59.35
sysconfig-0.71.61-0.15.1
sysfsutils-2.1.0-102.25.1
syslinux-3.82-8.17.6
syslog-ng-2.0.9-27.34.40.5.1
sysstat-8.1.5-7.52.1
sysvinit-2.86-221.3.1
tack-5.6-93.15.1
tar-1.27.1-14.11.1
tcl-8.5.5-2.81
tcpd-7.6-858.1
tcpdump-3.9.8-1.30.13.1
tcsh-6.18.01-9.7.1
telnet-1.2-134.24.1
terminfo-5.6-93.15.1
terminfo-base-5.6-93.15.1
texinfo-4.12-1.86
timezone-2020a-0.52.32.1
tunctl-20070815-10.22
udev-147-0.111.5.1
ulimit-1.2-2.4.11
unzip-6.00-11.18.8.1
update-alternatives-1.14.19-1.22
usbutils-004-1.18.1
utempter-0.5.5-106.20.1
util-linux-2.19.1-6.72.1
util-linux-lang-2.19.1-6.72.1
uuid-runtime-2.19.1-6.72.1
vim-7.2-8.21.6.2
vim-base-7.2-8.21.6.2
vim-data-7.2-8.21.6.2
vlan-1.9-62.24.1
vlock-1.4-52.16
w3m-0.5.3.git20161120-4.1
wget-1.11.4-1.41.3.1
wireless-tools-30.pre7-3.13.1
wodim-1.1.8-3.34.3.1
wxGTK-2.8.8.1-1.36
x86info-1.29-0.5.34
xaw3d-1.5E-408.13
xdg-utils-1.0.2-36.18
xfsprogs-3.1.8-1.11.9.1
xinetd-2.3.14-130.133.7.1
xorg-x11-libfontenc-32bit-7.4-1.15
xorg-x11-libfontenc-7.4-1.15
xorg-x11-libICE-32bit-7.4-3.1
xorg-x11-libICE-7.4-3.1
xorg-x11-libs-32bit-7.4-8.26.50.8.1
xorg-x11-libs-7.4-8.26.50.8.1
xorg-x11-libSM-32bit-7.4-1.18
xorg-x11-libSM-7.4-1.18
xorg-x11-libX11-32bit-7.4-5.11.72.27.1
xorg-x11-libX11-7.4-5.11.72.27.1
xorg-x11-libXau-32bit-7.4-1.15
xorg-x11-libXau-7.4-1.15
xorg-x11-libxcb-32bit-7.4-1.31.9.2
xorg-x11-libxcb-7.4-1.31.9.2
xorg-x11-libXdmcp-7.4-3.1
xorg-x11-libXext-32bit-7.4-1.18.16
xorg-x11-libXext-7.4-1.18.16
xorg-x11-libXfixes-32bit-7.4-1.20.1
xorg-x11-libXfixes-7.4-1.20.1
xorg-x11-libxkbfile-32bit-7.4-1.14
xorg-x11-libxkbfile-7.4-1.14
xorg-x11-libXmu-32bit-7.4-1.17
xorg-x11-libXmu-7.4-1.17
xorg-x11-libXp-32bit-7.4-1.18.7
xorg-x11-libXp-7.4-1.18.7
xorg-x11-libXpm-32bit-7.4-3.1
xorg-x11-libXpm-7.4-3.1
xorg-x11-libXprintUtil-32bit-7.4-1.17
xorg-x11-libXprintUtil-7.4-1.17
xorg-x11-libXrender-32bit-7.4-1.23.1
xorg-x11-libXrender-7.4-1.23.1
xorg-x11-libXt-32bit-7.4-1.19.8
xorg-x11-libXt-7.4-1.19.8
xorg-x11-libXv-32bit-7.4-1.20.1
xorg-x11-libXv-7.4-1.20.1
xorg-x11-xauth-7.4-9.65.46
xterm-238-3.3.1
xz-5.0.3-0.12.3.1
xz-lang-5.0.3-0.12.3.1
yast2-2.17.140-1.1
yast2-add-on-2.17.31-0.7.49
yast2-add-on-creator-2.17.15-0.5.93
yast2-audit-laf-2.17.11-4.3
yast2-autofs-2.17.1-0.1.61
yast2-backup-2.17.14-0.5.1
yast2-bootloader-2.17.101-4.5.1
yast2-boot-server-2.14.0-276.38
yast2-branding-SLES-2.17.0-1.11
yast2-ca-management-2.17.27-1.1
yast2-core-2.17.48-8.3.1
yast2-country-2.17.55-0.7.1
yast2-country-data-2.17.55-0.7.1
yast2-dbus-client-2.17.0-0.1.65
yast2-dbus-server-2.17.5-0.5.1
yast2-dhcp-server-2.17.6-0.4.2.21
yast2-dirinstall-2.17.5-0.7.83
yast2-dns-server-2.17.24-1.2
yast2-fingerprint-reader-2.17.7-0.1.201
yast2-firewall-2.17.13-0.11.11
yast2-ftp-server-2.17.9.1-5.3.2
yast2-hardware-detection-2.17.2-2.7.1
yast2-http-server-2.17.17-1.99
yast2-inetd-2.17.3-1.53
yast2-installation-2.17.114-1.14
yast2-instserver-2.17.7-0.2.1
yast2-irda-2.17.3-0.1.85
yast2-iscsi-client-2.17.42-1.4
yast2-iscsi-server-2.17.11-1.58
yast2-isns-2.17.2-0.2.2
yast2-kdump-2.17.30-8.1
yast2-kerberos-client-2.17.16-0.7.79
yast2-kerberos-server-2.17.8-0.6.2
yast2-ldap-2.17.8-0.7.61
yast2-ldap-client-2.17.40-15.1
yast2-ldap-server-2.17.44-0.5.1
yast2-libyui-2.21.1-2.5.93
yast2-mail-2.17.7-0.15.1
yast2-mail-plugins-2.17.7-0.15.1
yast2-metapackage-handler-0.8.7-1.34
yast2-mouse-2.16.1-19.38
yast2-ncurses-2.17.23-1.14
yast2-ncurses-pkg-2.17.20-0.5.1
yast2-network-2.17.212-4.5.1
yast2-nfs-client-2.17.19-1.32
yast2-nfs-common-2.17.8-0.2.1
yast2-nfs-server-2.17.8-0.2.1
yast2-nis-client-2.17.8-0.1.1
yast2-nis-server-2.17.3-0.7.130
yast2-ntp-client-2.17.20-10.34
yast2-online-update-2.17.24-1.82
yast2-online-update-frontend-2.17.24-1.82
yast2-packager-2.17.113-1.47
yast2-pam-2.17.3-0.5.211
yast2-perl-bindings-2.17.2-1.32.121
yast2-pkg-bindings-2.17.61-1.40
yast2-power-management-2.17.7-0.1.84
yast2-printer-2.17.64-4.4
yast2-profile-manager-2.17.2-0.7.5
yast2-python-bindings-2.17.4-1.32.115
yast2-registration-2.17.38-0.8.43
yast2-registration-branding-SLE-2.17.38-0.8.43
yast2-repair-2.17.13-1.98
yast2-restore-2.17.7-0.5.1
yast2-runlevel-2.17.9-0.7.3
yast2-samba-client-2.17.31-9.2
yast2-samba-server-2.18.0-1.87
yast2-schema-2.17.7-8.1
yast2-security-2.17.16-0.7.25
yast2-slp-2.17.0-0.7.55
yast2-slp-server-2.17.8-7.1
yast2-squid-2.17.12-0.7.24
yast2-sshd-2.17.2-1.21
yast2-storage-2.17.161-5.1
yast2-storage-lib-2.17.161-5.1
yast2-sudo-2.17.3-1.53
yast2-support-2.17.22-2.3.3
yast2-sysconfig-2.17.0-1.38
yast2-tftp-server-2.17.2-0.7.38
yast2-theme-SLE-2.17.27-0.18.9
yast2-trans-en_US-2.17.35-0.7.37
yast2-transfer-2.16.3-0.5.133
yast2-trans-stats-2.15.0-2.17
yast2-tune-2.17.7-1.28
yast2-update-2.17.27-4.12
yast2-users-2.17.56-3.6
yast2-vm-2.17.17-0.7.66
yast2-wagon-2.17.38-0.7.29
yast2-xml-2.16.1-1.23
yast2-ycp-ui-bindings-2.21.1-2.5.107
ypbind-1.22-1.17
yp-tools-2.12-0.2.5
zip-3.0-4.9.4.1
zisofs-tools-1.0.6-138.22
zlib-1.2.7-0.14.1
zlib-32bit-1.2.7-0.14.1
zsh-4.3.6-67.9.3.1
zypper-1.6.335-29.9
zypper-log-1.6.335-29.9
zypp-plugin-python-0.5-1.5
"""

input2 = """aaa_base-11-6.115.1
acl-2.2.47-30.36.1
acpid-1.0.6-91.25.20
adaptec-firmware-1.35-2.15.4
aspell-0.60.6-26.22
aspell-en-6.0-160.7
aspell-ispell-0.60.6-26.22
at-3.1.8-1069.22.30.1
atk-1.28.0-1.4.1
atk-lang-1.28.0-1.4.1
atmel-firmware-1.3-139.15.4
attr-2.4.43-1.18
audit-1.8-0.34.26
audit-libs-1.8-0.34.26
audit-libs-32bit-1.8-0.34.26
augeas-lenses-0.9.0-3.21.6.1
autoconf-2.63-1.160.2
autofs-5.0.6-42.8.26
automake-1.10.1-4.131.9.1
autoyast2-2.17.82-5.1
autoyast2-installation-2.17.82-5.1
bash-3.2-152.1
bash-doc-3.2-152.1
bc-1.06-838.15
bind-libs-9.9.6P1-0.51.26.1
bind-utils-9.9.6P1-0.51.26.1
binutils-2.25.0-5.5
bison-2.3-127.112
blktrace-1.0.3-0.7.1
boost-license-1.36.0-12.8.1
bootcycle-0.3-225.18
bootsplash-3.3-146.24.12
bootsplash-branding-SLES-3.1-47.22
branding-SLES-11-3.20.30
bridge-utils-1.4-23.18.3.2
brocade-firmware-3.2.3.0-0.11.35
bzip2-1.0.5-34.256.8.1
cairo-1.8.8-2.3.7.1
cairo-32bit-1.8.8-2.3.7.1
cdrkit-cdrtools-compat-1.1.8-3.34.3.1
checkmedia-3.0-0.9.1
cifs-utils-5.1-0.14.46
command-not-found-0.1.0-29.9.29
ConsoleKit-0.2.10-64.69.1
ConsoleKit-32bit-0.2.10-64.69.1
convmv-1.12-1.22
coreutils-8.12-6.25.33.3.1
coreutils-lang-8.12-6.25.33.3.1
cpio-2.9-75.80.1
cpio-lang-2.9-75.80.1
cpp33-3.3.3-11.9
cpp43-4.3.4_20091019-37.9.1
cpp-4.3-62.200.2
cpufrequtils-004-35.20
cpupower-3.19-2.23.3
cracklib-2.8.12-56.13.1
cracklib-32bit-2.8.12-56.13.1
cracklib-dict-full-2.8.12-43.16
crash-7.0.9-30.9.1
crash-eppic-7.0.9-30.9.1
cron-4.1-194.211.213.1
cryptconfig-0.3-68.8.17
cryptsetup-1.1.3-2.10
ctags-2013.10.2-0.3.1
cups-client-1.3.9-8.46.56.18.1
cups-libs-1.3.9-8.46.56.18.1
cups-libs-32bit-1.3.9-8.46.56.18.1
curl-7.37.0-70.47.1
cvs-1.12.12-144.23.5.3.1
cyrus-sasl-2.1.22-182.26.4.1
cyrus-sasl-32bit-2.1.22-182.26.4.1
cyrus-sasl-digestmd5-2.1.22-182.26.4.1
cyrus-sasl-gssapi-2.1.22-182.26.4.1
cyrus-sasl-openssl1-2.1.22-182.26.4.1
cyrus-sasl-plain-2.1.22-182.26.4.1
cyrus-sasl-saslauthd-2.1.22-182.26.4.1
dbus-1-1.2.10-3.34.8.1
dbus-1-32bit-1.2.10-3.34.8.1
dbus-1-glib-0.76-34.22.1
dbus-1-python-0.83.0-27.1.43
db-utils-4.5.20-97.5
delayacct-utils-2.6.32.12-3.3.38
deltarpm-3.6.1-4.11.1
desktop-data-SLED-11-29.22.58
desktop-translations-11.1-10.50.1
device-mapper-1.02.77-0.15.14
dhcpcd-3.2.3-45.5.3
diffutils-2.8.7-143.23.1
DirectFB-1.2.3-6.32
dirmngr-1.0.2-1.19
dmapi-2.2.10-8.7.2
dmraid-1.0.0.rc16-0.15.3
dos2unix-3.1-438.22.1
dosfstools-3.0.26-3.1
ds_agent-9.5.3-2754
e2fsprogs-1.41.9-2.16.1
ed-0.2-1001.30.3.4
efibootmgr-0.6.0-2.23
eject-2.1.0-115.19.2.1
elfutils-0.152-4.9.17
elilo-3.14-0.39.3.1
emacs-22.3-42.6.1
emacs-info-22.3-42.6.1
emacs-x11-22.3-42.6.1
ethtool-6.2.6.39-0.29.3
expat-2.0.1-88.42.3.2
expect-5.44.1.11-1.241.1
facter-1.6.18-0.3.1
fastjar-0.95-1.24.1
fbset-2.1-919.22
file-4.24-43.27.1
filesystem-11.1-3.5.3
fillup-1.42-242.21
findutils-4.4.0-38.26.1
finger-1.3-104.22
FirmwareUpdateKit-1.1-2.17
flex-2.5.35-43.98
fontconfig-2.6.0-10.20.5.2
fontconfig-32bit-2.6.0-10.20.5.2
fping-2.4b2-97.5
freetype2-2.3.7-25.45.8.1
freetype2-32bit-2.3.7-25.45.8.1
fuse-2.8.7-0.11.3.1
gawk-3.1.8-2.6.1
gcc33-32bit-3.3.3-11.9
gcc33-3.3.3-11.9
gcc43-32bit-4.3.4_20091019-37.9.1
gcc43-4.3.4_20091019-37.9.1
gcc-4.3-62.200.2
gcc43-c++-4.3.4_20091019-37.9.1
gcc43-info-4.3.4_20091019-37.9.1
gcc43-locale-4.3.4_20091019-37.9.1
gcc-c++-4.3-62.200.2
gcc-info-4.3-62.200.2
gcc-locale-4.3-62.200.2
gconf2-2.28.0-1.8.1
gconf2-branding-SLES-2.25-0.13.31
gconf2-lang-2.28.0-1.8.1
gd-2.0.36.RC1-52.33.5.1
gdb-7.9.1-8.2
gdbm-1.8.3-374.25
gdbm-devel-1.8.3-374.25
genisoimage-1.1.8-3.34.3.1
gettext-runtime-0.17-61.40
gfxboot-4.1.34-0.5.44
gfxboot-branding-SLES-4.1.34-0.5.44
giflib-4.1.6-21.1
git-1.7.12.4-0.18.17.1
git-core-1.7.12.4-0.18.17.1
glib2-2.22.5-0.8.39.1
glib2-branding-SLES-2.16-47.3
glib2-lang-2.22.5-0.8.39.1
glibc-2.11.3-17.110.33.1
glibc-32bit-2.11.3-17.110.33.1
glibc-devel-2.11.3-17.110.33.1
glibc-devel-32bit-2.11.3-17.110.33.1
glibc-i18ndata-2.11.3-17.110.33.1
glibc-info-2.11.3-17.110.33.1
glibc-locale-2.11.3-17.110.33.1
gmp-4.2.3-10.99
gnome-icon-theme-2.28.0-1.2.11
gnome-keyring-2.28.2-1.14.30
gnome-keyring-lang-2.28.2-1.14.30
gnuplot-4.2.3-5.34
gpart-0.1h-565.22
gpg2-2.0.9-25.33.42.3.1
gpg2-lang-2.0.9-25.33.42.3.1
gpgme-1.1.6-25.32.1
gpg-pubkey-257a4686-60101325
gpg-pubkey-307e3d54-4be01a65
gpg-pubkey-39db7c82-510a966b
gpg-pubkey-3d25d3d9-36e12d04
gpg-pubkey-50a3dd1c-50f35137
gpg-pubkey-9c800aca-4be01999
gpg-pubkey-b37b98a9-4be01a1a
gpg-pubkey-de57bfbe-53a9be98
gpm-1.20.1-452.83
grep-2.7-5.7.1
groff-1.18.1.1-167.18.61
growpart-0.27-0.7.16
grub-0.97-172.3.2
gtk2-2.18.9-0.45.8.1
gtk2-32bit-2.18.9-0.45.8.1
gtk2-branding-SLED-11.1-1.26
gtk2-engines-2.16.1-4.26
gtk2-engines-32bit-2.16.1-4.26
gtk2-lang-2.18.9-0.45.8.1
gtk2-theme-SLED-11.1-1.29.82
gvfs-1.4.3-0.17.21.1
gvfs-backends-1.4.3-0.17.21.1
gvfs-fuse-1.4.3-0.17.21.1
gvfs-lang-1.4.3-0.17.21.1
gzip-1.3.12-69.23.1
hal-0.5.12-23.76.1
haveged-1.3-0.6.1
hdparm-9.27-1.6.39
hicolor-icon-theme-0.10-102.22
hwinfo-15.57-0.12.2
icedax-1.1.8-3.34.3.1
icmpinfo-1.11-691.22
icom-firmware-1.0-124.28.4
ifplugd-0.28-210.20
info-4.12-1.86
initviocons-0.5-55.21
insserv-1.12.0-25.11.47
inst-source-utils-2013.1.25-0.20.10
iotop-0.4.3-7.8.1
ipmitool-1.8.15-0.30.3.1
iproute2-3.0-5.3.2
iptables-1.4.16.3-1.37
iputils-ss021109-292.28.1
ipw-firmware-9-1.6.4
irqbalance-1.0.4-0.23.2
ivman-0.6.14-201.31.1
jdk-1.7.0_67-fcs
joe-3.5-92.22
kbd-1.14.1-16.33.1
kdump-0.8.4-56.6.1
kernel-default-3.0.101-107.1
kernel-default-3.0.101-108.126.1
kernel-default-base-3.0.101-107.1
kernel-default-base-3.0.101-108.126.1
kernel-default-devel-3.0.101-107.1
kernel-default-devel-3.0.101-108.126.1
kernel-firmware-20110923-0.59.3.1
kernel-source-3.0.101-107.1
kernel-source-3.0.101-108.126.1
kexec-tools-2.0.3-0.20.2
keyutils-1.2-107.29.15
keyutils-libs-1.2-107.29.15
keyutils-libs-32bit-1.2-107.29.15
klogd-1.4.1-708.44.32
kpartx-0.4.9-123.8.1
krb5-1.6.3-133.49.113.13.1
krb5-32bit-1.6.3-133.49.113.13.1
ksh-93u-0.37.1
ksymoops-2.4.11-117.22
lcms-1.17-77.16.1
less-424b-10.24.1
lgtoclnt-19.5.0.1-1
lgtoman-19.5.0.1-1
lgtonmda-19.5.0.1-1
lgtoxtdclnt-19.5.0.1-1
libacl-2.2.47-30.36.1
libaio-0.3.109-0.1.46
libaio-32bit-0.3.109-0.1.46
libaio-devel-0.3.109-0.1.46
libaio-devel-32bit-0.3.109-0.1.46
libapr1-1.3.3-11.18.19.13.2
libapr-util1-1.3.4-12.22.23.3.2
libarchive2-2.5.5-9.1
libasm1-0.152-4.9.17
libasound2-1.0.18-16.24.1
libatk-1_0-0-1.28.0-1.4.1
libatk-1_0-0-32bit-1.28.0-1.4.1
libattr-2.4.43-1.18
libaugeas0-0.9.0-3.21.6.1
libavahi-client3-0.6.23-35.6.2
libavahi-common3-0.6.23-35.6.2
libavahi-glib1-0.6.23-35.6.1
libblkid1-2.19.1-6.72.1
libblocxx6-2.1.0.342-122.6
libbluetooth3-4.99-0.12.35
libboost_regex1_36_0-1.36.0-12.8.1
libbz2-1-1.0.5-34.256.8.1
libcap1-1.10-6.10
libcap2-2.11-2.17.1
libcdio7-0.80-6.11
libcdio_cdda0-0.80-6.11
libcdio_paranoia0-0.80-6.11
libcom_err2-1.41.9-2.16.1
libcom_err2-32bit-1.41.9-2.16.1
libcroco-0_6-3-0.6.1-120.16
libcryptsetup0-1.0.5_SVNr46-58.37.3
libcryptsetup1-1.1.3-2.10
libcurl4-7.37.0-70.47.1
libdb-4_5-32bit-4.5.20-97.5
libdb-4_5-4.5.20-97.5
libdw1-0.152-4.9.17
libebl1-0.152-4.9.17
libelf0-0.8.12-1.1.52
libelf1-0.152-4.9.17
libesmtp-1.0.4-157.17.2
libevent-1_4-2-1.4.5-24.24.3.1
libexif-0.6.17-2.14.7.2
libexpat1-2.0.1-88.42.3.2
libexpat1-32bit-2.0.1-88.42.3.2
libext2fs2-1.41.9-2.16.1
libfprint0-0.0.6-18.22.136
libfuse2-2.8.7-0.11.3.1
libgcc43-32bit-4.6.9-0.14.1.9
libgcc43-4.6.9-0.14.1.9
libgcc46-4.6.9-0.13.22
libgcc_s1-32bit-5.3.1+r233831-14.1
libgcc_s1-5.3.1+r233831-14.1
libgcrypt11-1.5.0-0.26.6.1
libgio-2_0-0-2.22.5-0.8.39.1
libgio-2_0-0-32bit-2.22.5-0.8.39.1
libglib-2_0-0-2.22.5-0.8.39.1
libglib-2_0-0-32bit-2.22.5-0.8.39.1
libgmodule-2_0-0-2.22.5-0.8.39.1
libgmodule-2_0-0-32bit-2.22.5-0.8.39.1
libgnutls26-2.4.1-24.39.70.1
libgobject-2_0-0-2.22.5-0.8.39.1
libgobject-2_0-0-32bit-2.22.5-0.8.39.1
libgomp1-32bit-5.3.1+r233831-14.1
libgomp1-5.3.1+r233831-14.1
libgomp43-32bit-4.6.9-0.14.1.9
libgomp46-32bit-4.6.9-0.13.22
libgpg-error0-1.10-0.7.29
libgpgme11-1.1.6-25.32.1
libgphoto2-2.4.3-3.27.1
libgphoto2-lang-2.4.3-3.27.1
libgsf-1-114-1.14.9-2.27
libgssglue1-0.1-20.2.1
libgthread-2_0-0-2.22.5-0.8.39.1
libgthread-2_0-0-32bit-2.22.5-0.8.39.1
libgvfscommon0-1.4.3-0.17.21.1
libHX13-1.23-4.13.1
libicu-4.0-47.6.1
libidl-0.8.13-1.1.57
libidn-1.10-7.3.1
libiniparser0-2.17-87.17
libiniparser0-32bit-2.17-87.17
libiptc0-1.4.16.3-1.37
libjpeg-32bit-6.2.0-879.12.7.1
libjpeg-6.2.0-879.12.7.1
libksba-1.0.4-1.25.1
liblcms1-1.17-77.16.1
libldap-2_4-2-2.4.26-0.74.26.1
libldap-2_4-2-32bit-2.4.26-0.74.26.1
libldapcpp1-0.3.0-0.9.29
libldap-openssl1-2_4-2-2.4.26-0.74.26.1
libldb1-3.6.3-94.34.1
libltdl7-2.2.6-2.133.1
liblzma5-5.0.3-0.12.3.1
liblzmadec0-4.32.7-1.25
liblzo2-2-2.03-12.3.1
libMagickCore1-6.4.3.6-78.135.1
libmng-1.0.10-46.18
libmpfr1-2.3.2-3.118.2
libmspack0-0.0.20060920alpha-74.11.6.1
libncurses5-32bit-5.6-93.15.1
libncurses5-5.6-93.15.1
libncurses6-5.6-93.15.1
libneon27-0.29.6-6.7.1
libnet-1.1.2.1-140.24.1
libnewt0_52-0.52.10-1.35.113
libnfnetlink0-1.0.0+git1-9.5.56
libnl-1.1-49.22.6.1
libnscd-2.0.2-73.18
libnuma1-2.0.10-0.9.31
libopenct1-0.6.15-5.20
libopenobex1-1.5-8.9.7
libopensc2-0.11.6-5.27.3.1
libopenssl0_9_8-0.9.8j-0.106.37.1
libopenssl0_9_8-32bit-0.9.8j-0.106.37.1
libopenssl1_0_0-1.0.1g-0.58.33.1
libpcap0-0.9.8-50.10.1
libpixman-1-0-0.24.4-0.15.1
libpixman-1-0-32bit-0.24.4-0.15.1
libpng12-0-1.2.31-5.43.1
libpng12-0-32bit-1.2.31-5.43.1
libproxy0-0.3.1-2.6.1
libproxy0-config-gnome-0.3.1-2.6.3
libpython2_6-1_0-2.6.9-40.48.1
libpython2_6-1_0-32bit-2.6.9-40.48.1
libreadline5-5.2-152.1
libreiserfs-0.3.0.5-143.3
librpcsecgss-0.18-1.15
librsvg-2.26.0-2.5.1
libselinux1-2.0.91-4.2.1
libselinux1-32bit-2.0.91-4.2.1
libsensors3-2.10.6-10.15
libsepol1-2.0.41-2.2.9
libsmbclient0-3.6.3-94.34.1
libsmbios2-2.0.2-11.8.4
libsnmp15-5.4.2.1-8.12.31.1
libsoup-2_4-1-2.32.2-4.15.1
libsqlite3-0-3.7.6.3-1.4.7.12.1
libssh2-1-1.4.3-17.12.1
libstdc++33-32bit-3.3.3-11.9
libstdc++33-3.3.3-11.9
libstdc++43-4.6.9-0.14.1.9
libstdc++43-devel-4.3.4_20091019-37.9.1
libstdc++46-4.6.9-0.13.22
libstdc++47-devel-32bit-4.7.2_20130108-0.19.3
libstdc++47-devel-4.7.2_20130108-0.19.3
libstdc++6-32bit-5.3.1+r233831-14.1
libstdc++6-5.3.1+r233831-14.1
libstdc++-devel-4.3-62.200.2
libtalloc2-32bit-3.6.3-94.34.1
libtalloc2-3.6.3-94.34.1
libtasn1-1.5-1.34.1
libtasn1-3-1.5-1.34.1
libtdb1-32bit-3.6.3-94.34.1
libtdb1-3.6.3-94.34.1
libtevent0-32bit-3.6.3-94.34.1
libtevent0-3.6.3-94.34.1
libtiff3-32bit-3.8.2-141.169.31.1
libtiff3-3.8.2-141.169.31.1
libtirpc1-0.2.1-1.13.6.1
libtool-2.2.6-2.133.1
libudev0-147-0.110.1
libusb-0_1-4-0.1.12-139.1.1
libusb-1_0-0-1.0.9-8.4.4.1
libuuid1-2.19.1-6.72.1
libuuid1-32bit-2.19.1-6.72.1
libwbclient0-32bit-3.6.3-94.34.1
libwbclient0-3.6.3-94.34.1
libx86-1.1-13.17
libxcrypt-3.0.3-0.6.1
libxcrypt-32bit-3.0.3-0.6.1
libxml2-2.7.6-0.77.36.1
libxml2-python-2.7.6-0.77.36.1
libxslt-1.1.24-19.33.1
libxtables9-1.4.16.3-1.37
libyaml-0-2-0.1.3-0.10.21.2
libzio-0.9-5.77
libzmq3-4.0.4-3.3.1
libzypp-9.40.5-19.1
licenses-20070810-2.15
limal-1.5.3-0.2.11
limal-ca-mgm-1.5.24-0.3.2
limal-ca-mgm-perl-1.5.24-0.3.2
limal-nfs-server-1.5.3-0.2.11
limal-nfs-server-perl-1.5.3-0.2.11
limal-perl-1.5.3-0.2.11
linux-kernel-headers-3.0-19.18
login-3.41-0.4.2
logrotate-3.7.7-10.30.7.1
lsof-4.80-1.33.1
lsscsi-0.23-0.12.1
lukemftp-1.5-725.17
lvm2-2.02.98-0.42.3
lzma-4.32.7-1.25
m4-1.4.12-1.19
mailx-12.5-1.11.2
make-3.81-128.20
makedumpfile-1.5.6-2.29
man-2.5.2-17.16
man-pages-3.15-2.29.1
master-boot-code-1.14-70.11
mcelog-1.0.2014.12.20-0.24.3.1
mdadm-3.3.1-10.27.4
mercurial-2.3.2-0.18.9.1
metamail-2.7.19-1244.20
microcode_ctl-1.17-102.83.68.1
mingetty-1.0.7s-92.22
mkinitrd-2.4.2-106.11.1
module-init-tools-3.11.1-31.25
mpt-firmware-1.0-236.22
mtools-3.9.11-165.31
multipath-tools-0.4.9-123.8.1
mutt-1.5.17-42.56.1
ncurses-devel-5.6-93.15.1
ncurses-utils-5.6-93.15.1
netcat-1.10-1005.22
netcfg-11.2-0.8.1
netdate-1.2-713.22
net-tools-1.60-725.35.1
newt-0.52.10-1.35.113
nfs-client-1.2.3-18.48.8.1
nfsidmap-0.25-0.13.1
nscd-2.11.3-17.110.33.1
nss_ldap-262-11.32.39.1
nss_ldap-32bit-262-11.32.39.1
ntp-4.2.8p15-64.16.1
numactl-2.0.10-0.9.31
obex-data-server-0.4.6-2.7.90
og-update-info-1-202107
openct-0.6.15-5.20
OpenIPMI-2.0.16-0.15.1
open-iscsi-2.0.873-0.42.6.16
openldap2-client-2.4.26-0.74.26.1
opensc-0.11.6-5.27.3.1
openslp-1.2.0-172.27.3.1
openssh-6.6p1-36.23.1
openssh-helpers-6.6p1-36.23.1
openssl-0.9.8j-0.106.37.1
openssl1-1.0.1g-0.58.33.1
openssl-certs-2.44-0.7.21.1
opie-2.4-662.18.1
orbit2-2.14.17-2.7.8
pam-1.1.5-0.17.2
pam-32bit-1.1.5-0.17.2
pam-config-0.79-2.10.3.1
pam_ldap-184-147.20
pam_ldap-32bit-184-147.20
pam-modules-11-1.27.3.1
pam_mount-0.47-13.16.1
pango-1.26.2-1.9.2
pango-32bit-1.26.2-1.9.2
parted-2.3-10.51.1
patch-2.5.9-252.22.10.1
pax-3.4-135.21
pciutils-3.1.7-11.13.1
pciutils-ids-2018.02.08-4.3.1
pcre-32bit-7.8-2.18
pcre-7.8-2.18
pcsc-lite-1.4.102-1.37.3
perl-5.10.0-64.81.13.1
perl-base-5.10.0-64.81.13.1
perl-Bit-Vector-6.4-1.14
perl-Bootloader-0.4.89.72-3.1
perl-Carp-Clan-6.00-1.16
perl-Config-Crontab-1.21-73.21
perl-Config-IniFiles-2.39-1.24.1
perl-Crypt-SmbHash-0.12-132.17
perl-Date-Calc-5.4-137.14
perl-Digest-HMAC-1.01-436.17
perl-Digest-MD4-1.5-1.22
perl-Digest-SHA1-2.11-1.22
perl-doc-5.10.0-64.81.13.1
perl-Error-0.17015-1.13
perl-gettext-1.05-91.95
perl-HTML-Parser-3.56-1.18.1
perl-HTML-Tagset-3.20-1.22
perl-Module-Build-0.2808.01-0.81.13.1
perl-Net-SSLeay-1.64-0.9.1
perl-NetxAP-0.02-604.22
perl-Parse-RecDescent-1.96.0-1.22
perl-satsolver-0.44.5-0.5.194
perl-Socket6-0.22-1.24.1
perl-Test-Simple-0.72-0.81.13.1
perl-TimeDate-1.16-71.22
perl-URI-1.37-1.22
perl-WWW-Curl-4.09-2.1.72
perl-X500-DN-0.29-78.22
perl-XML-LibXML-1.66-3.3.1
perl-XML-LibXML-Common-0.13-70.7
perl-XML-NamespaceSupport-1.09-1.22
perl-XML-Parser-2.36-1.18
perl-XML-SAX-0.96-2.7
perl-XML-Simple-2.18-1.15
perl-XML-Writer-0.604-2.10
perl-XML-XPath-1.13-74.15
permissions-2013.1.7-0.6.12.1
pinentry-0.7.5-61.33.1
pkg-config-0.23-1.22
plotutils-2.5-197.19
pm-profiler-0.1-28.7.1
pmtools-20071116-44.35.1
pm-utils-0.99.4.20071229-12.14.1
PolicyKit-0.9-14.43.1
PolicyKit-doc-0.9-14.43.1
polkit-default-privs-0.1_200812111413-3.6
popt-1.7-37.63.64.1
postfix-openssl1-2.9.4-0.28.2
ppp-2.4.5.git-2.32.3.1
pptp-1.7.2-1.22
prctl-1.3-488.22
procinfo-18-198.16.1
procmail-3.22-240.8.3.1
procps-3.2.7-152.31.1
providers-2006.11.21-105.21
psmisc-22.7-7.3.1
pth-2.0.7-102.22
puppet-2.7.26-0.5.3.1
pwdutils-3.2.15-0.17.28
python-2.6.9-40.48.1
python2-rhnlib-4.2.3-12.31.1
python-argparse-1.2.1-2.5.65
python-backports.ssl_match_hostname-3.4.0.2-2.2
python-base-2.6.9-40.48.1
python-certifi-2015.9.6.2-2.2
python-curses-2.6.9-40.48.1
python-dmidecode-3.10.11-0.12.1
python-ethtool-0.7-0.15.15.1
python-futures-2.1.3-0.5.2
python-jabberpy-0.5-0.10.1
python-Jinja2-2.6-2.19.5.1
python-MarkupSafe-0.18-0.7.2
python-msgpack-python-0.4.6-2.2
python-newt-0.52.10-1.35.113
python-openssl-0.7.0-1.17.2
python-psutil-1.2.1-0.5.2
python-pycrypto-2.6.1-5.1
python-PyYAML-3.10-0.13.8
python-pyzmq-14.0.0-2.2
python-requests-2.0.1-0.13.2
python-satsolver-0.44.5-0.5.194
python-selinux-2.0.91-4.2.1
python-simplejson-2.1.1-1.9.1
python-tornado-4.2.1-5.1
python-xml-2.6.9-40.48.1
quota-3.16-51.1.0
rcs-5.7-1005.22
readline-doc-5.2-152.1
rear-2.00-1.fc25
recode-3.6-635.18
reiserfs-3.6.21-1.15.1
release-notes-sles-11.4.31-0.39.9.1
rpcbind-0.1.6+git20080930-6.27.2
rpm-4.4.2.3-37.63.64.1
rpm-python-4.4.2.3-37.63.64.2
rsh-0.17-706.22.1
rsync-3.0.4-2.53.9.26
ruby-1.8.7.p357-0.9.19.1
salt-2016.11.10-43.75.1
salt-minion-2016.11.10-43.75.1
samba-client-32bit-3.6.3-94.34.1
samba-client-3.6.3-94.34.1
samba-krb-printing-3.6.3-94.34.1
samba-winbind-32bit-3.6.3-94.34.1
samba-winbind-3.6.3-94.34.1
sash-3.7-170.1.30
satsolver-tools-0.17.9-0.5.2
scout-0.1.0-29.9.29
scpm-1.1.7-1.19
screen-4.0.2-162.19.2.1
SDL-1.2.13-106.11.1
sed-4.1.5-85.33.3.1
setserial-2.17-716.22
sg3_utils-1.40-0.29.1
sharutils-4.6.3-3.19
slang-2.1.1-58.18
sle-hae-release-11.4-1.54
sle-hae-release-cd-11.4-1.54
sle-sdk-release-11.4-1.55
sle-sdk-release-SDK-11.4-1.55
sles-manuals_en-11.4-0.33.1
sles-release-11.4-1.109
sles-release-DVD-11.4-1.109
smartmontools-6.3-0.10.3.4
snmp-mibs-5.4.2.1-8.12.31.1
sound-theme-freedesktop-0.2-1.17
splashy-0.3.8-106.21
splunkforwarder-6.5.1-f74036626f0c
sqlite3-3.7.6.3-1.4.7.12.1
star-1.5final-28.23.27.1
strace-4.5.18-10.26.19
subscription-tools-1.0-0.21.1
subversion-1.6.17-1.36.9.1
sudo-1.7.6p2-0.30.8.1
supportutils-1.21-122.12.1
supportutils-plugin-susemanager-client-4.2.2-9.21.1
suse-build-key-1.0-907.47.3.1
SuSEfirewall2-3.6_SVNr208-2.18.6.1
suseRegister-1.6-1.40.7.1
suse-sam-0.8.5-0.4.9
suse-sam-data-0.8.5-0.4.9
suspend-0.80.20081103-1.59.35
sysconfig-0.71.61-0.15.1
sysfsutils-2.1.0-102.25.1
syslinux-3.82-8.17.6
syslog-ng-2.0.9-27.34.40.5.1
sysstat-8.1.5-7.52.1
sysvinit-2.86-221.3.1
tack-5.6-93.15.1
tar-1.27.1-14.11.1
tcl-8.5.5-2.81
tcpd-7.6-858.1
tcpdump-3.9.8-1.30.13.1
tcsh-6.18.01-9.7.1
telnet-1.2-134.24.1
terminfo-5.6-93.15.1
terminfo-base-5.6-93.15.1
texinfo-4.12-1.86
timezone-2020a-0.52.32.1
tunctl-20070815-10.22
udev-147-0.110.1
ulimit-1.2-2.4.11
unzip-6.00-11.18.8.1
update-alternatives-1.14.19-1.22
usbutils-004-1.18.1
utempter-0.5.5-106.20.1
util-linux-2.19.1-6.72.1
util-linux-lang-2.19.1-6.72.1
uuid-runtime-2.19.1-6.72.1
vim-7.2-8.21.6.2
vim-base-7.2-8.21.6.2
vim-data-7.2-8.21.6.2
vlan-1.9-62.24.1
vlock-1.4-52.16
w3m-0.5.3.git20161120-4.1
wget-1.11.4-1.41.3.1
wireless-tools-30.pre7-3.13.1
wodim-1.1.8-3.34.3.1
wxGTK-2.8.8.1-1.36
x86info-1.29-0.5.34
xaw3d-1.5E-408.13
xdg-utils-1.0.2-36.18
xfsprogs-3.1.8-1.11.9.1
xinetd-2.3.14-130.133.7.1
xorg-x11-libfontenc-32bit-7.4-1.15
xorg-x11-libfontenc-7.4-1.15
xorg-x11-libICE-32bit-7.4-3.1
xorg-x11-libICE-7.4-3.1
xorg-x11-libs-32bit-7.4-8.26.50.8.1
xorg-x11-libs-7.4-8.26.50.8.1
xorg-x11-libSM-32bit-7.4-1.18
xorg-x11-libSM-7.4-1.18
xorg-x11-libX11-32bit-7.4-5.11.72.27.1
xorg-x11-libX11-7.4-5.11.72.27.1
xorg-x11-libXau-32bit-7.4-1.15
xorg-x11-libXau-7.4-1.15
xorg-x11-libxcb-32bit-7.4-1.31.9.2
xorg-x11-libxcb-7.4-1.31.9.2
xorg-x11-libXdmcp-7.4-3.1
xorg-x11-libXext-32bit-7.4-1.18.16
xorg-x11-libXext-7.4-1.18.16
xorg-x11-libXfixes-32bit-7.4-1.20.1
xorg-x11-libXfixes-7.4-1.20.1
xorg-x11-libxkbfile-32bit-7.4-1.14
xorg-x11-libxkbfile-7.4-1.14
xorg-x11-libXmu-32bit-7.4-1.17
xorg-x11-libXmu-7.4-1.17
xorg-x11-libXp-32bit-7.4-1.18.7
xorg-x11-libXp-7.4-1.18.7
xorg-x11-libXpm-32bit-7.4-3.1
xorg-x11-libXpm-7.4-3.1
xorg-x11-libXprintUtil-32bit-7.4-1.17
xorg-x11-libXprintUtil-7.4-1.17
xorg-x11-libXrender-32bit-7.4-1.23.1
xorg-x11-libXrender-7.4-1.23.1
xorg-x11-libXt-32bit-7.4-1.19.8
xorg-x11-libXt-7.4-1.19.8
xorg-x11-libXv-32bit-7.4-1.20.1
xorg-x11-libXv-7.4-1.20.1
xorg-x11-xauth-7.4-9.65.46
xterm-238-3.3.1
xz-5.0.3-0.12.3.1
xz-lang-5.0.3-0.12.3.1
yast2-2.17.140-1.1
yast2-add-on-2.17.31-0.7.49
yast2-add-on-creator-2.17.15-0.5.93
yast2-audit-laf-2.17.11-4.3
yast2-autofs-2.17.1-0.1.61
yast2-backup-2.17.14-0.5.1
yast2-bootloader-2.17.101-4.5.1
yast2-boot-server-2.14.0-276.38
yast2-branding-SLES-2.17.0-1.11
yast2-ca-management-2.17.27-1.1
yast2-core-2.17.48-8.3.1
yast2-country-2.17.55-0.7.1
yast2-country-data-2.17.55-0.7.1
yast2-dbus-client-2.17.0-0.1.65
yast2-dbus-server-2.17.5-0.5.1
yast2-dhcp-server-2.17.6-0.4.2.21
yast2-dirinstall-2.17.5-0.7.83
yast2-dns-server-2.17.24-1.2
yast2-fingerprint-reader-2.17.7-0.1.201
yast2-firewall-2.17.13-0.11.11
yast2-ftp-server-2.17.9.1-5.3.2
yast2-hardware-detection-2.17.2-2.7.1
yast2-http-server-2.17.17-1.99
yast2-inetd-2.17.3-1.53
yast2-installation-2.17.114-1.14
yast2-instserver-2.17.7-0.2.1
yast2-irda-2.17.3-0.1.85
yast2-iscsi-client-2.17.42-1.4
yast2-iscsi-server-2.17.11-1.58
yast2-isns-2.17.2-0.2.2
yast2-kdump-2.17.30-8.1
yast2-kerberos-client-2.17.16-0.7.79
yast2-kerberos-server-2.17.8-0.6.2
yast2-ldap-2.17.8-0.7.61
yast2-ldap-client-2.17.40-15.1
yast2-ldap-server-2.17.44-0.5.1
yast2-libyui-2.21.1-2.5.93
yast2-mail-2.17.7-0.15.1
yast2-mail-plugins-2.17.7-0.15.1
yast2-metapackage-handler-0.8.7-1.34
yast2-mouse-2.16.1-19.38
yast2-ncurses-2.17.23-1.14
yast2-ncurses-pkg-2.17.20-0.5.1
yast2-network-2.17.212-4.5.1
yast2-nfs-client-2.17.19-1.32
yast2-nfs-common-2.17.8-0.2.1
yast2-nfs-server-2.17.8-0.2.1
yast2-nis-client-2.17.8-0.1.1
yast2-nis-server-2.17.3-0.7.130
yast2-ntp-client-2.17.20-10.34
yast2-online-update-2.17.24-1.82
yast2-online-update-frontend-2.17.24-1.82
yast2-packager-2.17.113-1.47
yast2-pam-2.17.3-0.5.211
yast2-perl-bindings-2.17.2-1.32.121
yast2-pkg-bindings-2.17.61-1.40
yast2-power-management-2.17.7-0.1.84
yast2-printer-2.17.64-4.4
yast2-profile-manager-2.17.2-0.7.5
yast2-python-bindings-2.17.4-1.32.115
yast2-registration-2.17.38-0.8.43
yast2-registration-branding-SLE-2.17.38-0.8.43
yast2-repair-2.17.13-1.98
yast2-restore-2.17.7-0.5.1
yast2-runlevel-2.17.9-0.7.3
yast2-samba-client-2.17.31-9.2
yast2-samba-server-2.18.0-1.87
yast2-schema-2.17.7-8.1
yast2-security-2.17.16-0.7.25
yast2-slp-2.17.0-0.7.55
yast2-slp-server-2.17.8-7.1
yast2-squid-2.17.12-0.7.24
yast2-sshd-2.17.2-1.21
yast2-storage-2.17.161-5.1
yast2-storage-lib-2.17.161-5.1
yast2-sudo-2.17.3-1.53
yast2-support-2.17.22-2.3.3
yast2-sysconfig-2.17.0-1.38
yast2-tftp-server-2.17.2-0.7.38
yast2-theme-SLE-2.17.27-0.18.9
yast2-trans-en_US-2.17.35-0.7.37
yast2-transfer-2.16.3-0.5.133
yast2-trans-stats-2.15.0-2.17
yast2-tune-2.17.7-1.28
yast2-update-2.17.27-4.12
yast2-users-2.17.56-3.6
yast2-vm-2.17.17-0.7.66
yast2-wagon-2.17.38-0.7.29
yast2-xml-2.16.1-1.23
yast2-ycp-ui-bindings-2.21.1-2.5.107
ypbind-1.22-1.17
yp-tools-2.12-0.2.5
zip-3.0-4.9.4.1
zisofs-tools-1.0.6-138.22
zlib-1.2.7-0.14.1
zlib-32bit-1.2.7-0.14.1
zsh-4.3.6-67.9.3.1
zypper-1.6.335-29.9
zypper-log-1.6.335-29.9
zypp-plugin-python-0.5-1.5
"""


class IntegerationTest(unittest.TestCase):
  def test_all(self):
    aPackages = [Package.parse(line) for line in input1.splitlines()]
    bPackages = [Package.parse(line) for line in input2.splitlines()]
    installed_packages_diff = create_diff(aPackages, bPackages, includeEqual=False)
    with io.StringIO() as buf:
      print_diff("serverA", "serverB", installed_packages_diff, file=buf)
      self.assertEqual("""= serverA serverB =
U curl                                     7.37.0-70.66.1                           7.37.0-70.47.1                          
U kernel-default                           3.0.101-108.129.1                        3.0.101-108.126.1                       
U kernel-default-base                      3.0.101-108.129.1                        3.0.101-108.126.1                       
U kernel-default-devel                     3.0.101-108.129.1                        3.0.101-108.126.1                       
U kernel-source                            3.0.101-108.129.1                        3.0.101-108.126.1                       
U libcurl4                                 7.37.0-70.66.1                           7.37.0-70.47.1                          
U libsqlite3-0                             3.7.6.3-1.4.7.15.1                       3.7.6.3-1.4.7.12.1                      
U libudev0                                 147-0.111.5.1                            147-0.110.1                             
U microcode_ctl                            1.17-102.83.71.1                         1.17-102.83.68.1                        
U og-update-info                           1-202108                                 1-202107                                
U sqlite3                                  3.7.6.3-1.4.7.15.1                       3.7.6.3-1.4.7.12.1                      
U udev                                     147-0.111.5.1                            147-0.110.1                             
A jdk                                      missing                                  1.7.0_67-fcs                            
A libstdc++47-devel-32bit                  missing                                  4.7.2_20130108-0.19.3                   
A libstdc++47-devel                        missing                                  4.7.2_20130108-0.19.3""",
                       buf.getvalue().strip())
