# pyDendron

## Dendrochronology: Wikipedia

``Dendrochronology (or tree-ring dating) is the scientific method of dating tree rings (also called growth rings) to the exact year they were formed in a tree. As well as dating them, this can give data for dendroclimatology, the study of climate and atmospheric conditions during different periods in history from the wood of old trees. Dendrochronology derives from the Ancient Greek dendron (δένδρον), meaning "tree", khronos (χρόνος), meaning "time", and -logia (-λογία), "the study of".''

## pyDendron

*pyDendron* is an open-source python package dedicated to dendrochronology. It provides a web GUI to manage, trace, interdate data. *pyDendron* is developed by members of the *GROUping Research On Tree-rings Database* ([GROOT] (https://bioarcheodat.hypotheses.org/6241)), one of the three workshops of the [BioArcheoDat] (https:// bioarcheodat. hypotheses.org/) CNRS interdisciplinary research network.

Development is in its early stages. Bugs are provided free of charge like the source code.

## Requirements 

- [Anaconda](https://docs.anaconda.com/anaconda/install/index.html) or [Miniconda](https://docs.anaconda.com/free/miniconda/miniconda-install/). Miniconda is recommended.

- Donwlod miniconda and install it. Default options are OK. 
Choose the version that corresponds to our OS: https://docs.anaconda.com/free/miniconda/miniconda-other-installer-links/

## Installation

- On Linux and MacOs, open a terminal. On Windows, open Anaconda Prompt (available from the windows menu).
- pyDendron can be installed on Linux, Windows, or Mac with ``pip``:


```bash
pip install pyDendron
```

or with ``conda``:

```bash
conda install symeignier::pyDendron
```

## Run application
- On Linux and MacOs, open a terminal. On Windows, open Anaconda Prompt (available from the windows menu).
- Launch *pyDendron*: 
```bash
pyDendron
```
- On Windows, you can create a shortcut to `miniconda3/scripts/pyDendron.exe` in the Windows menus or taskbar.

### Update pyDendron 
with pip:
```bash
pip install --upgrade pyDendron
```

with conda:
```bash
conda update symeignier::pyDendron
```
