"""
    Copyright (C) 2020 David J. Wooten

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import numpy as np

def jacobian(d1, d2, E0, E1, E2, E3, logh1, logh2, logC1, logC2, r1, r2, logalpha12, logalpha21):
    """
    Returns MuSyC Jacobian with respect to:
    E0, E1, E2, E3, logh1, logh2, logC1, logC2, logalpha12, logalpha21
    """
    h1 = np.exp(logh1)
    h2 = np.exp(logh2)
    C1 = np.exp(logC1)
    C2 = np.exp(logC2)
    alpha12 = np.exp(logalpha12)
    alpha21 = np.exp(logalpha21)

    logd1 = np.log(d1)
    logd2 = np.log(d2)

    logd1alpha21 = np.log(d1*alpha21)
    logd2alpha12 = np.log(d2*alpha12)

    d1h1 = d1**h1
    d2h2 = d2**h2

    C1h1 = C1**h1
    C2h2 = C2**h2
    r1r = r1*C1h1
    r2r = r2*C2h2

    alpha21d1h1 = (alpha21*d1)**h1
    alpha12d2h2 = (alpha12*d2)**h2

    C12h1 = C1**(2*h1)
    C22h2 = C2**(2*h2)

    exp = np.exp
    log = np.log

    # ********** logh1 ********

    j_logh1 = E0*r1*r2*(r1*alpha21d1h1*h1*logd1alpha21 + r1*C1h1*h1*logC1)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E0*r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*C1h1*C2h2*h1*logC1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E0*r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1*logd1 - d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1*logd1alpha21 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1*logd1 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1*logd1alpha21 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h1*logd1 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h1*logC1 - d1h1*r1**2*r2*C1h1*C2h2*h1*logd1 - d1h1*r1**2*r2*C1h1*C2h2*h1*logC1 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h1*logd1 - d1h1*r1*r2**2*C22h2*h1*logd1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1*logd1alpha21 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1*logC1 - 2*d2h2*r1**2*r2*C12h1*h1*logC1 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h1*logd1alpha21 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h1*logd1alpha21 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h1*logC1 - d2h2*r1*r2**2*C1h1*C2h2*h1*logC1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1*logd1alpha21 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1*logC1 - 2*r1**2*r2*C12h1*C2h2*h1*logC1 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h1*logC1 - r1*r2**2*C1h1*C22h2*h1*logC1)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E1*r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1*logd1 - d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1*logd1alpha21 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1*logd1 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1*logd1alpha21 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h1*logd1 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h1*logC1 - d1h1*r1**2*r2*C1h1*C2h2*h1*logd1 - d1h1*r1**2*r2*C1h1*C2h2*h1*logC1 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h1*logd1 - d1h1*r1*r2**2*C22h2*h1*logd1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1*logd1alpha21 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1*logC1 - 2*d2h2*r1**2*r2*C12h1*h1*logC1 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h1*logd1alpha21 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h1*logd1alpha21 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h1*logC1 - d2h2*r1*r2**2*C1h1*C2h2*h1*logC1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1*logd1alpha21 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1*logC1 - 2*r1**2*r2*C12h1*C2h2*h1*logC1 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h1*logC1 - r1*r2**2*C1h1*C22h2*h1*logC1)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E1*r1*r2*(d1h1*r1*alpha21d1h1*h1*logd1 + d1h1*r1*alpha21d1h1*h1*logd1alpha21 + d1h1*r1*C1h1*h1*logd1 + d1h1*r1*C1h1*h1*logC1 + d1h1*r2*C2h2*h1*logd1 + d2h2*r2*alpha21d1h1*h1*logd1alpha21)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E2*r1*r2*(d1h1*r1*alpha12d2h2*h1*logd1 + d2h2*r1*C1h1*h1*logC1)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E2*r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*C1h1*h1*logC1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E2*r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1*logd1 - d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1*logd1alpha21 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1*logd1 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1*logd1alpha21 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h1*logd1 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h1*logC1 - d1h1*r1**2*r2*C1h1*C2h2*h1*logd1 - d1h1*r1**2*r2*C1h1*C2h2*h1*logC1 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h1*logd1 - d1h1*r1*r2**2*C22h2*h1*logd1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1*logd1alpha21 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1*logC1 - 2*d2h2*r1**2*r2*C12h1*h1*logC1 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h1*logd1alpha21 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h1*logd1alpha21 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h1*logC1 - d2h2*r1*r2**2*C1h1*C2h2*h1*logC1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1*logd1alpha21 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1*logC1 - 2*r1**2*r2*C12h1*C2h2*h1*logC1 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h1*logC1 - r1*r2**2*C1h1*C22h2*h1*logC1)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E3*(-r1*r2*(r1*alpha21d1h1*h1*logd1alpha21 + r1*C1h1*h1*logC1)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(d1h1*r1*alpha12d2h2*h1*logd1 + d2h2*r1*C1h1*h1*logC1)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*C1h1*C2h2*h1*logC1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1*logd1 - d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1*logd1alpha21 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1*logd1 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1*logd1alpha21 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h1*logd1 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h1*logC1 - d1h1*r1**2*r2*C1h1*C2h2*h1*logd1 - d1h1*r1**2*r2*C1h1*C2h2*h1*logC1 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h1*logd1 - d1h1*r1*r2**2*C22h2*h1*logd1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1*logd1alpha21 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1*logC1 - 2*d2h2*r1**2*r2*C12h1*h1*logC1 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h1*logd1alpha21 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h1*logd1alpha21 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h1*logC1 - d2h2*r1*r2**2*C1h1*C2h2*h1*logC1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1*logd1alpha21 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1*logC1 - 2*r1**2*r2*C12h1*C2h2*h1*logC1 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h1*logC1 - r1*r2**2*C1h1*C22h2*h1*logC1)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1*logd1 - d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1*logd1alpha21 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1*logd1 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1*logd1alpha21 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h1*logd1 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h1*logC1 - d1h1*r1**2*r2*C1h1*C2h2*h1*logd1 - d1h1*r1**2*r2*C1h1*C2h2*h1*logC1 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h1*logd1 - d1h1*r1*r2**2*C22h2*h1*logd1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1*logd1alpha21 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1*logC1 - 2*d2h2*r1**2*r2*C12h1*h1*logC1 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h1*logd1alpha21 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h1*logd1alpha21 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h1*logC1 - d2h2*r1*r2**2*C1h1*C2h2*h1*logC1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1*logd1alpha21 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1*logC1 - 2*r1**2*r2*C12h1*C2h2*h1*logC1 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h1*logC1 - r1*r2**2*C1h1*C22h2*h1*logC1)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*C1h1*h1*logC1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1*logd1 - d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1*logd1alpha21 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1*logd1 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1*logd1alpha21 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h1*logd1 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h1*logC1 - d1h1*r1**2*r2*C1h1*C2h2*h1*logd1 - d1h1*r1**2*r2*C1h1*C2h2*h1*logC1 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h1*logd1 - d1h1*r1*r2**2*C22h2*h1*logd1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1*logd1alpha21 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1*logC1 - 2*d2h2*r1**2*r2*C12h1*h1*logC1 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h1*logd1alpha21 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h1*logd1alpha21 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h1*logC1 - d2h2*r1*r2**2*C1h1*C2h2*h1*logC1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1*logd1alpha21 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1*logC1 - 2*r1**2*r2*C12h1*C2h2*h1*logC1 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h1*logC1 - r1*r2**2*C1h1*C22h2*h1*logC1)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(d1h1*r1*alpha21d1h1*h1*logd1 + d1h1*r1*alpha21d1h1*h1*logd1alpha21 + d1h1*r1*C1h1*h1*logd1 + d1h1*r1*C1h1*h1*logC1 + d1h1*r2*C2h2*h1*logd1 + d2h2*r2*alpha21d1h1*h1*logd1alpha21)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2))

    # ********** logh2 ********

    j_logh2 = E0*r1*r2*(r2*alpha12d2h2*h2*logd2alpha12 + r2*C2h2*h2*logC2)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E0*r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*C1h1*C2h2*h2*logC2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E0*r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h2*logd2alpha12 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h2*logC2 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h2*logd2alpha12 - d1h1*r1**2*r2*C1h1*C2h2*h2*logC2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2*logd2alpha12 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2*logC2 - 2*d1h1*r1*r2**2*C22h2*h2*logC2 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h2*logd2 - d2h2*r1**2*r2*C12h1*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2*logd2alpha12 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2*logC2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2*logd2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2*logd2alpha12 - d2h2*r1*r2**2*C1h1*C2h2*h2*logd2 - d2h2*r1*r2**2*C1h1*C2h2*h2*logC2 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h2*logC2 - r1**2*r2*C12h1*C2h2*h2*logC2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2*logd2alpha12 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2*logC2 - 2*r1*r2**2*C1h1*C22h2*h2*logC2)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E1*r1*r2*(d1h1*r2*C2h2*h2*logC2 + d2h2*r2*alpha21d1h1*h2*logd2)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E1*r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*C2h2*h2*logC2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E1*r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h2*logd2alpha12 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h2*logC2 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h2*logd2alpha12 - d1h1*r1**2*r2*C1h1*C2h2*h2*logC2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2*logd2alpha12 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2*logC2 - 2*d1h1*r1*r2**2*C22h2*h2*logC2 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h2*logd2 - d2h2*r1**2*r2*C12h1*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2*logd2alpha12 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2*logC2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2*logd2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2*logd2alpha12 - d2h2*r1*r2**2*C1h1*C2h2*h2*logd2 - d2h2*r1*r2**2*C1h1*C2h2*h2*logC2 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h2*logC2 - r1**2*r2*C12h1*C2h2*h2*logC2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2*logd2alpha12 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2*logC2 - 2*r1*r2**2*C1h1*C22h2*h2*logC2)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E2*r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h2*logd2alpha12 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h2*logC2 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h2*logd2alpha12 - d1h1*r1**2*r2*C1h1*C2h2*h2*logC2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2*logd2alpha12 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2*logC2 - 2*d1h1*r1*r2**2*C22h2*h2*logC2 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h2*logd2 - d2h2*r1**2*r2*C12h1*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2*logd2alpha12 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2*logC2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2*logd2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2*logd2alpha12 - d2h2*r1*r2**2*C1h1*C2h2*h2*logd2 - d2h2*r1*r2**2*C1h1*C2h2*h2*logC2 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h2*logC2 - r1**2*r2*C12h1*C2h2*h2*logC2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2*logd2alpha12 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2*logC2 - 2*r1*r2**2*C1h1*C22h2*h2*logC2)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E2*r1*r2*(d1h1*r1*alpha12d2h2*h2*logd2alpha12 + d2h2*r1*C1h1*h2*logd2 + d2h2*r2*alpha12d2h2*h2*logd2 + d2h2*r2*alpha12d2h2*h2*logd2alpha12 + d2h2*r2*C2h2*h2*logd2 + d2h2*r2*C2h2*h2*logC2)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E3*(-r1*r2*(r2*alpha12d2h2*h2*logd2alpha12 + r2*C2h2*h2*logC2)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(d1h1*r2*C2h2*h2*logC2 + d2h2*r2*alpha21d1h1*h2*logd2)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*C1h1*C2h2*h2*logC2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h2*logd2alpha12 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h2*logC2 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h2*logd2alpha12 - d1h1*r1**2*r2*C1h1*C2h2*h2*logC2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2*logd2alpha12 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2*logC2 - 2*d1h1*r1*r2**2*C22h2*h2*logC2 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h2*logd2 - d2h2*r1**2*r2*C12h1*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2*logd2alpha12 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2*logC2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2*logd2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2*logd2alpha12 - d2h2*r1*r2**2*C1h1*C2h2*h2*logd2 - d2h2*r1*r2**2*C1h1*C2h2*h2*logC2 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h2*logC2 - r1**2*r2*C12h1*C2h2*h2*logC2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2*logd2alpha12 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2*logC2 - 2*r1*r2**2*C1h1*C22h2*h2*logC2)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*C2h2*h2*logC2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h2*logd2alpha12 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h2*logC2 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h2*logd2alpha12 - d1h1*r1**2*r2*C1h1*C2h2*h2*logC2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2*logd2alpha12 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2*logC2 - 2*d1h1*r1*r2**2*C22h2*h2*logC2 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h2*logd2 - d2h2*r1**2*r2*C12h1*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2*logd2alpha12 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2*logC2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2*logd2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2*logd2alpha12 - d2h2*r1*r2**2*C1h1*C2h2*h2*logd2 - d2h2*r1*r2**2*C1h1*C2h2*h2*logC2 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h2*logC2 - r1**2*r2*C12h1*C2h2*h2*logC2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2*logd2alpha12 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2*logC2 - 2*r1*r2**2*C1h1*C22h2*h2*logC2)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h2*logd2alpha12 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h2*logC2 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h2*logd2alpha12 - d1h1*r1**2*r2*C1h1*C2h2*h2*logC2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2*logd2alpha12 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2*logC2 - 2*d1h1*r1*r2**2*C22h2*h2*logC2 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h2*logd2 - d2h2*r1**2*r2*C12h1*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2*logd2alpha12 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2*logd2 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2*logC2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2*logd2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2*logd2alpha12 - d2h2*r1*r2**2*C1h1*C2h2*h2*logd2 - d2h2*r1*r2**2*C1h1*C2h2*h2*logC2 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h2*logC2 - r1**2*r2*C12h1*C2h2*h2*logC2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2*logd2alpha12 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2*logC2 - 2*r1*r2**2*C1h1*C22h2*h2*logC2)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(d1h1*r1*alpha12d2h2*h2*logd2alpha12 + d2h2*r1*C1h1*h2*logd2 + d2h2*r2*alpha12d2h2*h2*logd2 + d2h2*r2*alpha12d2h2*h2*logd2alpha12 + d2h2*r2*C2h2*h2*logd2 + d2h2*r2*C2h2*h2*logC2)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2))

    # ********** logC1 ********

    j_logC1 = E0*r1**2*r2*C12h1*C2h2*h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E0*r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*(-d1h1*r1**2*r2*alpha12d2h2*C1h1*h1 - d1h1*r1**2*r2*C1h1*C2h2*h1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1 - 2*d2h2*r1**2*r2*C12h1*h1 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h1 - d2h2*r1*r2**2*C1h1*C2h2*h1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1 - 2*r1**2*r2*C12h1*C2h2*h1 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h1 - r1*r2**2*C1h1*C22h2*h1)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E0*r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*C1h1*C2h2*h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E1*d1h1*r1**2*r2*C1h1*C2h2*h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E1*r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*(-d1h1*r1**2*r2*alpha12d2h2*C1h1*h1 - d1h1*r1**2*r2*C1h1*C2h2*h1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1 - 2*d2h2*r1**2*r2*C12h1*h1 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h1 - d2h2*r1*r2**2*C1h1*C2h2*h1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1 - 2*r1**2*r2*C12h1*C2h2*h1 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h1 - r1*r2**2*C1h1*C22h2*h1)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E2*d2h2*r1**2*r2*C12h1*h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E2*r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*(-d1h1*r1**2*r2*alpha12d2h2*C1h1*h1 - d1h1*r1**2*r2*C1h1*C2h2*h1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1 - 2*d2h2*r1**2*r2*C12h1*h1 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h1 - d2h2*r1*r2**2*C1h1*C2h2*h1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1 - 2*r1**2*r2*C12h1*C2h2*h1 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h1 - r1*r2**2*C1h1*C22h2*h1)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E2*r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*C1h1*h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E3*(-d1h1*r1**2*r2*C1h1*C2h2*h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - d2h2*r1**2*r2*C12h1*h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1**2*r2*C12h1*C2h2*h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*(-d1h1*r1**2*r2*alpha12d2h2*C1h1*h1 - d1h1*r1**2*r2*C1h1*C2h2*h1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1 - 2*d2h2*r1**2*r2*C12h1*h1 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h1 - d2h2*r1*r2**2*C1h1*C2h2*h1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1 - 2*r1**2*r2*C12h1*C2h2*h1 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h1 - r1*r2**2*C1h1*C22h2*h1)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*C1h1*C2h2*h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*(-d1h1*r1**2*r2*alpha12d2h2*C1h1*h1 - d1h1*r1**2*r2*C1h1*C2h2*h1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1 - 2*d2h2*r1**2*r2*C12h1*h1 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h1 - d2h2*r1*r2**2*C1h1*C2h2*h1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1 - 2*r1**2*r2*C12h1*C2h2*h1 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h1 - r1*r2**2*C1h1*C22h2*h1)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*(-d1h1*r1**2*r2*alpha12d2h2*C1h1*h1 - d1h1*r1**2*r2*C1h1*C2h2*h1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1 - 2*d2h2*r1**2*r2*C12h1*h1 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h1 - d2h2*r1*r2**2*C1h1*C2h2*h1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1 - 2*r1**2*r2*C12h1*C2h2*h1 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h1 - r1*r2**2*C1h1*C22h2*h1)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*C1h1*h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2))

    # ********** logC2 ********

    j_logC2 = E0*r1*r2**2*C1h1*C22h2*h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E0*r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*C2h2*h2 - d1h1*r1**2*r2*C1h1*C2h2*h2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2 - 2*d1h1*r1*r2**2*C22h2*h2 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2 - d2h2*r1*r2**2*C1h1*C2h2*h2 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h2 - r1**2*r2*C12h1*C2h2*h2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2 - 2*r1*r2**2*C1h1*C22h2*h2)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E0*r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*C1h1*C2h2*h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E1*d1h1*r1*r2**2*C22h2*h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E1*r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*(-d1h1*r1**2*r2*alpha21d1h1*C2h2*h2 - d1h1*r1**2*r2*C1h1*C2h2*h2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2 - 2*d1h1*r1*r2**2*C22h2*h2 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2 - d2h2*r1*r2**2*C1h1*C2h2*h2 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h2 - r1**2*r2*C12h1*C2h2*h2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2 - 2*r1*r2**2*C1h1*C22h2*h2)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E1*r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*C2h2*h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E2*d2h2*r1*r2**2*C1h1*C2h2*h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E2*r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*C2h2*h2 - d1h1*r1**2*r2*C1h1*C2h2*h2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2 - 2*d1h1*r1*r2**2*C22h2*h2 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2 - d2h2*r1*r2**2*C1h1*C2h2*h2 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h2 - r1**2*r2*C12h1*C2h2*h2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2 - 2*r1*r2**2*C1h1*C22h2*h2)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E3*(-d1h1*r1*r2**2*C22h2*h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - d2h2*r1*r2**2*C1h1*C2h2*h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2**2*C1h1*C22h2*h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*C2h2*h2 - d1h1*r1**2*r2*C1h1*C2h2*h2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2 - 2*d1h1*r1*r2**2*C22h2*h2 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2 - d2h2*r1*r2**2*C1h1*C2h2*h2 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h2 - r1**2*r2*C12h1*C2h2*h2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2 - 2*r1*r2**2*C1h1*C22h2*h2)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*C1h1*C2h2*h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*(-d1h1*r1**2*r2*alpha21d1h1*C2h2*h2 - d1h1*r1**2*r2*C1h1*C2h2*h2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2 - 2*d1h1*r1*r2**2*C22h2*h2 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2 - d2h2*r1*r2**2*C1h1*C2h2*h2 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h2 - r1**2*r2*C12h1*C2h2*h2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2 - 2*r1*r2**2*C1h1*C22h2*h2)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*C2h2*h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*C2h2*h2 - d1h1*r1**2*r2*C1h1*C2h2*h2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2 - 2*d1h1*r1*r2**2*C22h2*h2 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h2 - d2h2*r1*r2**2*C1h1*C2h2*h2 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h2 - r1**2*r2*C12h1*C2h2*h2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2 - 2*r1*r2**2*C1h1*C22h2*h2)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2)

    # ********** logalpha12 ********

    j_logalpha12 = E0*r1*r2**2*alpha12d2h2*C1h1*C2h2*h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E0*r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h2 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E1*r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h2 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E2*r1*r2*(d1h1*r1*alpha12d2h2*h2 + d2h2*r2*alpha12d2h2*h2)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E2*r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h2 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E3*(-r1*r2**2*alpha12d2h2*C1h1*C2h2*h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(d1h1*r1*alpha12d2h2*h2 + d2h2*r2*alpha12d2h2*h2)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h2 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h2 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h2 - d1h1*r1**2*r2*alpha12d2h2*C1h1*h2 - d1h1*r1*r2**2*alpha12d2h2*C2h2*h2 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h2 - d2h2*r1*r2**2*alpha12d2h2*C1h1*h2 - r1*r2**2*alpha12d2h2*C1h1*C2h2*h2)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2)

    # ********** logalpha21 ********

    j_logalpha21 = E0*r1**2*r2*alpha21d1h1*C1h1*C2h2*h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E0*r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h1 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E1*r1*r2*(d1h1*r1*alpha21d1h1*h1 + d2h2*r2*alpha21d1h1*h1)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) + E1*r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h1 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E2*r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h1 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 + E3*(-r1**2*r2*alpha21d1h1*C1h1*C2h2*h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(d1h1*r1*alpha21d1h1*h1 + d2h2*r2*alpha21d1h1*h1)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2) - r1*r2*(r1*alpha21d1h1 + r1*C1h1 + r2*alpha12d2h2 + r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h1 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1)*C1h1*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(d1h1*r1*alpha21d1h1 + d1h1*r1*C1h1 + d1h1*r2*C2h2 + d2h2*r2*alpha21d1h1)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h1 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1)*C2h2/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2 - r1*r2*(d1h1*r1*alpha12d2h2 + d2h2*r1*C1h1 + d2h2*r2*alpha12d2h2 + d2h2*r2*C2h2)*(-d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2*h1 - d1h1*r1**2*r2*alpha21d1h1*C2h2*h1 - d2h2*r1**2*r2*alpha21d1h1*C1h1*h1 - d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2*h1 - d2h2*r1*r2**2*alpha21d1h1*C2h2*h1 - r1**2*r2*alpha21d1h1*C1h1*C2h2*h1)*C1h1/(d1h1*r1**2*r2*alpha21d1h1*alpha12d2h2 + d1h1*r1**2*r2*alpha21d1h1*C2h2 + d1h1*r1**2*r2*alpha12d2h2*C1h1 + d1h1*r1**2*r2*C1h1*C2h2 + d1h1*r1*r2**2*alpha12d2h2*C2h2 + d1h1*r1*r2**2*C22h2 + d2h2*r1**2*r2*alpha21d1h1*C1h1 + d2h2*r1**2*r2*C12h1 + d2h2*r1*r2**2*alpha21d1h1*alpha12d2h2 + d2h2*r1*r2**2*alpha21d1h1*C2h2 + d2h2*r1*r2**2*alpha12d2h2*C1h1 + d2h2*r1*r2**2*C1h1*C2h2 + r1**2*r2*alpha21d1h1*C1h1*C2h2 + r1**2*r2*C12h1*C2h2 + r1*r2**2*alpha12d2h2*C1h1*C2h2 + r1*r2**2*C1h1*C22h2)**2)





    # U
    j_E0 = r1*r2*(r1*(d1*exp(logalpha21))**exp(logh1) + r1*exp(logC1)**exp(logh1) + r2*(d2*exp(logalpha12))**exp(logh2) + r2*exp(logC2)**exp(logh2))*exp(logC1)**exp(logh1)*exp(logC2)**exp(logh2)/(d1**exp(logh1)*r1**2*r2*(d1*exp(logalpha21))**exp(logh1)*(d2*exp(logalpha12))**exp(logh2) + d1**exp(logh1)*r1**2*r2*(d1*exp(logalpha21))**exp(logh1)*exp(logC2)**exp(logh2) + d1**exp(logh1)*r1**2*r2*(d2*exp(logalpha12))**exp(logh2)*exp(logC1)**exp(logh1) + d1**exp(logh1)*r1**2*r2*exp(logC1)**exp(logh1)*exp(logC2)**exp(logh2) + d1**exp(logh1)*r1*r2**2*(d2*exp(logalpha12))**exp(logh2)*exp(logC2)**exp(logh2) + d1**exp(logh1)*r1*r2**2*exp(logC2)**(2*exp(logh2)) + d2**exp(logh2)*r1**2*r2*(d1*exp(logalpha21))**exp(logh1)*exp(logC1)**exp(logh1) + d2**exp(logh2)*r1**2*r2*exp(logC1)**(2*exp(logh1)) + d2**exp(logh2)*r1*r2**2*(d1*exp(logalpha21))**exp(logh1)*(d2*exp(logalpha12))**exp(logh2) + d2**exp(logh2)*r1*r2**2*(d1*exp(logalpha21))**exp(logh1)*exp(logC2)**exp(logh2) + d2**exp(logh2)*r1*r2**2*(d2*exp(logalpha12))**exp(logh2)*exp(logC1)**exp(logh1) + d2**exp(logh2)*r1*r2**2*exp(logC1)**exp(logh1)*exp(logC2)**exp(logh2) + r1**2*r2*(d1*exp(logalpha21))**exp(logh1)*exp(logC1)**exp(logh1)*exp(logC2)**exp(logh2) + r1**2*r2*exp(logC1)**(2*exp(logh1))*exp(logC2)**exp(logh2) + r1*r2**2*(d2*exp(logalpha12))**exp(logh2)*exp(logC1)**exp(logh1)*exp(logC2)**exp(logh2) + r1*r2**2*exp(logC1)**exp(logh1)*exp(logC2)**(2*exp(logh2)))

    # A1
    j_E1 = r1*r2r*(d1h1*r1*(alpha21d1h1) + d1h1*r1r + d1h1*r2r + d2h2*r2*(alpha21d1h1))/(d1h1*r1**2*r2*(alpha12d2h2)*(alpha21d1h1) + d1h1*r1**2*r2r*(alpha21d1h1) + d1h1*r1*r1r*r2*(alpha12d2h2) + d1h1*r1*r1r*r2r + d1h1*r1*r2*r2r*(alpha12d2h2) + d1h1*r1*r2r**2 + d2h2*r1*r1r*r2*(alpha21d1h1) + d2h2*r1*r2**2*(alpha12d2h2)*(alpha21d1h1) + d2h2*r1*r2*r2r*(alpha21d1h1) + d2h2*r1r**2*r2 + d2h2*r1r*r2**2*(alpha12d2h2) + d2h2*r1r*r2*r2r + r1*r1r*r2r*(alpha21d1h1) + r1r**2*r2r + r1r*r2*r2r*(alpha12d2h2) + r1r*r2r**2)

    # A2
    j_E2 = r1r*r2*(d1h1*r1*(alpha12d2h2) + d2h2*r1r + d2h2*r2*(alpha12d2h2) + d2h2*r2r)/(d1h1*r1**2*r2*(alpha12d2h2)*(alpha21d1h1) + d1h1*r1**2*r2r*(alpha21d1h1) + d1h1*r1*r1r*r2*(alpha12d2h2) + d1h1*r1*r1r*r2r + d1h1*r1*r2*r2r*(alpha12d2h2) + d1h1*r1*r2r**2 + d2h2*r1*r1r*r2*(alpha21d1h1) + d2h2*r1*r2**2*(alpha12d2h2)*(alpha21d1h1) + d2h2*r1*r2*r2r*(alpha21d1h1) + d2h2*r1r**2*r2 + d2h2*r1r*r2**2*(alpha12d2h2) + d2h2*r1r*r2*r2r + r1*r1r*r2r*(alpha21d1h1) + r1r**2*r2r + r1r*r2*r2r*(alpha12d2h2) + r1r*r2r**2)

    # A12
    j_E3 = 1-(j_E0 + j_E1 + j_E2)

    # E0, E1, E2, E3, logh1, logh2, logC1, logC2, logalpha12, logalpha21
    return np.hstack([j.reshape(-1,1) for j in [j_E0, j_E1, j_E2, j_E3, j_logh1, j_logh2, j_logC1, j_logC2, j_logalpha12, j_logalpha21]])