[![PyPI version](https://badge.fury.io/py/pywinos.svg)](https://badge.fury.io/py/pywinos)
[![Build Status](https://travis-ci.org/c-pher/PyWinOS.svg?branch=master)](https://travis-ci.org/c-pher/PyWinOS)
[![Coverage Status](https://coveralls.io/repos/github/c-pher/PyWinOS/badge.svg?branch=master)](https://coveralls.io/github/c-pher/PyWinOS?branch=master)

# PyWinOS
The cross-platform tool to work with remote and local Windows OS.

PyWinOS uses the Windows Remote Manager (WinRM) service. It can establish connection to a remote server based on Windows OS and execute commands:
- PowerShell
- Command line
- WMI.

It can execute commands locally using subprocess and command-line too.

For more information on WinRM, please visit [Microsoft’s WinRM site](https://docs.microsoft.com/en-us/windows/win32/winrm/portal?redirectedfrom=MSDN)
It based on [pywinrm](https://pypi.org/project/pywinrm/).

PyWinOS returns object with **exit code, stdout and sdtderr** response.

## Installation
For most users, the recommended method to install is via pip:
```cmd
pip install pywinos
```

or from source:

```cmd
python setup.py install
```

## Import
```python
from pywinos import WinOSClient
```
---
## Usage (remote server)
#### Run PowerShell:
```python
from pywinos import WinOSClient

tool = WinOSClient(host='172.16.0.126', username='administrator', password='rds123RDS', logger_enabled=True)
response = tool.run_ps(command='$PSVersionTable.PSVersion')

print(response)  
# ResponseParser(response=(0, 'Major  Minor  Build  Revision\r\n-----  -----  -----  --------\r\n5      1      17763  592', None, '$PSVersionTable.PSVersion'))
print(response.exited)  # 0
print(response.stdout)
# Major  Minor  Build  Revision
# -----  -----  -----  --------
# 5      1      17763  592

# stderr in PowerShell contains some text by default    
print(response.stderr)  # <Objs Version="1.1.0.1" xmlns="http://schemas.microsoft.com/powershell/2004/04"><Ob...
print(response.ok)  # True
```

#### Run command line:
```python
from pywinos import WinOSClient

tool = WinOSClient('172.16.0.126', 'administrator', 'P@ssw0rd', logger_enabled=False)
response = tool.run_cmd(command='whoami')

print(response)  # <Response code 0, out "b'\r\nMajor  Minor  Build'", err "b''">
print(response.exited)  # 0
print(response.stdout)  # test-vm1\administrator
print(response.stderr)  # None
print(response.ok)  # True

```

## Usage (local server)
#### Run command line:
```python
from pywinos import WinOSClient

tool = WinOSClient(logger_enabled=False)
# tool = WinOSClient(host='', logger_enabled=False)
# tool = WinOSClient(host='localhost', logger_enabled=False)
# tool = WinOSClient(host='127.0.0.1', logger_enabled=False)
response = tool.run_cmd(command='whoami')

print(response)  # (0, b'mypc\\bobby\r\n', b'')
print(response.exited)  # 0
print(response.stdout)  # my_pc\bobby
print(response.stderr)  # None
print(response.ok)  # True
```

### Main low-level methods to work with local/remote Windows OS:

* run_cmd
* run_cmd_local
* run_ps
* run_ps_local

### High-level methods:

* list_all_methods()
* is_host_available()
* remove() / remove_local()
* get_os_info() / get_os_info_local
* get_os_name_local / get_os_name_local()
* get_current_os_name_local()
* is_windows
* ping()
* exists() / exists_local()
* get_content() / get_content_local()
* get_json() / get_json_local()  # sd
* get_local_hostname_ip()
* get_dirs_files() / get_dirs_files_local()
* get_file_version() / get_file_version_local()
* get_file_size() / get_file_size_local()
* replace_text()
* get_hash() / get_available_hash_algorithm() / get_hash_local()
* get_xml_dom() / get_xml_tree_local()
* clean_directory() / clean_directory_local()
* copy() / copy_local()
* create_directory() / create_directory_local()
* unzip() / unzip_local()
* get_service() / get_service_local()
* get_service_status() / get_service_status_local()
* start_service() / start_service_local()
* restart_service() / restart_service_local()
* stop_service() / stop_service_local()
* get_process() / get_process_local()
* kill_process() / kill_process_local()
* wait_service_start() / wait_service_start_local()
* get_service_file_version() / get_service_file_version_local()
* is_service_running() / is_service_running_local()
* is_process_running / is_process_running_local()
* get_network_adapter_state() / get_network_adapter_state_local()
* disable_network_adapter() / disable_network_adapter_local()
* enable_network_adapter() / enable_network_adapter_local()
* debug_info()
* get_process_working_set_size() / get_process_working_set_size_local()
* timestamp_local()
* set_date_adjustment()
* is_disk_offline() / is_disk_offline_local()
* set_disk_state() / set_disk_state_local()
* attach_share()

## Changelog

##### 1.2.0 (6.04.2022)

- External logger used
- Logger moved into class in order to have access to it after inheritance
