# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.model_utils import (
    ModelSimple,
    cached_property,
)


class WidgetServiceSummaryDisplayFormat(ModelSimple):
    """
    Number of columns to display.

    :param value: Must be one of ["one_column", "two_column", "three_column"].
    :type value: str
    """

    allowed_values = {
        "value": {
            "ONE_COLUMN": "one_column",
            "TWO_COLUMN": "two_column",
            "THREE_COLUMN": "three_column",
        },
    }

    @cached_property
    def openapi_types(_):
        return {
            "value": (str,),
        }
