# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.model_utils import (
    ModelSimple,
    cached_property,
)


class SecurityMonitoringRuleNewValueOptionsLearningDuration(ModelSimple):
    """
    The duration in days during which values are learned, and after which signals will be generated for values that
        weren't learned. If set to 0, a signal will be generated for all new values after the first value is learned.

    :param value: If omitted defaults to 0. Must be one of [0, 1, 7].
    :type value: int
    """

    allowed_values = {
        "value": {
            "ZERO_DAYS": 0,
            "ONE_DAY": 1,
            "SEVEN_DAYS": 7,
        },
    }

    @cached_property
    def openapi_types(_):
        return {
            "value": (int,),
        }
