# Development

This repository contains code that is autogenerated.

As such, code changes must be made against the templates, not against generated code.

## Testing

### Prerequisite

Export the following environment variables:
* `DD_TEST_CLIENT_API_KEY`: The Datadog API key to run integration tests against
* `DD_TEST_CLIENT_APP_KEY`: The Datadog Application key to run integration tests against

**IMPORTANT**: Do not use production keys.

Tests can be run againts different site (EU, staging, local):
* `DD_TEST_SITE`: The base URL for test site (e.g. `datadoghq.eu`)

**NOTE**: All recorded URLs will be replaced by `datadoghq.com`. Please make sure that you do NOT leak any
any sensitive information.

### Commands

This project contains both Integration and Unit tests.
__Never__ run the test suite against an organization with production data.

Tests can be executed via [`pytest`](https://pytest.org).
You can optionally add `-k <testName>` to filter individual tests.

By default integration tests use recorded API responses stored in cassettes. To record new API responses run the tests with `RECORD=true`. To run integration tests against API without recording cassettes, run the tests with `RECORD=none`.

**IMPORTANT**:
When creating a PR that adds or updates a test, __never__ commit
generated code, only commit test files being updated and any updated cassettes.
