# Generated by Django 5.2.6 on 2025-09-15 23:14

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('jobs', '0002_alter_job_max_retries_joblog'),
    ]

    operations = [
        migrations.AlterField(
            model_name='job',
            name='broadcast',
            field=models.BooleanField(default=False, help_text='If true, all runners execute this job'),
        ),
        migrations.AlterField(
            model_name='job',
            name='channel',
            field=models.CharField(help_text='Logical queue/channel name', max_length=100),
        ),
        migrations.AlterField(
            model_name='job',
            name='created',
            field=models.DateTimeField(auto_now_add=True),
        ),
        migrations.AlterField(
            model_name='job',
            name='expires_at',
            field=models.DateTimeField(blank=True, help_text='Job expires if not run by this time', null=True),
        ),
        migrations.AlterField(
            model_name='job',
            name='func',
            field=models.CharField(help_text='Registry key for the job function', max_length=255),
        ),
        migrations.AlterField(
            model_name='job',
            name='modified',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AlterField(
            model_name='job',
            name='run_at',
            field=models.DateTimeField(blank=True, help_text='When to run this job (null = immediate)', null=True),
        ),
        migrations.AlterField(
            model_name='job',
            name='runner_id',
            field=models.CharField(blank=True, help_text='ID of runner currently executing', max_length=64, null=True),
        ),
        migrations.AlterField(
            model_name='job',
            name='status',
            field=models.CharField(choices=[('pending', 'Pending'), ('running', 'Running'), ('completed', 'Completed'), ('failed', 'Failed'), ('canceled', 'Canceled'), ('expired', 'Expired')], default='pending', help_text='Current job status', max_length=16),
        ),
        migrations.AddIndex(
            model_name='job',
            index=models.Index(fields=['channel'], name='jobs_job_channel_0600ca_idx'),
        ),
        migrations.AddIndex(
            model_name='job',
            index=models.Index(fields=['func'], name='jobs_job_func_a770c0_idx'),
        ),
        migrations.AddIndex(
            model_name='job',
            index=models.Index(fields=['status'], name='jobs_job_status_7d017a_idx'),
        ),
        migrations.AddIndex(
            model_name='job',
            index=models.Index(fields=['run_at'], name='jobs_job_run_at_9cebab_idx'),
        ),
        migrations.AddIndex(
            model_name='job',
            index=models.Index(fields=['expires_at'], name='jobs_job_expires_1dbc32_idx'),
        ),
        migrations.AddIndex(
            model_name='job',
            index=models.Index(fields=['broadcast'], name='jobs_job_broadca_2507a1_idx'),
        ),
        migrations.AddIndex(
            model_name='job',
            index=models.Index(fields=['runner_id'], name='jobs_job_runner__4dae2a_idx'),
        ),
        migrations.AddIndex(
            model_name='job',
            index=models.Index(fields=['created'], name='jobs_job_created_a99b91_idx'),
        ),
        migrations.AddIndex(
            model_name='job',
            index=models.Index(fields=['modified'], name='jobs_job_modifie_b4706c_idx'),
        ),
    ]
