# Generated by Django 4.2.23 on 2025-09-03 20:22

from django.db import migrations, models
import django.db.models.deletion
import mojo.models.rest


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Job',
            fields=[
                ('id', models.CharField(editable=False, max_length=32, primary_key=True, serialize=False)),
                ('channel', models.CharField(db_index=True, help_text='Logical queue/channel name', max_length=100)),
                ('func', models.CharField(db_index=True, help_text='Registry key for the job function', max_length=255)),
                ('payload', models.JSONField(blank=True, default=dict, help_text='Job arguments/data (keep small)')),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('running', 'Running'), ('completed', 'Completed'), ('failed', 'Failed'), ('canceled', 'Canceled'), ('expired', 'Expired')], db_index=True, default='pending', help_text='Current job status', max_length=16)),
                ('run_at', models.DateTimeField(blank=True, db_index=True, help_text='When to run this job (null = immediate)', null=True)),
                ('expires_at', models.DateTimeField(blank=True, db_index=True, help_text='Job expires if not run by this time', null=True)),
                ('attempt', models.IntegerField(default=0, help_text='Current attempt number')),
                ('max_retries', models.IntegerField(default=3, help_text='Maximum retry attempts')),
                ('backoff_base', models.FloatField(default=2.0, help_text='Base for exponential backoff')),
                ('backoff_max_sec', models.IntegerField(default=3600, help_text='Maximum backoff in seconds')),
                ('broadcast', models.BooleanField(db_index=True, default=False, help_text='If true, all runners execute this job')),
                ('cancel_requested', models.BooleanField(default=False, help_text='Cooperative cancel flag')),
                ('max_exec_seconds', models.IntegerField(blank=True, help_text='Hard execution time limit', null=True)),
                ('runner_id', models.CharField(blank=True, db_index=True, help_text='ID of runner currently executing', max_length=64, null=True)),
                ('last_error', models.TextField(blank=True, default='', help_text='Latest error message')),
                ('stack_trace', models.TextField(blank=True, default='', help_text='Latest stack trace')),
                ('metadata', models.JSONField(blank=True, default=dict, help_text='Custom metadata from job execution')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('started_at', models.DateTimeField(blank=True, help_text='When job execution started', null=True)),
                ('finished_at', models.DateTimeField(blank=True, help_text='When job execution finished', null=True)),
                ('idempotency_key', models.CharField(blank=True, help_text='Optional key for exactly-once semantics', max_length=64, null=True, unique=True)),
            ],
            options={
                'db_table': 'jobs_job',
                'ordering': ['-created'],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='JobEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('channel', models.CharField(db_index=True, max_length=100)),
                ('event', models.CharField(choices=[('created', 'Created'), ('queued', 'Queued'), ('scheduled', 'Scheduled'), ('running', 'Running'), ('retry', 'Retry'), ('canceled', 'Canceled'), ('completed', 'Completed'), ('failed', 'Failed'), ('expired', 'Expired'), ('claimed', 'Claimed'), ('released', 'Released')], db_index=True, help_text='Event type', max_length=24)),
                ('at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('runner_id', models.CharField(blank=True, db_index=True, help_text='Runner that generated this event', max_length=64, null=True)),
                ('attempt', models.IntegerField(default=0, help_text='Attempt number at time of event')),
                ('details', models.JSONField(blank=True, default=dict, help_text='Event-specific details (keep minimal)')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='events', to='jobs.job')),
            ],
            options={
                'db_table': 'jobs_jobevent',
                'ordering': ['-at'],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.AddIndex(
            model_name='job',
            index=models.Index(fields=['channel', 'status'], name='jobs_job_channel_b6258d_idx'),
        ),
        migrations.AddIndex(
            model_name='job',
            index=models.Index(fields=['status', 'run_at'], name='jobs_job_status_f5c023_idx'),
        ),
        migrations.AddIndex(
            model_name='job',
            index=models.Index(fields=['runner_id', 'status'], name='jobs_job_runner__068502_idx'),
        ),
        migrations.AddIndex(
            model_name='jobevent',
            index=models.Index(fields=['job', '-at'], name='jobs_jobeve_job_id_4bb0aa_idx'),
        ),
        migrations.AddIndex(
            model_name='jobevent',
            index=models.Index(fields=['channel', 'event', '-at'], name='jobs_jobeve_channel_65ad24_idx'),
        ),
        migrations.AddIndex(
            model_name='jobevent',
            index=models.Index(fields=['runner_id', '-at'], name='jobs_jobeve_runner__8d884e_idx'),
        ),
        migrations.AddIndex(
            model_name='jobevent',
            index=models.Index(fields=['-at'], name='jobs_jobeve_at_67fd08_idx'),
        ),
    ]
