# Generated by Django 4.2.21 on 2025-08-30 02:36

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import mojo.models.rest


class Migration(migrations.Migration):

    dependencies = [
        ('account', '0010_group_avatar'),
    ]

    operations = [
        migrations.AddField(
            model_name='user',
            name='org',
            field=models.ForeignKey(blank=True, help_text='Default organization for this user', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='org_users', to='account.group'),
        ),
        migrations.CreateModel(
            name='RegisteredDevice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('device_token', models.TextField(db_index=True, help_text='Push token from platform')),
                ('device_id', models.CharField(db_index=True, help_text='App-provided device ID', max_length=255)),
                ('platform', models.CharField(choices=[('ios', 'iOS'), ('android', 'Android'), ('web', 'Web')], db_index=True, max_length=20)),
                ('app_version', models.CharField(blank=True, max_length=50)),
                ('os_version', models.CharField(blank=True, max_length=50)),
                ('device_name', models.CharField(blank=True, max_length=100)),
                ('push_enabled', models.BooleanField(db_index=True, default=True)),
                ('push_preferences', models.JSONField(blank=True, default=dict, help_text='Category-based notification preferences')),
                ('is_active', models.BooleanField(db_index=True, default=True)),
                ('last_seen', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='registered_devices', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-last_seen'],
                'unique_together': {('user', 'device_id'), ('device_token', 'platform')},
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='PushConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mojo_secrets', models.TextField(blank=True, default=None, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('name', models.CharField(help_text='Configuration name', max_length=100)),
                ('is_active', models.BooleanField(db_index=True, default=True)),
                ('apns_enabled', models.BooleanField(default=False)),
                ('apns_key_id', models.CharField(blank=True, max_length=100)),
                ('apns_team_id', models.CharField(blank=True, max_length=100)),
                ('apns_bundle_id', models.CharField(blank=True, max_length=255)),
                ('apns_key_file', models.TextField(blank=True, help_text='Encrypted via MojoSecrets')),
                ('apns_use_sandbox', models.BooleanField(default=False)),
                ('fcm_enabled', models.BooleanField(default=False)),
                ('fcm_server_key', models.TextField(blank=True, help_text='Encrypted via MojoSecrets')),
                ('fcm_sender_id', models.CharField(blank=True, max_length=100)),
                ('default_sound', models.CharField(default='default', max_length=50)),
                ('default_badge_count', models.IntegerField(default=1)),
                ('group', models.OneToOneField(blank=True, help_text='Organization for this config. Null = system default', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='push_config', to='account.group')),
            ],
            options={
                'ordering': ['group__name', 'name'],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='NotificationTemplate',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('name', models.CharField(db_index=True, max_length=100)),
                ('title_template', models.CharField(max_length=200)),
                ('body_template', models.TextField()),
                ('action_url', models.URLField(blank=True, help_text='Template URL with variable support', null=True)),
                ('category', models.CharField(db_index=True, default='general', max_length=50)),
                ('priority', models.CharField(choices=[('low', 'Low'), ('normal', 'Normal'), ('high', 'High')], db_index=True, default='normal', max_length=20)),
                ('variables', models.JSONField(blank=True, default=dict, help_text='Expected template variables and descriptions')),
                ('is_active', models.BooleanField(db_index=True, default=True)),
                ('group', models.ForeignKey(blank=True, help_text='Organization for this template. Null = system template', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='notification_templates', to='account.group')),
            ],
            options={
                'ordering': ['group__name', 'name'],
                'unique_together': {('group', 'name')},
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='NotificationDelivery',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('title', models.CharField(max_length=200)),
                ('body', models.TextField()),
                ('category', models.CharField(db_index=True, max_length=50)),
                ('action_url', models.URLField(blank=True, null=True)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('sent', 'Sent'), ('delivered', 'Delivered'), ('failed', 'Failed')], db_index=True, default='pending', max_length=20)),
                ('sent_at', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('delivered_at', models.DateTimeField(blank=True, null=True)),
                ('error_message', models.TextField(blank=True, null=True)),
                ('platform_data', models.JSONField(blank=True, default=dict, help_text='Platform-specific response data')),
                ('device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notification_deliveries', to='account.registereddevice')),
                ('template', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='deliveries', to='account.notificationtemplate')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notification_deliveries', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-created'],
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
    ]
