# -*- coding: utf-8 -*-
# Generated by Django 1.11.22 on 2019-07-23 17:46
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import modelcluster.fields
import molo.core.blocks
import molo.core.models
import molo.forms.blocks
from molo.forms import rules
import wagtail.core.blocks
import wagtail.core.fields
import wagtail.images.blocks


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailimages', '0021_image_file_hash'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('wagtail_personalisation', '0018_segment_excluded_users'),
        ('core', '0018_remove_wagtail_forms'),
        ('wagtailcore', '0040_page_draft_title'),
    ]

    operations = [
        migrations.CreateModel(
            name='CombinationRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('body', wagtail.core.fields.StreamField([('Rule', molo.forms.blocks.RuleSelectBlock()), ('Operator', wagtail.core.blocks.ChoiceBlock(choices=[('and', 'And'), ('or', 'Or')])), ('NestedLogic', wagtail.core.blocks.StructBlock([('rule_1', molo.forms.blocks.RuleSelectBlock(required=True)), ('operator', wagtail.core.blocks.ChoiceBlock(choices=[('and', 'And'), ('or', 'Or')])), ('rule_2', molo.forms.blocks.RuleSelectBlock(required=True))]))])),
                ('segment', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='forms_combinationrule_related', related_query_name='forms_combinationrules', to='wagtail_personalisation.Segment')),
            ],
            options={
                'verbose_name': 'Rule Combination',
            },
        ),
        migrations.CreateModel(
            name='FormResponseRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'verbose_name': 'Form response rule',
            },
        ),
        migrations.CreateModel(
            name='FormsArticleTagRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('operator', models.CharField(choices=[('gt', 'more than'), ('lt', 'less than'), ('eq', 'equal to')], default='gt', max_length=3, verbose_name='operator')),
                ('count', models.PositiveIntegerField()),
                ('date_from', models.DateTimeField(blank=True, null=True)),
                ('date_to', models.DateTimeField(blank=True, help_text='All times are UTC. Leave both fields blank to search all time.', null=True)),
                ('segment', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='forms_formsarticletagrule_related', related_query_name='forms_formsarticletagrules', to='wagtail_personalisation.Segment')),
                ('tag', models.ForeignKey(help_text='The number in the bracket indicates the number of articles that have the tag.', on_delete=django.db.models.deletion.CASCADE, to='core.Tag')),
            ],
            options={
                'verbose_name': 'Article tag rule',
            },
        ),
        migrations.CreateModel(
            name='FormsIndexPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
            ],
            options={
                'abstract': False,
            },
            bases=('wagtailcore.page', molo.core.models.PreventDeleteMixin),
        ),
        migrations.CreateModel(
            name='FormsSegmentUserGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=254)),
                ('users', models.ManyToManyField(related_name='forms_segment_groups', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='FormsTermsAndConditionsIndexPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
            ],
            options={
                'abstract': False,
            },
            bases=(molo.core.models.TranslatablePageMixinNotRoutable, 'wagtailcore.page'),
        ),
        migrations.CreateModel(
            name='FormSubmissionDataRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field_name', molo.forms.rules.FieldNameField(help_text="Field's label. For possible choices please input any text and save, so it will be displayed in the error messages below the field.", max_length=255, verbose_name='field name')),
                ('expected_response', models.CharField(help_text='When comparing text values, please input text. Comparison on text is always case-insensitive. Multiple choice values must be separated with commas.', max_length=255, verbose_name='expected response')),
                ('operator', models.CharField(choices=[('eq', 'equals'), ('in', 'contains')], default='in', help_text='When using the "contains" operator, "expected response" can contain a small part of user\'s response and it will be matched. "Exact" would match responses that are exactly the same as the "expected response".', max_length=3, verbose_name='operator')),
                ('segment', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='forms_formsubmissiondatarule_related', related_query_name='forms_formsubmissiondatarules', to='wagtail_personalisation.Segment')),
            ],
            options={
                'verbose_name': 'Form submission rule',
            },
        ),
        migrations.CreateModel(
            name='FormTermsConditions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GroupMembershipRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='forms.FormsSegmentUserGroup')),
                ('segment', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='forms_groupmembershiprule_related', related_query_name='forms_groupmembershiprules', to='wagtail_personalisation.Segment')),
            ],
            options={
                'verbose_name': 'Group membership rule',
            },
        ),
        migrations.CreateModel(
            name='MoloFormFormField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('label', models.CharField(help_text='The label of the form field', max_length=255, verbose_name='label')),
                ('required', models.BooleanField(default=True, verbose_name='required')),
                ('default_value', models.CharField(blank=True, help_text='Default value. Comma separated values supported for checkboxes.', max_length=255, verbose_name='default value')),
                ('help_text', models.CharField(blank=True, max_length=255, verbose_name='help text')),
                ('page_break', models.BooleanField(default=False, help_text='Inserts a page break which puts the next question onto a new page')),
                ('admin_label', models.CharField(default='', help_text='Column header used during CSV export of form responses.', max_length=256)),
                ('skip_logic', molo.forms.blocks.SkipLogicField([('skip_logic', wagtail.core.blocks.StructBlock([('choice', wagtail.core.blocks.CharBlock(required=False)), ('skip_logic', wagtail.core.blocks.ChoiceBlock(choices=[('next', 'Next default question'), ('end', 'End of form'), ('question', 'Another question'), ('form', 'Another form')])), ('form', wagtail.core.blocks.PageChooserBlock(required=False, target_model=['forms.MoloFormPage'])), ('question', molo.forms.blocks.QuestionSelectBlock(help_text='Please save the form as a draft to populate or update the list of questions.', required=False))]))], blank=True, help_text='<strong>Checkbox must include only 2 Answer Options. True and False in that order.</strong>', verbose_name='Answer options')),
                ('choices', models.TextField(blank=True, help_text='Comma separated list of choices. Only applicable in checkboxes,radio and dropdown. The full length of the choice list and the commas that separate them are resctricted to 512 characters.', verbose_name='choices')),
                ('field_type', models.CharField(choices=[('singleline', 'Single line text'), ('multiline', 'Multi-line text'), ('email', 'Email'), ('number', 'Number'), ('url', 'URL'), ('checkbox', 'Checkbox'), ('checkboxes', 'Checkboxes'), ('dropdown', 'Drop down'), ('multiselect', 'Multiple select'), ('radio', 'Radio buttons'), ('date', 'Date'), ('datetime', 'Date/time'), ('hidden', 'Hidden field'), ('positive_number', 'Positive Number')], max_length=16, verbose_name='field type')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MoloFormPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('introduction', models.TextField(blank=True)),
                ('homepage_introduction', models.TextField(blank=True)),
                ('description', wagtail.core.fields.StreamField([('heading', wagtail.core.blocks.CharBlock(classname='full title')), ('paragraph', molo.core.blocks.MarkDownBlock()), ('image', wagtail.images.blocks.ImageChooserBlock()), ('list', wagtail.core.blocks.ListBlock(wagtail.core.blocks.CharBlock(label='Item'))), ('numbered_list', wagtail.core.blocks.ListBlock(wagtail.core.blocks.CharBlock(label='Item'))), ('page', wagtail.core.blocks.PageChooserBlock())], blank=True, null=True)),
                ('thank_you_text', models.TextField(blank=True)),
                ('submit_text', models.TextField(blank=True)),
                ('homepage_button_text', models.TextField(blank=True)),
                ('allow_anonymous_submissions', models.BooleanField(default=False, help_text='Check this to allow users who are NOT logged in to complete forms.')),
                ('allow_multiple_submissions_per_user', models.BooleanField(default=False, help_text='Check this to allow users to complete a form more than once.')),
                ('show_results', models.BooleanField(default=False, help_text='Whether to show the form results to the user after they have submitted their answer(s).')),
                ('show_results_as_percentage', models.BooleanField(default=False, help_text='Whether to show the form results to the user after they have submitted their answer(s) as a percentage or as a number.')),
                ('multi_step', models.BooleanField(default=False, help_text='Whether to display the form questions to the user one at a time, instead of all at once.', verbose_name='Multi-step')),
                ('display_form_directly', models.BooleanField(default=False, help_text='This is similar to polls, in which the questions are displayed directly on the page, instead of displaying a link to another page to complete the form.', verbose_name='Display Question Directly')),
                ('your_words_competition', models.BooleanField(default=False, help_text='This will display the correct template for yourwords', verbose_name='Is YourWords Competition')),
                ('extra_style_hints', models.TextField(blank=True, default='', help_text='Styling options that can be applied to this page and all its descendants', null=True)),
            ],
            options={
                'abstract': False,
            },
            bases=(molo.core.models.TranslatablePageMixinNotRoutable, 'wagtailcore.page'),
        ),
        migrations.CreateModel(
            name='MoloFormPageView',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('visited_at', models.DateTimeField(auto_now_add=True)),
                ('page', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.ArticlePage')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='MoloFormSubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('form_data', models.TextField()),
                ('submit_time', models.DateTimeField(auto_now_add=True, verbose_name='submit time')),
                ('article_page', models.ForeignKey(blank=True, help_text='Page to which the entry was converted to', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='core.ArticlePage')),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Page')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'form submission',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PersonalisableFormField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('label', models.CharField(help_text='The label of the form field', max_length=255, verbose_name='label')),
                ('required', models.BooleanField(default=True, verbose_name='required')),
                ('choices', models.TextField(blank=True, help_text='Comma separated list of choices. Only applicable in checkboxes, radio and dropdown.', verbose_name='choices')),
                ('default_value', models.CharField(blank=True, help_text='Default value. Comma separated values supported for checkboxes.', max_length=255, verbose_name='default value')),
                ('help_text', models.CharField(blank=True, max_length=255, verbose_name='help text')),
                ('page_break', models.BooleanField(default=False, help_text='Inserts a page break which puts the next question onto a new page')),
                ('admin_label', models.CharField(default='', help_text='Column header used during CSV export of form responses.', max_length=256)),
                ('skip_logic', molo.forms.blocks.SkipLogicField([('skip_logic', wagtail.core.blocks.StructBlock([('choice', wagtail.core.blocks.CharBlock(required=False)), ('skip_logic', wagtail.core.blocks.ChoiceBlock(choices=[('next', 'Next default question'), ('end', 'End of form'), ('question', 'Another question'), ('form', 'Another form')])), ('form', wagtail.core.blocks.PageChooserBlock(required=False, target_model=['forms.MoloFormPage'])), ('question', molo.forms.blocks.QuestionSelectBlock(help_text='Please save the form as a draft to populate or update the list of questions.', required=False))]))], blank=True, help_text='<strong>Checkbox must include only 2 Answer Options. True and False in that order.</strong>', verbose_name='Answer options')),
                ('field_type', models.CharField(choices=[('singleline', 'Single line text'), ('multiline', 'Multi-line text'), ('email', 'Email'), ('number', 'Number'), ('url', 'URL'), ('checkbox', 'Checkbox'), ('checkboxes', 'Checkboxes'), ('dropdown', 'Drop down'), ('multiselect', 'Multiple select'), ('radio', 'Radio buttons'), ('date', 'Date'), ('datetime', 'Date/time'), ('hidden', 'Hidden field')], max_length=16, verbose_name='field type')),
                ('segment', models.ForeignKey(blank=True, help_text='Leave it empty to show this field to every user.', null=True, on_delete=django.db.models.deletion.PROTECT, to='wagtail_personalisation.Segment')),
            ],
            options={
                'verbose_name': 'personalisable form field',
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PersonalisableForm',
            fields=[
                ('moloformpage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='forms.MoloFormPage')),
                ('segment', models.ForeignKey(blank=True, help_text='Leave it empty to show this formto every user.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='wagtail_personalisation.Segment')),
            ],
            options={
                'verbose_name': 'personalisable form',
            },
            bases=('forms.moloformpage',),
        ),
        migrations.AddField(
            model_name='moloformpage',
            name='image',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image'),
        ),
        migrations.AddField(
            model_name='moloformpage',
            name='language',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.SiteLanguage'),
        ),
        migrations.AddField(
            model_name='moloformpage',
            name='translated_pages',
            field=models.ManyToManyField(blank=True, related_name='_moloformpage_translated_pages_+', to='forms.MoloFormPage'),
        ),
        migrations.AddField(
            model_name='moloformformfield',
            name='page',
            field=modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='form_fields', to='forms.MoloFormPage'),
        ),
        migrations.AddField(
            model_name='formtermsconditions',
            name='page',
            field=modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='terms_and_conditions', to='forms.MoloFormPage'),
        ),
        migrations.AddField(
            model_name='formtermsconditions',
            name='terms_and_conditions',
            field=models.ForeignKey(blank=True, help_text='Terms and Conditions', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.Page'),
        ),
        migrations.AddField(
            model_name='formresponserule',
            name='form',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='forms.MoloFormPage', verbose_name='form'),
        ),
        migrations.AddField(
            model_name='formresponserule',
            name='segment',
            field=modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='forms_formresponserule_related', related_query_name='forms_formresponserules', to='wagtail_personalisation.Segment'),
        ),
        migrations.AddField(
            model_name='personalisableformfield',
            name='page',
            field=modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='personalisable_form_fields', to='forms.PersonalisableForm'),
        ),
        migrations.AddField(
            model_name='formsubmissiondatarule',
            name='form',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='forms.PersonalisableForm', verbose_name='form'),
        ),
    ]
