from __future__ import generator_stop

from itertools import chain

from setuptools import setup

# nltk.download("punkt")

with open("README.md", encoding="utf-8") as fr:
    long_description = fr.read()

extras_require = {
    "args": [],
    "algorithms": [],
    "atomic": [],
    "binary": [],
    "concurrency": [],
    "constants_physics": [],
    "constants_video": [],
    "csv": [],
    "datetime": [],
    "debug": [],
    "dict": [],
    "datastructures": [],
    "error": [],
    "exceptions": [],
    "factorial": [],
    "func": [],
    "file": [],
    "filesystem": [],
    "geometry": [],
    "hash": [],
    "iter": [],
    "imdb": [],
    "indexing": [],
    "latex": [],
    "math": [],
    "metrictree": [],
    "mongo": [],
    "object": [],
    "ops": [],
    "os": ["ctypes-windows-sdk>=0.0.7; sys_platform == 'win32'"],
    "pickle": [],
    "profile": [],
    "rand": [],
    "ringlist": [],
    "search": [],
    "sequence": [],
    "set": [],
    "signal": [],
    "sort": [],
    "sql": [],
    "sqlite": [],
    "statistics": [],
    "stdio": [],
    "string": [],
    "test": [],
    "time": [],
    "typing": ["typing-extensions"],
    "text": [],
    "twitch": [],
    "url": [],
    # "browscap": ["re2"], # unfinished
    "cholesky": ["numpy", "numba"],
    "config": ["jsonschema", "sortedcontainers"],
    "downloadmanager": ["aiohttp>=0.16.3", "orderedset"],
    "encoder": ["numpy", "nltk>=3.6.1"],
    "filesdb": ["tls-property"],
    "fingerprinting": ["numpy", "numba", "pillow"],
    "html": ["beautifulsoup4"],
    "http": ["requests", "certifi"],
    "http2": ["hyper"],
    "image": ["numpy", "scipy<1.6.0"],
    "json": ["jsonschema"],
    "lda": ["numpy", "nltk>=3.6.1"],
    "metrics": ["numpy"],
    "mp4": ["setuptools"],
    "multihash": ["rhash"],
    "net": ["netifaces"],
    "nlp": ["nltk>=3.6.1"],
    "regression": ["numpy"],
    "resizing": ["numpy", "opencv-python", "scikit-learn"],
    "rich": ["rich"],
    "scene_change_detection": ["numpy"],
    "sudoku": ["setuptools"],
    "tls": ["cryptography", "pyOpenSSL>=17.5.0"],
    "torrent": ["bencode.py>=2.0.0", "requests"],  # bencoding ?
    "videofile": ["opencv-python", "av"],
    "win32": ["wmi", "pypiwin32"],
    "widgets": ["wxPython"],
    "xsl": ["lxml"],
    # helpers for specific packages
    "aria": ["aria2p", "requests"],
    "av": ["av"],
    "cv": ["opencv-python", "numpy"],
    "flask": ["flask", "werkzeug>=0.11.11"],
    "gensim": ["gensim>=4.0.0", "numpy"],
    "msgpack": ["msgpack>=0.6.0"],
    "mediainfo": ["pymediainfo"],
    "numpy": ["numpy"],
    "numba": ["numba"],
    "nltk": ["nltk>=3.6.1"],
    "networkx": ["networkx"],
    "pandas": ["pandas"],
    "pdf": ["PyPDF2>=2.5.0"],
    "pillow": ["pillow", "piexif"],
    "powerpoint": ["python-pptx"],
    "rasa": ["requests", "aiohttp>=2.3", "ruamel.yaml"],
    "salesforce": ["simple-salesforce>=1.1.0", "simplejson", "aiohttp>=2.3", "requests", "pandas"],
    "scipy": ["numpy", "scipy<1.6.0"],
    "spark": ["pyspark>=3.0.0"],
    "toml": ["toml"],
    "torch": ["torch"],
    "twisted": ["twisted"],
    "tensorflow": ["tensorflow"],
    "yaml": ["ruamel.yaml"],
}

extras_require["all"] = sorted(set(chain.from_iterable(extras_require.values())))

setup(
    author="Dobatymo",
    name="genutility",
    version="0.0.92",
    url="https://github.com/Dobatymo/genutility",
    description="A collection of various Python utilities",
    long_description=long_description,
    long_description_content_type="text/markdown",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: ISC License (ISCL)",
        "Operating System :: OS Independent",
        "Topic :: Utilities",
    ],
    packages=["genutility", "genutility.compat", "genutility.fileformats", "genutility.hardware", "genutility.win"],
    package_data={"genutility": ["py.typed", "data/*.tsv"]},
    python_requires=">=3.6",
    install_requires=["ctypes-windows-sdk>=0.0.7; sys_platform=='win32'", "typing-extensions"],
    extras_require=extras_require,
    license_files=["LICENSE"],
)
