# knowde
knowde(know + node)は知識管理メモ支援ツールである。  
**理解とは分解と再構成だ**。
機械は自分の手で分解・組み立て直すことではじめてその構造を把握できる。
知識も同様である。

本ツールは
1. 理解した内容を1文とそれらを関連付けに分解してメモ(再構成)するための独自文法
2. その文法に則ったプレーンテキストの読み取りと蓄積
3. 関連付けによる情報の検索・表示

を提供する。

これで知識を整理すれば、概念の位置づけや複雑さなどを一目で分かるようになる。
wikipediaのようなリンク地獄や知識の体系的理解の難しさとはおさらばだ！

## Requirements
Python 3.11+
## How to use
### Installation
    pip install knowde
### プレーンテキストの独自文法
```md
# 題名 // 情報のまとまりの識別として使う
    // メタ情報
    [@author 著者]
    [@publish 第一出版日]
    [@url url]
! コメントは!から始まる1行
## 見出し1
    aaa //1文にはインデントが必要
    bbb\
        ccc //改行を含めて1文(bbbccc)と見なす
### 見出し2
    ...
###### 見出し5 // 5段階まで見出しが使える
    ppp
        qqq    //pppの配下を表す 詳細などを書く
        <- rrr //pppの前提
        -> sss //pppによる帰結

    ...途中
```

### CLI
```sh
kn --help #helpの表示
```
例: プレーンテキストを読み取り
```sh
cat xxx.txt |kn read
# or
kn read xxx.txt
```

## URLs
PyPI: https://pypi.org/project/knowde/  
GitHub: https://github.com/shogogoto/knowde

-----
### なぜこれを作ろうと思ったか
#### 大学数学ムズすぎ
定理の依存関係を追えれば、全体像が把握しやすくなるだろうと思った。

大学数学の勉強で以下を経験した。
- 名前もない大量の定理があって証明を追い切れなかった
- 全体像がつかめない、どこに繋がっているかも分からずモチベが低下した

#### 手書きメモの限界
見返せる生きたメモはプレーンテキストなどのデジタルなものしか不可能だと悟った。

読書内容をいざブログなどでアウトプットしようとしたら、
全く書けるレベルに達していないことが発覚して愕然とした。  
だから次は読書メモを始めた。
ノートやコピー用紙では紙のこすれや消しゴムのせいで文字が滲んだり、紙が痛んり、
かさばった。それが嫌でデジタルペーパーに移行した。  
しかし、それらの手書きメモは検索性が悪く、見返すことはなかった。
見返してもメモの精度が低く、アウトプットの参考として使い物にならないものばかりだった。
