# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import re
import sys
sys.path.insert(0, os.path.abspath('..'))


# -- Project information -----------------------------------------------------

project = 's1etad'
copyright = '2020, s1etad Developers'
author = 'Nuno Miranda <nuno.miranda@esa.int>'

with open('../s1etad.py') as fd:
    s = fd.read()


# The short X.Y version
pattern = r'^__version__( )?=( )?(?P<q>[\'"])(?P<v>\d+\.\d+(\.\d+))(?P=q)'
version = re.search(pattern, s, re.M).group('v')

# The full version, including alpha/beta/rc tags
pattern = r'^__version__( )?=( )?(?P<q>[\'"])(?P<r>\d+\.\d+(\.\d+).*)(?P=q)'
release = re.search(pattern, s, re.M).group('r')


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'sphinx.ext.todo',
    'sphinx.ext.mathjax',
    'sphinx.ext.viewcode',
    'sphinx.ext.napoleon',
    'nbsphinx',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'alabaster'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']


# -- Extension configuration -------------------------------------------------

# -- Options for intersphinx extension ---------------------------------------

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'https://docs.python.org/3/': None}

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# -- Options for autodoc extension -------------------------------------------
autodoc_mock_imports = [
    'numpy',
    'scipy',
    'lxml',
    'netCDF4',
    'pandas',
    'dateutil',
    'shapely',
    'simplekml',
]

# -- Options for ReadTheDocs integration -------------------------------------
if os.environ.get('READTHEDOCS'):
    html_theme = "default"

master_doc = 'index'
html_context = {
    "display_gitlab": True,
    "gitlab_user": "nuno.miranda",
    "gitlab_repo": "s1-etad",
    "gitlab_version": "master",
    "conf_py_path": "docs",
}