r'''
# dev-fsx-storagevirtualmachine

> AWS CDK [L1 construct](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html) and data structures for the [AWS CloudFormation Registry](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html) type `Dev::FSx::StorageVirtualMachine`.

## Usage

In order to use this library, you will need to activate this AWS CloudFormation Registry type in your account. You can do this via the AWS Management Console or using the [AWS CLI](https://aws.amazon.com/cli/) using the following command:

```sh
aws cloudformation activate-type \
  --type-name Dev::FSx::StorageVirtualMachine \
  --publisher-id undefined \
  --type RESOURCE \
  --execution-role-arn ROLE-ARN
```

Alternatively:

```sh
aws cloudformation activate-type \
  --public-type-arn arn:aws:cloudformation:us-east-1::type/resource/Dev-FSx-StorageVirtualMachine \
  --execution-role-arn ROLE-ARN
```

You can find more information about activating this type in the [AWS CloudFormation documentation](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html).

## Feedback

This library is auto-generated and published to all supported programming languages by the [cdklabs/cdk-cloudformation](https://github.com/cdklabs/cdk-cloudformation) project based on the API schema published for `Dev::FSx::StorageVirtualMachine`.

* Issues related to this generated library should be [reported here](https://github.com/cdklabs/cdk-cloudformation/issues/new?title=Issue+with+%40cdk-cloudformation%2Fdev-fsx-storagevirtualmachine).
* Issues related to `Dev::FSx::StorageVirtualMachine` should be reported to the [publisher](undefined).

## License

Distributed under the Apache-2.0 License.
'''
from pkgutil import extend_path
__path__ = extend_path(__path__, __name__)

import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

import typeguard
from importlib.metadata import version as _metadata_package_version
TYPEGUARD_MAJOR_VERSION = int(_metadata_package_version('typeguard').split('.')[0])

def check_type(argname: str, value: object, expected_type: typing.Any) -> typing.Any:
    if TYPEGUARD_MAJOR_VERSION <= 2:
        return typeguard.check_type(argname=argname, value=value, expected_type=expected_type) # type:ignore
    else:
        if isinstance(value, jsii._reference_map.InterfaceDynamicProxy): # pyright: ignore [reportAttributeAccessIssue]
           pass
        else:
            if TYPEGUARD_MAJOR_VERSION == 3:
                typeguard.config.collection_check_strategy = typeguard.CollectionCheckStrategy.ALL_ITEMS # type:ignore
                typeguard.check_type(value=value, expected_type=expected_type) # type:ignore
            else:
                typeguard.check_type(value=value, expected_type=expected_type, collection_check_strategy=typeguard.CollectionCheckStrategy.ALL_ITEMS) # type:ignore

from ._jsii import *

import aws_cdk as _aws_cdk_ceddda9d
import constructs as _constructs_77d1e7e8


@jsii.data_type(
    jsii_type="@cdk-cloudformation/dev-fsx-storagevirtualmachine.ActiveDirectoryConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "net_bios_name": "netBiosName",
        "self_managed_active_directory_configuration": "selfManagedActiveDirectoryConfiguration",
    },
)
class ActiveDirectoryConfiguration:
    def __init__(
        self,
        *,
        net_bios_name: typing.Optional[builtins.str] = None,
        self_managed_active_directory_configuration: typing.Optional[typing.Union["SelfManagedActiveDirectoryConfiguration", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param net_bios_name: 
        :param self_managed_active_directory_configuration: 

        :schema: ActiveDirectoryConfiguration
        '''
        if isinstance(self_managed_active_directory_configuration, dict):
            self_managed_active_directory_configuration = SelfManagedActiveDirectoryConfiguration(**self_managed_active_directory_configuration)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b94daf46a8bf87a124644cbdf568c85cfad94f42244833b783cfd812d042f70f)
            check_type(argname="argument net_bios_name", value=net_bios_name, expected_type=type_hints["net_bios_name"])
            check_type(argname="argument self_managed_active_directory_configuration", value=self_managed_active_directory_configuration, expected_type=type_hints["self_managed_active_directory_configuration"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if net_bios_name is not None:
            self._values["net_bios_name"] = net_bios_name
        if self_managed_active_directory_configuration is not None:
            self._values["self_managed_active_directory_configuration"] = self_managed_active_directory_configuration

    @builtins.property
    def net_bios_name(self) -> typing.Optional[builtins.str]:
        '''
        :schema: ActiveDirectoryConfiguration#NetBiosName
        '''
        result = self._values.get("net_bios_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def self_managed_active_directory_configuration(
        self,
    ) -> typing.Optional["SelfManagedActiveDirectoryConfiguration"]:
        '''
        :schema: ActiveDirectoryConfiguration#SelfManagedActiveDirectoryConfiguration
        '''
        result = self._values.get("self_managed_active_directory_configuration")
        return typing.cast(typing.Optional["SelfManagedActiveDirectoryConfiguration"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ActiveDirectoryConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class CfnStorageVirtualMachine(
    _aws_cdk_ceddda9d.CfnResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdk-cloudformation/dev-fsx-storagevirtualmachine.CfnStorageVirtualMachine",
):
    '''A CloudFormation ``Dev::FSx::StorageVirtualMachine``.

    :cloudformationResource: Dev::FSx::StorageVirtualMachine
    :link: http://unknown-url
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        file_system_id: builtins.str,
        name: builtins.str,
        active_directory_configuration: typing.Optional[typing.Union[ActiveDirectoryConfiguration, typing.Dict[builtins.str, typing.Any]]] = None,
        root_volume_security_style: typing.Optional[builtins.str] = None,
        svm_admin_password: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union["Tag", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``Dev::FSx::StorageVirtualMachine``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param file_system_id: 
        :param name: 
        :param active_directory_configuration: 
        :param root_volume_security_style: 
        :param svm_admin_password: 
        :param tags: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__512fca0dc6f3eb9a51a7a7d8f8c3c5a4f9a73a828026c9320422e5dbab5c77a8)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnStorageVirtualMachineProps(
            file_system_id=file_system_id,
            name=name,
            active_directory_configuration=active_directory_configuration,
            root_volume_security_style=root_volume_security_style,
            svm_admin_password=svm_admin_password,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrResourceARN")
    def attr_resource_arn(self) -> builtins.str:
        '''Attribute ``Dev::FSx::StorageVirtualMachine.ResourceARN``.

        :link: http://unknown-url
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrResourceARN"))

    @builtins.property
    @jsii.member(jsii_name="attrStorageVirtualMachineId")
    def attr_storage_virtual_machine_id(self) -> builtins.str:
        '''Attribute ``Dev::FSx::StorageVirtualMachine.StorageVirtualMachineId``.

        :link: http://unknown-url
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrStorageVirtualMachineId"))

    @builtins.property
    @jsii.member(jsii_name="attrUuid")
    def attr_uuid(self) -> builtins.str:
        '''Attribute ``Dev::FSx::StorageVirtualMachine.UUID``.

        :link: http://unknown-url
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrUuid"))

    @builtins.property
    @jsii.member(jsii_name="props")
    def props(self) -> "CfnStorageVirtualMachineProps":
        '''Resource props.'''
        return typing.cast("CfnStorageVirtualMachineProps", jsii.get(self, "props"))


@jsii.data_type(
    jsii_type="@cdk-cloudformation/dev-fsx-storagevirtualmachine.CfnStorageVirtualMachineProps",
    jsii_struct_bases=[],
    name_mapping={
        "file_system_id": "fileSystemId",
        "name": "name",
        "active_directory_configuration": "activeDirectoryConfiguration",
        "root_volume_security_style": "rootVolumeSecurityStyle",
        "svm_admin_password": "svmAdminPassword",
        "tags": "tags",
    },
)
class CfnStorageVirtualMachineProps:
    def __init__(
        self,
        *,
        file_system_id: builtins.str,
        name: builtins.str,
        active_directory_configuration: typing.Optional[typing.Union[ActiveDirectoryConfiguration, typing.Dict[builtins.str, typing.Any]]] = None,
        root_volume_security_style: typing.Optional[builtins.str] = None,
        svm_admin_password: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union["Tag", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Resource Type definition for Dev::FSx::StorageVirtualMachine.

        :param file_system_id: 
        :param name: 
        :param active_directory_configuration: 
        :param root_volume_security_style: 
        :param svm_admin_password: 
        :param tags: 

        :schema: CfnStorageVirtualMachineProps
        '''
        if isinstance(active_directory_configuration, dict):
            active_directory_configuration = ActiveDirectoryConfiguration(**active_directory_configuration)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dadc3c742dd59fe417f697f780d7918c1ad0d66901fd9586c8b9b7dd60c5b95c)
            check_type(argname="argument file_system_id", value=file_system_id, expected_type=type_hints["file_system_id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument active_directory_configuration", value=active_directory_configuration, expected_type=type_hints["active_directory_configuration"])
            check_type(argname="argument root_volume_security_style", value=root_volume_security_style, expected_type=type_hints["root_volume_security_style"])
            check_type(argname="argument svm_admin_password", value=svm_admin_password, expected_type=type_hints["svm_admin_password"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "file_system_id": file_system_id,
            "name": name,
        }
        if active_directory_configuration is not None:
            self._values["active_directory_configuration"] = active_directory_configuration
        if root_volume_security_style is not None:
            self._values["root_volume_security_style"] = root_volume_security_style
        if svm_admin_password is not None:
            self._values["svm_admin_password"] = svm_admin_password
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def file_system_id(self) -> builtins.str:
        '''
        :schema: CfnStorageVirtualMachineProps#FileSystemId
        '''
        result = self._values.get("file_system_id")
        assert result is not None, "Required property 'file_system_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :schema: CfnStorageVirtualMachineProps#Name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def active_directory_configuration(
        self,
    ) -> typing.Optional[ActiveDirectoryConfiguration]:
        '''
        :schema: CfnStorageVirtualMachineProps#ActiveDirectoryConfiguration
        '''
        result = self._values.get("active_directory_configuration")
        return typing.cast(typing.Optional[ActiveDirectoryConfiguration], result)

    @builtins.property
    def root_volume_security_style(self) -> typing.Optional[builtins.str]:
        '''
        :schema: CfnStorageVirtualMachineProps#RootVolumeSecurityStyle
        '''
        result = self._values.get("root_volume_security_style")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def svm_admin_password(self) -> typing.Optional[builtins.str]:
        '''
        :schema: CfnStorageVirtualMachineProps#SvmAdminPassword
        '''
        result = self._values.get("svm_admin_password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List["Tag"]]:
        '''
        :schema: CfnStorageVirtualMachineProps#Tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List["Tag"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnStorageVirtualMachineProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdk-cloudformation/dev-fsx-storagevirtualmachine.SelfManagedActiveDirectoryConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "dns_ips": "dnsIps",
        "domain_join_service_account_secret": "domainJoinServiceAccountSecret",
        "domain_name": "domainName",
        "file_system_administrators_group": "fileSystemAdministratorsGroup",
        "organizational_unit_distinguished_name": "organizationalUnitDistinguishedName",
        "password": "password",
        "user_name": "userName",
    },
)
class SelfManagedActiveDirectoryConfiguration:
    def __init__(
        self,
        *,
        dns_ips: typing.Optional[typing.Sequence[builtins.str]] = None,
        domain_join_service_account_secret: typing.Optional[builtins.str] = None,
        domain_name: typing.Optional[builtins.str] = None,
        file_system_administrators_group: typing.Optional[builtins.str] = None,
        organizational_unit_distinguished_name: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
        user_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param dns_ips: 
        :param domain_join_service_account_secret: 
        :param domain_name: 
        :param file_system_administrators_group: 
        :param organizational_unit_distinguished_name: 
        :param password: 
        :param user_name: 

        :schema: SelfManagedActiveDirectoryConfiguration
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8070e1b168a7ae08565df7db60823658b461faf0565bf726278f0f69ee8553be)
            check_type(argname="argument dns_ips", value=dns_ips, expected_type=type_hints["dns_ips"])
            check_type(argname="argument domain_join_service_account_secret", value=domain_join_service_account_secret, expected_type=type_hints["domain_join_service_account_secret"])
            check_type(argname="argument domain_name", value=domain_name, expected_type=type_hints["domain_name"])
            check_type(argname="argument file_system_administrators_group", value=file_system_administrators_group, expected_type=type_hints["file_system_administrators_group"])
            check_type(argname="argument organizational_unit_distinguished_name", value=organizational_unit_distinguished_name, expected_type=type_hints["organizational_unit_distinguished_name"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument user_name", value=user_name, expected_type=type_hints["user_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if dns_ips is not None:
            self._values["dns_ips"] = dns_ips
        if domain_join_service_account_secret is not None:
            self._values["domain_join_service_account_secret"] = domain_join_service_account_secret
        if domain_name is not None:
            self._values["domain_name"] = domain_name
        if file_system_administrators_group is not None:
            self._values["file_system_administrators_group"] = file_system_administrators_group
        if organizational_unit_distinguished_name is not None:
            self._values["organizational_unit_distinguished_name"] = organizational_unit_distinguished_name
        if password is not None:
            self._values["password"] = password
        if user_name is not None:
            self._values["user_name"] = user_name

    @builtins.property
    def dns_ips(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :schema: SelfManagedActiveDirectoryConfiguration#DnsIps
        '''
        result = self._values.get("dns_ips")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def domain_join_service_account_secret(self) -> typing.Optional[builtins.str]:
        '''
        :schema: SelfManagedActiveDirectoryConfiguration#DomainJoinServiceAccountSecret
        '''
        result = self._values.get("domain_join_service_account_secret")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def domain_name(self) -> typing.Optional[builtins.str]:
        '''
        :schema: SelfManagedActiveDirectoryConfiguration#DomainName
        '''
        result = self._values.get("domain_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def file_system_administrators_group(self) -> typing.Optional[builtins.str]:
        '''
        :schema: SelfManagedActiveDirectoryConfiguration#FileSystemAdministratorsGroup
        '''
        result = self._values.get("file_system_administrators_group")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def organizational_unit_distinguished_name(self) -> typing.Optional[builtins.str]:
        '''
        :schema: SelfManagedActiveDirectoryConfiguration#OrganizationalUnitDistinguishedName
        '''
        result = self._values.get("organizational_unit_distinguished_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''
        :schema: SelfManagedActiveDirectoryConfiguration#Password
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user_name(self) -> typing.Optional[builtins.str]:
        '''
        :schema: SelfManagedActiveDirectoryConfiguration#UserName
        '''
        result = self._values.get("user_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SelfManagedActiveDirectoryConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdk-cloudformation/dev-fsx-storagevirtualmachine.Tag",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "value": "value"},
)
class Tag:
    def __init__(self, *, key: builtins.str, value: builtins.str) -> None:
        '''
        :param key: 
        :param value: 

        :schema: Tag
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0dd1b199c40c18585f31071d2d14cd12e208edeb0e1069110096b801388ddb20)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "value": value,
        }

    @builtins.property
    def key(self) -> builtins.str:
        '''
        :schema: Tag#Key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''
        :schema: Tag#Value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Tag(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


__all__ = [
    "ActiveDirectoryConfiguration",
    "CfnStorageVirtualMachine",
    "CfnStorageVirtualMachineProps",
    "SelfManagedActiveDirectoryConfiguration",
    "Tag",
]

publication.publish()

def _typecheckingstub__b94daf46a8bf87a124644cbdf568c85cfad94f42244833b783cfd812d042f70f(
    *,
    net_bios_name: typing.Optional[builtins.str] = None,
    self_managed_active_directory_configuration: typing.Optional[typing.Union[SelfManagedActiveDirectoryConfiguration, typing.Dict[builtins.str, typing.Any]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__512fca0dc6f3eb9a51a7a7d8f8c3c5a4f9a73a828026c9320422e5dbab5c77a8(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    file_system_id: builtins.str,
    name: builtins.str,
    active_directory_configuration: typing.Optional[typing.Union[ActiveDirectoryConfiguration, typing.Dict[builtins.str, typing.Any]]] = None,
    root_volume_security_style: typing.Optional[builtins.str] = None,
    svm_admin_password: typing.Optional[builtins.str] = None,
    tags: typing.Optional[typing.Sequence[typing.Union[Tag, typing.Dict[builtins.str, typing.Any]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__dadc3c742dd59fe417f697f780d7918c1ad0d66901fd9586c8b9b7dd60c5b95c(
    *,
    file_system_id: builtins.str,
    name: builtins.str,
    active_directory_configuration: typing.Optional[typing.Union[ActiveDirectoryConfiguration, typing.Dict[builtins.str, typing.Any]]] = None,
    root_volume_security_style: typing.Optional[builtins.str] = None,
    svm_admin_password: typing.Optional[builtins.str] = None,
    tags: typing.Optional[typing.Sequence[typing.Union[Tag, typing.Dict[builtins.str, typing.Any]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8070e1b168a7ae08565df7db60823658b461faf0565bf726278f0f69ee8553be(
    *,
    dns_ips: typing.Optional[typing.Sequence[builtins.str]] = None,
    domain_join_service_account_secret: typing.Optional[builtins.str] = None,
    domain_name: typing.Optional[builtins.str] = None,
    file_system_administrators_group: typing.Optional[builtins.str] = None,
    organizational_unit_distinguished_name: typing.Optional[builtins.str] = None,
    password: typing.Optional[builtins.str] = None,
    user_name: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__0dd1b199c40c18585f31071d2d14cd12e208edeb0e1069110096b801388ddb20(
    *,
    key: builtins.str,
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass
