"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnStorageVirtualMachine = void 0;
exports.toJson_CfnStorageVirtualMachineProps = toJson_CfnStorageVirtualMachineProps;
exports.toJson_ActiveDirectoryConfiguration = toJson_ActiveDirectoryConfiguration;
exports.toJson_Tag = toJson_Tag;
exports.toJson_SelfManagedActiveDirectoryConfiguration = toJson_SelfManagedActiveDirectoryConfiguration;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnStorageVirtualMachineProps' to JSON representation.
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_CfnStorageVirtualMachineProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'SvmAdminPassword': obj.svmAdminPassword,
        'ActiveDirectoryConfiguration': toJson_ActiveDirectoryConfiguration(obj.activeDirectoryConfiguration),
        'RootVolumeSecurityStyle': obj.rootVolumeSecurityStyle,
        'FileSystemId': obj.fileSystemId,
        'Tags': obj.tags?.map(y => toJson_Tag(y)),
        'Name': obj.name,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'ActiveDirectoryConfiguration' to JSON representation.
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_ActiveDirectoryConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'SelfManagedActiveDirectoryConfiguration': toJson_SelfManagedActiveDirectoryConfiguration(obj.selfManagedActiveDirectoryConfiguration),
        'NetBiosName': obj.netBiosName,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'Tag' to JSON representation.
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_Tag(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Value': obj.value,
        'Key': obj.key,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'SelfManagedActiveDirectoryConfiguration' to JSON representation.
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_SelfManagedActiveDirectoryConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'FileSystemAdministratorsGroup': obj.fileSystemAdministratorsGroup,
        'UserName': obj.userName,
        'DomainName': obj.domainName,
        'OrganizationalUnitDistinguishedName': obj.organizationalUnitDistinguishedName,
        'DomainJoinServiceAccountSecret': obj.domainJoinServiceAccountSecret,
        'DnsIps': obj.dnsIps?.map(y => y),
        'Password': obj.password,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/* eslint-enable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
/**
 * A CloudFormation `Dev::FSx::StorageVirtualMachine`
 *
 * @cloudformationResource Dev::FSx::StorageVirtualMachine
 * @stability external
 * @link http://unknown-url
 */
class CfnStorageVirtualMachine extends cdk.CfnResource {
    /**
     * Create a new `Dev::FSx::StorageVirtualMachine`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnStorageVirtualMachine.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnStorageVirtualMachineProps(props) });
        this.props = props;
        this.attrResourceARN = cdk.Token.asString(this.getAtt('ResourceARN'));
        this.attrUuid = cdk.Token.asString(this.getAtt('UUID'));
        this.attrStorageVirtualMachineId = cdk.Token.asString(this.getAtt('StorageVirtualMachineId'));
    }
}
exports.CfnStorageVirtualMachine = CfnStorageVirtualMachine;
_a = JSII_RTTI_SYMBOL_1;
CfnStorageVirtualMachine[_a] = { fqn: "@cdk-cloudformation/dev-fsx-storagevirtualmachine.CfnStorageVirtualMachine", version: "0.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnStorageVirtualMachine.CFN_RESOURCE_TYPE_NAME = "Dev::FSx::StorageVirtualMachine";
//# sourceMappingURL=data:application/json;base64,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