import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Resource Type definition for Dev::FSx::StorageVirtualMachine
 *
 * @schema CfnStorageVirtualMachineProps
 */
export interface CfnStorageVirtualMachineProps {
    /**
     * @schema CfnStorageVirtualMachineProps#SvmAdminPassword
     */
    readonly svmAdminPassword?: string;
    /**
     * @schema CfnStorageVirtualMachineProps#ActiveDirectoryConfiguration
     */
    readonly activeDirectoryConfiguration?: ActiveDirectoryConfiguration;
    /**
     * @schema CfnStorageVirtualMachineProps#RootVolumeSecurityStyle
     */
    readonly rootVolumeSecurityStyle?: string;
    /**
     * @schema CfnStorageVirtualMachineProps#FileSystemId
     */
    readonly fileSystemId: string;
    /**
     * @schema CfnStorageVirtualMachineProps#Tags
     */
    readonly tags?: Tag[];
    /**
     * @schema CfnStorageVirtualMachineProps#Name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'CfnStorageVirtualMachineProps' to JSON representation.
 */
export declare function toJson_CfnStorageVirtualMachineProps(obj: CfnStorageVirtualMachineProps | undefined): Record<string, any> | undefined;
/**
 * @schema ActiveDirectoryConfiguration
 */
export interface ActiveDirectoryConfiguration {
    /**
     * @schema ActiveDirectoryConfiguration#SelfManagedActiveDirectoryConfiguration
     */
    readonly selfManagedActiveDirectoryConfiguration?: SelfManagedActiveDirectoryConfiguration;
    /**
     * @schema ActiveDirectoryConfiguration#NetBiosName
     */
    readonly netBiosName?: string;
}
/**
 * Converts an object of type 'ActiveDirectoryConfiguration' to JSON representation.
 */
export declare function toJson_ActiveDirectoryConfiguration(obj: ActiveDirectoryConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema Tag
 */
export interface Tag {
    /**
     * @schema Tag#Value
     */
    readonly value: string;
    /**
     * @schema Tag#Key
     */
    readonly key: string;
}
/**
 * Converts an object of type 'Tag' to JSON representation.
 */
export declare function toJson_Tag(obj: Tag | undefined): Record<string, any> | undefined;
/**
 * @schema SelfManagedActiveDirectoryConfiguration
 */
export interface SelfManagedActiveDirectoryConfiguration {
    /**
     * @schema SelfManagedActiveDirectoryConfiguration#FileSystemAdministratorsGroup
     */
    readonly fileSystemAdministratorsGroup?: string;
    /**
     * @schema SelfManagedActiveDirectoryConfiguration#UserName
     */
    readonly userName?: string;
    /**
     * @schema SelfManagedActiveDirectoryConfiguration#DomainName
     */
    readonly domainName?: string;
    /**
     * @schema SelfManagedActiveDirectoryConfiguration#OrganizationalUnitDistinguishedName
     */
    readonly organizationalUnitDistinguishedName?: string;
    /**
     * @schema SelfManagedActiveDirectoryConfiguration#DomainJoinServiceAccountSecret
     */
    readonly domainJoinServiceAccountSecret?: string;
    /**
     * @schema SelfManagedActiveDirectoryConfiguration#DnsIps
     */
    readonly dnsIps?: string[];
    /**
     * @schema SelfManagedActiveDirectoryConfiguration#Password
     */
    readonly password?: string;
}
/**
 * Converts an object of type 'SelfManagedActiveDirectoryConfiguration' to JSON representation.
 */
export declare function toJson_SelfManagedActiveDirectoryConfiguration(obj: SelfManagedActiveDirectoryConfiguration | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Dev::FSx::StorageVirtualMachine`
 *
 * @cloudformationResource Dev::FSx::StorageVirtualMachine
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnStorageVirtualMachine extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Dev::FSx::StorageVirtualMachine";
    /**
     * Resource props.
     */
    readonly props: CfnStorageVirtualMachineProps;
    /**
     * Attribute `Dev::FSx::StorageVirtualMachine.ResourceARN`
     * @link http://unknown-url
     */
    readonly attrResourceARN: string;
    /**
     * Attribute `Dev::FSx::StorageVirtualMachine.UUID`
     * @link http://unknown-url
     */
    readonly attrUuid: string;
    /**
     * Attribute `Dev::FSx::StorageVirtualMachine.StorageVirtualMachineId`
     * @link http://unknown-url
     */
    readonly attrStorageVirtualMachineId: string;
    /**
     * Create a new `Dev::FSx::StorageVirtualMachine`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnStorageVirtualMachineProps);
}
