from __future__ import annotations

from collections.abc import Iterator, Iterable
from typing import overload

def angle(angle: float, /, unit: str) -> float: ...
def _iterable_to_complex(obj: Iterable[float], /) -> complex: ...

class Vector:
    __slots__ = ("_complex",)
    _complex: complex
    @overload
    def __init__(self, /, x: complex | Iterable[float]) -> None: ...
    @overload
    def __init__(self, /, x: float, y: float) -> None: ...
    @staticmethod
    def from_polar(r: float, theta: float) -> Vector: ...
    def dot(self, other: Vector, /) -> float: ...
    def perp_dot(self, other: Vector, /) -> float: ...
    def perp(self, /) -> Vector: ...
    def rotate(self, /, angle: float) -> Vector: ...
    def hat(self, /) -> Vector: ...
    def rec(self, /) -> tuple[float, float]: ...
    def pol(self, /) -> tuple[float, float]: ...
    @overload
    def round(self, /, ndigits: None = ...) -> tuple[int, int]: ...
    @overload
    def round(self, /, ndigits: int) -> tuple[float, float]: ...
    def __str__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def __len__(self, /) -> int: ...
    def __getitem__(self, key: int, /) -> float: ...
    def __iter__(self, /) -> Iterator[float]: ...
    def __reversed__(self, /) -> Iterator[float]: ...
    def __neg__(self, /) -> Vector: ...
    def __add__(self, other: Vector, /) -> Vector: ...
    def __sub__(self, other: Vector, /) -> Vector: ...
    def __mul__(self, value: float, /) -> Vector: ...
    def __truediv__(self, value: float, /) -> Vector: ...
    __rmul__ = __mul__
    def __abs__(self, /) -> float: ...
    @property
    def x(self) -> float: ...
    @property
    def y(self) -> float: ...
    @property
    def r(self) -> float: ...
    @property
    def theta(self) -> float: ...
