# Generated by Django 3.0.14 on 2021-10-27 08:30

import core.fields
import core.models
import datetime
import dirtyfields.dirtyfields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import invoice.mixins
import invoice.models
import jsonfallback.fields
import simple_history.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('core', '0015_missing_roles'),
    ]

    operations = [
        migrations.CreateModel(
            name='Bill',
            fields=[
                ('id', models.UUIDField(db_column='UUID', default=None, editable=False, primary_key=True, serialize=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('date_valid_from', core.fields.DateTimeField(db_column='DateValidFrom', default=datetime.datetime.now)),
                ('date_valid_to', core.fields.DateTimeField(blank=True, db_column='DateValidTo', null=True)),
                ('replacement_uuid', models.UUIDField(db_column='ReplacementUUID', null=True)),
                ('thirdparty_id', models.CharField(db_column='ThirdpartyId', max_length=255, null=True)),
                ('code_tp', models.CharField(db_column='CodeTp', max_length=255, null=True)),
                ('code', models.CharField(db_column='Code', max_length=255)),
                ('code_ext', models.CharField(db_column='CodeExt', max_length=255, null=True)),
                ('date_due', core.fields.DateField(db_column='DateDue', null=True)),
                ('date_payed', core.fields.DateField(db_column='DatePayed', null=True)),
                ('amount_discount', models.DecimalField(db_column='AmountDiscount', decimal_places=2, default=0.0, max_digits=18, null=True)),
                ('amount_net', models.DecimalField(db_column='AmountNet', decimal_places=2, default=0.0, max_digits=18)),
                ('amount_total', models.DecimalField(db_column='AmountTotal', decimal_places=2, default=0.0, max_digits=18)),
                ('tax_analysis', jsonfallback.fields.FallbackJSONField(db_column='TaxAnalysis', null=True)),
                ('status', models.SmallIntegerField(choices=[(0, 'draft'), (1, 'validated'), (2, 'payed'), (3, 'cancelled'), (4, 'deleted'), (5, 'suspended')], db_column='Status', default=0)),
                ('currency_tp_code', models.CharField(db_column='CurrencyTpCode', default=invoice.models.get_default_currency, max_length=255)),
                ('currency_code', models.CharField(db_column='CurrencyCode', default=invoice.models.get_default_currency, max_length=255)),
                ('note', models.TextField(blank=True, db_column='Note', null=True)),
                ('terms', models.TextField(blank=True, db_column='Terms', null=True)),
                ('payment_reference', models.CharField(db_column='PaymentReference', max_length=255, null=True)),
                ('subject_id', models.CharField(db_column='SubjectId', max_length=255, null=True)),
                ('date_bill', core.fields.DateField(db_column='DateBill', default=datetime.date.today, null=True)),
                ('subject_type', models.ForeignKey(db_column='SubjectType', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='subject_type_bill', to='contenttypes.ContentType')),
                ('thirdparty_type', models.ForeignKey(db_column='ThirdpartyType', null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='contenttypes.ContentType')),
                ('user_created', models.ForeignKey(db_column='UserCreatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='bill_user_created', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(db_column='UserUpdatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='bill_user_updated', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'tblBill',
                'managed': True,
            },
            bases=(invoice.mixins.GenericInvoiceQuerysetMixin, dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='BillEvent',
            fields=[
                ('id', models.UUIDField(db_column='UUID', default=None, editable=False, primary_key=True, serialize=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('message', models.CharField(db_column='Message', max_length=500, null=True)),
                ('event_type', models.SmallIntegerField(choices=[(0, 'message'), (1, 'status'), (2, 'warning'), (3, 'payment'), (4, 'payment_error')], db_column='Status', default=0)),
                ('bill', models.ForeignKey(db_column='BillId', on_delete=django.db.models.deletion.DO_NOTHING, related_name='events_bill', to='invoice.Bill')),
                ('user_created', models.ForeignKey(db_column='UserCreatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='billevent_user_created', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(db_column='UserUpdatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='billevent_user_updated', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'tblBillEvent',
                'managed': True,
            },
            bases=(invoice.mixins.GenericInvoiceQuerysetMixin, dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='BillItem',
            fields=[
                ('id', models.UUIDField(db_column='UUID', default=None, editable=False, primary_key=True, serialize=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('date_valid_from', core.fields.DateTimeField(db_column='DateValidFrom', default=datetime.datetime.now)),
                ('date_valid_to', core.fields.DateTimeField(blank=True, db_column='DateValidTo', null=True)),
                ('replacement_uuid', models.UUIDField(db_column='ReplacementUUID', null=True)),
                ('code', models.CharField(db_column='Code', max_length=255)),
                ('description', models.TextField(blank=True, db_column='Description', null=True)),
                ('details', jsonfallback.fields.FallbackJSONField(db_column='Details', null=True)),
                ('ledger_account', models.CharField(db_column='LedgerAccount', max_length=255, null=True)),
                ('quantity', models.IntegerField(db_column='Quantity', default=0.0)),
                ('unit_price', models.DecimalField(db_column='UnitPrice', decimal_places=2, default=0.0, max_digits=18)),
                ('discount', models.DecimalField(db_column='Discount', decimal_places=2, default=0.0, max_digits=18)),
                ('tax_rate', models.UUIDField(db_column='CalculationUUID', null=True)),
                ('tax_analysis', jsonfallback.fields.FallbackJSONField(db_column='TaxAnalysis', null=True)),
                ('amount_total', models.DecimalField(db_column='AmountTotal', decimal_places=2, max_digits=18, null=True)),
                ('amount_net', models.DecimalField(db_column='AmountNet', decimal_places=2, default=0.0, max_digits=18)),
                ('line_id', models.CharField(db_column='LineId', max_length=255, null=True)),
                ('bill', models.ForeignKey(db_column='BillId', on_delete=django.db.models.deletion.DO_NOTHING, related_name='line_items_bill', to='invoice.Bill')),
                ('line_type', models.ForeignKey(db_column='LineType', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='line_type_bill', to='contenttypes.ContentType')),
                ('user_created', models.ForeignKey(db_column='UserCreatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='billitem_user_created', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(db_column='UserUpdatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='billitem_user_updated', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'tblBillLineItem',
                'managed': True,
            },
            bases=(invoice.mixins.GenericInvoiceQuerysetMixin, dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='BillPayment',
            fields=[
                ('id', models.UUIDField(db_column='UUID', default=None, editable=False, primary_key=True, serialize=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('code_tp', models.CharField(db_column='CodeTp', max_length=255, null=True)),
                ('code_ext', models.CharField(db_column='CodeExt', max_length=255, null=True)),
                ('code_receipt', models.CharField(db_column='CodeReceipt', max_length=255, null=True)),
                ('label', models.CharField(db_column='Label', max_length=255, null=True)),
                ('status', models.SmallIntegerField(choices=[(0, 'rejected'), (1, 'accepted'), (2, 'refunded'), (3, 'cancelled')], db_column='Status')),
                ('amount_payed', models.DecimalField(db_column='AmountPayed', decimal_places=2, max_digits=18, null=True)),
                ('fees', models.DecimalField(db_column='Fees', decimal_places=2, max_digits=18, null=True)),
                ('amount_received', models.DecimalField(db_column='AmountReceived', decimal_places=2, max_digits=18, null=True)),
                ('date_payment', core.fields.DateField(db_column='DatePayment', null=True)),
                ('bill', models.ForeignKey(db_column='BillId', on_delete=django.db.models.deletion.DO_NOTHING, related_name='payments_bill', to='invoice.Bill')),
                ('user_created', models.ForeignKey(db_column='UserCreatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='billpayment_user_created', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(db_column='UserUpdatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='billpayment_user_updated', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'tblBillPayment',
                'managed': True,
            },
            bases=(invoice.mixins.GenericInvoiceQuerysetMixin, dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Invoice',
            fields=[
                ('id', models.UUIDField(db_column='UUID', default=None, editable=False, primary_key=True, serialize=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('date_valid_from', core.fields.DateTimeField(db_column='DateValidFrom', default=datetime.datetime.now)),
                ('date_valid_to', core.fields.DateTimeField(blank=True, db_column='DateValidTo', null=True)),
                ('replacement_uuid', models.UUIDField(db_column='ReplacementUUID', null=True)),
                ('thirdparty_id', models.CharField(db_column='ThirdpartyId', max_length=255, null=True)),
                ('code_tp', models.CharField(db_column='CodeTp', max_length=255, null=True)),
                ('code', models.CharField(db_column='Code', max_length=255)),
                ('code_ext', models.CharField(db_column='CodeExt', max_length=255, null=True)),
                ('date_due', core.fields.DateField(db_column='DateDue', null=True)),
                ('date_payed', core.fields.DateField(db_column='DatePayed', null=True)),
                ('amount_discount', models.DecimalField(db_column='AmountDiscount', decimal_places=2, default=0.0, max_digits=18, null=True)),
                ('amount_net', models.DecimalField(db_column='AmountNet', decimal_places=2, default=0.0, max_digits=18)),
                ('amount_total', models.DecimalField(db_column='AmountTotal', decimal_places=2, default=0.0, max_digits=18)),
                ('tax_analysis', jsonfallback.fields.FallbackJSONField(db_column='TaxAnalysis', null=True)),
                ('status', models.SmallIntegerField(choices=[(0, 'draft'), (1, 'validated'), (2, 'payed'), (3, 'cancelled'), (4, 'deleted'), (5, 'suspended')], db_column='Status', default=0)),
                ('currency_tp_code', models.CharField(db_column='CurrencyTpCode', default=invoice.models.get_default_currency, max_length=255)),
                ('currency_code', models.CharField(db_column='CurrencyCode', default=invoice.models.get_default_currency, max_length=255)),
                ('note', models.TextField(blank=True, db_column='Note', null=True)),
                ('terms', models.TextField(blank=True, db_column='Terms', null=True)),
                ('payment_reference', models.CharField(db_column='PaymentReference', max_length=255, null=True)),
                ('subject_id', models.CharField(db_column='SubjectId', max_length=255, null=True)),
                ('date_invoice', core.fields.DateField(db_column='DateInvoice', default=datetime.date.today, null=True)),
                ('subject_type', models.ForeignKey(db_column='SubjectType', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='subject_type', to='contenttypes.ContentType')),
                ('thirdparty_type', models.ForeignKey(db_column='ThirdpartyType', null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='contenttypes.ContentType')),
                ('user_created', models.ForeignKey(db_column='UserCreatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='invoice_user_created', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(db_column='UserUpdatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='invoice_user_updated', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'tblInvoice',
                'managed': True,
            },
            bases=(invoice.mixins.GenericInvoiceQuerysetMixin, dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='InvoiceEvent',
            fields=[
                ('id', models.UUIDField(db_column='UUID', default=None, editable=False, primary_key=True, serialize=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('message', models.CharField(db_column='Message', max_length=500, null=True)),
                ('event_type', models.SmallIntegerField(choices=[(0, 'message'), (1, 'status'), (2, 'warning'), (3, 'payment'), (4, 'payment_error')], db_column='Status', default=0)),
                ('invoice', models.ForeignKey(db_column='InvoiceId', on_delete=django.db.models.deletion.DO_NOTHING, related_name='events', to='invoice.Invoice')),
                ('user_created', models.ForeignKey(db_column='UserCreatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='invoiceevent_user_created', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(db_column='UserUpdatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='invoiceevent_user_updated', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'tblInvoiceEvent',
                'managed': True,
            },
            bases=(invoice.mixins.GenericInvoiceQuerysetMixin, dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='InvoiceLineItem',
            fields=[
                ('id', models.UUIDField(db_column='UUID', default=None, editable=False, primary_key=True, serialize=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('date_valid_from', core.fields.DateTimeField(db_column='DateValidFrom', default=datetime.datetime.now)),
                ('date_valid_to', core.fields.DateTimeField(blank=True, db_column='DateValidTo', null=True)),
                ('replacement_uuid', models.UUIDField(db_column='ReplacementUUID', null=True)),
                ('code', models.CharField(db_column='Code', max_length=255)),
                ('description', models.TextField(blank=True, db_column='Description', null=True)),
                ('details', jsonfallback.fields.FallbackJSONField(db_column='Details', null=True)),
                ('ledger_account', models.CharField(db_column='LedgerAccount', max_length=255, null=True)),
                ('quantity', models.IntegerField(db_column='Quantity', default=0.0)),
                ('unit_price', models.DecimalField(db_column='UnitPrice', decimal_places=2, default=0.0, max_digits=18)),
                ('discount', models.DecimalField(db_column='Discount', decimal_places=2, default=0.0, max_digits=18)),
                ('tax_rate', models.UUIDField(db_column='CalculationUUID', null=True)),
                ('tax_analysis', jsonfallback.fields.FallbackJSONField(db_column='TaxAnalysis', null=True)),
                ('amount_total', models.DecimalField(db_column='AmountTotal', decimal_places=2, max_digits=18, null=True)),
                ('amount_net', models.DecimalField(db_column='AmountNet', decimal_places=2, default=0.0, max_digits=18)),
                ('line_id', models.CharField(db_column='LineId', max_length=255, null=True)),
                ('invoice', models.ForeignKey(db_column='InvoiceId', on_delete=django.db.models.deletion.DO_NOTHING, related_name='line_items', to='invoice.Invoice')),
                ('line_type', models.ForeignKey(db_column='LineType', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='line_type', to='contenttypes.ContentType')),
                ('user_created', models.ForeignKey(db_column='UserCreatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='invoicelineitem_user_created', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(db_column='UserUpdatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='invoicelineitem_user_updated', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'tblInvoiceLineItem',
                'managed': True,
            },
            bases=(invoice.mixins.GenericInvoiceQuerysetMixin, dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='InvoicePayment',
            fields=[
                ('id', models.UUIDField(db_column='UUID', default=None, editable=False, primary_key=True, serialize=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('code_tp', models.CharField(db_column='CodeTp', max_length=255, null=True)),
                ('code_ext', models.CharField(db_column='CodeExt', max_length=255, null=True)),
                ('code_receipt', models.CharField(db_column='CodeReceipt', max_length=255, null=True)),
                ('label', models.CharField(db_column='Label', max_length=255, null=True)),
                ('status', models.SmallIntegerField(choices=[(0, 'rejected'), (1, 'accepted'), (2, 'refunded'), (3, 'cancelled')], db_column='Status')),
                ('amount_payed', models.DecimalField(db_column='AmountPayed', decimal_places=2, max_digits=18, null=True)),
                ('fees', models.DecimalField(db_column='Fees', decimal_places=2, max_digits=18, null=True)),
                ('amount_received', models.DecimalField(db_column='AmountReceived', decimal_places=2, max_digits=18, null=True)),
                ('date_payment', core.fields.DateField(db_column='DatePayment', null=True)),
                ('invoice', models.ForeignKey(db_column='InvoiceId', on_delete=django.db.models.deletion.DO_NOTHING, related_name='payments', to='invoice.Invoice')),
                ('user_created', models.ForeignKey(db_column='UserCreatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='invoicepayment_user_created', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(db_column='UserUpdatedUUID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='invoicepayment_user_updated', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'tblInvoicePayment',
                'managed': True,
            },
            bases=(invoice.mixins.GenericInvoiceQuerysetMixin, dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='InvoicePaymentMutation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('invoice_payment', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='mutations', to='invoice.InvoicePayment')),
                ('mutation', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='invoice_payments', to='core.MutationLog')),
            ],
            options={
                'db_table': 'invoice_InvoicePaymentMutation',
                'managed': True,
            },
            bases=(models.Model, core.models.ObjectMutation),
        ),
        migrations.CreateModel(
            name='InvoiceMutation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('invoice', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='mutations', to='invoice.Invoice')),
                ('mutation', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='invoices', to='core.MutationLog')),
            ],
            options={
                'db_table': 'invoice_invoiceMutation',
                'managed': True,
            },
            bases=(models.Model, core.models.ObjectMutation),
        ),
        migrations.CreateModel(
            name='InvoiceLineItemMutation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('invoice_line_items', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='mutations', to='invoice.InvoiceLineItem')),
                ('mutation', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='invoice_line_items', to='core.MutationLog')),
            ],
            options={
                'db_table': 'invoice_InvoiceLineItemsMutation',
                'managed': True,
            },
            bases=(models.Model, core.models.ObjectMutation),
        ),
        migrations.CreateModel(
            name='InvoiceEventMutation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('invoice_event', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='mutations', to='invoice.InvoiceEvent')),
                ('mutation', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='event_messages', to='core.MutationLog')),
            ],
            options={
                'db_table': 'invoice_InvoiceEventMutation',
                'managed': True,
            },
            bases=(models.Model, core.models.ObjectMutation),
        ),
        migrations.CreateModel(
            name='HistoricalInvoicePayment',
            fields=[
                ('id', models.UUIDField(db_column='UUID', db_index=True, default=None, editable=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('code_tp', models.CharField(db_column='CodeTp', max_length=255, null=True)),
                ('code_ext', models.CharField(db_column='CodeExt', max_length=255, null=True)),
                ('code_receipt', models.CharField(db_column='CodeReceipt', max_length=255, null=True)),
                ('label', models.CharField(db_column='Label', max_length=255, null=True)),
                ('status', models.SmallIntegerField(choices=[(0, 'rejected'), (1, 'accepted'), (2, 'refunded'), (3, 'cancelled')], db_column='Status')),
                ('amount_payed', models.DecimalField(db_column='AmountPayed', decimal_places=2, max_digits=18, null=True)),
                ('fees', models.DecimalField(db_column='Fees', decimal_places=2, max_digits=18, null=True)),
                ('amount_received', models.DecimalField(db_column='AmountReceived', decimal_places=2, max_digits=18, null=True)),
                ('date_payment', core.fields.DateField(db_column='DatePayment', null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('invoice', models.ForeignKey(blank=True, db_column='InvoiceId', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='invoice.Invoice')),
                ('user_created', models.ForeignKey(blank=True, db_column='UserCreatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(blank=True, db_column='UserUpdatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical invoice payment',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalInvoiceLineItem',
            fields=[
                ('id', models.UUIDField(db_column='UUID', db_index=True, default=None, editable=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('date_valid_from', core.fields.DateTimeField(db_column='DateValidFrom', default=datetime.datetime.now)),
                ('date_valid_to', core.fields.DateTimeField(blank=True, db_column='DateValidTo', null=True)),
                ('replacement_uuid', models.UUIDField(db_column='ReplacementUUID', null=True)),
                ('code', models.CharField(db_column='Code', max_length=255)),
                ('description', models.TextField(blank=True, db_column='Description', null=True)),
                ('details', jsonfallback.fields.FallbackJSONField(db_column='Details', null=True)),
                ('ledger_account', models.CharField(db_column='LedgerAccount', max_length=255, null=True)),
                ('quantity', models.IntegerField(db_column='Quantity', default=0.0)),
                ('unit_price', models.DecimalField(db_column='UnitPrice', decimal_places=2, default=0.0, max_digits=18)),
                ('discount', models.DecimalField(db_column='Discount', decimal_places=2, default=0.0, max_digits=18)),
                ('tax_rate', models.UUIDField(db_column='CalculationUUID', null=True)),
                ('tax_analysis', jsonfallback.fields.FallbackJSONField(db_column='TaxAnalysis', null=True)),
                ('amount_total', models.DecimalField(db_column='AmountTotal', decimal_places=2, max_digits=18, null=True)),
                ('amount_net', models.DecimalField(db_column='AmountNet', decimal_places=2, default=0.0, max_digits=18)),
                ('line_id', models.CharField(db_column='LineId', max_length=255, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('invoice', models.ForeignKey(blank=True, db_column='InvoiceId', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='invoice.Invoice')),
                ('line_type', models.ForeignKey(blank=True, db_column='LineType', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='contenttypes.ContentType')),
                ('user_created', models.ForeignKey(blank=True, db_column='UserCreatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(blank=True, db_column='UserUpdatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical invoice line item',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalInvoiceEvent',
            fields=[
                ('id', models.UUIDField(db_column='UUID', db_index=True, default=None, editable=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('message', models.CharField(db_column='Message', max_length=500, null=True)),
                ('event_type', models.SmallIntegerField(choices=[(0, 'message'), (1, 'status'), (2, 'warning'), (3, 'payment'), (4, 'payment_error')], db_column='Status', default=0)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('invoice', models.ForeignKey(blank=True, db_column='InvoiceId', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='invoice.Invoice')),
                ('user_created', models.ForeignKey(blank=True, db_column='UserCreatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(blank=True, db_column='UserUpdatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical invoice event',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalInvoice',
            fields=[
                ('id', models.UUIDField(db_column='UUID', db_index=True, default=None, editable=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('date_valid_from', core.fields.DateTimeField(db_column='DateValidFrom', default=datetime.datetime.now)),
                ('date_valid_to', core.fields.DateTimeField(blank=True, db_column='DateValidTo', null=True)),
                ('replacement_uuid', models.UUIDField(db_column='ReplacementUUID', null=True)),
                ('thirdparty_id', models.CharField(db_column='ThirdpartyId', max_length=255, null=True)),
                ('code_tp', models.CharField(db_column='CodeTp', max_length=255, null=True)),
                ('code', models.CharField(db_column='Code', max_length=255)),
                ('code_ext', models.CharField(db_column='CodeExt', max_length=255, null=True)),
                ('date_due', core.fields.DateField(db_column='DateDue', null=True)),
                ('date_payed', core.fields.DateField(db_column='DatePayed', null=True)),
                ('amount_discount', models.DecimalField(db_column='AmountDiscount', decimal_places=2, default=0.0, max_digits=18, null=True)),
                ('amount_net', models.DecimalField(db_column='AmountNet', decimal_places=2, default=0.0, max_digits=18)),
                ('amount_total', models.DecimalField(db_column='AmountTotal', decimal_places=2, default=0.0, max_digits=18)),
                ('tax_analysis', jsonfallback.fields.FallbackJSONField(db_column='TaxAnalysis', null=True)),
                ('status', models.SmallIntegerField(choices=[(0, 'draft'), (1, 'validated'), (2, 'payed'), (3, 'cancelled'), (4, 'deleted'), (5, 'suspended')], db_column='Status', default=0)),
                ('currency_tp_code', models.CharField(db_column='CurrencyTpCode', default=invoice.models.get_default_currency, max_length=255)),
                ('currency_code', models.CharField(db_column='CurrencyCode', default=invoice.models.get_default_currency, max_length=255)),
                ('note', models.TextField(blank=True, db_column='Note', null=True)),
                ('terms', models.TextField(blank=True, db_column='Terms', null=True)),
                ('payment_reference', models.CharField(db_column='PaymentReference', max_length=255, null=True)),
                ('subject_id', models.CharField(db_column='SubjectId', max_length=255, null=True)),
                ('date_invoice', core.fields.DateField(db_column='DateInvoice', default=datetime.date.today, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('subject_type', models.ForeignKey(blank=True, db_column='SubjectType', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='contenttypes.ContentType')),
                ('thirdparty_type', models.ForeignKey(blank=True, db_column='ThirdpartyType', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='contenttypes.ContentType')),
                ('user_created', models.ForeignKey(blank=True, db_column='UserCreatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(blank=True, db_column='UserUpdatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical invoice',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalBillPayment',
            fields=[
                ('id', models.UUIDField(db_column='UUID', db_index=True, default=None, editable=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('code_tp', models.CharField(db_column='CodeTp', max_length=255, null=True)),
                ('code_ext', models.CharField(db_column='CodeExt', max_length=255, null=True)),
                ('code_receipt', models.CharField(db_column='CodeReceipt', max_length=255, null=True)),
                ('label', models.CharField(db_column='Label', max_length=255, null=True)),
                ('status', models.SmallIntegerField(choices=[(0, 'rejected'), (1, 'accepted'), (2, 'refunded'), (3, 'cancelled')], db_column='Status')),
                ('amount_payed', models.DecimalField(db_column='AmountPayed', decimal_places=2, max_digits=18, null=True)),
                ('fees', models.DecimalField(db_column='Fees', decimal_places=2, max_digits=18, null=True)),
                ('amount_received', models.DecimalField(db_column='AmountReceived', decimal_places=2, max_digits=18, null=True)),
                ('date_payment', core.fields.DateField(db_column='DatePayment', null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('bill', models.ForeignKey(blank=True, db_column='BillId', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='invoice.Bill')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user_created', models.ForeignKey(blank=True, db_column='UserCreatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(blank=True, db_column='UserUpdatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical bill payment',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalBillItem',
            fields=[
                ('id', models.UUIDField(db_column='UUID', db_index=True, default=None, editable=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('date_valid_from', core.fields.DateTimeField(db_column='DateValidFrom', default=datetime.datetime.now)),
                ('date_valid_to', core.fields.DateTimeField(blank=True, db_column='DateValidTo', null=True)),
                ('replacement_uuid', models.UUIDField(db_column='ReplacementUUID', null=True)),
                ('code', models.CharField(db_column='Code', max_length=255)),
                ('description', models.TextField(blank=True, db_column='Description', null=True)),
                ('details', jsonfallback.fields.FallbackJSONField(db_column='Details', null=True)),
                ('ledger_account', models.CharField(db_column='LedgerAccount', max_length=255, null=True)),
                ('quantity', models.IntegerField(db_column='Quantity', default=0.0)),
                ('unit_price', models.DecimalField(db_column='UnitPrice', decimal_places=2, default=0.0, max_digits=18)),
                ('discount', models.DecimalField(db_column='Discount', decimal_places=2, default=0.0, max_digits=18)),
                ('tax_rate', models.UUIDField(db_column='CalculationUUID', null=True)),
                ('tax_analysis', jsonfallback.fields.FallbackJSONField(db_column='TaxAnalysis', null=True)),
                ('amount_total', models.DecimalField(db_column='AmountTotal', decimal_places=2, max_digits=18, null=True)),
                ('amount_net', models.DecimalField(db_column='AmountNet', decimal_places=2, default=0.0, max_digits=18)),
                ('line_id', models.CharField(db_column='LineId', max_length=255, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('bill', models.ForeignKey(blank=True, db_column='BillId', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='invoice.Bill')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('line_type', models.ForeignKey(blank=True, db_column='LineType', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='contenttypes.ContentType')),
                ('user_created', models.ForeignKey(blank=True, db_column='UserCreatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(blank=True, db_column='UserUpdatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical bill item',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalBillEvent',
            fields=[
                ('id', models.UUIDField(db_column='UUID', db_index=True, default=None, editable=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('message', models.CharField(db_column='Message', max_length=500, null=True)),
                ('event_type', models.SmallIntegerField(choices=[(0, 'message'), (1, 'status'), (2, 'warning'), (3, 'payment'), (4, 'payment_error')], db_column='Status', default=0)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('bill', models.ForeignKey(blank=True, db_column='BillId', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='invoice.Bill')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user_created', models.ForeignKey(blank=True, db_column='UserCreatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(blank=True, db_column='UserUpdatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical bill event',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalBill',
            fields=[
                ('id', models.UUIDField(db_column='UUID', db_index=True, default=None, editable=False)),
                ('is_deleted', models.BooleanField(db_column='isDeleted', default=False)),
                ('json_ext', jsonfallback.fields.FallbackJSONField(blank=True, db_column='Json_ext', null=True)),
                ('date_created', core.fields.DateTimeField(db_column='DateCreated', null=True)),
                ('date_updated', core.fields.DateTimeField(db_column='DateUpdated', null=True)),
                ('version', models.IntegerField(default=1)),
                ('date_valid_from', core.fields.DateTimeField(db_column='DateValidFrom', default=datetime.datetime.now)),
                ('date_valid_to', core.fields.DateTimeField(blank=True, db_column='DateValidTo', null=True)),
                ('replacement_uuid', models.UUIDField(db_column='ReplacementUUID', null=True)),
                ('thirdparty_id', models.CharField(db_column='ThirdpartyId', max_length=255, null=True)),
                ('code_tp', models.CharField(db_column='CodeTp', max_length=255, null=True)),
                ('code', models.CharField(db_column='Code', max_length=255)),
                ('code_ext', models.CharField(db_column='CodeExt', max_length=255, null=True)),
                ('date_due', core.fields.DateField(db_column='DateDue', null=True)),
                ('date_payed', core.fields.DateField(db_column='DatePayed', null=True)),
                ('amount_discount', models.DecimalField(db_column='AmountDiscount', decimal_places=2, default=0.0, max_digits=18, null=True)),
                ('amount_net', models.DecimalField(db_column='AmountNet', decimal_places=2, default=0.0, max_digits=18)),
                ('amount_total', models.DecimalField(db_column='AmountTotal', decimal_places=2, default=0.0, max_digits=18)),
                ('tax_analysis', jsonfallback.fields.FallbackJSONField(db_column='TaxAnalysis', null=True)),
                ('status', models.SmallIntegerField(choices=[(0, 'draft'), (1, 'validated'), (2, 'payed'), (3, 'cancelled'), (4, 'deleted'), (5, 'suspended')], db_column='Status', default=0)),
                ('currency_tp_code', models.CharField(db_column='CurrencyTpCode', default=invoice.models.get_default_currency, max_length=255)),
                ('currency_code', models.CharField(db_column='CurrencyCode', default=invoice.models.get_default_currency, max_length=255)),
                ('note', models.TextField(blank=True, db_column='Note', null=True)),
                ('terms', models.TextField(blank=True, db_column='Terms', null=True)),
                ('payment_reference', models.CharField(db_column='PaymentReference', max_length=255, null=True)),
                ('subject_id', models.CharField(db_column='SubjectId', max_length=255, null=True)),
                ('date_bill', core.fields.DateField(db_column='DateBill', default=datetime.date.today, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('subject_type', models.ForeignKey(blank=True, db_column='SubjectType', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='contenttypes.ContentType')),
                ('thirdparty_type', models.ForeignKey(blank=True, db_column='ThirdpartyType', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='contenttypes.ContentType')),
                ('user_created', models.ForeignKey(blank=True, db_column='UserCreatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user_updated', models.ForeignKey(blank=True, db_column='UserUpdatedUUID', db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical bill',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='BillPaymentMutation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('bill_payment', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='mutations', to='invoice.BillPayment')),
                ('mutation', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='bill_payments', to='core.MutationLog')),
            ],
            options={
                'db_table': 'bill_BillPaymentMutation',
                'managed': True,
            },
            bases=(models.Model, core.models.ObjectMutation),
        ),
        migrations.CreateModel(
            name='BillMutation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('bill', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='mutations', to='invoice.Bill')),
                ('mutation', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='bills', to='core.MutationLog')),
            ],
            options={
                'db_table': 'bill_BillMutation',
                'managed': True,
            },
            bases=(models.Model, core.models.ObjectMutation),
        ),
        migrations.CreateModel(
            name='BillItemMutation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('bile_items', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='mutations', to='invoice.BillItem')),
                ('mutation', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='bill_line_items', to='core.MutationLog')),
            ],
            options={
                'db_table': 'bill_BillLineItemsMutation',
                'managed': True,
            },
            bases=(models.Model, core.models.ObjectMutation),
        ),
        migrations.CreateModel(
            name='BillEventMutation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('bill_event', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='mutations', to='invoice.BillEvent')),
                ('mutation', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='bill_event_messages', to='core.MutationLog')),
            ],
            options={
                'db_table': 'bill_BillEventMutation',
                'managed': True,
            },
            bases=(models.Model, core.models.ObjectMutation),
        ),
    ]
