import json
import logging
import os

from pigar.core import parse_packages

from .base_handler import BaseHandler

logger = logging.getLogger('EnvironmentHandler')
logger.setLevel(logging.DEBUG)


BASE_STRING = """# Autogenerated by Cloud-Cells, please adjust.
channels:
  - conda-forge
"""

def determine_packages(dir=os.getcwd()):
    libs, guess = parse_packages(dir)
    determined = [(key, libs[key].version) for key in libs.keys()]
    determined.extend([(key, None) for key in guess.keys()])

    return determined


def write_requirements(packages):
    if len(packages) == 0:
        return ""

    requirements = "dependencies:\n"
    requirements += "  - pip:\n"

    for lib, version in packages:
        if version:
            requirements += f"    - {lib}=={version}\n"
        else:
            requirements += f"    - {lib}\n"

    return requirements



class EnvironmentHandler(BaseHandler):
    def get(self, path):
        logger.info('path: '+path)
        self.finish(json.dumps({'data': BASE_STRING}))
