# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._microsoft_service_linker_enums import *


class AuthInfoBase(msrest.serialization.Model):
    """The authentication info.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SecretAuthInfo, ServicePrincipalCertificateAuthInfo, ServicePrincipalSecretAuthInfo, SystemAssignedIdentityAuthInfo, UserAssignedIdentityAuthInfo.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. The authentication type.Constant filled by server. Possible values
     include: "systemAssignedIdentity", "userAssignedIdentity", "servicePrincipalSecret",
     "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~microsoft_service_linker.models.AuthType
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
    }

    _subtype_map = {
        'auth_type': {'secret': 'SecretAuthInfo', 'servicePrincipalCertificate': 'ServicePrincipalCertificateAuthInfo', 'servicePrincipalSecret': 'ServicePrincipalSecretAuthInfo', 'systemAssignedIdentity': 'SystemAssignedIdentityAuthInfo', 'userAssignedIdentity': 'UserAssignedIdentityAuthInfo'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AuthInfoBase, self).__init__(**kwargs)
        self.auth_type = None  # type: Optional[str]


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~microsoft_service_linker.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~microsoft_service_linker.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~microsoft_service_linker.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~microsoft_service_linker.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class LinkerList(msrest.serialization.Model):
    """The list of Linker.

    :ivar next_link: The link used to get the next page of Linker list.
    :vartype next_link: str
    :ivar value: The list of Linkers.
    :vartype value: list[~microsoft_service_linker.models.LinkerResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[LinkerResource]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["LinkerResource"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link used to get the next page of Linker list.
        :paramtype next_link: str
        :keyword value: The list of Linkers.
        :paramtype value: list[~microsoft_service_linker.models.LinkerResource]
        """
        super(LinkerList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class LinkerPatch(msrest.serialization.Model):
    """A linker to be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_id: The resource Id of target service.
    :vartype target_id: str
    :ivar auth_info: The authentication type.
    :vartype auth_info: ~microsoft_service_linker.models.AuthInfoBase
    :ivar client_type: The application client type. Possible values include: "none", "dotnet",
     "java", "python", "go", "php", "ruby", "django", "nodejs", "springBoot".
    :vartype client_type: str or ~microsoft_service_linker.models.ClientType
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar v_net_solution: The VNet solution.
    :vartype v_net_solution: ~microsoft_service_linker.models.VNetSolution
    :ivar secret_store: An option to store secret value in secure place.
    :vartype secret_store: ~microsoft_service_linker.models.SecretStore
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'target_id': {'key': 'properties.targetId', 'type': 'str'},
        'auth_info': {'key': 'properties.authInfo', 'type': 'AuthInfoBase'},
        'client_type': {'key': 'properties.clientType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'v_net_solution': {'key': 'properties.vNetSolution', 'type': 'VNetSolution'},
        'secret_store': {'key': 'properties.secretStore', 'type': 'SecretStore'},
    }

    def __init__(
        self,
        *,
        target_id: Optional[str] = None,
        auth_info: Optional["AuthInfoBase"] = None,
        client_type: Optional[Union[str, "ClientType"]] = None,
        v_net_solution: Optional["VNetSolution"] = None,
        secret_store: Optional["SecretStore"] = None,
        **kwargs
    ):
        """
        :keyword target_id: The resource Id of target service.
        :paramtype target_id: str
        :keyword auth_info: The authentication type.
        :paramtype auth_info: ~microsoft_service_linker.models.AuthInfoBase
        :keyword client_type: The application client type. Possible values include: "none", "dotnet",
         "java", "python", "go", "php", "ruby", "django", "nodejs", "springBoot".
        :paramtype client_type: str or ~microsoft_service_linker.models.ClientType
        :keyword v_net_solution: The VNet solution.
        :paramtype v_net_solution: ~microsoft_service_linker.models.VNetSolution
        :keyword secret_store: An option to store secret value in secure place.
        :paramtype secret_store: ~microsoft_service_linker.models.SecretStore
        """
        super(LinkerPatch, self).__init__(**kwargs)
        self.target_id = target_id
        self.auth_info = auth_info
        self.client_type = client_type
        self.provisioning_state = None
        self.v_net_solution = v_net_solution
        self.secret_store = secret_store


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)


class LinkerResource(ProxyResource):
    """Linker of source and target resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system data.
    :vartype system_data: ~microsoft_service_linker.models.SystemData
    :ivar target_id: The resource Id of target service.
    :vartype target_id: str
    :ivar auth_info: The authentication type.
    :vartype auth_info: ~microsoft_service_linker.models.AuthInfoBase
    :ivar client_type: The application client type. Possible values include: "none", "dotnet",
     "java", "python", "go", "php", "ruby", "django", "nodejs", "springBoot".
    :vartype client_type: str or ~microsoft_service_linker.models.ClientType
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar v_net_solution: The VNet solution.
    :vartype v_net_solution: ~microsoft_service_linker.models.VNetSolution
    :ivar secret_store: An option to store secret value in secure place.
    :vartype secret_store: ~microsoft_service_linker.models.SecretStore
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'target_id': {'key': 'properties.targetId', 'type': 'str'},
        'auth_info': {'key': 'properties.authInfo', 'type': 'AuthInfoBase'},
        'client_type': {'key': 'properties.clientType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'v_net_solution': {'key': 'properties.vNetSolution', 'type': 'VNetSolution'},
        'secret_store': {'key': 'properties.secretStore', 'type': 'SecretStore'},
    }

    def __init__(
        self,
        *,
        target_id: Optional[str] = None,
        auth_info: Optional["AuthInfoBase"] = None,
        client_type: Optional[Union[str, "ClientType"]] = None,
        v_net_solution: Optional["VNetSolution"] = None,
        secret_store: Optional["SecretStore"] = None,
        **kwargs
    ):
        """
        :keyword target_id: The resource Id of target service.
        :paramtype target_id: str
        :keyword auth_info: The authentication type.
        :paramtype auth_info: ~microsoft_service_linker.models.AuthInfoBase
        :keyword client_type: The application client type. Possible values include: "none", "dotnet",
         "java", "python", "go", "php", "ruby", "django", "nodejs", "springBoot".
        :paramtype client_type: str or ~microsoft_service_linker.models.ClientType
        :keyword v_net_solution: The VNet solution.
        :paramtype v_net_solution: ~microsoft_service_linker.models.VNetSolution
        :keyword secret_store: An option to store secret value in secure place.
        :paramtype secret_store: ~microsoft_service_linker.models.SecretStore
        """
        super(LinkerResource, self).__init__(**kwargs)
        self.system_data = None
        self.target_id = target_id
        self.auth_info = auth_info
        self.client_type = client_type
        self.provisioning_state = None
        self.v_net_solution = v_net_solution
        self.secret_store = secret_store


class Operation(msrest.serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~microsoft_service_linker.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Possible values include: "user",
     "system", "user,system".
    :vartype origin: str or ~microsoft_service_linker.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Possible values include: "Internal".
    :vartype action_type: str or ~microsoft_service_linker.models.ActionType
    """

    _validation = {
        'name': {'readonly': True},
        'is_data_action': {'readonly': True},
        'origin': {'readonly': True},
        'action_type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~microsoft_service_linker.models.OperationDisplay
        """
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(msrest.serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~microsoft_service_linker.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecretAuthInfo(AuthInfoBase):
    """The authentication info when authType is secret.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. The authentication type.Constant filled by server. Possible values
     include: "systemAssignedIdentity", "userAssignedIdentity", "servicePrincipalSecret",
     "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~microsoft_service_linker.models.AuthType
    :ivar name: Username or account name for secret auth.
    :vartype name: str
    :ivar secret: Password or account key for secret auth.
    :vartype secret: str
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Username or account name for secret auth.
        :paramtype name: str
        :keyword secret: Password or account key for secret auth.
        :paramtype secret: str
        """
        super(SecretAuthInfo, self).__init__(**kwargs)
        self.auth_type = 'secret'  # type: str
        self.name = name
        self.secret = secret


class SecretStore(msrest.serialization.Model):
    """An option to store secret value in secure place.

    :ivar key_vault_id: The key vault id to store secret.
    :vartype key_vault_id: str
    """

    _attribute_map = {
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_vault_id: The key vault id to store secret.
        :paramtype key_vault_id: str
        """
        super(SecretStore, self).__init__(**kwargs)
        self.key_vault_id = key_vault_id


class ServicePrincipalCertificateAuthInfo(AuthInfoBase):
    """The authentication info when authType is servicePrincipal certificate.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. The authentication type.Constant filled by server. Possible values
     include: "systemAssignedIdentity", "userAssignedIdentity", "servicePrincipalSecret",
     "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~microsoft_service_linker.models.AuthType
    :ivar client_id: Required. Application clientId for servicePrincipal auth.
    :vartype client_id: str
    :ivar principal_id: Required. Principal Id for servicePrincipal auth.
    :vartype principal_id: str
    :ivar certificate: Required. ServicePrincipal certificate for servicePrincipal auth.
    :vartype certificate: str
    """

    _validation = {
        'auth_type': {'required': True},
        'client_id': {'required': True},
        'principal_id': {'required': True},
        'certificate': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        principal_id: str,
        certificate: str,
        **kwargs
    ):
        """
        :keyword client_id: Required. Application clientId for servicePrincipal auth.
        :paramtype client_id: str
        :keyword principal_id: Required. Principal Id for servicePrincipal auth.
        :paramtype principal_id: str
        :keyword certificate: Required. ServicePrincipal certificate for servicePrincipal auth.
        :paramtype certificate: str
        """
        super(ServicePrincipalCertificateAuthInfo, self).__init__(**kwargs)
        self.auth_type = 'servicePrincipalCertificate'  # type: str
        self.client_id = client_id
        self.principal_id = principal_id
        self.certificate = certificate


class ServicePrincipalSecretAuthInfo(AuthInfoBase):
    """The authentication info when authType is servicePrincipal secret.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. The authentication type.Constant filled by server. Possible values
     include: "systemAssignedIdentity", "userAssignedIdentity", "servicePrincipalSecret",
     "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~microsoft_service_linker.models.AuthType
    :ivar client_id: Required. ServicePrincipal application clientId for servicePrincipal auth.
    :vartype client_id: str
    :ivar principal_id: Required. Principal Id for servicePrincipal auth.
    :vartype principal_id: str
    :ivar secret: Required. Secret for servicePrincipal auth.
    :vartype secret: str
    """

    _validation = {
        'auth_type': {'required': True},
        'client_id': {'required': True},
        'principal_id': {'required': True},
        'secret': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        principal_id: str,
        secret: str,
        **kwargs
    ):
        """
        :keyword client_id: Required. ServicePrincipal application clientId for servicePrincipal auth.
        :paramtype client_id: str
        :keyword principal_id: Required. Principal Id for servicePrincipal auth.
        :paramtype principal_id: str
        :keyword secret: Required. Secret for servicePrincipal auth.
        :paramtype secret: str
        """
        super(ServicePrincipalSecretAuthInfo, self).__init__(**kwargs)
        self.auth_type = 'servicePrincipalSecret'  # type: str
        self.client_id = client_id
        self.principal_id = principal_id
        self.secret = secret


class SourceConfiguration(msrest.serialization.Model):
    """A configuration item for source resource.

    :ivar name: The name of setting.
    :vartype name: str
    :ivar value: The value of setting.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of setting.
        :paramtype name: str
        :keyword value: The value of setting.
        :paramtype value: str
        """
        super(SourceConfiguration, self).__init__(**kwargs)
        self.name = name
        self.value = value


class SourceConfigurationResult(msrest.serialization.Model):
    """Configurations for source resource, include appSettings, connectionString and serviceBindings.

    :ivar configurations: The configuration properties for source resource.
    :vartype configurations: list[~microsoft_service_linker.models.SourceConfiguration]
    """

    _attribute_map = {
        'configurations': {'key': 'configurations', 'type': '[SourceConfiguration]'},
    }

    def __init__(
        self,
        *,
        configurations: Optional[List["SourceConfiguration"]] = None,
        **kwargs
    ):
        """
        :keyword configurations: The configuration properties for source resource.
        :paramtype configurations: list[~microsoft_service_linker.models.SourceConfiguration]
        """
        super(SourceConfigurationResult, self).__init__(**kwargs)
        self.configurations = configurations


class SystemAssignedIdentityAuthInfo(AuthInfoBase):
    """The authentication info when authType is systemAssignedIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. The authentication type.Constant filled by server. Possible values
     include: "systemAssignedIdentity", "userAssignedIdentity", "servicePrincipalSecret",
     "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~microsoft_service_linker.models.AuthType
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SystemAssignedIdentityAuthInfo, self).__init__(**kwargs)
        self.auth_type = 'systemAssignedIdentity'  # type: str


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~microsoft_service_linker.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~microsoft_service_linker.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~microsoft_service_linker.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~microsoft_service_linker.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentityAuthInfo(AuthInfoBase):
    """The authentication info when authType is userAssignedIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. The authentication type.Constant filled by server. Possible values
     include: "systemAssignedIdentity", "userAssignedIdentity", "servicePrincipalSecret",
     "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~microsoft_service_linker.models.AuthType
    :ivar client_id: Required. Client Id for userAssignedIdentity.
    :vartype client_id: str
    :ivar subscription_id: Required. Subscription id for userAssignedIdentity.
    :vartype subscription_id: str
    """

    _validation = {
        'auth_type': {'required': True},
        'client_id': {'required': True},
        'subscription_id': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        subscription_id: str,
        **kwargs
    ):
        """
        :keyword client_id: Required. Client Id for userAssignedIdentity.
        :paramtype client_id: str
        :keyword subscription_id: Required. Subscription id for userAssignedIdentity.
        :paramtype subscription_id: str
        """
        super(UserAssignedIdentityAuthInfo, self).__init__(**kwargs)
        self.auth_type = 'userAssignedIdentity'  # type: str
        self.client_id = client_id
        self.subscription_id = subscription_id


class ValidateResult(msrest.serialization.Model):
    """The validation result for a linker.

    :ivar name: The linker name.
    :vartype name: str
    :ivar linker_status: Specifies if the linker is healthy. Possible values include: "Healthy",
     "Not healthy".
    :vartype linker_status: str or ~microsoft_service_linker.models.LinkerStatus
    :ivar reason: The reason of the error.
    :vartype reason: str
    :ivar report_start_time_utc: The start time of the validation report.
    :vartype report_start_time_utc: ~datetime.datetime
    :ivar report_end_time_utc: The end time of the validation report.
    :vartype report_end_time_utc: ~datetime.datetime
    :ivar target_id: The resource Id of target service.
    :vartype target_id: str
    :ivar auth_type: The authentication type. Possible values include: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~microsoft_service_linker.models.AuthType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'linker_status': {'key': 'linkerStatus', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
        'report_start_time_utc': {'key': 'reportStartTimeUtc', 'type': 'iso-8601'},
        'report_end_time_utc': {'key': 'reportEndTimeUtc', 'type': 'iso-8601'},
        'target_id': {'key': 'targetId', 'type': 'str'},
        'auth_type': {'key': 'authType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        linker_status: Optional[Union[str, "LinkerStatus"]] = None,
        reason: Optional[str] = None,
        report_start_time_utc: Optional[datetime.datetime] = None,
        report_end_time_utc: Optional[datetime.datetime] = None,
        target_id: Optional[str] = None,
        auth_type: Optional[Union[str, "AuthType"]] = None,
        **kwargs
    ):
        """
        :keyword name: The linker name.
        :paramtype name: str
        :keyword linker_status: Specifies if the linker is healthy. Possible values include: "Healthy",
         "Not healthy".
        :paramtype linker_status: str or ~microsoft_service_linker.models.LinkerStatus
        :keyword reason: The reason of the error.
        :paramtype reason: str
        :keyword report_start_time_utc: The start time of the validation report.
        :paramtype report_start_time_utc: ~datetime.datetime
        :keyword report_end_time_utc: The end time of the validation report.
        :paramtype report_end_time_utc: ~datetime.datetime
        :keyword target_id: The resource Id of target service.
        :paramtype target_id: str
        :keyword auth_type: The authentication type. Possible values include: "systemAssignedIdentity",
         "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret".
        :paramtype auth_type: str or ~microsoft_service_linker.models.AuthType
        """
        super(ValidateResult, self).__init__(**kwargs)
        self.name = name
        self.linker_status = linker_status
        self.reason = reason
        self.report_start_time_utc = report_start_time_utc
        self.report_end_time_utc = report_end_time_utc
        self.target_id = target_id
        self.auth_type = auth_type


class VNetSolution(msrest.serialization.Model):
    """The VNet solution for linker.

    :ivar type: Type of VNet solution. Possible values include: "serviceEndpoint", "privateLink".
    :vartype type: str or ~microsoft_service_linker.models.VNetSolutionType
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "VNetSolutionType"]] = None,
        **kwargs
    ):
        """
        :keyword type: Type of VNet solution. Possible values include: "serviceEndpoint",
         "privateLink".
        :paramtype type: str or ~microsoft_service_linker.models.VNetSolutionType
        """
        super(VNetSolution, self).__init__(**kwargs)
        self.type = type
