# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.sub_field import SubField
from fit_tool.profile.profile_type import *


class WorkoutMessage(DataMessage):
    ID = 26
    NAME = 'workout'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=WorkoutMessage.NAME,
                         global_id=WorkoutMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             WorkoutSportField(
                                 size=self.__get_field_size(definition_message, WorkoutSportField.ID),
                                 growable=definition_message is None),
                             WorkoutCapabilitiesField(
                                 size=self.__get_field_size(definition_message, WorkoutCapabilitiesField.ID),
                                 growable=definition_message is None),
                             WorkoutNumValidStepsField(
                                 size=self.__get_field_size(definition_message, WorkoutNumValidStepsField.ID),
                                 growable=definition_message is None),
                             WorkoutWorkoutNameField(
                                 size=self.__get_field_size(definition_message, WorkoutWorkoutNameField.ID),
                                 growable=definition_message is None),
                             WorkoutSubSportField(
                                 size=self.__get_field_size(definition_message, WorkoutSubSportField.ID),
                                 growable=definition_message is None),
                             WorkoutPoolLengthField(
                                 size=self.__get_field_size(definition_message, WorkoutPoolLengthField.ID),
                                 growable=definition_message is None),
                             WorkoutPoolLengthUnitField(
                                 size=self.__get_field_size(definition_message, WorkoutPoolLengthUnitField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def sport(self) -> Optional[Sport]:
        field = self.get_field(WorkoutSportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sport.setter
    def sport(self, value: Sport):
        field = self.get_field(WorkoutSportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def capabilities(self) -> Optional[int]:
        field = self.get_field(WorkoutCapabilitiesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @capabilities.setter
    def capabilities(self, value: int):
        field = self.get_field(WorkoutCapabilitiesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def num_valid_steps(self) -> Optional[int]:
        field = self.get_field(WorkoutNumValidStepsField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @num_valid_steps.setter
    def num_valid_steps(self, value: int):
        field = self.get_field(WorkoutNumValidStepsField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def workout_name(self) -> Optional[str]:
        field = self.get_field(WorkoutWorkoutNameField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @workout_name.setter
    def workout_name(self, value: str):
        field = self.get_field(WorkoutWorkoutNameField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sub_sport(self) -> Optional[SubSport]:
        field = self.get_field(WorkoutSubSportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sub_sport.setter
    def sub_sport(self, value: SubSport):
        field = self.get_field(WorkoutSubSportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def pool_length(self) -> Optional[float]:
        field = self.get_field(WorkoutPoolLengthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @pool_length.setter
    def pool_length(self, value: float):
        field = self.get_field(WorkoutPoolLengthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def pool_length_unit(self) -> Optional[DisplayMeasure]:
        field = self.get_field(WorkoutPoolLengthUnitField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @pool_length_unit.setter
    def pool_length_unit(self, value: DisplayMeasure):
        field = self.get_field(WorkoutPoolLengthUnitField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class WorkoutSportField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sport',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutCapabilitiesField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='capabilities',
            field_id=self.ID,
            base_type=BaseType.UINT32Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutNumValidStepsField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='num_valid_steps',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutWorkoutNameField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='wkt_name',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutSubSportField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sub_sport',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutPoolLengthField(Field):
    ID = 14

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='pool_length',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutPoolLengthUnitField(Field):
    ID = 15

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='pool_length_unit',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
