# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.sub_field import SubField
from fit_tool.profile.profile_type import *


class UserProfileMessage(DataMessage):
    ID = 3
    NAME = 'user_profile'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=UserProfileMessage.NAME,
                         global_id=UserProfileMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             MessageIndexField(
                                 size=self.__get_field_size(definition_message, MessageIndexField.ID),
                                 growable=definition_message is None),
                             UserProfileFriendlyNameField(
                                 size=self.__get_field_size(definition_message, UserProfileFriendlyNameField.ID),
                                 growable=definition_message is None),
                             UserProfileGenderField(
                                 size=self.__get_field_size(definition_message, UserProfileGenderField.ID),
                                 growable=definition_message is None),
                             UserProfileAgeField(
                                 size=self.__get_field_size(definition_message, UserProfileAgeField.ID),
                                 growable=definition_message is None),
                             UserProfileHeightField(
                                 size=self.__get_field_size(definition_message, UserProfileHeightField.ID),
                                 growable=definition_message is None),
                             UserProfileWeightField(
                                 size=self.__get_field_size(definition_message, UserProfileWeightField.ID),
                                 growable=definition_message is None),
                             UserProfileLanguageField(
                                 size=self.__get_field_size(definition_message, UserProfileLanguageField.ID),
                                 growable=definition_message is None),
                             UserProfileElevSettingField(
                                 size=self.__get_field_size(definition_message, UserProfileElevSettingField.ID),
                                 growable=definition_message is None),
                             UserProfileWeightSettingField(
                                 size=self.__get_field_size(definition_message, UserProfileWeightSettingField.ID),
                                 growable=definition_message is None),
                             UserProfileRestingHeartRateField(
                                 size=self.__get_field_size(definition_message, UserProfileRestingHeartRateField.ID),
                                 growable=definition_message is None),
                             UserProfileDefaultMaxRunningHeartRateField(
                                 size=self.__get_field_size(definition_message,
                                                            UserProfileDefaultMaxRunningHeartRateField.ID),
                                 growable=definition_message is None),
                             UserProfileDefaultMaxBikingHeartRateField(
                                 size=self.__get_field_size(definition_message,
                                                            UserProfileDefaultMaxBikingHeartRateField.ID),
                                 growable=definition_message is None),
                             UserProfileDefaultMaxHeartRateField(
                                 size=self.__get_field_size(definition_message, UserProfileDefaultMaxHeartRateField.ID),
                                 growable=definition_message is None),
                             UserProfileHrSettingField(
                                 size=self.__get_field_size(definition_message, UserProfileHrSettingField.ID),
                                 growable=definition_message is None),
                             UserProfileSpeedSettingField(
                                 size=self.__get_field_size(definition_message, UserProfileSpeedSettingField.ID),
                                 growable=definition_message is None),
                             UserProfileDistSettingField(
                                 size=self.__get_field_size(definition_message, UserProfileDistSettingField.ID),
                                 growable=definition_message is None),
                             UserProfilePowerSettingField(
                                 size=self.__get_field_size(definition_message, UserProfilePowerSettingField.ID),
                                 growable=definition_message is None),
                             UserProfileActivityClassField(
                                 size=self.__get_field_size(definition_message, UserProfileActivityClassField.ID),
                                 growable=definition_message is None),
                             UserProfilePositionSettingField(
                                 size=self.__get_field_size(definition_message, UserProfilePositionSettingField.ID),
                                 growable=definition_message is None),
                             UserProfileTemperatureSettingField(
                                 size=self.__get_field_size(definition_message, UserProfileTemperatureSettingField.ID),
                                 growable=definition_message is None),
                             UserProfileLocalIdField(
                                 size=self.__get_field_size(definition_message, UserProfileLocalIdField.ID),
                                 growable=definition_message is None),
                             UserProfileGlobalIdField(
                                 size=self.__get_field_size(definition_message, UserProfileGlobalIdField.ID),
                                 growable=definition_message is None),
                             UserProfileWakeTimeField(
                                 size=self.__get_field_size(definition_message, UserProfileWakeTimeField.ID),
                                 growable=definition_message is None),
                             UserProfileSleepTimeField(
                                 size=self.__get_field_size(definition_message, UserProfileSleepTimeField.ID),
                                 growable=definition_message is None),
                             UserProfileHeightSettingField(
                                 size=self.__get_field_size(definition_message, UserProfileHeightSettingField.ID),
                                 growable=definition_message is None),
                             UserProfileUserRunningStepLengthField(
                                 size=self.__get_field_size(definition_message,
                                                            UserProfileUserRunningStepLengthField.ID),
                                 growable=definition_message is None),
                             UserProfileUserWalkingStepLengthField(
                                 size=self.__get_field_size(definition_message,
                                                            UserProfileUserWalkingStepLengthField.ID),
                                 growable=definition_message is None),
                             UserProfileDepthSettingField(
                                 size=self.__get_field_size(definition_message, UserProfileDepthSettingField.ID),
                                 growable=definition_message is None),
                             UserProfileDiveCountField(
                                 size=self.__get_field_size(definition_message, UserProfileDiveCountField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def message_index(self) -> Optional[int]:
        field = self.get_field(MessageIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @message_index.setter
    def message_index(self, value: int):
        field = self.get_field(MessageIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def friendly_name(self) -> Optional[str]:
        field = self.get_field(UserProfileFriendlyNameField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @friendly_name.setter
    def friendly_name(self, value: str):
        field = self.get_field(UserProfileFriendlyNameField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def gender(self) -> Optional[Gender]:
        field = self.get_field(UserProfileGenderField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @gender.setter
    def gender(self, value: Gender):
        field = self.get_field(UserProfileGenderField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def age(self) -> Optional[int]:
        field = self.get_field(UserProfileAgeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @age.setter
    def age(self, value: int):
        field = self.get_field(UserProfileAgeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def height(self) -> Optional[float]:
        field = self.get_field(UserProfileHeightField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @height.setter
    def height(self, value: float):
        field = self.get_field(UserProfileHeightField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def weight(self) -> Optional[float]:
        field = self.get_field(UserProfileWeightField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @weight.setter
    def weight(self, value: float):
        field = self.get_field(UserProfileWeightField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def language(self) -> Optional[Language]:
        field = self.get_field(UserProfileLanguageField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @language.setter
    def language(self, value: Language):
        field = self.get_field(UserProfileLanguageField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def elev_setting(self) -> Optional[DisplayMeasure]:
        field = self.get_field(UserProfileElevSettingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @elev_setting.setter
    def elev_setting(self, value: DisplayMeasure):
        field = self.get_field(UserProfileElevSettingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def weight_setting(self) -> Optional[DisplayMeasure]:
        field = self.get_field(UserProfileWeightSettingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @weight_setting.setter
    def weight_setting(self, value: DisplayMeasure):
        field = self.get_field(UserProfileWeightSettingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def resting_heart_rate(self) -> Optional[int]:
        field = self.get_field(UserProfileRestingHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @resting_heart_rate.setter
    def resting_heart_rate(self, value: int):
        field = self.get_field(UserProfileRestingHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def default_max_running_heart_rate(self) -> Optional[int]:
        field = self.get_field(UserProfileDefaultMaxRunningHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @default_max_running_heart_rate.setter
    def default_max_running_heart_rate(self, value: int):
        field = self.get_field(UserProfileDefaultMaxRunningHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def default_max_biking_heart_rate(self) -> Optional[int]:
        field = self.get_field(UserProfileDefaultMaxBikingHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @default_max_biking_heart_rate.setter
    def default_max_biking_heart_rate(self, value: int):
        field = self.get_field(UserProfileDefaultMaxBikingHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def default_max_heart_rate(self) -> Optional[int]:
        field = self.get_field(UserProfileDefaultMaxHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @default_max_heart_rate.setter
    def default_max_heart_rate(self, value: int):
        field = self.get_field(UserProfileDefaultMaxHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def hr_setting(self) -> Optional[DisplayHeart]:
        field = self.get_field(UserProfileHrSettingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @hr_setting.setter
    def hr_setting(self, value: DisplayHeart):
        field = self.get_field(UserProfileHrSettingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def speed_setting(self) -> Optional[DisplayMeasure]:
        field = self.get_field(UserProfileSpeedSettingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @speed_setting.setter
    def speed_setting(self, value: DisplayMeasure):
        field = self.get_field(UserProfileSpeedSettingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def dist_setting(self) -> Optional[DisplayMeasure]:
        field = self.get_field(UserProfileDistSettingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @dist_setting.setter
    def dist_setting(self, value: DisplayMeasure):
        field = self.get_field(UserProfileDistSettingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def power_setting(self) -> Optional[DisplayPower]:
        field = self.get_field(UserProfilePowerSettingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @power_setting.setter
    def power_setting(self, value: DisplayPower):
        field = self.get_field(UserProfilePowerSettingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def activity_class(self) -> Optional[ActivityClass]:
        field = self.get_field(UserProfileActivityClassField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @activity_class.setter
    def activity_class(self, value: ActivityClass):
        field = self.get_field(UserProfileActivityClassField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def position_setting(self) -> Optional[DisplayPosition]:
        field = self.get_field(UserProfilePositionSettingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @position_setting.setter
    def position_setting(self, value: DisplayPosition):
        field = self.get_field(UserProfilePositionSettingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def temperature_setting(self) -> Optional[DisplayMeasure]:
        field = self.get_field(UserProfileTemperatureSettingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @temperature_setting.setter
    def temperature_setting(self, value: DisplayMeasure):
        field = self.get_field(UserProfileTemperatureSettingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def user_profile_local_id(self) -> Optional[int]:
        field = self.get_field(UserProfileLocalIdField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @user_profile_local_id.setter
    def user_profile_local_id(self, value: int):
        field = self.get_field(UserProfileLocalIdField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def user_profile_global_id(self) -> Optional[int]:
        field = self.get_field(UserProfileGlobalIdField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @user_profile_global_id.setter
    def user_profile_global_id(self, value: int):
        field = self.get_field(UserProfileGlobalIdField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def wake_time(self) -> Optional[int]:
        field = self.get_field(UserProfileWakeTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @wake_time.setter
    def wake_time(self, value: int):
        field = self.get_field(UserProfileWakeTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sleep_time(self) -> Optional[int]:
        field = self.get_field(UserProfileSleepTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sleep_time.setter
    def sleep_time(self, value: int):
        field = self.get_field(UserProfileSleepTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def height_setting(self) -> Optional[DisplayMeasure]:
        field = self.get_field(UserProfileHeightSettingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @height_setting.setter
    def height_setting(self, value: DisplayMeasure):
        field = self.get_field(UserProfileHeightSettingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def user_running_step_length(self) -> Optional[float]:
        field = self.get_field(UserProfileUserRunningStepLengthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @user_running_step_length.setter
    def user_running_step_length(self, value: float):
        field = self.get_field(UserProfileUserRunningStepLengthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def user_walking_step_length(self) -> Optional[float]:
        field = self.get_field(UserProfileUserWalkingStepLengthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @user_walking_step_length.setter
    def user_walking_step_length(self, value: float):
        field = self.get_field(UserProfileUserWalkingStepLengthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def depth_setting(self) -> Optional[DisplayMeasure]:
        field = self.get_field(UserProfileDepthSettingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @depth_setting.setter
    def depth_setting(self, value: DisplayMeasure):
        field = self.get_field(UserProfileDepthSettingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def dive_count(self) -> Optional[int]:
        field = self.get_field(UserProfileDiveCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @dive_count.setter
    def dive_count(self, value: int):
        field = self.get_field(UserProfileDiveCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class MessageIndexField(Field):
    ID = 254

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='message_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileFriendlyNameField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='friendly_name',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileGenderField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='gender',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileAgeField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='age',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='years',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileHeightField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='height',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileWeightField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='weight',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='kg',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileLanguageField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='language',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileElevSettingField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='elev_setting',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileWeightSettingField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='weight_setting',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileRestingHeartRateField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='resting_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileDefaultMaxRunningHeartRateField(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='default_max_running_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileDefaultMaxBikingHeartRateField(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='default_max_biking_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileDefaultMaxHeartRateField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='default_max_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileHrSettingField(Field):
    ID = 12

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='hr_setting',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileSpeedSettingField(Field):
    ID = 13

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='speed_setting',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileDistSettingField(Field):
    ID = 14

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='dist_setting',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfilePowerSettingField(Field):
    ID = 16

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='power_setting',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileActivityClassField(Field):
    ID = 17

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='activity_class',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfilePositionSettingField(Field):
    ID = 18

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='position_setting',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileTemperatureSettingField(Field):
    ID = 21

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='temperature_setting',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileLocalIdField(Field):
    ID = 22

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='local_id',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileGlobalIdField(Field):
    ID = 23

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='global_id',
            field_id=self.ID,
            base_type=BaseType.BYTE,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileWakeTimeField(Field):
    ID = 28

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='wake_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileSleepTimeField(Field):
    ID = 29

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sleep_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileHeightSettingField(Field):
    ID = 30

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='height_setting',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileUserRunningStepLengthField(Field):
    ID = 31

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='user_running_step_length',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileUserWalkingStepLengthField(Field):
    ID = 32

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='user_walking_step_length',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileDepthSettingField(Field):
    ID = 47

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='depth_setting',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class UserProfileDiveCountField(Field):
    ID = 49

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='dive_count',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
