# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.sub_field import SubField
from fit_tool.profile.profile_type import *


class ScheduleMessage(DataMessage):
    ID = 28
    NAME = 'schedule'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=ScheduleMessage.NAME,
                         global_id=ScheduleMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             ScheduleManufacturerField(
                                 size=self.__get_field_size(definition_message, ScheduleManufacturerField.ID),
                                 growable=definition_message is None),
                             ScheduleProductField(
                                 size=self.__get_field_size(definition_message, ScheduleProductField.ID),
                                 growable=definition_message is None),
                             ScheduleSerialNumberField(
                                 size=self.__get_field_size(definition_message, ScheduleSerialNumberField.ID),
                                 growable=definition_message is None),
                             ScheduleTimeCreatedField(
                                 size=self.__get_field_size(definition_message, ScheduleTimeCreatedField.ID),
                                 growable=definition_message is None),
                             ScheduleCompletedField(
                                 size=self.__get_field_size(definition_message, ScheduleCompletedField.ID),
                                 growable=definition_message is None),
                             ScheduleTypeField(
                                 size=self.__get_field_size(definition_message, ScheduleTypeField.ID),
                                 growable=definition_message is None),
                             ScheduleScheduledTimeField(
                                 size=self.__get_field_size(definition_message, ScheduleScheduledTimeField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def manufacturer(self) -> Optional[int]:
        field = self.get_field(ScheduleManufacturerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @manufacturer.setter
    def manufacturer(self, value: int):
        field = self.get_field(ScheduleManufacturerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def product(self) -> Optional[int]:
        field = self.get_field(ScheduleProductField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @product.setter
    def product(self, value: int):
        field = self.get_field(ScheduleProductField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def favero_product(self) -> Optional[int]:
        field = self.get_field(ScheduleProductField.ID)
        type_field = self.get_field(ScheduleManufacturerField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [263]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @favero_product.setter
    def favero_product(self, value: int):
        field = self.get_field(ScheduleProductField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def garmin_product(self) -> Optional[int]:
        field = self.get_field(ScheduleProductField.ID)
        type_field = self.get_field(ScheduleManufacturerField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [1, 15, 13, 89]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @garmin_product.setter
    def garmin_product(self, value: int):
        field = self.get_field(ScheduleProductField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def serial_number(self) -> Optional[int]:
        field = self.get_field(ScheduleSerialNumberField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @serial_number.setter
    def serial_number(self, value: int):
        field = self.get_field(ScheduleSerialNumberField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def time_created(self) -> Optional[int]:
        field = self.get_field(ScheduleTimeCreatedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @time_created.setter
    def time_created(self, value: int):
        field = self.get_field(ScheduleTimeCreatedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def completed(self) -> Optional[bool]:
        field = self.get_field(ScheduleCompletedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @completed.setter
    def completed(self, value: bool):
        field = self.get_field(ScheduleCompletedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def type(self) -> Optional[Schedule]:
        field = self.get_field(ScheduleTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @type.setter
    def type(self, value: Schedule):
        field = self.get_field(ScheduleTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def scheduled_time(self) -> Optional[int]:
        field = self.get_field(ScheduleScheduledTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @scheduled_time.setter
    def scheduled_time(self, value: int):
        field = self.get_field(ScheduleScheduledTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class ScheduleManufacturerField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='manufacturer',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ScheduleProductField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='product',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
                SubField(
                    name='favero_product',
                    base_type=BaseType.UINT16,
                    scale=1,
                    offset=0,
                    reference_map={
                        ScheduleManufacturerField.ID: [263]
                    }),
                SubField(
                    name='garmin_product',
                    base_type=BaseType.UINT16,
                    scale=1,
                    offset=0,
                    reference_map={
                        ScheduleManufacturerField.ID: [1, 15, 13, 89]
                    })
            ]
        )


class ScheduleSerialNumberField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='serial_number',
            field_id=self.ID,
            base_type=BaseType.UINT32Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ScheduleTimeCreatedField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_created',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class ScheduleCompletedField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='completed',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ScheduleTypeField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ScheduleScheduledTimeField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='scheduled_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
