# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.sub_field import SubField
from fit_tool.profile.profile_type import *


class EventMessage(DataMessage):
    ID = 21
    NAME = 'event'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=EventMessage.NAME,
                         global_id=EventMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             TimestampField(
                                 size=self.__get_field_size(definition_message, TimestampField.ID),
                                 growable=definition_message is None),
                             EventEventField(
                                 size=self.__get_field_size(definition_message, EventEventField.ID),
                                 growable=definition_message is None),
                             EventEventTypeField(
                                 size=self.__get_field_size(definition_message, EventEventTypeField.ID),
                                 growable=definition_message is None),
                             EventData16Field(
                                 size=self.__get_field_size(definition_message, EventData16Field.ID),
                                 growable=definition_message is None),
                             EventDataField(
                                 size=self.__get_field_size(definition_message, EventDataField.ID),
                                 growable=definition_message is None),
                             EventEventGroupField(
                                 size=self.__get_field_size(definition_message, EventEventGroupField.ID),
                                 growable=definition_message is None),
                             EventScoreField(
                                 size=self.__get_field_size(definition_message, EventScoreField.ID),
                                 growable=definition_message is None),
                             EventOpponentScoreField(
                                 size=self.__get_field_size(definition_message, EventOpponentScoreField.ID),
                                 growable=definition_message is None),
                             EventFrontGearNumField(
                                 size=self.__get_field_size(definition_message, EventFrontGearNumField.ID),
                                 growable=definition_message is None),
                             EventFrontGearField(
                                 size=self.__get_field_size(definition_message, EventFrontGearField.ID),
                                 growable=definition_message is None),
                             EventRearGearNumField(
                                 size=self.__get_field_size(definition_message, EventRearGearNumField.ID),
                                 growable=definition_message is None),
                             EventRearGearField(
                                 size=self.__get_field_size(definition_message, EventRearGearField.ID),
                                 growable=definition_message is None),
                             EventDeviceIndexField(
                                 size=self.__get_field_size(definition_message, EventDeviceIndexField.ID),
                                 growable=definition_message is None),
                             EventRadarThreatLevelMaxField(
                                 size=self.__get_field_size(definition_message, EventRadarThreatLevelMaxField.ID),
                                 growable=definition_message is None),
                             EventRadarThreatCountField(
                                 size=self.__get_field_size(definition_message, EventRadarThreatCountField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def timestamp(self) -> Optional[int]:
        field = self.get_field(TimestampField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @timestamp.setter
    def timestamp(self, value: int):
        field = self.get_field(TimestampField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def event(self) -> Optional[Event]:
        field = self.get_field(EventEventField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @event.setter
    def event(self, value: Event):
        field = self.get_field(EventEventField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def event_type(self) -> Optional[EventType]:
        field = self.get_field(EventEventTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @event_type.setter
    def event_type(self, value: EventType):
        field = self.get_field(EventEventTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def data16(self) -> Optional[int]:
        field = self.get_field(EventData16Field.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @data16.setter
    def data16(self, value: int):
        field = self.get_field(EventData16Field.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def data(self) -> Optional[int]:
        field = self.get_field(EventDataField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @data.setter
    def data(self, value: int):
        field = self.get_field(EventDataField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def timer_trigger(self) -> Optional[TimerTrigger]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [0]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @timer_trigger.setter
    def timer_trigger(self, value: TimerTrigger):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def course_point_index(self) -> Optional[int]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [10]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @course_point_index.setter
    def course_point_index(self, value: int):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def battery_level(self) -> Optional[float]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [11]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @battery_level.setter
    def battery_level(self, value: float):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def virtual_partner_speed(self) -> Optional[float]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [12]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @virtual_partner_speed.setter
    def virtual_partner_speed(self, value: float):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def hr_high_alert(self) -> Optional[int]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [13]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @hr_high_alert.setter
    def hr_high_alert(self, value: int):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def hr_low_alert(self) -> Optional[int]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [14]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @hr_low_alert.setter
    def hr_low_alert(self, value: int):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def speed_high_alert(self) -> Optional[float]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [15]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @speed_high_alert.setter
    def speed_high_alert(self, value: float):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def speed_low_alert(self) -> Optional[float]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [16]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @speed_low_alert.setter
    def speed_low_alert(self, value: float):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def cad_high_alert(self) -> Optional[int]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [17]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @cad_high_alert.setter
    def cad_high_alert(self, value: int):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def cad_low_alert(self) -> Optional[int]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [18]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @cad_low_alert.setter
    def cad_low_alert(self, value: int):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def power_high_alert(self) -> Optional[int]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [19]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @power_high_alert.setter
    def power_high_alert(self, value: int):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def power_low_alert(self) -> Optional[int]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [20]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @power_low_alert.setter
    def power_low_alert(self, value: int):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_duration_alert(self) -> Optional[float]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [23]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_duration_alert.setter
    def time_duration_alert(self, value: float):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def distance_duration_alert(self) -> Optional[float]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [24]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @distance_duration_alert.setter
    def distance_duration_alert(self, value: float):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def calorie_duration_alert(self) -> Optional[int]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [25]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @calorie_duration_alert.setter
    def calorie_duration_alert(self, value: int):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def fitness_equipment_state(self) -> Optional[FitnessEquipmentState]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [27]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @fitness_equipment_state.setter
    def fitness_equipment_state(self, value: FitnessEquipmentState):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sport_point(self) -> Optional[int]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [33]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sport_point.setter
    def sport_point(self, value: int):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def gear_change_data(self) -> Optional[int]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [42, 43]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @gear_change_data.setter
    def gear_change_data(self, value: int):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def rider_position(self) -> Optional[RiderPositionType]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [44]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @rider_position.setter
    def rider_position(self, value: RiderPositionType):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def comm_timeout(self) -> Optional[int]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [47]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @comm_timeout.setter
    def comm_timeout(self, value: int):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def radar_threat_alert(self) -> Optional[int]:
        field = self.get_field(EventDataField.ID)
        type_field = self.get_field(EventEventField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [75]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @radar_threat_alert.setter
    def radar_threat_alert(self, value: int):
        field = self.get_field(EventDataField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def event_group(self) -> Optional[int]:
        field = self.get_field(EventEventGroupField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @event_group.setter
    def event_group(self, value: int):
        field = self.get_field(EventEventGroupField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def score(self) -> Optional[int]:
        field = self.get_field(EventScoreField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @score.setter
    def score(self, value: int):
        field = self.get_field(EventScoreField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def opponent_score(self) -> Optional[int]:
        field = self.get_field(EventOpponentScoreField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @opponent_score.setter
    def opponent_score(self, value: int):
        field = self.get_field(EventOpponentScoreField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def front_gear_num(self) -> Optional[int]:
        field = self.get_field(EventFrontGearNumField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @front_gear_num.setter
    def front_gear_num(self, value: int):
        field = self.get_field(EventFrontGearNumField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def front_gear(self) -> Optional[int]:
        field = self.get_field(EventFrontGearField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @front_gear.setter
    def front_gear(self, value: int):
        field = self.get_field(EventFrontGearField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def rear_gear_num(self) -> Optional[int]:
        field = self.get_field(EventRearGearNumField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @rear_gear_num.setter
    def rear_gear_num(self, value: int):
        field = self.get_field(EventRearGearNumField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def rear_gear(self) -> Optional[int]:
        field = self.get_field(EventRearGearField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @rear_gear.setter
    def rear_gear(self, value: int):
        field = self.get_field(EventRearGearField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def device_index(self) -> Optional[int]:
        field = self.get_field(EventDeviceIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @device_index.setter
    def device_index(self, value: int):
        field = self.get_field(EventDeviceIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def radar_threat_level_max(self) -> Optional[RadarThreatLevelType]:
        field = self.get_field(EventRadarThreatLevelMaxField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @radar_threat_level_max.setter
    def radar_threat_level_max(self, value: RadarThreatLevelType):
        field = self.get_field(EventRadarThreatLevelMaxField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def radar_threat_count(self) -> Optional[int]:
        field = self.get_field(EventRadarThreatCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @radar_threat_count.setter
    def radar_threat_count(self, value: int):
        field = self.get_field(EventRadarThreatCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class TimestampField(Field):
    ID = 253

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='timestamp',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class EventEventField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='event',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class EventEventTypeField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='event_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class EventData16Field(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='data16',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class EventDataField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='data',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
                SubField(
                    name='timer_trigger',
                    base_type=BaseType.ENUM,
                    scale=1,
                    offset=0,
                    reference_map={
                        EventEventField.ID: [0]
                    }),
                SubField(
                    name='course_point_index',
                    base_type=BaseType.UINT16,
                    scale=1,
                    offset=0,
                    reference_map={
                        EventEventField.ID: [10]
                    }),
                SubField(
                    name='battery_level',
                    base_type=BaseType.UINT16,
                    scale=1000,
                    offset=0,
                    units='V',
                    reference_map={
                        EventEventField.ID: [11]
                    }),
                SubField(
                    name='virtual_partner_speed',
                    base_type=BaseType.UINT16,
                    scale=1000,
                    offset=0,
                    units='m/s',
                    reference_map={
                        EventEventField.ID: [12]
                    }),
                SubField(
                    name='hr_high_alert',
                    base_type=BaseType.UINT8,
                    scale=1,
                    offset=0,
                    units='bpm',
                    reference_map={
                        EventEventField.ID: [13]
                    }),
                SubField(
                    name='hr_low_alert',
                    base_type=BaseType.UINT8,
                    scale=1,
                    offset=0,
                    units='bpm',
                    reference_map={
                        EventEventField.ID: [14]
                    }),
                SubField(
                    name='speed_high_alert',
                    base_type=BaseType.UINT32,
                    scale=1000,
                    offset=0,
                    units='m/s',
                    reference_map={
                        EventEventField.ID: [15]
                    }),
                SubField(
                    name='speed_low_alert',
                    base_type=BaseType.UINT32,
                    scale=1000,
                    offset=0,
                    units='m/s',
                    reference_map={
                        EventEventField.ID: [16]
                    }),
                SubField(
                    name='cad_high_alert',
                    base_type=BaseType.UINT16,
                    scale=1,
                    offset=0,
                    units='rpm',
                    reference_map={
                        EventEventField.ID: [17]
                    }),
                SubField(
                    name='cad_low_alert',
                    base_type=BaseType.UINT16,
                    scale=1,
                    offset=0,
                    units='rpm',
                    reference_map={
                        EventEventField.ID: [18]
                    }),
                SubField(
                    name='power_high_alert',
                    base_type=BaseType.UINT16,
                    scale=1,
                    offset=0,
                    units='watts',
                    reference_map={
                        EventEventField.ID: [19]
                    }),
                SubField(
                    name='power_low_alert',
                    base_type=BaseType.UINT16,
                    scale=1,
                    offset=0,
                    units='watts',
                    reference_map={
                        EventEventField.ID: [20]
                    }),
                SubField(
                    name='time_duration_alert',
                    base_type=BaseType.UINT32,
                    scale=1000,
                    offset=0,
                    units='s',
                    reference_map={
                        EventEventField.ID: [23]
                    }),
                SubField(
                    name='distance_duration_alert',
                    base_type=BaseType.UINT32,
                    scale=100,
                    offset=0,
                    units='m',
                    reference_map={
                        EventEventField.ID: [24]
                    }),
                SubField(
                    name='calorie_duration_alert',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='calories',
                    reference_map={
                        EventEventField.ID: [25]
                    }),
                SubField(
                    name='fitness_equipment_state',
                    base_type=BaseType.ENUM,
                    scale=1,
                    offset=0,
                    reference_map={
                        EventEventField.ID: [27]
                    }),
                SubField(
                    name='sport_point',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    reference_map={
                        EventEventField.ID: [33]
                    }),
                SubField(
                    name='gear_change_data',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    reference_map={
                        EventEventField.ID: [42, 43]
                    }),
                SubField(
                    name='rider_position',
                    base_type=BaseType.ENUM,
                    scale=1,
                    offset=0,
                    reference_map={
                        EventEventField.ID: [44]
                    }),
                SubField(
                    name='comm_timeout',
                    base_type=BaseType.UINT16,
                    scale=1,
                    offset=0,
                    reference_map={
                        EventEventField.ID: [47]
                    }),
                SubField(
                    name='radar_threat_alert',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    reference_map={
                        EventEventField.ID: [75]
                    })
            ]
        )


class EventEventGroupField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='event_group',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class EventScoreField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='score',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class EventOpponentScoreField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='opponent_score',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class EventFrontGearNumField(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='front_gear_num',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class EventFrontGearField(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='front_gear',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class EventRearGearNumField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='rear_gear_num',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class EventRearGearField(Field):
    ID = 12

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='rear_gear',
            field_id=self.ID,
            base_type=BaseType.UINT8Z,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class EventDeviceIndexField(Field):
    ID = 13

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='device_index',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class EventRadarThreatLevelMaxField(Field):
    ID = 21

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='radar_threat_level_max',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class EventRadarThreatCountField(Field):
    ID = 22

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='radar_threat_count',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
