# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.sub_field import SubField
from fit_tool.profile.profile_type import *


class DiveSummaryMessage(DataMessage):
    ID = 268
    NAME = 'dive_summary'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=DiveSummaryMessage.NAME,
                         global_id=DiveSummaryMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             TimestampField(
                                 size=self.__get_field_size(definition_message, TimestampField.ID),
                                 growable=definition_message is None),
                             DiveSummaryReferenceMesgField(
                                 size=self.__get_field_size(definition_message, DiveSummaryReferenceMesgField.ID),
                                 growable=definition_message is None),
                             DiveSummaryReferenceIndexField(
                                 size=self.__get_field_size(definition_message, DiveSummaryReferenceIndexField.ID),
                                 growable=definition_message is None),
                             DiveSummaryAvgDepthField(
                                 size=self.__get_field_size(definition_message, DiveSummaryAvgDepthField.ID),
                                 growable=definition_message is None),
                             DiveSummaryMaxDepthField(
                                 size=self.__get_field_size(definition_message, DiveSummaryMaxDepthField.ID),
                                 growable=definition_message is None),
                             DiveSummarySurfaceIntervalField(
                                 size=self.__get_field_size(definition_message, DiveSummarySurfaceIntervalField.ID),
                                 growable=definition_message is None),
                             DiveSummaryStartCnsField(
                                 size=self.__get_field_size(definition_message, DiveSummaryStartCnsField.ID),
                                 growable=definition_message is None),
                             DiveSummaryEndCnsField(
                                 size=self.__get_field_size(definition_message, DiveSummaryEndCnsField.ID),
                                 growable=definition_message is None),
                             DiveSummaryStartN2Field(
                                 size=self.__get_field_size(definition_message, DiveSummaryStartN2Field.ID),
                                 growable=definition_message is None),
                             DiveSummaryEndN2Field(
                                 size=self.__get_field_size(definition_message, DiveSummaryEndN2Field.ID),
                                 growable=definition_message is None),
                             DiveSummaryO2ToxicityField(
                                 size=self.__get_field_size(definition_message, DiveSummaryO2ToxicityField.ID),
                                 growable=definition_message is None),
                             DiveSummaryDiveNumberField(
                                 size=self.__get_field_size(definition_message, DiveSummaryDiveNumberField.ID),
                                 growable=definition_message is None),
                             DiveSummaryBottomTimeField(
                                 size=self.__get_field_size(definition_message, DiveSummaryBottomTimeField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def timestamp(self) -> Optional[int]:
        field = self.get_field(TimestampField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @timestamp.setter
    def timestamp(self, value: int):
        field = self.get_field(TimestampField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def reference_mesg(self) -> Optional[int]:
        field = self.get_field(DiveSummaryReferenceMesgField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @reference_mesg.setter
    def reference_mesg(self, value: int):
        field = self.get_field(DiveSummaryReferenceMesgField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def reference_index(self) -> Optional[int]:
        field = self.get_field(DiveSummaryReferenceIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @reference_index.setter
    def reference_index(self, value: int):
        field = self.get_field(DiveSummaryReferenceIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_depth(self) -> Optional[float]:
        field = self.get_field(DiveSummaryAvgDepthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_depth.setter
    def avg_depth(self, value: float):
        field = self.get_field(DiveSummaryAvgDepthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_depth(self) -> Optional[float]:
        field = self.get_field(DiveSummaryMaxDepthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_depth.setter
    def max_depth(self, value: float):
        field = self.get_field(DiveSummaryMaxDepthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def surface_interval(self) -> Optional[int]:
        field = self.get_field(DiveSummarySurfaceIntervalField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @surface_interval.setter
    def surface_interval(self, value: int):
        field = self.get_field(DiveSummarySurfaceIntervalField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def start_cns(self) -> Optional[int]:
        field = self.get_field(DiveSummaryStartCnsField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @start_cns.setter
    def start_cns(self, value: int):
        field = self.get_field(DiveSummaryStartCnsField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def end_cns(self) -> Optional[int]:
        field = self.get_field(DiveSummaryEndCnsField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @end_cns.setter
    def end_cns(self, value: int):
        field = self.get_field(DiveSummaryEndCnsField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def start_n2(self) -> Optional[int]:
        field = self.get_field(DiveSummaryStartN2Field.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @start_n2.setter
    def start_n2(self, value: int):
        field = self.get_field(DiveSummaryStartN2Field.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def end_n2(self) -> Optional[int]:
        field = self.get_field(DiveSummaryEndN2Field.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @end_n2.setter
    def end_n2(self, value: int):
        field = self.get_field(DiveSummaryEndN2Field.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def o2_toxicity(self) -> Optional[int]:
        field = self.get_field(DiveSummaryO2ToxicityField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @o2_toxicity.setter
    def o2_toxicity(self, value: int):
        field = self.get_field(DiveSummaryO2ToxicityField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def dive_number(self) -> Optional[int]:
        field = self.get_field(DiveSummaryDiveNumberField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @dive_number.setter
    def dive_number(self, value: int):
        field = self.get_field(DiveSummaryDiveNumberField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def bottom_time(self) -> Optional[float]:
        field = self.get_field(DiveSummaryBottomTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @bottom_time.setter
    def bottom_time(self, value: float):
        field = self.get_field(DiveSummaryBottomTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class TimestampField(Field):
    ID = 253

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='timestamp',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class DiveSummaryReferenceMesgField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='reference_mesg',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DiveSummaryReferenceIndexField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='reference_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DiveSummaryAvgDepthField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_depth',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class DiveSummaryMaxDepthField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_depth',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class DiveSummarySurfaceIntervalField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='surface_interval',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class DiveSummaryStartCnsField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='start_cns',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class DiveSummaryEndCnsField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='end_cns',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class DiveSummaryStartN2Field(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='start_n2',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class DiveSummaryEndN2Field(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='end_n2',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class DiveSummaryO2ToxicityField(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='o2_toxicity',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='OTUs',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class DiveSummaryDiveNumberField(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='dive_number',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class DiveSummaryBottomTimeField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='bottom_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )
