# coding: utf-8

"""
    DocuSign Click API

    DocuSign Click lets you capture consent to standard agreement terms with a single click: terms and conditions, terms of service, terms of use, privacy policies, and more. The Click API lets you include this customizable clickwrap solution in your DocuSign integrations.  # noqa: E501

    OpenAPI spec version: v1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from docusign_click.client.configuration import Configuration


class DocumentData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'full_name': 'str',
        'email': 'str',
        'company': 'str',
        'job_title': 'str',
        '_date': 'str'
    }

    attribute_map = {
        'full_name': 'fullName',
        'email': 'email',
        'company': 'company',
        'job_title': 'jobTitle',
        '_date': 'date'
    }

    def __init__(self, _configuration=None, **kwargs):  # noqa: E501
        """DocumentData - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._full_name = None
        self._email = None
        self._company = None
        self._job_title = None
        self.__date = None
        self.discriminator = None

        setattr(self, "_{}".format('full_name'), kwargs.get('full_name', None))
        setattr(self, "_{}".format('email'), kwargs.get('email', None))
        setattr(self, "_{}".format('company'), kwargs.get('company', None))
        setattr(self, "_{}".format('job_title'), kwargs.get('job_title', None))
        setattr(self, "_{}".format('_date'), kwargs.get('_date', None))

    @property
    def full_name(self):
        """Gets the full_name of this DocumentData.  # noqa: E501

        The full name of the signer. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.  # noqa: E501

        :return: The full_name of this DocumentData.  # noqa: E501
        :rtype: str
        """
        return self._full_name

    @full_name.setter
    def full_name(self, full_name):
        """Sets the full_name of this DocumentData.

        The full name of the signer. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.  # noqa: E501

        :param full_name: The full_name of this DocumentData.  # noqa: E501
        :type: str
        """

        self._full_name = full_name

    @property
    def email(self):
        """Gets the email of this DocumentData.  # noqa: E501

        The email address of the signer. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.  # noqa: E501

        :return: The email of this DocumentData.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this DocumentData.

        The email address of the signer. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.  # noqa: E501

        :param email: The email of this DocumentData.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def company(self):
        """Gets the company of this DocumentData.  # noqa: E501

        The company name of the signer. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.  # noqa: E501

        :return: The company of this DocumentData.  # noqa: E501
        :rtype: str
        """
        return self._company

    @company.setter
    def company(self, company):
        """Sets the company of this DocumentData.

        The company name of the signer. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.  # noqa: E501

        :param company: The company of this DocumentData.  # noqa: E501
        :type: str
        """

        self._company = company

    @property
    def job_title(self):
        """Gets the job_title of this DocumentData.  # noqa: E501

        The job title of the signer. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.  # noqa: E501

        :return: The job_title of this DocumentData.  # noqa: E501
        :rtype: str
        """
        return self._job_title

    @job_title.setter
    def job_title(self, job_title):
        """Sets the job_title of this DocumentData.

        The job title of the signer. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.  # noqa: E501

        :param job_title: The job_title of this DocumentData.  # noqa: E501
        :type: str
        """

        self._job_title = job_title

    @property
    def _date(self):
        """Gets the _date of this DocumentData.  # noqa: E501

        A custom date for the contract. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.  # noqa: E501

        :return: The _date of this DocumentData.  # noqa: E501
        :rtype: str
        """
        return self.__date

    @_date.setter
    def _date(self, _date):
        """Sets the _date of this DocumentData.

        A custom date for the contract. This field is created in the UI editor for a Clickwrap document. Only required if present in the document.  # noqa: E501

        :param _date: The _date of this DocumentData.  # noqa: E501
        :type: str
        """

        self.__date = _date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DocumentData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DocumentData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DocumentData):
            return True

        return self.to_dict() != other.to_dict()
