# coding: utf-8

"""
    DocuSign Click API

    DocuSign Click lets you capture consent to standard agreement terms with a single click: terms and conditions, terms of service, terms of use, privacy policies, and more. The Click API lets you include this customizable clickwrap solution in your DocuSign integrations.  # noqa: E501

    OpenAPI spec version: v1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..client.configuration import Configuration
from ..client.api_client import ApiClient


class AccountsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_clickwrap(self, account_id, **kwargs):
        """
        Creates a Clickwrap for the specified accountId
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_clickwrap(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param ClickwrapRequest clickwrap_request:
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_clickwrap_with_http_info(account_id, **kwargs)
        else:
            (data) = self.create_clickwrap_with_http_info(account_id, **kwargs)
            return data

    def create_clickwrap_with_http_info(self, account_id, **kwargs):
        """
        Creates a Clickwrap for the specified accountId
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_clickwrap_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param ClickwrapRequest clickwrap_request:
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_clickwrap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_clickwrap`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'clickwrap_request' in params:
            body_params = params['clickwrap_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionSummaryResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_clickwrap_version(self, account_id, clickwrap_id, **kwargs):
        """
        Creates the clickwrap version
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_clickwrap_version(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param ClickwrapRequest clickwrap_request:
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_clickwrap_version_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.create_clickwrap_version_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def create_clickwrap_version_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Creates the clickwrap version
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_clickwrap_version_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param ClickwrapRequest clickwrap_request:
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'clickwrap_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_clickwrap_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_clickwrap_version`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `create_clickwrap_version`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'clickwrap_request' in params:
            body_params = params['clickwrap_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionSummaryResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_has_agreed(self, account_id, clickwrap_id, **kwargs):
        """
        Checks if a user has agreed to a clickwrap and returns a response with the agreement url. Returns HttpStatusCode.OK if user has no pending agreement.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_has_agreed(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param UserAgreementRequest user_agreement_request:
        :return: UserAgreementResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_has_agreed_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.create_has_agreed_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def create_has_agreed_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Checks if a user has agreed to a clickwrap and returns a response with the agreement url. Returns HttpStatusCode.OK if user has no pending agreement.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_has_agreed_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param UserAgreementRequest user_agreement_request:
        :return: UserAgreementResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'user_agreement_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_has_agreed" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_has_agreed`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `create_has_agreed`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/agreements'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user_agreement_request' in params:
            body_params = params['user_agreement_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UserAgreementResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_clickwrap(self, account_id, clickwrap_id, **kwargs):
        """
        Deletes the clickwrap and all its version specified by clickwrapId. Active clickwrap will not get deleted
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwrap(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str versions:
        :return: ClickwrapVersionsDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_clickwrap_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.delete_clickwrap_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def delete_clickwrap_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Deletes the clickwrap and all its version specified by clickwrapId. Active clickwrap will not get deleted
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwrap_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str versions:
        :return: ClickwrapVersionsDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'versions']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_clickwrap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_clickwrap`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `delete_clickwrap`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}
        if 'versions' in params:
            query_params['versions'] = params['versions']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionsDeleteResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_clickwrap_version(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Delete a Clickwrap version specified by versionId
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwrap_version(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str version_id: (required)
        :return: ClickwrapVersionDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
        else:
            (data) = self.delete_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
            return data

    def delete_clickwrap_version_with_http_info(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Delete a Clickwrap version specified by versionId
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str version_id: (required)
        :return: ClickwrapVersionDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_clickwrap_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_clickwrap_version`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `delete_clickwrap_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `delete_clickwrap_version`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionDeleteResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_clickwrap_versions(self, account_id, clickwrap_id, **kwargs):
        """
        Deletes the versions specified by query parameter clickwrapVersionIds for a clickwrap, or all versions if no query parameter is specified. It will not delete if a version is active.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwrap_versions(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str clickwrap_version_ids:
        :return: ClickwrapVersionsDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_clickwrap_versions_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.delete_clickwrap_versions_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def delete_clickwrap_versions_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Deletes the versions specified by query parameter clickwrapVersionIds for a clickwrap, or all versions if no query parameter is specified. It will not delete if a version is active.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwrap_versions_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str clickwrap_version_ids:
        :return: ClickwrapVersionsDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'clickwrap_version_ids']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_clickwrap_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_clickwrap_versions`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `delete_clickwrap_versions`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}
        if 'clickwrap_version_ids' in params:
            query_params['clickwrapVersionIds'] = params['clickwrap_version_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionsDeleteResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_clickwraps(self, account_id, **kwargs):
        """
        Deletes all the clickwraps for an account or the ones passed in query parameter clickwrapIds. It will not delete active clickwraps.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwraps(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_ids:
        :return: ClickwrapsDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_clickwraps_with_http_info(account_id, **kwargs)
        else:
            (data) = self.delete_clickwraps_with_http_info(account_id, **kwargs)
            return data

    def delete_clickwraps_with_http_info(self, account_id, **kwargs):
        """
        Deletes all the clickwraps for an account or the ones passed in query parameter clickwrapIds. It will not delete active clickwraps.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_clickwraps_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_ids:
        :return: ClickwrapsDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_ids']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_clickwraps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_clickwraps`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'clickwrap_ids' in params:
            query_params['clickwrapIds'] = params['clickwrap_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapsDeleteResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_agreement(self, account_id, agreement_id, clickwrap_id, **kwargs):
        """
        Gets the agreement by a provided agreement ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agreement(account_id, agreement_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str agreement_id: (required)
        :param str clickwrap_id: (required)
        :return: UserAgreementResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_agreement_with_http_info(account_id, agreement_id, clickwrap_id, **kwargs)
        else:
            (data) = self.get_agreement_with_http_info(account_id, agreement_id, clickwrap_id, **kwargs)
            return data

    def get_agreement_with_http_info(self, account_id, agreement_id, clickwrap_id, **kwargs):
        """
        Gets the agreement by a provided agreement ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agreement_with_http_info(account_id, agreement_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str agreement_id: (required)
        :param str clickwrap_id: (required)
        :return: UserAgreementResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'agreement_id', 'clickwrap_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agreement" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_agreement`")
        # verify the required parameter 'agreement_id' is set
        if ('agreement_id' not in params) or (params['agreement_id'] is None):
            raise ValueError("Missing the required parameter `agreement_id` when calling `get_agreement`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_agreement`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/agreements/{agreementId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'agreement_id' in params:
            path_params['agreementId'] = params['agreement_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UserAgreementResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_agreement_document(self, account_id, clickwrap_id, order_or_disclosure, version_id, **kwargs):
        """
        Downloads a document at an order within the agreement.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agreement_document(account_id, clickwrap_id, order_or_disclosure, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str order_or_disclosure: (required)
        :param str version_id: (required)
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_agreement_document_with_http_info(account_id, clickwrap_id, order_or_disclosure, version_id, **kwargs)
        else:
            (data) = self.get_agreement_document_with_http_info(account_id, clickwrap_id, order_or_disclosure, version_id, **kwargs)
            return data

    def get_agreement_document_with_http_info(self, account_id, clickwrap_id, order_or_disclosure, version_id, **kwargs):
        """
        Downloads a document at an order within the agreement.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agreement_document_with_http_info(account_id, clickwrap_id, order_or_disclosure, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str order_or_disclosure: (required)
        :param str version_id: (required)
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'order_or_disclosure', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agreement_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_agreement_document`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_agreement_document`")
        # verify the required parameter 'order_or_disclosure' is set
        if ('order_or_disclosure' not in params) or (params['order_or_disclosure'] is None):
            raise ValueError("Missing the required parameter `order_or_disclosure` when calling `get_agreement_document`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_agreement_document`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}/documents/{orderOrDisclosure}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']
        if 'order_or_disclosure' in params:
            path_params['orderOrDisclosure'] = params['order_or_disclosure']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Document',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_agreement_pdf(self, account_id, agreement_id, clickwrap_id, **kwargs):
        """
        Downloads the agreement PDF and optionally certificate of completion.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agreement_pdf(account_id, agreement_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str agreement_id: (required)
        :param str clickwrap_id: (required)
        :param str include_coc:
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_agreement_pdf_with_http_info(account_id, agreement_id, clickwrap_id, **kwargs)
        else:
            (data) = self.get_agreement_pdf_with_http_info(account_id, agreement_id, clickwrap_id, **kwargs)
            return data

    def get_agreement_pdf_with_http_info(self, account_id, agreement_id, clickwrap_id, **kwargs):
        """
        Downloads the agreement PDF and optionally certificate of completion.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_agreement_pdf_with_http_info(account_id, agreement_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str agreement_id: (required)
        :param str clickwrap_id: (required)
        :param str include_coc:
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'agreement_id', 'clickwrap_id', 'include_coc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agreement_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_agreement_pdf`")
        # verify the required parameter 'agreement_id' is set
        if ('agreement_id' not in params) or (params['agreement_id'] is None):
            raise ValueError("Missing the required parameter `agreement_id` when calling `get_agreement_pdf`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_agreement_pdf`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/agreements/{agreementId}/download'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'agreement_id' in params:
            path_params['agreementId'] = params['agreement_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}
        if 'include_coc' in params:
            query_params['include_coc'] = params['include_coc']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/pdf'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_clickwrap(self, account_id, clickwrap_id, **kwargs):
        """
        Gets the clickwrap for an account specified by clickwrapId
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :return: ClickwrapVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_clickwrap_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.get_clickwrap_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def get_clickwrap_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Gets the clickwrap for an account specified by clickwrapId
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :return: ClickwrapVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clickwrap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_clickwrap`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_clickwrap`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_clickwrap_agreements(self, account_id, clickwrap_id, **kwargs):
        """
        Gets the agreement responses for a clickwrap
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_agreements(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str client_user_id:
        :param str from_date:
        :param str page_number:
        :param str status:
        :param str to_date:
        :return: ClickwrapAgreementsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_clickwrap_agreements_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.get_clickwrap_agreements_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def get_clickwrap_agreements_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Gets the agreement responses for a clickwrap
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_agreements_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str client_user_id:
        :param str from_date:
        :param str page_number:
        :param str status:
        :param str to_date:
        :return: ClickwrapAgreementsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'client_user_id', 'from_date', 'page_number', 'status', 'to_date']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clickwrap_agreements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_clickwrap_agreements`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_clickwrap_agreements`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}
        if 'client_user_id' in params:
            query_params['client_user_id'] = params['client_user_id']
        if 'from_date' in params:
            query_params['from_date'] = params['from_date']
        if 'page_number' in params:
            query_params['page_number'] = params['page_number']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'to_date' in params:
            query_params['to_date'] = params['to_date']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapAgreementsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_clickwrap_version(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Gets the Clickwrap version by clickwrapId and versionId for an account
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_version(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str version_id: (required)
        :return: ClickwrapVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
        else:
            (data) = self.get_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
            return data

    def get_clickwrap_version_with_http_info(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Gets the Clickwrap version by clickwrapId and versionId for an account
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str version_id: (required)
        :return: ClickwrapVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clickwrap_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_clickwrap_version`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_clickwrap_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_clickwrap_version`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_clickwrap_version_agreements(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Gets the agreement responses for a clickwrap version
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_version_agreements(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str version_id: (required)
        :param str client_user_id:
        :param str from_date:
        :param str page_number:
        :param str status:
        :param str to_date:
        :return: ClickwrapAgreementsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_clickwrap_version_agreements_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
        else:
            (data) = self.get_clickwrap_version_agreements_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
            return data

    def get_clickwrap_version_agreements_with_http_info(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Gets the agreement responses for a clickwrap version
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_version_agreements_with_http_info(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str version_id: (required)
        :param str client_user_id:
        :param str from_date:
        :param str page_number:
        :param str status:
        :param str to_date:
        :return: ClickwrapAgreementsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'version_id', 'client_user_id', 'from_date', 'page_number', 'status', 'to_date']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clickwrap_version_agreements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_clickwrap_version_agreements`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_clickwrap_version_agreements`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_clickwrap_version_agreements`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}/users'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}
        if 'client_user_id' in params:
            query_params['client_user_id'] = params['client_user_id']
        if 'from_date' in params:
            query_params['from_date'] = params['from_date']
        if 'page_number' in params:
            query_params['page_number'] = params['page_number']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'to_date' in params:
            query_params['to_date'] = params['to_date']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapAgreementsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_clickwrap_versions(self, account_id, clickwrap_id, **kwargs):
        """
        Gets all the versions of a clickwrap for an account
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_versions(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :return: ClickwrapVersionsPagedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_clickwrap_versions_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.get_clickwrap_versions_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def get_clickwrap_versions_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Gets all the versions of a clickwrap for an account
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwrap_versions_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :return: ClickwrapVersionsPagedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clickwrap_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_clickwrap_versions`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `get_clickwrap_versions`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionsPagedResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_clickwraps(self, account_id, **kwargs):
        """
        Gets the Clickwraps for an account
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwraps(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str filter:
        :param str from_date:
        :param str name:
        :param str owner_user_id:
        :param str page_number:
        :param str status:
        :param str to_date:
        :return: ClickwrapVersionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_clickwraps_with_http_info(account_id, **kwargs)
        else:
            (data) = self.get_clickwraps_with_http_info(account_id, **kwargs)
            return data

    def get_clickwraps_with_http_info(self, account_id, **kwargs):
        """
        Gets the Clickwraps for an account
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_clickwraps_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str filter:
        :param str from_date:
        :param str name:
        :param str owner_user_id:
        :param str page_number:
        :param str status:
        :param str to_date:
        :return: ClickwrapVersionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'filter', 'from_date', 'name', 'owner_user_id', 'page_number', 'status', 'to_date']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clickwraps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_clickwraps`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'filter' in params:
            query_params['filter'] = params['filter']
        if 'from_date' in params:
            query_params['from_date'] = params['from_date']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'owner_user_id' in params:
            query_params['ownerUserId'] = params['owner_user_id']
        if 'page_number' in params:
            query_params['page_number'] = params['page_number']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'to_date' in params:
            query_params['to_date'] = params['to_date']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_service_information(self, **kwargs):
        """
        Provides base service and version access information.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_service_information(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ServiceInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_service_information_with_http_info(**kwargs)
        else:
            (data) = self.get_service_information_with_http_info(**kwargs)
            return data

    def get_service_information_with_http_info(self, **kwargs):
        """
        Provides base service and version access information.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_service_information_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ServiceInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_service_information" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        resource_path = '/service_information'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ServiceInformation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_clickwrap(self, account_id, clickwrap_id, **kwargs):
        """
        Updates the clickwrap specified by clickwrapId
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_clickwrap(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param ClickwrapTransferRequest clickwrap_transfer_request:
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_clickwrap_with_http_info(account_id, clickwrap_id, **kwargs)
        else:
            (data) = self.update_clickwrap_with_http_info(account_id, clickwrap_id, **kwargs)
            return data

    def update_clickwrap_with_http_info(self, account_id, clickwrap_id, **kwargs):
        """
        Updates the clickwrap specified by clickwrapId
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_clickwrap_with_http_info(account_id, clickwrap_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param ClickwrapTransferRequest clickwrap_transfer_request:
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'clickwrap_transfer_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_clickwrap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_clickwrap`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `update_clickwrap`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'clickwrap_transfer_request' in params:
            body_params = params['clickwrap_transfer_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionSummaryResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_clickwrap_version(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Updates the clickwrap version specified by versionId
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_clickwrap_version(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str version_id: (required)
        :param ClickwrapRequest clickwrap_request:
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
        else:
            (data) = self.update_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, **kwargs)
            return data

    def update_clickwrap_version_with_http_info(self, account_id, clickwrap_id, version_id, **kwargs):
        """
        Updates the clickwrap version specified by versionId
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_clickwrap_version_with_http_info(account_id, clickwrap_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param str clickwrap_id: (required)
        :param str version_id: (required)
        :param ClickwrapRequest clickwrap_request:
        :return: ClickwrapVersionSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'clickwrap_id', 'version_id', 'clickwrap_request']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_clickwrap_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_clickwrap_version`")
        # verify the required parameter 'clickwrap_id' is set
        if ('clickwrap_id' not in params) or (params['clickwrap_id'] is None):
            raise ValueError("Missing the required parameter `clickwrap_id` when calling `update_clickwrap_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `update_clickwrap_version`")


        collection_formats = {}

        resource_path = '/v1/accounts/{accountId}/clickwraps/{clickwrapId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'clickwrap_id' in params:
            path_params['clickwrapId'] = params['clickwrap_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'clickwrap_request' in params:
            body_params = params['clickwrap_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ClickwrapVersionSummaryResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
