import * as cdk from '@aws-cdk/core';
import { CfnVirtualGateway } from './appmesh.generated';
import { HealthCheck, Protocol } from './shared-interfaces';
/**
 * (experimental) Represents the properties needed to define HTTP Listeners for a VirtualGateway.
 *
 * @experimental
 */
export interface HttpGatewayListenerProps {
    /**
     * (experimental) Port to listen for connections on.
     *
     * @default - 8080
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) The health check information for the listener.
     *
     * @default - no healthcheck
     * @experimental
     */
    readonly healthCheck?: HealthCheck;
}
/**
 * (experimental) Represents the properties needed to define GRPC Listeners for a VirtualGateway.
 *
 * @experimental
 */
export interface GrpcGatewayListenerProps {
    /**
     * (experimental) Port to listen for connections on.
     *
     * @default - 8080
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) The health check information for the listener.
     *
     * @default - no healthcheck
     * @experimental
     */
    readonly healthCheck?: HealthCheck;
}
/**
 * (experimental) Properties for a VirtualGateway listener.
 *
 * @experimental
 */
export interface VirtualGatewayListenerConfig {
    /**
     * (experimental) Single listener config for a VirtualGateway.
     *
     * @experimental
     */
    readonly listener: CfnVirtualGateway.VirtualGatewayListenerProperty;
}
/**
 * (experimental) Represents the properties needed to define listeners for a VirtualGateway.
 *
 * @experimental
 */
export declare abstract class VirtualGatewayListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualGateway.
     *
     * @experimental
     */
    static httpGatewayListener(props?: HttpGatewayListenerProps): VirtualGatewayListener;
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualGateway.
     *
     * @experimental
     */
    static http2GatewayListener(props?: HttpGatewayListenerProps): VirtualGatewayListener;
    /**
     * (experimental) Returns a GRPC Listener for a VirtualGateway.
     *
     * @experimental
     */
    static grpcGatewayListener(props?: GrpcGatewayListenerProps): VirtualGatewayListener;
    /**
     * (experimental) Protocol the listener implements.
     *
     * @experimental
     */
    protected abstract protocol: Protocol;
    /**
     * (experimental) Port to listen for connections on.
     *
     * @experimental
     */
    protected abstract port: number;
    /**
     * (experimental) Health checking strategy upstream nodes should use when communicating with the listener.
     *
     * @experimental
     */
    protected abstract healthCheck?: HealthCheck;
    /**
     * (experimental) Called when the GatewayListener type is initialized.
     *
     * Can be used to enforce
     * mutual exclusivity
     *
     * @experimental
     */
    abstract bind(scope: cdk.Construct): VirtualGatewayListenerConfig;
    /**
     * @experimental
     */
    protected renderHealthCheck(hc: HealthCheck): CfnVirtualGateway.VirtualGatewayHealthCheckPolicyProperty | undefined;
}
