"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRoute = void 0;
const cdk = require("@aws-cdk/core");
const appmesh_generated_1 = require("./appmesh.generated");
const virtual_gateway_1 = require("./virtual-gateway");
/**
 * (experimental) GatewayRoute represents a new or existing gateway route attached to a VirtualGateway and Mesh.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html
 * @experimental
 */
class GatewayRoute extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.gatewayRouteName || cdk.Lazy.stringValue({ produce: () => this.node.uniqueId }),
        });
        this.virtualGateway = props.virtualGateway;
        const routeSpecConfig = props.routeSpec.bind(this);
        const gatewayRoute = new appmesh_generated_1.CfnGatewayRoute(this, 'Resource', {
            gatewayRouteName: this.physicalName,
            meshName: props.virtualGateway.mesh.meshName,
            spec: {
                httpRoute: routeSpecConfig.httpSpecConfig,
                http2Route: routeSpecConfig.http2SpecConfig,
                grpcRoute: routeSpecConfig.grpcSpecConfig,
            },
            virtualGatewayName: this.virtualGateway.virtualGatewayName,
        });
        this.gatewayRouteName = this.getResourceNameAttribute(gatewayRoute.attrGatewayRouteName);
        this.gatewayRouteArn = this.getResourceArnAttribute(gatewayRoute.ref, {
            service: 'appmesh',
            resource: `mesh/${props.virtualGateway.mesh.meshName}/virtualRouter/${this.virtualGateway.virtualGatewayName}/gatewayRoute`,
            resourceName: this.physicalName,
        });
    }
    /**
     * (experimental) Import an existing GatewayRoute given an ARN.
     *
     * @experimental
     */
    static fromGatewayRouteArn(scope, id, gatewayRouteArn) {
        return new ImportedGatewayRoute(scope, id, { gatewayRouteArn });
    }
}
exports.GatewayRoute = GatewayRoute;
/**
 * Represents an imported IGatewayRoute
 */
class ImportedGatewayRoute extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.gatewayRouteArn) {
            this.gatewayRouteArn = props.gatewayRouteArn;
            this.gatewayRouteName = cdk.Fn.select(4, cdk.Fn.split('/', cdk.Stack.of(scope).parseArn(props.gatewayRouteArn).resourceName));
            this.virtualGateway = virtual_gateway_1.VirtualGateway.fromVirtualGatewayArn(this, 'virtualGateway', props.gatewayRouteArn);
        }
        else {
            throw new Error('Need gatewayRouteArn');
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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