"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRouteSpec = void 0;
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Used to generate specs with different protocols for a GatewayRoute.
 *
 * @experimental
 */
class GatewayRouteSpec {
    /**
     * (experimental) Creates an HTTP Based GatewayRoute.
     *
     * @param props - no http gateway route.
     * @experimental
     */
    static httpRouteSpec(props) {
        return new HttpGatewayRouteSpec(props, shared_interfaces_1.Protocol.HTTP);
    }
    /**
     * (experimental) Creates an HTTP2 Based GatewayRoute.
     *
     * @param props - no http2 gateway route.
     * @experimental
     */
    static http2RouteSpec(props) {
        return new HttpGatewayRouteSpec(props, shared_interfaces_1.Protocol.HTTP2);
    }
    /**
     * (experimental) Creates an GRPC Based GatewayRoute.
     *
     * @param props - no grpc gateway route.
     * @experimental
     */
    static grpcRouteSpec(props) {
        return new GrpcGatewayRouteSpec(props);
    }
}
exports.GatewayRouteSpec = GatewayRouteSpec;
class HttpGatewayRouteSpec extends GatewayRouteSpec {
    constructor(props, protocol) {
        super();
        this.routeTarget = props.routeTarget;
        this.routeType = protocol;
        this.match = props.match;
    }
    bind(_scope) {
        const prefixPath = this.match ? this.match.prefixPath : '/';
        if (prefixPath[0] != '/') {
            throw new Error(`Prefix Path must start with \'/\', got: ${prefixPath}`);
        }
        const httpConfig = {
            match: {
                prefix: prefixPath,
            },
            action: {
                target: {
                    virtualService: {
                        virtualServiceName: this.routeTarget.virtualServiceName,
                    },
                },
            },
        };
        return {
            httpSpecConfig: this.routeType === shared_interfaces_1.Protocol.HTTP ? httpConfig : undefined,
            http2SpecConfig: this.routeType === shared_interfaces_1.Protocol.HTTP2 ? httpConfig : undefined,
        };
    }
}
class GrpcGatewayRouteSpec extends GatewayRouteSpec {
    constructor(props) {
        super();
        this.match = props.match;
        this.routeTarget = props.routeTarget;
    }
    bind(_scope) {
        return {
            grpcSpecConfig: {
                action: {
                    target: {
                        virtualService: {
                            virtualServiceName: this.routeTarget.virtualServiceName,
                        },
                    },
                },
                match: {
                    serviceName: this.match.serviceName,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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