#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sun Feb  3 16:26:32 2019

@author: Maria Climent-Pommeret
"""

import parsetabtolatex.parsetabtolatex_yacc as myyacc


class ParseTabToLatex:
    """
    Parses a parsetab.py file generated by ply and creates a .tex file
    containing the extracted grammar formatted using the syntax LaTeX
    package.
    """

    def __init__(self, infile, outfile):
        self.infile = infile
        self.outfile = outfile

    def generate_latex(self):
        with open(self.infile, "r") as parsetab:
            data = parsetab.read()
            code = myyacc.parser.parse(data).rewrite()
            with open(self.outfile, "w") as texfile:
                texfile.write(code)
