# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: ibc/core/channel/v1/channel.proto, ibc/core/channel/v1/genesis.proto, ibc/core/channel/v1/query.proto, ibc/core/channel/v1/tx.proto
# plugin: python-betterproto
# This file has been @generated

from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from .....cosmos.base.query import v1beta1 as ____cosmos_base_query_v1_beta1__
from ...client import v1 as __client_v1__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class State(betterproto.Enum):
    """
    State defines if a channel is in one of the following states:
     CLOSED, INIT, TRYOPEN, OPEN or UNINITIALIZED.
    """

    UNINITIALIZED_UNSPECIFIED = 0
    """Default State"""

    INIT = 1
    """A channel has just started the opening handshake."""

    TRYOPEN = 2
    """
    A channel has acknowledged the handshake step on the counterparty chain.
    """

    OPEN = 3
    """
    A channel has completed the handshake. Open channels are
     ready to send and receive packets.
    """

    CLOSED = 4
    """
    A channel has been closed and can no longer be used to send or receive
     packets.
    """


class Order(betterproto.Enum):
    """Order defines if a channel is ORDERED or UNORDERED"""

    NONE_UNSPECIFIED = 0
    """zero-value for channel ordering"""

    UNORDERED = 1
    """
    packets can be delivered in any order, which may differ from the order in
     which they were sent.
    """

    ORDERED = 2
    """packets are delivered exactly in the order which they were sent"""


class ResponseResultType(betterproto.Enum):
    """
    ResponseResultType defines the possible outcomes of the execution of a message
    """

    UNSPECIFIED = 0
    """Default zero value enumeration"""

    NOOP = 1
    """
    The message did not call the IBC application callbacks (because, for example, the packet had already been relayed)
    """

    SUCCESS = 2
    """The message was executed successfully"""


@dataclass(eq=False, repr=False)
class Channel(betterproto.Message):
    """
    Channel defines pipeline for exactly-once packet delivery between specific
     modules on separate blockchains, which has at least one end capable of
     sending packets and one end capable of receiving packets.
    """

    state: "State" = betterproto.enum_field(1)
    """current state of the channel end"""

    ordering: "Order" = betterproto.enum_field(2)
    """whether the channel is ordered or unordered"""

    counterparty: "Counterparty" = betterproto.message_field(3)
    """counterparty channel end"""

    connection_hops: List[str] = betterproto.string_field(4)
    """
    list of connection identifiers, in order, along which packets sent on
     this channel will travel
    """

    version: str = betterproto.string_field(5)
    """opaque channel version, which is agreed upon during the handshake"""


@dataclass(eq=False, repr=False)
class IdentifiedChannel(betterproto.Message):
    """
    IdentifiedChannel defines a channel with additional port and channel
     identifier fields.
    """

    state: "State" = betterproto.enum_field(1)
    """current state of the channel end"""

    ordering: "Order" = betterproto.enum_field(2)
    """whether the channel is ordered or unordered"""

    counterparty: "Counterparty" = betterproto.message_field(3)
    """counterparty channel end"""

    connection_hops: List[str] = betterproto.string_field(4)
    """
    list of connection identifiers, in order, along which packets sent on
     this channel will travel
    """

    version: str = betterproto.string_field(5)
    """opaque channel version, which is agreed upon during the handshake"""

    port_id: str = betterproto.string_field(6)
    """port identifier"""

    channel_id: str = betterproto.string_field(7)
    """channel identifier"""


@dataclass(eq=False, repr=False)
class Counterparty(betterproto.Message):
    """Counterparty defines a channel end counterparty"""

    port_id: str = betterproto.string_field(1)
    """
    port on the counterparty chain which owns the other end of the channel.
    """

    channel_id: str = betterproto.string_field(2)
    """channel end on the counterparty chain"""


@dataclass(eq=False, repr=False)
class Packet(betterproto.Message):
    """
    Packet defines a type that carries data across different chains through IBC
    """

    sequence: int = betterproto.uint64_field(1)
    """
    number corresponds to the order of sends and receives, where a Packet
     with an earlier sequence number must be sent and received before a Packet
     with a later sequence number.
    """

    source_port: str = betterproto.string_field(2)
    """identifies the port on the sending chain."""

    source_channel: str = betterproto.string_field(3)
    """identifies the channel end on the sending chain."""

    destination_port: str = betterproto.string_field(4)
    """identifies the port on the receiving chain."""

    destination_channel: str = betterproto.string_field(5)
    """identifies the channel end on the receiving chain."""

    data: bytes = betterproto.bytes_field(6)
    """actual opaque bytes transferred directly to the application module"""

    timeout_height: "__client_v1__.Height" = betterproto.message_field(7)
    """block height after which the packet times out"""

    timeout_timestamp: int = betterproto.uint64_field(8)
    """block timestamp (in nanoseconds) after which the packet times out"""


@dataclass(eq=False, repr=False)
class PacketState(betterproto.Message):
    """
    PacketState defines the generic type necessary to retrieve and store
     packet commitments, acknowledgements, and receipts.
     Caller is responsible for knowing the context necessary to interpret this
     state as a commitment, acknowledgement, or a receipt.
    """

    port_id: str = betterproto.string_field(1)
    """channel port identifier."""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier."""

    sequence: int = betterproto.uint64_field(3)
    """packet sequence."""

    data: bytes = betterproto.bytes_field(4)
    """embedded data that represents packet state."""


@dataclass(eq=False, repr=False)
class PacketId(betterproto.Message):
    """
    PacketId is an identifer for a unique Packet
     Source chains refer to packets by source port/channel
     Destination chains refer to packets by destination port/channel
    """

    port_id: str = betterproto.string_field(1)
    """channel port identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    sequence: int = betterproto.uint64_field(3)
    """packet sequence"""


@dataclass(eq=False, repr=False)
class Acknowledgement(betterproto.Message):
    """
    Acknowledgement is the recommended acknowledgement format to be used by
     app-specific protocols.
     NOTE: The field numbers 21 and 22 were explicitly chosen to avoid accidental
     conflicts with other protobuf message formats used for acknowledgements.
     The first byte of any message with this format will be the non-ASCII values
     `0xaa` (result) or `0xb2` (error). Implemented as defined by ICS:
     https://github.com/cosmos/ibc/tree/master/spec/core/ics-004-channel-and-packet-semantics#acknowledgement-envelope
    """

    result: bytes = betterproto.bytes_field(21, group="response")
    error: str = betterproto.string_field(22, group="response")


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the ibc channel submodule's genesis state."""

    channels: List["IdentifiedChannel"] = betterproto.message_field(1)
    acknowledgements: List["PacketState"] = betterproto.message_field(2)
    commitments: List["PacketState"] = betterproto.message_field(3)
    receipts: List["PacketState"] = betterproto.message_field(4)
    send_sequences: List["PacketSequence"] = betterproto.message_field(5)
    recv_sequences: List["PacketSequence"] = betterproto.message_field(6)
    ack_sequences: List["PacketSequence"] = betterproto.message_field(7)
    next_channel_sequence: int = betterproto.uint64_field(8)
    """the sequence for the next generated channel identifier"""


@dataclass(eq=False, repr=False)
class PacketSequence(betterproto.Message):
    """
    PacketSequence defines the genesis type necessary to retrieve and store
     next send and receive sequences.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    sequence: int = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class MsgChannelOpenInit(betterproto.Message):
    """
    MsgChannelOpenInit defines an sdk.Msg to initialize a channel handshake. It
     is called by a relayer on Chain A.
    """

    port_id: str = betterproto.string_field(1)
    channel: "Channel" = betterproto.message_field(2)
    signer: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class MsgChannelOpenInitResponse(betterproto.Message):
    """
    MsgChannelOpenInitResponse defines the Msg/ChannelOpenInit response type.
    """

    channel_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class MsgChannelOpenTry(betterproto.Message):
    """
    MsgChannelOpenInit defines a msg sent by a Relayer to try to open a channel
     on Chain B. The version field within the Channel field has been deprecated. Its
     value will be ignored by core IBC.
    """

    port_id: str = betterproto.string_field(1)
    previous_channel_id: str = betterproto.string_field(2)
    """
    in the case of crossing hello's, when both chains call OpenInit, we need
     the channel identifier of the previous channel in state INIT
    """

    channel: "Channel" = betterproto.message_field(3)
    """
    NOTE: the version field within the channel has been deprecated. Its value will be ignored by core IBC.
    """

    counterparty_version: str = betterproto.string_field(4)
    proof_init: bytes = betterproto.bytes_field(5)
    proof_height: "__client_v1__.Height" = betterproto.message_field(6)
    signer: str = betterproto.string_field(7)


@dataclass(eq=False, repr=False)
class MsgChannelOpenTryResponse(betterproto.Message):
    """
    MsgChannelOpenTryResponse defines the Msg/ChannelOpenTry response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelOpenAck(betterproto.Message):
    """
    MsgChannelOpenAck defines a msg sent by a Relayer to Chain A to acknowledge
     the change of channel state to TRYOPEN on Chain B.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    counterparty_channel_id: str = betterproto.string_field(3)
    counterparty_version: str = betterproto.string_field(4)
    proof_try: bytes = betterproto.bytes_field(5)
    proof_height: "__client_v1__.Height" = betterproto.message_field(6)
    signer: str = betterproto.string_field(7)


@dataclass(eq=False, repr=False)
class MsgChannelOpenAckResponse(betterproto.Message):
    """
    MsgChannelOpenAckResponse defines the Msg/ChannelOpenAck response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelOpenConfirm(betterproto.Message):
    """
    MsgChannelOpenConfirm defines a msg sent by a Relayer to Chain B to
     acknowledge the change of channel state to OPEN on Chain A.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    proof_ack: bytes = betterproto.bytes_field(3)
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    signer: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class MsgChannelOpenConfirmResponse(betterproto.Message):
    """
    MsgChannelOpenConfirmResponse defines the Msg/ChannelOpenConfirm response
     type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelCloseInit(betterproto.Message):
    """
    MsgChannelCloseInit defines a msg sent by a Relayer to Chain A
     to close a channel with Chain B.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    signer: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class MsgChannelCloseInitResponse(betterproto.Message):
    """
    MsgChannelCloseInitResponse defines the Msg/ChannelCloseInit response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelCloseConfirm(betterproto.Message):
    """
    MsgChannelCloseConfirm defines a msg sent by a Relayer to Chain B
     to acknowledge the change of channel state to CLOSED on Chain A.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    proof_init: bytes = betterproto.bytes_field(3)
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    signer: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class MsgChannelCloseConfirmResponse(betterproto.Message):
    """
    MsgChannelCloseConfirmResponse defines the Msg/ChannelCloseConfirm response
     type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgRecvPacket(betterproto.Message):
    """MsgRecvPacket receives incoming IBC packet"""

    packet: "Packet" = betterproto.message_field(1)
    proof_commitment: bytes = betterproto.bytes_field(2)
    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    signer: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class MsgRecvPacketResponse(betterproto.Message):
    """MsgRecvPacketResponse defines the Msg/RecvPacket response type."""

    result: "ResponseResultType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class MsgTimeout(betterproto.Message):
    """MsgTimeout receives timed-out packet"""

    packet: "Packet" = betterproto.message_field(1)
    proof_unreceived: bytes = betterproto.bytes_field(2)
    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    next_sequence_recv: int = betterproto.uint64_field(4)
    signer: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class MsgTimeoutResponse(betterproto.Message):
    """MsgTimeoutResponse defines the Msg/Timeout response type."""

    result: "ResponseResultType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class MsgTimeoutOnClose(betterproto.Message):
    """
    MsgTimeoutOnClose timed-out packet upon counterparty channel closure.
    """

    packet: "Packet" = betterproto.message_field(1)
    proof_unreceived: bytes = betterproto.bytes_field(2)
    proof_close: bytes = betterproto.bytes_field(3)
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    next_sequence_recv: int = betterproto.uint64_field(5)
    signer: str = betterproto.string_field(6)


@dataclass(eq=False, repr=False)
class MsgTimeoutOnCloseResponse(betterproto.Message):
    """
    MsgTimeoutOnCloseResponse defines the Msg/TimeoutOnClose response type.
    """

    result: "ResponseResultType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class MsgAcknowledgement(betterproto.Message):
    """MsgAcknowledgement receives incoming IBC acknowledgement"""

    packet: "Packet" = betterproto.message_field(1)
    acknowledgement: bytes = betterproto.bytes_field(2)
    proof_acked: bytes = betterproto.bytes_field(3)
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    signer: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class MsgAcknowledgementResponse(betterproto.Message):
    """
    MsgAcknowledgementResponse defines the Msg/Acknowledgement response type.
    """

    result: "ResponseResultType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class QueryChannelRequest(betterproto.Message):
    """
    QueryChannelRequest is the request type for the Query/Channel RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""


@dataclass(eq=False, repr=False)
class QueryChannelResponse(betterproto.Message):
    """
    QueryChannelResponse is the response type for the Query/Channel RPC method.
     Besides the Channel end, it includes a proof and the height from which the
     proof was retrieved.
    """

    channel: "Channel" = betterproto.message_field(1)
    """channel associated with the request identifiers"""

    proof: bytes = betterproto.bytes_field(2)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryChannelsRequest(betterproto.Message):
    """
    QueryChannelsRequest is the request type for the Query/Channels RPC method
    """

    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(1)
    )
    """pagination request"""


@dataclass(eq=False, repr=False)
class QueryChannelsResponse(betterproto.Message):
    """
    QueryChannelsResponse is the response type for the Query/Channels RPC method.
    """

    channels: List["IdentifiedChannel"] = betterproto.message_field(1)
    """list of stored channels of the chain."""

    pagination: "____cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination response"""

    height: "__client_v1__.Height" = betterproto.message_field(3)
    """query block height"""


@dataclass(eq=False, repr=False)
class QueryConnectionChannelsRequest(betterproto.Message):
    """
    QueryConnectionChannelsRequest is the request type for the
     Query/QueryConnectionChannels RPC method
    """

    connection: str = betterproto.string_field(1)
    """connection unique identifier"""

    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )
    """pagination request"""


@dataclass(eq=False, repr=False)
class QueryConnectionChannelsResponse(betterproto.Message):
    """
    QueryConnectionChannelsResponse is the Response type for the
     Query/QueryConnectionChannels RPC method
    """

    channels: List["IdentifiedChannel"] = betterproto.message_field(1)
    """list of channels associated with a connection."""

    pagination: "____cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination response"""

    height: "__client_v1__.Height" = betterproto.message_field(3)
    """query block height"""


@dataclass(eq=False, repr=False)
class QueryChannelClientStateRequest(betterproto.Message):
    """
    QueryChannelClientStateRequest is the request type for the Query/ClientState
     RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""


@dataclass(eq=False, repr=False)
class QueryChannelClientStateResponse(betterproto.Message):
    """
    QueryChannelClientStateResponse is the Response type for the
     Query/QueryChannelClientState RPC method
    """

    identified_client_state: "__client_v1__.IdentifiedClientState" = (
        betterproto.message_field(1)
    )
    """client state associated with the channel"""

    proof: bytes = betterproto.bytes_field(2)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryChannelConsensusStateRequest(betterproto.Message):
    """
    QueryChannelConsensusStateRequest is the request type for the
     Query/ConsensusState RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    revision_number: int = betterproto.uint64_field(3)
    """revision number of the consensus state"""

    revision_height: int = betterproto.uint64_field(4)
    """revision height of the consensus state"""


@dataclass(eq=False, repr=False)
class QueryChannelConsensusStateResponse(betterproto.Message):
    """
    QueryChannelClientStateResponse is the Response type for the
     Query/QueryChannelClientState RPC method
    """

    consensus_state: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        1
    )
    """consensus state associated with the channel"""

    client_id: str = betterproto.string_field(2)
    """client ID associated with the consensus state"""

    proof: bytes = betterproto.bytes_field(3)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryPacketCommitmentRequest(betterproto.Message):
    """
    QueryPacketCommitmentRequest is the request type for the
     Query/PacketCommitment RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    sequence: int = betterproto.uint64_field(3)
    """packet sequence"""


@dataclass(eq=False, repr=False)
class QueryPacketCommitmentResponse(betterproto.Message):
    """
    QueryPacketCommitmentResponse defines the client query response for a packet
     which also includes a proof and the height from which the proof was
     retrieved
    """

    commitment: bytes = betterproto.bytes_field(1)
    """packet associated with the request fields"""

    proof: bytes = betterproto.bytes_field(2)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryPacketCommitmentsRequest(betterproto.Message):
    """
    QueryPacketCommitmentsRequest is the request type for the
     Query/QueryPacketCommitments RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(3)
    )
    """pagination request"""


@dataclass(eq=False, repr=False)
class QueryPacketCommitmentsResponse(betterproto.Message):
    """
    QueryPacketCommitmentsResponse is the request type for the
     Query/QueryPacketCommitments RPC method
    """

    commitments: List["PacketState"] = betterproto.message_field(1)
    pagination: "____cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination response"""

    height: "__client_v1__.Height" = betterproto.message_field(3)
    """query block height"""


@dataclass(eq=False, repr=False)
class QueryPacketReceiptRequest(betterproto.Message):
    """
    QueryPacketReceiptRequest is the request type for the
     Query/PacketReceipt RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    sequence: int = betterproto.uint64_field(3)
    """packet sequence"""


@dataclass(eq=False, repr=False)
class QueryPacketReceiptResponse(betterproto.Message):
    """
    QueryPacketReceiptResponse defines the client query response for a packet
     receipt which also includes a proof, and the height from which the proof was
     retrieved
    """

    received: bool = betterproto.bool_field(2)
    """success flag for if receipt exists"""

    proof: bytes = betterproto.bytes_field(3)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryPacketAcknowledgementRequest(betterproto.Message):
    """
    QueryPacketAcknowledgementRequest is the request type for the
     Query/PacketAcknowledgement RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    sequence: int = betterproto.uint64_field(3)
    """packet sequence"""


@dataclass(eq=False, repr=False)
class QueryPacketAcknowledgementResponse(betterproto.Message):
    """
    QueryPacketAcknowledgementResponse defines the client query response for a
     packet which also includes a proof and the height from which the
     proof was retrieved
    """

    acknowledgement: bytes = betterproto.bytes_field(1)
    """packet associated with the request fields"""

    proof: bytes = betterproto.bytes_field(2)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryPacketAcknowledgementsRequest(betterproto.Message):
    """
    QueryPacketAcknowledgementsRequest is the request type for the
     Query/QueryPacketCommitments RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(3)
    )
    """pagination request"""

    packet_commitment_sequences: List[int] = betterproto.uint64_field(4)
    """list of packet sequences"""


@dataclass(eq=False, repr=False)
class QueryPacketAcknowledgementsResponse(betterproto.Message):
    """
    QueryPacketAcknowledgemetsResponse is the request type for the
     Query/QueryPacketAcknowledgements RPC method
    """

    acknowledgements: List["PacketState"] = betterproto.message_field(1)
    pagination: "____cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination response"""

    height: "__client_v1__.Height" = betterproto.message_field(3)
    """query block height"""


@dataclass(eq=False, repr=False)
class QueryUnreceivedPacketsRequest(betterproto.Message):
    """
    QueryUnreceivedPacketsRequest is the request type for the
     Query/UnreceivedPackets RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    packet_commitment_sequences: List[int] = betterproto.uint64_field(3)
    """list of packet sequences"""


@dataclass(eq=False, repr=False)
class QueryUnreceivedPacketsResponse(betterproto.Message):
    """
    QueryUnreceivedPacketsResponse is the response type for the
     Query/UnreceivedPacketCommitments RPC method
    """

    sequences: List[int] = betterproto.uint64_field(1)
    """list of unreceived packet sequences"""

    height: "__client_v1__.Height" = betterproto.message_field(2)
    """query block height"""


@dataclass(eq=False, repr=False)
class QueryUnreceivedAcksRequest(betterproto.Message):
    """
    QueryUnreceivedAcks is the request type for the
     Query/UnreceivedAcks RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    packet_ack_sequences: List[int] = betterproto.uint64_field(3)
    """list of acknowledgement sequences"""


@dataclass(eq=False, repr=False)
class QueryUnreceivedAcksResponse(betterproto.Message):
    """
    QueryUnreceivedAcksResponse is the response type for the
     Query/UnreceivedAcks RPC method
    """

    sequences: List[int] = betterproto.uint64_field(1)
    """list of unreceived acknowledgement sequences"""

    height: "__client_v1__.Height" = betterproto.message_field(2)
    """query block height"""


@dataclass(eq=False, repr=False)
class QueryNextSequenceReceiveRequest(betterproto.Message):
    """
    QueryNextSequenceReceiveRequest is the request type for the
     Query/QueryNextSequenceReceiveRequest RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""


@dataclass(eq=False, repr=False)
class QueryNextSequenceReceiveResponse(betterproto.Message):
    """
    QuerySequenceResponse is the request type for the
     Query/QueryNextSequenceReceiveResponse RPC method
    """

    next_sequence_receive: int = betterproto.uint64_field(1)
    """next sequence receive number"""

    proof: bytes = betterproto.bytes_field(2)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    """height at which the proof was retrieved"""


class MsgStub(betterproto.ServiceStub):
    async def channel_open_init(
        self,
        msg_channel_open_init: "MsgChannelOpenInit",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelOpenInitResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelOpenInit",
            msg_channel_open_init,
            MsgChannelOpenInitResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_open_try(
        self,
        msg_channel_open_try: "MsgChannelOpenTry",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelOpenTryResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelOpenTry",
            msg_channel_open_try,
            MsgChannelOpenTryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_open_ack(
        self,
        msg_channel_open_ack: "MsgChannelOpenAck",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelOpenAckResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelOpenAck",
            msg_channel_open_ack,
            MsgChannelOpenAckResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_open_confirm(
        self,
        msg_channel_open_confirm: "MsgChannelOpenConfirm",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelOpenConfirmResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelOpenConfirm",
            msg_channel_open_confirm,
            MsgChannelOpenConfirmResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_close_init(
        self,
        msg_channel_close_init: "MsgChannelCloseInit",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelCloseInitResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelCloseInit",
            msg_channel_close_init,
            MsgChannelCloseInitResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_close_confirm(
        self,
        msg_channel_close_confirm: "MsgChannelCloseConfirm",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelCloseConfirmResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelCloseConfirm",
            msg_channel_close_confirm,
            MsgChannelCloseConfirmResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def recv_packet(
        self,
        msg_recv_packet: "MsgRecvPacket",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgRecvPacketResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/RecvPacket",
            msg_recv_packet,
            MsgRecvPacketResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def timeout(
        self,
        msg_timeout: "MsgTimeout",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgTimeoutResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/Timeout",
            msg_timeout,
            MsgTimeoutResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def timeout_on_close(
        self,
        msg_timeout_on_close: "MsgTimeoutOnClose",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgTimeoutOnCloseResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/TimeoutOnClose",
            msg_timeout_on_close,
            MsgTimeoutOnCloseResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def acknowledgement(
        self,
        msg_acknowledgement: "MsgAcknowledgement",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgAcknowledgementResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/Acknowledgement",
            msg_acknowledgement,
            MsgAcknowledgementResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryStub(betterproto.ServiceStub):
    async def channel(
        self,
        query_channel_request: "QueryChannelRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryChannelResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/Channel",
            query_channel_request,
            QueryChannelResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channels(
        self,
        query_channels_request: "QueryChannelsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryChannelsResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/Channels",
            query_channels_request,
            QueryChannelsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def connection_channels(
        self,
        query_connection_channels_request: "QueryConnectionChannelsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryConnectionChannelsResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/ConnectionChannels",
            query_connection_channels_request,
            QueryConnectionChannelsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_client_state(
        self,
        query_channel_client_state_request: "QueryChannelClientStateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryChannelClientStateResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/ChannelClientState",
            query_channel_client_state_request,
            QueryChannelClientStateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_consensus_state(
        self,
        query_channel_consensus_state_request: "QueryChannelConsensusStateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryChannelConsensusStateResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/ChannelConsensusState",
            query_channel_consensus_state_request,
            QueryChannelConsensusStateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def packet_commitment(
        self,
        query_packet_commitment_request: "QueryPacketCommitmentRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryPacketCommitmentResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketCommitment",
            query_packet_commitment_request,
            QueryPacketCommitmentResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def packet_commitments(
        self,
        query_packet_commitments_request: "QueryPacketCommitmentsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryPacketCommitmentsResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketCommitments",
            query_packet_commitments_request,
            QueryPacketCommitmentsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def packet_receipt(
        self,
        query_packet_receipt_request: "QueryPacketReceiptRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryPacketReceiptResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketReceipt",
            query_packet_receipt_request,
            QueryPacketReceiptResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def packet_acknowledgement(
        self,
        query_packet_acknowledgement_request: "QueryPacketAcknowledgementRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryPacketAcknowledgementResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketAcknowledgement",
            query_packet_acknowledgement_request,
            QueryPacketAcknowledgementResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def packet_acknowledgements(
        self,
        query_packet_acknowledgements_request: "QueryPacketAcknowledgementsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryPacketAcknowledgementsResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketAcknowledgements",
            query_packet_acknowledgements_request,
            QueryPacketAcknowledgementsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def unreceived_packets(
        self,
        query_unreceived_packets_request: "QueryUnreceivedPacketsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryUnreceivedPacketsResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/UnreceivedPackets",
            query_unreceived_packets_request,
            QueryUnreceivedPacketsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def unreceived_acks(
        self,
        query_unreceived_acks_request: "QueryUnreceivedAcksRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryUnreceivedAcksResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/UnreceivedAcks",
            query_unreceived_acks_request,
            QueryUnreceivedAcksResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def next_sequence_receive(
        self,
        query_next_sequence_receive_request: "QueryNextSequenceReceiveRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryNextSequenceReceiveResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/NextSequenceReceive",
            query_next_sequence_receive_request,
            QueryNextSequenceReceiveResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgBase(ServiceBase):
    async def channel_open_init(
        self, msg_channel_open_init: "MsgChannelOpenInit"
    ) -> "MsgChannelOpenInitResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_open_try(
        self, msg_channel_open_try: "MsgChannelOpenTry"
    ) -> "MsgChannelOpenTryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_open_ack(
        self, msg_channel_open_ack: "MsgChannelOpenAck"
    ) -> "MsgChannelOpenAckResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_open_confirm(
        self, msg_channel_open_confirm: "MsgChannelOpenConfirm"
    ) -> "MsgChannelOpenConfirmResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_close_init(
        self, msg_channel_close_init: "MsgChannelCloseInit"
    ) -> "MsgChannelCloseInitResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_close_confirm(
        self, msg_channel_close_confirm: "MsgChannelCloseConfirm"
    ) -> "MsgChannelCloseConfirmResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def recv_packet(
        self, msg_recv_packet: "MsgRecvPacket"
    ) -> "MsgRecvPacketResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def timeout(self, msg_timeout: "MsgTimeout") -> "MsgTimeoutResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def timeout_on_close(
        self, msg_timeout_on_close: "MsgTimeoutOnClose"
    ) -> "MsgTimeoutOnCloseResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def acknowledgement(
        self, msg_acknowledgement: "MsgAcknowledgement"
    ) -> "MsgAcknowledgementResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_channel_open_init(
        self,
        stream: "grpclib.server.Stream[MsgChannelOpenInit, MsgChannelOpenInitResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_open_init(request)
        await stream.send_message(response)

    async def __rpc_channel_open_try(
        self,
        stream: "grpclib.server.Stream[MsgChannelOpenTry, MsgChannelOpenTryResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_open_try(request)
        await stream.send_message(response)

    async def __rpc_channel_open_ack(
        self,
        stream: "grpclib.server.Stream[MsgChannelOpenAck, MsgChannelOpenAckResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_open_ack(request)
        await stream.send_message(response)

    async def __rpc_channel_open_confirm(
        self,
        stream: "grpclib.server.Stream[MsgChannelOpenConfirm, MsgChannelOpenConfirmResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_open_confirm(request)
        await stream.send_message(response)

    async def __rpc_channel_close_init(
        self,
        stream: "grpclib.server.Stream[MsgChannelCloseInit, MsgChannelCloseInitResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_close_init(request)
        await stream.send_message(response)

    async def __rpc_channel_close_confirm(
        self,
        stream: "grpclib.server.Stream[MsgChannelCloseConfirm, MsgChannelCloseConfirmResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_close_confirm(request)
        await stream.send_message(response)

    async def __rpc_recv_packet(
        self, stream: "grpclib.server.Stream[MsgRecvPacket, MsgRecvPacketResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.recv_packet(request)
        await stream.send_message(response)

    async def __rpc_timeout(
        self, stream: "grpclib.server.Stream[MsgTimeout, MsgTimeoutResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.timeout(request)
        await stream.send_message(response)

    async def __rpc_timeout_on_close(
        self,
        stream: "grpclib.server.Stream[MsgTimeoutOnClose, MsgTimeoutOnCloseResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.timeout_on_close(request)
        await stream.send_message(response)

    async def __rpc_acknowledgement(
        self,
        stream: "grpclib.server.Stream[MsgAcknowledgement, MsgAcknowledgementResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.acknowledgement(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/ibc.core.channel.v1.Msg/ChannelOpenInit": grpclib.const.Handler(
                self.__rpc_channel_open_init,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelOpenInit,
                MsgChannelOpenInitResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelOpenTry": grpclib.const.Handler(
                self.__rpc_channel_open_try,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelOpenTry,
                MsgChannelOpenTryResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelOpenAck": grpclib.const.Handler(
                self.__rpc_channel_open_ack,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelOpenAck,
                MsgChannelOpenAckResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelOpenConfirm": grpclib.const.Handler(
                self.__rpc_channel_open_confirm,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelOpenConfirm,
                MsgChannelOpenConfirmResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelCloseInit": grpclib.const.Handler(
                self.__rpc_channel_close_init,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelCloseInit,
                MsgChannelCloseInitResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelCloseConfirm": grpclib.const.Handler(
                self.__rpc_channel_close_confirm,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelCloseConfirm,
                MsgChannelCloseConfirmResponse,
            ),
            "/ibc.core.channel.v1.Msg/RecvPacket": grpclib.const.Handler(
                self.__rpc_recv_packet,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgRecvPacket,
                MsgRecvPacketResponse,
            ),
            "/ibc.core.channel.v1.Msg/Timeout": grpclib.const.Handler(
                self.__rpc_timeout,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgTimeout,
                MsgTimeoutResponse,
            ),
            "/ibc.core.channel.v1.Msg/TimeoutOnClose": grpclib.const.Handler(
                self.__rpc_timeout_on_close,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgTimeoutOnClose,
                MsgTimeoutOnCloseResponse,
            ),
            "/ibc.core.channel.v1.Msg/Acknowledgement": grpclib.const.Handler(
                self.__rpc_acknowledgement,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgAcknowledgement,
                MsgAcknowledgementResponse,
            ),
        }


class QueryBase(ServiceBase):
    async def channel(
        self, query_channel_request: "QueryChannelRequest"
    ) -> "QueryChannelResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channels(
        self, query_channels_request: "QueryChannelsRequest"
    ) -> "QueryChannelsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def connection_channels(
        self, query_connection_channels_request: "QueryConnectionChannelsRequest"
    ) -> "QueryConnectionChannelsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_client_state(
        self, query_channel_client_state_request: "QueryChannelClientStateRequest"
    ) -> "QueryChannelClientStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_consensus_state(
        self, query_channel_consensus_state_request: "QueryChannelConsensusStateRequest"
    ) -> "QueryChannelConsensusStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_commitment(
        self, query_packet_commitment_request: "QueryPacketCommitmentRequest"
    ) -> "QueryPacketCommitmentResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_commitments(
        self, query_packet_commitments_request: "QueryPacketCommitmentsRequest"
    ) -> "QueryPacketCommitmentsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_receipt(
        self, query_packet_receipt_request: "QueryPacketReceiptRequest"
    ) -> "QueryPacketReceiptResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_acknowledgement(
        self, query_packet_acknowledgement_request: "QueryPacketAcknowledgementRequest"
    ) -> "QueryPacketAcknowledgementResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_acknowledgements(
        self,
        query_packet_acknowledgements_request: "QueryPacketAcknowledgementsRequest",
    ) -> "QueryPacketAcknowledgementsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def unreceived_packets(
        self, query_unreceived_packets_request: "QueryUnreceivedPacketsRequest"
    ) -> "QueryUnreceivedPacketsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def unreceived_acks(
        self, query_unreceived_acks_request: "QueryUnreceivedAcksRequest"
    ) -> "QueryUnreceivedAcksResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def next_sequence_receive(
        self, query_next_sequence_receive_request: "QueryNextSequenceReceiveRequest"
    ) -> "QueryNextSequenceReceiveResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_channel(
        self, stream: "grpclib.server.Stream[QueryChannelRequest, QueryChannelResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel(request)
        await stream.send_message(response)

    async def __rpc_channels(
        self,
        stream: "grpclib.server.Stream[QueryChannelsRequest, QueryChannelsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channels(request)
        await stream.send_message(response)

    async def __rpc_connection_channels(
        self,
        stream: "grpclib.server.Stream[QueryConnectionChannelsRequest, QueryConnectionChannelsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.connection_channels(request)
        await stream.send_message(response)

    async def __rpc_channel_client_state(
        self,
        stream: "grpclib.server.Stream[QueryChannelClientStateRequest, QueryChannelClientStateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_client_state(request)
        await stream.send_message(response)

    async def __rpc_channel_consensus_state(
        self,
        stream: "grpclib.server.Stream[QueryChannelConsensusStateRequest, QueryChannelConsensusStateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_consensus_state(request)
        await stream.send_message(response)

    async def __rpc_packet_commitment(
        self,
        stream: "grpclib.server.Stream[QueryPacketCommitmentRequest, QueryPacketCommitmentResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.packet_commitment(request)
        await stream.send_message(response)

    async def __rpc_packet_commitments(
        self,
        stream: "grpclib.server.Stream[QueryPacketCommitmentsRequest, QueryPacketCommitmentsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.packet_commitments(request)
        await stream.send_message(response)

    async def __rpc_packet_receipt(
        self,
        stream: "grpclib.server.Stream[QueryPacketReceiptRequest, QueryPacketReceiptResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.packet_receipt(request)
        await stream.send_message(response)

    async def __rpc_packet_acknowledgement(
        self,
        stream: "grpclib.server.Stream[QueryPacketAcknowledgementRequest, QueryPacketAcknowledgementResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.packet_acknowledgement(request)
        await stream.send_message(response)

    async def __rpc_packet_acknowledgements(
        self,
        stream: "grpclib.server.Stream[QueryPacketAcknowledgementsRequest, QueryPacketAcknowledgementsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.packet_acknowledgements(request)
        await stream.send_message(response)

    async def __rpc_unreceived_packets(
        self,
        stream: "grpclib.server.Stream[QueryUnreceivedPacketsRequest, QueryUnreceivedPacketsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.unreceived_packets(request)
        await stream.send_message(response)

    async def __rpc_unreceived_acks(
        self,
        stream: "grpclib.server.Stream[QueryUnreceivedAcksRequest, QueryUnreceivedAcksResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.unreceived_acks(request)
        await stream.send_message(response)

    async def __rpc_next_sequence_receive(
        self,
        stream: "grpclib.server.Stream[QueryNextSequenceReceiveRequest, QueryNextSequenceReceiveResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.next_sequence_receive(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/ibc.core.channel.v1.Query/Channel": grpclib.const.Handler(
                self.__rpc_channel,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryChannelRequest,
                QueryChannelResponse,
            ),
            "/ibc.core.channel.v1.Query/Channels": grpclib.const.Handler(
                self.__rpc_channels,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryChannelsRequest,
                QueryChannelsResponse,
            ),
            "/ibc.core.channel.v1.Query/ConnectionChannels": grpclib.const.Handler(
                self.__rpc_connection_channels,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryConnectionChannelsRequest,
                QueryConnectionChannelsResponse,
            ),
            "/ibc.core.channel.v1.Query/ChannelClientState": grpclib.const.Handler(
                self.__rpc_channel_client_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryChannelClientStateRequest,
                QueryChannelClientStateResponse,
            ),
            "/ibc.core.channel.v1.Query/ChannelConsensusState": grpclib.const.Handler(
                self.__rpc_channel_consensus_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryChannelConsensusStateRequest,
                QueryChannelConsensusStateResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketCommitment": grpclib.const.Handler(
                self.__rpc_packet_commitment,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketCommitmentRequest,
                QueryPacketCommitmentResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketCommitments": grpclib.const.Handler(
                self.__rpc_packet_commitments,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketCommitmentsRequest,
                QueryPacketCommitmentsResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketReceipt": grpclib.const.Handler(
                self.__rpc_packet_receipt,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketReceiptRequest,
                QueryPacketReceiptResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketAcknowledgement": grpclib.const.Handler(
                self.__rpc_packet_acknowledgement,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketAcknowledgementRequest,
                QueryPacketAcknowledgementResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketAcknowledgements": grpclib.const.Handler(
                self.__rpc_packet_acknowledgements,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketAcknowledgementsRequest,
                QueryPacketAcknowledgementsResponse,
            ),
            "/ibc.core.channel.v1.Query/UnreceivedPackets": grpclib.const.Handler(
                self.__rpc_unreceived_packets,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryUnreceivedPacketsRequest,
                QueryUnreceivedPacketsResponse,
            ),
            "/ibc.core.channel.v1.Query/UnreceivedAcks": grpclib.const.Handler(
                self.__rpc_unreceived_acks,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryUnreceivedAcksRequest,
                QueryUnreceivedAcksResponse,
            ),
            "/ibc.core.channel.v1.Query/NextSequenceReceive": grpclib.const.Handler(
                self.__rpc_next_sequence_receive,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryNextSequenceReceiveRequest,
                QueryNextSequenceReceiveResponse,
            ),
        }
