# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: ethermint/evm/v1/evm.proto, ethermint/evm/v1/genesis.proto, ethermint/evm/v1/query.proto, ethermint/evm/v1/tx.proto
# plugin: python-betterproto
# This file has been @generated

from dataclasses import dataclass
from datetime import datetime
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....cosmos.base.query import v1beta1 as ___cosmos_base_query_v1_beta1__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params defines the EVM module parameters"""

    evm_denom: str = betterproto.string_field(1)
    """
    evm denom represents the token denomination used to run the EVM state
     transitions.
    """

    enable_create: bool = betterproto.bool_field(2)
    """
    enable create toggles state transitions that use the vm.Create function
    """

    enable_call: bool = betterproto.bool_field(3)
    """enable call toggles state transitions that use the vm.Call function"""

    extra_eips: List[int] = betterproto.int64_field(4)
    """extra eips defines the additional EIPs for the vm.Config"""

    chain_config: "ChainConfig" = betterproto.message_field(5)
    """chain config defines the EVM chain configuration parameters"""

    allow_unprotected_txs: bool = betterproto.bool_field(6)
    """
    Allow unprotected transactions defines if replay-protected (i.e non EIP155 
     signed) transactions can be executed on the state machine.
    """


@dataclass(eq=False, repr=False)
class ChainConfig(betterproto.Message):
    """
    ChainConfig defines the Ethereum ChainConfig parameters using *sdk.Int values
     instead of *big.Int.
    """

    homestead_block: str = betterproto.string_field(1)
    """Homestead switch block (nil no fork, 0 = already homestead)"""

    dao_fork_block: str = betterproto.string_field(2)
    """TheDAO hard-fork switch block (nil no fork)"""

    dao_fork_support: bool = betterproto.bool_field(3)
    """Whether the nodes supports or opposes the DAO hard-fork"""

    eip150_block: str = betterproto.string_field(4)
    """
    EIP150 implements the Gas price changes
     (https://github.com/ethereum/EIPs/issues/150) EIP150 HF block (nil no fork)
    """

    eip150_hash: str = betterproto.string_field(5)
    """
    EIP150 HF hash (needed for header only clients as only gas pricing changed)
    """

    eip155_block: str = betterproto.string_field(6)
    """EIP155Block HF block"""

    eip158_block: str = betterproto.string_field(7)
    """EIP158 HF block"""

    byzantium_block: str = betterproto.string_field(8)
    """Byzantium switch block (nil no fork, 0 = already on byzantium)"""

    constantinople_block: str = betterproto.string_field(9)
    """Constantinople switch block (nil no fork, 0 = already activated)"""

    petersburg_block: str = betterproto.string_field(10)
    """Petersburg switch block (nil same as Constantinople)"""

    istanbul_block: str = betterproto.string_field(11)
    """Istanbul switch block (nil no fork, 0 = already on istanbul)"""

    muir_glacier_block: str = betterproto.string_field(12)
    """
    Eip-2384 (bomb delay) switch block (nil no fork, 0 = already activated)
    """

    berlin_block: str = betterproto.string_field(13)
    """Berlin switch block (nil = no fork, 0 = already on berlin)"""

    london_block: str = betterproto.string_field(17)
    """London switch block (nil = no fork, 0 = already on london)"""

    arrow_glacier_block: str = betterproto.string_field(18)
    """
    Eip-4345 (bomb delay) switch block (nil = no fork, 0 = already activated)
    """

    merge_fork_block: str = betterproto.string_field(19)
    """
    EIP-3675 (TheMerge) switch block (nil = no fork, 0 = already in merge proceedings)
    """


@dataclass(eq=False, repr=False)
class State(betterproto.Message):
    """State represents a single Storage key value pair item."""

    key: str = betterproto.string_field(1)
    value: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class TransactionLogs(betterproto.Message):
    """
    TransactionLogs define the logs generated from a transaction execution
     with a given hash. It it used for import/export data as transactions are not
     persisted on blockchain state after an upgrade.
    """

    hash: str = betterproto.string_field(1)
    logs: List["Log"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Log(betterproto.Message):
    """
    Log represents an protobuf compatible Ethereum Log that defines a contract
     log event. These events are generated by the LOG opcode and stored/indexed by
     the node.
    """

    address: str = betterproto.string_field(1)
    """address of the contract that generated the event"""

    topics: List[str] = betterproto.string_field(2)
    """list of topics provided by the contract."""

    data: bytes = betterproto.bytes_field(3)
    """supplied by the contract, usually ABI-encoded"""

    block_number: int = betterproto.uint64_field(4)
    """block in which the transaction was included"""

    tx_hash: str = betterproto.string_field(5)
    """hash of the transaction"""

    tx_index: int = betterproto.uint64_field(6)
    """index of the transaction in the block"""

    block_hash: str = betterproto.string_field(7)
    """hash of the block in which the transaction was included"""

    index: int = betterproto.uint64_field(8)
    """index of the log in the block"""

    removed: bool = betterproto.bool_field(9)
    """
    The Removed field is true if this log was reverted due to a chain
     reorganisation. You must pay attention to this field if you receive logs
     through a filter query.
    """


@dataclass(eq=False, repr=False)
class TxResult(betterproto.Message):
    """TxResult stores results of Tx execution."""

    contract_address: str = betterproto.string_field(1)
    """
    contract_address contains the ethereum address of the created contract (if
     any). If the state transition is an evm.Call, the contract address will be
     empty.
    """

    bloom: bytes = betterproto.bytes_field(2)
    """bloom represents the bloom filter bytes"""

    tx_logs: "TransactionLogs" = betterproto.message_field(3)
    """
    tx_logs contains the transaction hash and the proto-compatible ethereum
     logs.
    """

    ret: bytes = betterproto.bytes_field(4)
    """ret defines the bytes from the execution."""

    reverted: bool = betterproto.bool_field(5)
    """reverted flag is set to true when the call has been reverted"""

    gas_used: int = betterproto.uint64_field(6)
    """gas_used notes the amount of gas consumed while execution"""


@dataclass(eq=False, repr=False)
class AccessTuple(betterproto.Message):
    """AccessTuple is the element type of an access list."""

    address: str = betterproto.string_field(1)
    """hex formatted ethereum address"""

    storage_keys: List[str] = betterproto.string_field(2)
    """hex formatted hashes of the storage keys"""


@dataclass(eq=False, repr=False)
class TraceConfig(betterproto.Message):
    """TraceConfig holds extra parameters to trace functions."""

    tracer: str = betterproto.string_field(1)
    """custom javascript tracer"""

    timeout: str = betterproto.string_field(2)
    """
    overrides the default timeout of 5 seconds for JavaScript-based tracing
     calls
    """

    reexec: int = betterproto.uint64_field(3)
    """number of blocks the tracer is willing to go back"""

    disable_stack: bool = betterproto.bool_field(5)
    """disable stack capture"""

    disable_storage: bool = betterproto.bool_field(6)
    """disable storage capture"""

    debug: bool = betterproto.bool_field(8)
    """print output during capture end"""

    limit: int = betterproto.int32_field(9)
    """maximum length of output, but zero means unlimited"""

    overrides: "ChainConfig" = betterproto.message_field(10)
    """
    Chain overrides, can be used to execute a trace using future fork rules
    """

    enable_memory: bool = betterproto.bool_field(11)
    """enable memory capture"""

    enable_return_data: bool = betterproto.bool_field(12)
    """enable return data capture"""


@dataclass(eq=False, repr=False)
class MsgEthereumTx(betterproto.Message):
    """
    MsgEthereumTx encapsulates an Ethereum transaction as an SDK message.
    """

    data: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(1)
    """inner transaction data"""

    size: float = betterproto.double_field(2)
    """encoded storage size of the transaction"""

    hash: str = betterproto.string_field(3)
    """transaction hash in hex format"""

    from_: str = betterproto.string_field(4)
    """
    ethereum signer address in hex format. This address value is checked
     against the address derived from the signature (V, R, S) using the
     secp256k1 elliptic curve
    """


@dataclass(eq=False, repr=False)
class LegacyTx(betterproto.Message):
    """
    LegacyTx is the transaction data of regular Ethereum transactions.
     NOTE: All non-protected transactions (i.e non EIP155 signed) will fail if the
     AllowUnprotectedTxs parameter is disabled.
    """

    nonce: int = betterproto.uint64_field(1)
    """nonce corresponds to the account nonce (transaction sequence)."""

    gas_price: str = betterproto.string_field(2)
    """gas price defines the value for each gas unit"""

    gas: int = betterproto.uint64_field(3)
    """gas defines the gas limit defined for the transaction."""

    to: str = betterproto.string_field(4)
    """hex formatted address of the recipient"""

    value: str = betterproto.string_field(5)
    """value defines the unsigned integer value of the transaction amount."""

    data: bytes = betterproto.bytes_field(6)
    """input defines the data payload bytes of the transaction."""

    v: bytes = betterproto.bytes_field(7)
    """v defines the signature value"""

    r: bytes = betterproto.bytes_field(8)
    """r defines the signature value"""

    s: bytes = betterproto.bytes_field(9)
    """s define the signature value"""


@dataclass(eq=False, repr=False)
class AccessListTx(betterproto.Message):
    """AccessListTx is the data of EIP-2930 access list transactions."""

    chain_id: str = betterproto.string_field(1)
    """destination EVM chain ID"""

    nonce: int = betterproto.uint64_field(2)
    """nonce corresponds to the account nonce (transaction sequence)."""

    gas_price: str = betterproto.string_field(3)
    """gas price defines the value for each gas unit"""

    gas: int = betterproto.uint64_field(4)
    """gas defines the gas limit defined for the transaction."""

    to: str = betterproto.string_field(5)
    """hex formatted address of the recipient"""

    value: str = betterproto.string_field(6)
    """value defines the unsigned integer value of the transaction amount."""

    data: bytes = betterproto.bytes_field(7)
    """input defines the data payload bytes of the transaction."""

    accesses: List["AccessTuple"] = betterproto.message_field(8)
    v: bytes = betterproto.bytes_field(9)
    """v defines the signature value"""

    r: bytes = betterproto.bytes_field(10)
    """r defines the signature value"""

    s: bytes = betterproto.bytes_field(11)
    """s define the signature value"""


@dataclass(eq=False, repr=False)
class DynamicFeeTx(betterproto.Message):
    """DynamicFeeTx is the data of EIP-1559 dinamic fee transactions."""

    chain_id: str = betterproto.string_field(1)
    """destination EVM chain ID"""

    nonce: int = betterproto.uint64_field(2)
    """nonce corresponds to the account nonce (transaction sequence)."""

    gas_tip_cap: str = betterproto.string_field(3)
    """gas tip cap defines the max value for the gas tip"""

    gas_fee_cap: str = betterproto.string_field(4)
    """gas fee cap defines the max value for the gas fee"""

    gas: int = betterproto.uint64_field(5)
    """gas defines the gas limit defined for the transaction."""

    to: str = betterproto.string_field(6)
    """hex formatted address of the recipient"""

    value: str = betterproto.string_field(7)
    """value defines the the transaction amount."""

    data: bytes = betterproto.bytes_field(8)
    """input defines the data payload bytes of the transaction."""

    accesses: List["AccessTuple"] = betterproto.message_field(9)
    v: bytes = betterproto.bytes_field(10)
    """v defines the signature value"""

    r: bytes = betterproto.bytes_field(11)
    """r defines the signature value"""

    s: bytes = betterproto.bytes_field(12)
    """s define the signature value"""


@dataclass(eq=False, repr=False)
class ExtensionOptionsEthereumTx(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class MsgEthereumTxResponse(betterproto.Message):
    """MsgEthereumTxResponse defines the Msg/EthereumTx response type."""

    hash: str = betterproto.string_field(1)
    """
    ethereum transaction hash in hex format. This hash differs from the
     Tendermint sha256 hash of the transaction bytes. See
     https://github.com/tendermint/tendermint/issues/6539 for reference
    """

    logs: List["Log"] = betterproto.message_field(2)
    """
    logs contains the transaction hash and the proto-compatible ethereum
     logs.
    """

    ret: bytes = betterproto.bytes_field(3)
    """
    returned data from evm function (result or data supplied with revert
     opcode)
    """

    vm_error: str = betterproto.string_field(4)
    """vm error is the error returned by vm execution"""

    gas_used: int = betterproto.uint64_field(5)
    """gas consumed by the transaction"""


@dataclass(eq=False, repr=False)
class QueryAccountRequest(betterproto.Message):
    """
    QueryAccountRequest is the request type for the Query/Account RPC method.
    """

    address: str = betterproto.string_field(1)
    """address is the ethereum hex address to query the account for."""


@dataclass(eq=False, repr=False)
class QueryAccountResponse(betterproto.Message):
    """
    QueryAccountResponse is the response type for the Query/Account RPC method.
    """

    balance: str = betterproto.string_field(1)
    """balance is the balance of the EVM denomination."""

    code_hash: str = betterproto.string_field(2)
    """code hash is the hex-formatted code bytes from the EOA."""

    nonce: int = betterproto.uint64_field(3)
    """nonce is the account's sequence number."""


@dataclass(eq=False, repr=False)
class QueryCosmosAccountRequest(betterproto.Message):
    """
    QueryCosmosAccountRequest is the request type for the Query/CosmosAccount RPC
     method.
    """

    address: str = betterproto.string_field(1)
    """address is the ethereum hex address to query the account for."""


@dataclass(eq=False, repr=False)
class QueryCosmosAccountResponse(betterproto.Message):
    """
    QueryCosmosAccountResponse is the response type for the Query/CosmosAccount
     RPC method.
    """

    cosmos_address: str = betterproto.string_field(1)
    """cosmos_address is the cosmos address of the account."""

    sequence: int = betterproto.uint64_field(2)
    """sequence is the account's sequence number."""

    account_number: int = betterproto.uint64_field(3)
    """account_number is the account numbert"""


@dataclass(eq=False, repr=False)
class QueryValidatorAccountRequest(betterproto.Message):
    """
    QueryValidatorAccountRequest is the request type for the
     Query/ValidatorAccount RPC method.
    """

    cons_address: str = betterproto.string_field(1)
    """cons_address is the validator cons address to query the account for."""


@dataclass(eq=False, repr=False)
class QueryValidatorAccountResponse(betterproto.Message):
    """
    QueryValidatorAccountResponse is the response type for the
     Query/ValidatorAccount RPC method.
    """

    account_address: str = betterproto.string_field(1)
    """
    account_address is the cosmos address of the account in bech32 format.
    """

    sequence: int = betterproto.uint64_field(2)
    """sequence is the account's sequence number."""

    account_number: int = betterproto.uint64_field(3)
    """account_number is the account number"""


@dataclass(eq=False, repr=False)
class QueryBalanceRequest(betterproto.Message):
    """
    QueryBalanceRequest is the request type for the Query/Balance RPC method.
    """

    address: str = betterproto.string_field(1)
    """address is the ethereum hex address to query the balance for."""


@dataclass(eq=False, repr=False)
class QueryBalanceResponse(betterproto.Message):
    """
    QueryBalanceResponse is the response type for the Query/Balance RPC method.
    """

    balance: str = betterproto.string_field(1)
    """balance is the balance of the EVM denomination."""


@dataclass(eq=False, repr=False)
class QueryStorageRequest(betterproto.Message):
    """
    QueryStorageRequest is the request type for the Query/Storage RPC method.
    """

    address: str = betterproto.string_field(1)
    """
    / address is the ethereum hex address to query the storage state for.
    """

    key: str = betterproto.string_field(2)
    """key defines the key of the storage state"""


@dataclass(eq=False, repr=False)
class QueryStorageResponse(betterproto.Message):
    """
    QueryStorageResponse is the response type for the Query/Storage RPC
     method.
    """

    value: str = betterproto.string_field(1)
    """
    key defines the storage state value hash associated with the given key.
    """


@dataclass(eq=False, repr=False)
class QueryCodeRequest(betterproto.Message):
    """QueryCodeRequest is the request type for the Query/Code RPC method."""

    address: str = betterproto.string_field(1)
    """address is the ethereum hex address to query the code for."""


@dataclass(eq=False, repr=False)
class QueryCodeResponse(betterproto.Message):
    """
    QueryCodeResponse is the response type for the Query/Code RPC
     method.
    """

    code: bytes = betterproto.bytes_field(1)
    """code represents the code bytes from an ethereum address."""


@dataclass(eq=False, repr=False)
class QueryTxLogsRequest(betterproto.Message):
    """
    QueryTxLogsRequest is the request type for the Query/TxLogs RPC method.
    """

    hash: str = betterproto.string_field(1)
    """hash is the ethereum transaction hex hash to query the logs for."""

    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryTxLogsResponse(betterproto.Message):
    """QueryTxLogs is the response type for the Query/TxLogs RPC method."""

    logs: List["Log"] = betterproto.message_field(1)
    """
    logs represents the ethereum logs generated from the given transaction.
    """

    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryParamsRequest(betterproto.Message):
    """
    QueryParamsRequest defines the request type for querying x/evm parameters.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryParamsResponse(betterproto.Message):
    """
    QueryParamsResponse defines the response type for querying x/evm parameters.
    """

    params: "Params" = betterproto.message_field(1)
    """params define the evm module parameters."""


@dataclass(eq=False, repr=False)
class EthCallRequest(betterproto.Message):
    """EthCallRequest defines EthCall request"""

    args: bytes = betterproto.bytes_field(1)
    """same json format as the json rpc api."""

    gas_cap: int = betterproto.uint64_field(2)
    """the default gas cap to be used"""


@dataclass(eq=False, repr=False)
class EstimateGasResponse(betterproto.Message):
    """EstimateGasResponse defines EstimateGas response"""

    gas: int = betterproto.uint64_field(1)
    """the estimated gas"""


@dataclass(eq=False, repr=False)
class QueryTraceTxRequest(betterproto.Message):
    """QueryTraceTxRequest defines TraceTx request"""

    msg: "MsgEthereumTx" = betterproto.message_field(1)
    """msgEthereumTx for the requested transaction"""

    trace_config: "TraceConfig" = betterproto.message_field(3)
    """TraceConfig holds extra parameters to trace functions."""

    predecessors: List["MsgEthereumTx"] = betterproto.message_field(4)
    """
    the predecessor transactions included in the same block
     need to be replayed first to get correct context for tracing.
    """

    block_number: int = betterproto.int64_field(5)
    """block number of requested transaction"""

    block_hash: str = betterproto.string_field(6)
    """block hex hash of requested transaction"""

    block_time: datetime = betterproto.message_field(7)
    """block time of requested transaction"""


@dataclass(eq=False, repr=False)
class QueryTraceTxResponse(betterproto.Message):
    """QueryTraceTxResponse defines TraceTx response"""

    data: bytes = betterproto.bytes_field(1)
    """response serialized in bytes"""


@dataclass(eq=False, repr=False)
class QueryTraceBlockRequest(betterproto.Message):
    """QueryTraceBlockRequest defines TraceTx request"""

    txs: List["MsgEthereumTx"] = betterproto.message_field(1)
    """txs messages in the block"""

    trace_config: "TraceConfig" = betterproto.message_field(3)
    """TraceConfig holds extra parameters to trace functions."""

    block_number: int = betterproto.int64_field(5)
    """block number"""

    block_hash: str = betterproto.string_field(6)
    """block hex hash"""

    block_time: datetime = betterproto.message_field(7)
    """block time"""


@dataclass(eq=False, repr=False)
class QueryTraceBlockResponse(betterproto.Message):
    """QueryTraceBlockResponse defines TraceBlock response"""

    data: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QueryBaseFeeRequest(betterproto.Message):
    """
    QueryBaseFeeRequest defines the request type for querying the EIP1559 base
     fee.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryBaseFeeResponse(betterproto.Message):
    """BaseFeeResponse returns the EIP1559 base fee."""

    base_fee: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the evm module's genesis state."""

    accounts: List["GenesisAccount"] = betterproto.message_field(1)
    """accounts is an array containing the ethereum genesis accounts."""

    params: "Params" = betterproto.message_field(2)
    """params defines all the parameters of the module."""


@dataclass(eq=False, repr=False)
class GenesisAccount(betterproto.Message):
    """
    GenesisAccount defines an account to be initialized in the genesis state.
     Its main difference between with Geth's GenesisAccount is that it uses a
     custom storage type and that it doesn't contain the private key field.
    """

    address: str = betterproto.string_field(1)
    """address defines an ethereum hex formated address of an account"""

    code: str = betterproto.string_field(2)
    """code defines the hex bytes of the account code."""

    storage: List["State"] = betterproto.message_field(3)
    """storage defines the set of state key values for the account."""


class MsgStub(betterproto.ServiceStub):
    async def ethereum_tx(
        self,
        msg_ethereum_tx: "MsgEthereumTx",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgEthereumTxResponse":
        return await self._unary_unary(
            "/ethermint.evm.v1.Msg/EthereumTx",
            msg_ethereum_tx,
            MsgEthereumTxResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryStub(betterproto.ServiceStub):
    async def account(
        self,
        query_account_request: "QueryAccountRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryAccountResponse":
        return await self._unary_unary(
            "/ethermint.evm.v1.Query/Account",
            query_account_request,
            QueryAccountResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def cosmos_account(
        self,
        query_cosmos_account_request: "QueryCosmosAccountRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryCosmosAccountResponse":
        return await self._unary_unary(
            "/ethermint.evm.v1.Query/CosmosAccount",
            query_cosmos_account_request,
            QueryCosmosAccountResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def validator_account(
        self,
        query_validator_account_request: "QueryValidatorAccountRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryValidatorAccountResponse":
        return await self._unary_unary(
            "/ethermint.evm.v1.Query/ValidatorAccount",
            query_validator_account_request,
            QueryValidatorAccountResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def balance(
        self,
        query_balance_request: "QueryBalanceRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryBalanceResponse":
        return await self._unary_unary(
            "/ethermint.evm.v1.Query/Balance",
            query_balance_request,
            QueryBalanceResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def storage(
        self,
        query_storage_request: "QueryStorageRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryStorageResponse":
        return await self._unary_unary(
            "/ethermint.evm.v1.Query/Storage",
            query_storage_request,
            QueryStorageResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def code(
        self,
        query_code_request: "QueryCodeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryCodeResponse":
        return await self._unary_unary(
            "/ethermint.evm.v1.Query/Code",
            query_code_request,
            QueryCodeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def params(
        self,
        query_params_request: "QueryParamsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryParamsResponse":
        return await self._unary_unary(
            "/ethermint.evm.v1.Query/Params",
            query_params_request,
            QueryParamsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def eth_call(
        self,
        eth_call_request: "EthCallRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgEthereumTxResponse":
        return await self._unary_unary(
            "/ethermint.evm.v1.Query/EthCall",
            eth_call_request,
            MsgEthereumTxResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def estimate_gas(
        self,
        eth_call_request: "EthCallRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EstimateGasResponse":
        return await self._unary_unary(
            "/ethermint.evm.v1.Query/EstimateGas",
            eth_call_request,
            EstimateGasResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def trace_tx(
        self,
        query_trace_tx_request: "QueryTraceTxRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryTraceTxResponse":
        return await self._unary_unary(
            "/ethermint.evm.v1.Query/TraceTx",
            query_trace_tx_request,
            QueryTraceTxResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def trace_block(
        self,
        query_trace_block_request: "QueryTraceBlockRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryTraceBlockResponse":
        return await self._unary_unary(
            "/ethermint.evm.v1.Query/TraceBlock",
            query_trace_block_request,
            QueryTraceBlockResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def base_fee(
        self,
        query_base_fee_request: "QueryBaseFeeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryBaseFeeResponse":
        return await self._unary_unary(
            "/ethermint.evm.v1.Query/BaseFee",
            query_base_fee_request,
            QueryBaseFeeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgBase(ServiceBase):
    async def ethereum_tx(
        self, msg_ethereum_tx: "MsgEthereumTx"
    ) -> "MsgEthereumTxResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_ethereum_tx(
        self, stream: "grpclib.server.Stream[MsgEthereumTx, MsgEthereumTxResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.ethereum_tx(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/ethermint.evm.v1.Msg/EthereumTx": grpclib.const.Handler(
                self.__rpc_ethereum_tx,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgEthereumTx,
                MsgEthereumTxResponse,
            ),
        }


class QueryBase(ServiceBase):
    async def account(
        self, query_account_request: "QueryAccountRequest"
    ) -> "QueryAccountResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def cosmos_account(
        self, query_cosmos_account_request: "QueryCosmosAccountRequest"
    ) -> "QueryCosmosAccountResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def validator_account(
        self, query_validator_account_request: "QueryValidatorAccountRequest"
    ) -> "QueryValidatorAccountResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def balance(
        self, query_balance_request: "QueryBalanceRequest"
    ) -> "QueryBalanceResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def storage(
        self, query_storage_request: "QueryStorageRequest"
    ) -> "QueryStorageResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def code(self, query_code_request: "QueryCodeRequest") -> "QueryCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def params(
        self, query_params_request: "QueryParamsRequest"
    ) -> "QueryParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def eth_call(
        self, eth_call_request: "EthCallRequest"
    ) -> "MsgEthereumTxResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def estimate_gas(
        self, eth_call_request: "EthCallRequest"
    ) -> "EstimateGasResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def trace_tx(
        self, query_trace_tx_request: "QueryTraceTxRequest"
    ) -> "QueryTraceTxResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def trace_block(
        self, query_trace_block_request: "QueryTraceBlockRequest"
    ) -> "QueryTraceBlockResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def base_fee(
        self, query_base_fee_request: "QueryBaseFeeRequest"
    ) -> "QueryBaseFeeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_account(
        self, stream: "grpclib.server.Stream[QueryAccountRequest, QueryAccountResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.account(request)
        await stream.send_message(response)

    async def __rpc_cosmos_account(
        self,
        stream: "grpclib.server.Stream[QueryCosmosAccountRequest, QueryCosmosAccountResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.cosmos_account(request)
        await stream.send_message(response)

    async def __rpc_validator_account(
        self,
        stream: "grpclib.server.Stream[QueryValidatorAccountRequest, QueryValidatorAccountResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.validator_account(request)
        await stream.send_message(response)

    async def __rpc_balance(
        self, stream: "grpclib.server.Stream[QueryBalanceRequest, QueryBalanceResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.balance(request)
        await stream.send_message(response)

    async def __rpc_storage(
        self, stream: "grpclib.server.Stream[QueryStorageRequest, QueryStorageResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.storage(request)
        await stream.send_message(response)

    async def __rpc_code(
        self, stream: "grpclib.server.Stream[QueryCodeRequest, QueryCodeResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.code(request)
        await stream.send_message(response)

    async def __rpc_params(
        self, stream: "grpclib.server.Stream[QueryParamsRequest, QueryParamsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.params(request)
        await stream.send_message(response)

    async def __rpc_eth_call(
        self, stream: "grpclib.server.Stream[EthCallRequest, MsgEthereumTxResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.eth_call(request)
        await stream.send_message(response)

    async def __rpc_estimate_gas(
        self, stream: "grpclib.server.Stream[EthCallRequest, EstimateGasResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.estimate_gas(request)
        await stream.send_message(response)

    async def __rpc_trace_tx(
        self, stream: "grpclib.server.Stream[QueryTraceTxRequest, QueryTraceTxResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.trace_tx(request)
        await stream.send_message(response)

    async def __rpc_trace_block(
        self,
        stream: "grpclib.server.Stream[QueryTraceBlockRequest, QueryTraceBlockResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.trace_block(request)
        await stream.send_message(response)

    async def __rpc_base_fee(
        self, stream: "grpclib.server.Stream[QueryBaseFeeRequest, QueryBaseFeeResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.base_fee(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/ethermint.evm.v1.Query/Account": grpclib.const.Handler(
                self.__rpc_account,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryAccountRequest,
                QueryAccountResponse,
            ),
            "/ethermint.evm.v1.Query/CosmosAccount": grpclib.const.Handler(
                self.__rpc_cosmos_account,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryCosmosAccountRequest,
                QueryCosmosAccountResponse,
            ),
            "/ethermint.evm.v1.Query/ValidatorAccount": grpclib.const.Handler(
                self.__rpc_validator_account,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryValidatorAccountRequest,
                QueryValidatorAccountResponse,
            ),
            "/ethermint.evm.v1.Query/Balance": grpclib.const.Handler(
                self.__rpc_balance,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryBalanceRequest,
                QueryBalanceResponse,
            ),
            "/ethermint.evm.v1.Query/Storage": grpclib.const.Handler(
                self.__rpc_storage,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryStorageRequest,
                QueryStorageResponse,
            ),
            "/ethermint.evm.v1.Query/Code": grpclib.const.Handler(
                self.__rpc_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryCodeRequest,
                QueryCodeResponse,
            ),
            "/ethermint.evm.v1.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryParamsRequest,
                QueryParamsResponse,
            ),
            "/ethermint.evm.v1.Query/EthCall": grpclib.const.Handler(
                self.__rpc_eth_call,
                grpclib.const.Cardinality.UNARY_UNARY,
                EthCallRequest,
                MsgEthereumTxResponse,
            ),
            "/ethermint.evm.v1.Query/EstimateGas": grpclib.const.Handler(
                self.__rpc_estimate_gas,
                grpclib.const.Cardinality.UNARY_UNARY,
                EthCallRequest,
                EstimateGasResponse,
            ),
            "/ethermint.evm.v1.Query/TraceTx": grpclib.const.Handler(
                self.__rpc_trace_tx,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryTraceTxRequest,
                QueryTraceTxResponse,
            ),
            "/ethermint.evm.v1.Query/TraceBlock": grpclib.const.Handler(
                self.__rpc_trace_block,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryTraceBlockRequest,
                QueryTraceBlockResponse,
            ),
            "/ethermint.evm.v1.Query/BaseFee": grpclib.const.Handler(
                self.__rpc_base_fee,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryBaseFeeRequest,
                QueryBaseFeeResponse,
            ),
        }
