# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: cosmwasm/wasm/v1/genesis.proto, cosmwasm/wasm/v1/ibc.proto, cosmwasm/wasm/v1/proposal.proto, cosmwasm/wasm/v1/query.proto, cosmwasm/wasm/v1/tx.proto, cosmwasm/wasm/v1/types.proto
# plugin: python-betterproto
# This file has been @generated

from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....cosmos.base import v1beta1 as ___cosmos_base_v1_beta1__
from ....cosmos.base.query import v1beta1 as ___cosmos_base_query_v1_beta1__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class AccessType(betterproto.Enum):
    """AccessType permission types"""

    UNSPECIFIED = 0
    """AccessTypeUnspecified placeholder for empty value"""

    NOBODY = 1
    """AccessTypeNobody forbidden"""

    ONLY_ADDRESS = 2
    """AccessTypeOnlyAddress restricted to an address"""

    EVERYBODY = 3
    """AccessTypeEverybody unrestricted"""


class ContractCodeHistoryOperationType(betterproto.Enum):
    """ContractCodeHistoryOperationType actions that caused a code change"""

    UNSPECIFIED = 0
    """
    ContractCodeHistoryOperationTypeUnspecified placeholder for empty value
    """

    INIT = 1
    """ContractCodeHistoryOperationTypeInit on chain contract instantiation"""

    MIGRATE = 2
    """ContractCodeHistoryOperationTypeMigrate code migration"""

    GENESIS = 3
    """ContractCodeHistoryOperationTypeGenesis based on genesis data"""


@dataclass(eq=False, repr=False)
class AccessTypeParam(betterproto.Message):
    """AccessTypeParam"""

    value: "AccessType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class AccessConfig(betterproto.Message):
    """AccessConfig access control type."""

    permission: "AccessType" = betterproto.enum_field(1)
    address: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params defines the set of wasm parameters."""

    code_upload_access: "AccessConfig" = betterproto.message_field(1)
    instantiate_default_permission: "AccessType" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class CodeInfo(betterproto.Message):
    """CodeInfo is data for the uploaded contract WASM code"""

    code_hash: bytes = betterproto.bytes_field(1)
    """CodeHash is the unique identifier created by wasmvm"""

    creator: str = betterproto.string_field(2)
    """Creator address who initially stored the code"""

    instantiate_config: "AccessConfig" = betterproto.message_field(5)
    """
    InstantiateConfig access control to apply on contract creation, optional
    """


@dataclass(eq=False, repr=False)
class ContractInfo(betterproto.Message):
    """ContractInfo stores a WASM contract instance"""

    code_id: int = betterproto.uint64_field(1)
    """CodeID is the reference to the stored Wasm code"""

    creator: str = betterproto.string_field(2)
    """Creator address who initially instantiated the contract"""

    admin: str = betterproto.string_field(3)
    """Admin is an optional address that can execute migrations"""

    label: str = betterproto.string_field(4)
    """Label is optional metadata to be stored with a contract instance."""

    created: "AbsoluteTxPosition" = betterproto.message_field(5)
    """
    Created Tx position when the contract was instantiated.
     This data should kept internal and not be exposed via query results. Just
     use for sorting
    """

    ibc_port_id: str = betterproto.string_field(6)
    extension: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(7)
    """
    Extension is an extension point to store custom metadata within the
     persistence model.
    """


@dataclass(eq=False, repr=False)
class ContractCodeHistoryEntry(betterproto.Message):
    """ContractCodeHistoryEntry metadata to a contract."""

    operation: "ContractCodeHistoryOperationType" = betterproto.enum_field(1)
    code_id: int = betterproto.uint64_field(2)
    """CodeID is the reference to the stored WASM code"""

    updated: "AbsoluteTxPosition" = betterproto.message_field(3)
    """Updated Tx position when the operation was executed."""

    msg: bytes = betterproto.bytes_field(4)


@dataclass(eq=False, repr=False)
class AbsoluteTxPosition(betterproto.Message):
    """
    AbsoluteTxPosition is a unique transaction position that allows for global
     ordering of transactions.
    """

    block_height: int = betterproto.uint64_field(1)
    """BlockHeight is the block the contract was created at"""

    tx_index: int = betterproto.uint64_field(2)
    """
    TxIndex is a monotonic counter within the block (actual transaction index,
     or gas consumed)
    """


@dataclass(eq=False, repr=False)
class Model(betterproto.Message):
    """Model is a struct that holds a KV pair"""

    key: bytes = betterproto.bytes_field(1)
    """hex-encode key to read it better (this is often ascii)"""

    value: bytes = betterproto.bytes_field(2)
    """base64-encode raw value"""


@dataclass(eq=False, repr=False)
class MsgStoreCode(betterproto.Message):
    """MsgStoreCode submit Wasm code to the system"""

    sender: str = betterproto.string_field(1)
    """Sender is the that actor that signed the messages"""

    wasm_byte_code: bytes = betterproto.bytes_field(2)
    """WASMByteCode can be raw or gzip compressed"""

    instantiate_permission: "AccessConfig" = betterproto.message_field(5)
    """
    InstantiatePermission access control to apply on contract creation,
     optional
    """


@dataclass(eq=False, repr=False)
class MsgStoreCodeResponse(betterproto.Message):
    """MsgStoreCodeResponse returns store result data."""

    code_id: int = betterproto.uint64_field(1)
    """CodeID is the reference to the stored WASM code"""


@dataclass(eq=False, repr=False)
class MsgInstantiateContract(betterproto.Message):
    """
    MsgInstantiateContract create a new smart contract instance for the given
     code id.
    """

    sender: str = betterproto.string_field(1)
    """Sender is the that actor that signed the messages"""

    admin: str = betterproto.string_field(2)
    """Admin is an optional address that can execute migrations"""

    code_id: int = betterproto.uint64_field(3)
    """CodeID is the reference to the stored WASM code"""

    label: str = betterproto.string_field(4)
    """Label is optional metadata to be stored with a contract instance."""

    msg: bytes = betterproto.bytes_field(5)
    """
    Msg json encoded message to be passed to the contract on instantiation
    """

    funds: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(6)
    """Funds coins that are transferred to the contract on instantiation"""


@dataclass(eq=False, repr=False)
class MsgInstantiateContractResponse(betterproto.Message):
    """MsgInstantiateContractResponse return instantiation result data"""

    address: str = betterproto.string_field(1)
    """Address is the bech32 address of the new contract instance."""

    data: bytes = betterproto.bytes_field(2)
    """Data contains base64-encoded bytes to returned from the contract"""


@dataclass(eq=False, repr=False)
class MsgExecuteContract(betterproto.Message):
    """
    MsgExecuteContract submits the given message data to a smart contract
    """

    sender: str = betterproto.string_field(1)
    """Sender is the that actor that signed the messages"""

    contract: str = betterproto.string_field(2)
    """Contract is the address of the smart contract"""

    msg: bytes = betterproto.bytes_field(3)
    """Msg json encoded message to be passed to the contract"""

    funds: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(5)
    """Funds coins that are transferred to the contract on execution"""


@dataclass(eq=False, repr=False)
class MsgExecuteContractResponse(betterproto.Message):
    """MsgExecuteContractResponse returns execution result data."""

    data: bytes = betterproto.bytes_field(1)
    """Data contains base64-encoded bytes to returned from the contract"""


@dataclass(eq=False, repr=False)
class MsgMigrateContract(betterproto.Message):
    """
    MsgMigrateContract runs a code upgrade/ downgrade for a smart contract
    """

    sender: str = betterproto.string_field(1)
    """Sender is the that actor that signed the messages"""

    contract: str = betterproto.string_field(2)
    """Contract is the address of the smart contract"""

    code_id: int = betterproto.uint64_field(3)
    """CodeID references the new WASM code"""

    msg: bytes = betterproto.bytes_field(4)
    """Msg json encoded message to be passed to the contract on migration"""


@dataclass(eq=False, repr=False)
class MsgMigrateContractResponse(betterproto.Message):
    """MsgMigrateContractResponse returns contract migration result data."""

    data: bytes = betterproto.bytes_field(1)
    """
    Data contains same raw bytes returned as data from the wasm contract.
     (May be empty)
    """


@dataclass(eq=False, repr=False)
class MsgUpdateAdmin(betterproto.Message):
    """MsgUpdateAdmin sets a new admin for a smart contract"""

    sender: str = betterproto.string_field(1)
    """Sender is the that actor that signed the messages"""

    new_admin: str = betterproto.string_field(2)
    """NewAdmin address to be set"""

    contract: str = betterproto.string_field(3)
    """Contract is the address of the smart contract"""


@dataclass(eq=False, repr=False)
class MsgUpdateAdminResponse(betterproto.Message):
    """MsgUpdateAdminResponse returns empty data"""

    pass


@dataclass(eq=False, repr=False)
class MsgClearAdmin(betterproto.Message):
    """MsgClearAdmin removes any admin stored for a smart contract"""

    sender: str = betterproto.string_field(1)
    """Sender is the that actor that signed the messages"""

    contract: str = betterproto.string_field(3)
    """Contract is the address of the smart contract"""


@dataclass(eq=False, repr=False)
class MsgClearAdminResponse(betterproto.Message):
    """MsgClearAdminResponse returns empty data"""

    pass


@dataclass(eq=False, repr=False)
class QueryContractInfoRequest(betterproto.Message):
    """
    QueryContractInfoRequest is the request type for the Query/ContractInfo RPC
     method
    """

    address: str = betterproto.string_field(1)
    """address is the address of the contract to query"""


@dataclass(eq=False, repr=False)
class QueryContractInfoResponse(betterproto.Message):
    """
    QueryContractInfoResponse is the response type for the Query/ContractInfo RPC
     method
    """

    address: str = betterproto.string_field(1)
    """address is the address of the contract"""

    contract_info: "ContractInfo" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryContractHistoryRequest(betterproto.Message):
    """
    QueryContractHistoryRequest is the request type for the Query/ContractHistory
     RPC method
    """

    address: str = betterproto.string_field(1)
    """address is the address of the contract to query"""

    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryContractHistoryResponse(betterproto.Message):
    """
    QueryContractHistoryResponse is the response type for the
     Query/ContractHistory RPC method
    """

    entries: List["ContractCodeHistoryEntry"] = betterproto.message_field(1)
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryContractsByCodeRequest(betterproto.Message):
    """
    QueryContractsByCodeRequest is the request type for the Query/ContractsByCode
     RPC method
    """

    code_id: int = betterproto.uint64_field(1)
    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryContractsByCodeResponse(betterproto.Message):
    """
    QueryContractsByCodeResponse is the response type for the
     Query/ContractsByCode RPC method
    """

    contracts: List[str] = betterproto.string_field(1)
    """contracts are a set of contract addresses"""

    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryAllContractStateRequest(betterproto.Message):
    """
    QueryAllContractStateRequest is the request type for the
     Query/AllContractState RPC method
    """

    address: str = betterproto.string_field(1)
    """address is the address of the contract"""

    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryAllContractStateResponse(betterproto.Message):
    """
    QueryAllContractStateResponse is the response type for the
     Query/AllContractState RPC method
    """

    models: List["Model"] = betterproto.message_field(1)
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryRawContractStateRequest(betterproto.Message):
    """
    QueryRawContractStateRequest is the request type for the
     Query/RawContractState RPC method
    """

    address: str = betterproto.string_field(1)
    """address is the address of the contract"""

    query_data: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class QueryRawContractStateResponse(betterproto.Message):
    """
    QueryRawContractStateResponse is the response type for the
     Query/RawContractState RPC method
    """

    data: bytes = betterproto.bytes_field(1)
    """Data contains the raw store data"""


@dataclass(eq=False, repr=False)
class QuerySmartContractStateRequest(betterproto.Message):
    """
    QuerySmartContractStateRequest is the request type for the
     Query/SmartContractState RPC method
    """

    address: str = betterproto.string_field(1)
    """address is the address of the contract"""

    query_data: bytes = betterproto.bytes_field(2)
    """QueryData contains the query data passed to the contract"""


@dataclass(eq=False, repr=False)
class QuerySmartContractStateResponse(betterproto.Message):
    """
    QuerySmartContractStateResponse is the response type for the
     Query/SmartContractState RPC method
    """

    data: bytes = betterproto.bytes_field(1)
    """Data contains the json data returned from the smart contract"""


@dataclass(eq=False, repr=False)
class QueryCodeRequest(betterproto.Message):
    """QueryCodeRequest is the request type for the Query/Code RPC method"""

    code_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class CodeInfoResponse(betterproto.Message):
    """CodeInfoResponse contains code meta data from CodeInfo"""

    code_id: int = betterproto.uint64_field(1)
    creator: str = betterproto.string_field(2)
    data_hash: bytes = betterproto.bytes_field(3)
    instantiate_permission: "AccessConfig" = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class QueryCodeResponse(betterproto.Message):
    """QueryCodeResponse is the response type for the Query/Code RPC method"""

    code_info: "CodeInfoResponse" = betterproto.message_field(1)
    data: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class QueryCodesRequest(betterproto.Message):
    """QueryCodesRequest is the request type for the Query/Codes RPC method"""

    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(1)
    )
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryCodesResponse(betterproto.Message):
    """
    QueryCodesResponse is the response type for the Query/Codes RPC method
    """

    code_infos: List["CodeInfoResponse"] = betterproto.message_field(1)
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryPinnedCodesRequest(betterproto.Message):
    """
    QueryPinnedCodesRequest is the request type for the Query/PinnedCodes
     RPC method
    """

    pagination: "___cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryPinnedCodesResponse(betterproto.Message):
    """
    QueryPinnedCodesResponse is the response type for the
     Query/PinnedCodes RPC method
    """

    code_ids: List[int] = betterproto.uint64_field(1)
    pagination: "___cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState - genesis state of x/wasm"""

    params: "Params" = betterproto.message_field(1)
    codes: List["Code"] = betterproto.message_field(2)
    contracts: List["Contract"] = betterproto.message_field(3)
    sequences: List["Sequence"] = betterproto.message_field(4)
    gen_msgs: List["GenesisStateGenMsgs"] = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class GenesisStateGenMsgs(betterproto.Message):
    """
    GenMsgs define the messages that can be executed during genesis phase in
     order. The intention is to have more human readable data that is auditable.
    """

    store_code: "MsgStoreCode" = betterproto.message_field(1, group="sum")
    instantiate_contract: "MsgInstantiateContract" = betterproto.message_field(
        2, group="sum"
    )
    execute_contract: "MsgExecuteContract" = betterproto.message_field(3, group="sum")


@dataclass(eq=False, repr=False)
class Code(betterproto.Message):
    """Code struct encompasses CodeInfo and CodeBytes"""

    code_id: int = betterproto.uint64_field(1)
    code_info: "CodeInfo" = betterproto.message_field(2)
    code_bytes: bytes = betterproto.bytes_field(3)
    pinned: bool = betterproto.bool_field(4)
    """Pinned to wasmvm cache"""


@dataclass(eq=False, repr=False)
class Contract(betterproto.Message):
    """
    Contract struct encompasses ContractAddress, ContractInfo, and ContractState
    """

    contract_address: str = betterproto.string_field(1)
    contract_info: "ContractInfo" = betterproto.message_field(2)
    contract_state: List["Model"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class Sequence(betterproto.Message):
    """Sequence key and value of an id generation counter"""

    id_key: bytes = betterproto.bytes_field(1)
    value: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class StoreCodeProposal(betterproto.Message):
    """
    StoreCodeProposal gov proposal content type to submit WASM code to the system
    """

    title: str = betterproto.string_field(1)
    """Title is a short summary"""

    description: str = betterproto.string_field(2)
    """Description is a human readable text"""

    run_as: str = betterproto.string_field(3)
    """
    RunAs is the address that is passed to the contract's environment as sender
    """

    wasm_byte_code: bytes = betterproto.bytes_field(4)
    """WASMByteCode can be raw or gzip compressed"""

    instantiate_permission: "AccessConfig" = betterproto.message_field(7)
    """InstantiatePermission to apply on contract creation, optional"""


@dataclass(eq=False, repr=False)
class InstantiateContractProposal(betterproto.Message):
    """
    InstantiateContractProposal gov proposal content type to instantiate a
     contract.
    """

    title: str = betterproto.string_field(1)
    """Title is a short summary"""

    description: str = betterproto.string_field(2)
    """Description is a human readable text"""

    run_as: str = betterproto.string_field(3)
    """
    RunAs is the address that is passed to the contract's environment as sender
    """

    admin: str = betterproto.string_field(4)
    """Admin is an optional address that can execute migrations"""

    code_id: int = betterproto.uint64_field(5)
    """CodeID is the reference to the stored WASM code"""

    label: str = betterproto.string_field(6)
    """Label is optional metadata to be stored with a constract instance."""

    msg: bytes = betterproto.bytes_field(7)
    """
    Msg json encoded message to be passed to the contract on instantiation
    """

    funds: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(8)
    """Funds coins that are transferred to the contract on instantiation"""


@dataclass(eq=False, repr=False)
class MigrateContractProposal(betterproto.Message):
    """
    MigrateContractProposal gov proposal content type to migrate a contract.
    """

    title: str = betterproto.string_field(1)
    """Title is a short summary"""

    description: str = betterproto.string_field(2)
    """Description is a human readable text"""

    contract: str = betterproto.string_field(4)
    """Contract is the address of the smart contract"""

    code_id: int = betterproto.uint64_field(5)
    """CodeID references the new WASM code"""

    msg: bytes = betterproto.bytes_field(6)
    """Msg json encoded message to be passed to the contract on migration"""


@dataclass(eq=False, repr=False)
class SudoContractProposal(betterproto.Message):
    """
    SudoContractProposal gov proposal content type to call sudo on a contract.
    """

    title: str = betterproto.string_field(1)
    """Title is a short summary"""

    description: str = betterproto.string_field(2)
    """Description is a human readable text"""

    contract: str = betterproto.string_field(3)
    """Contract is the address of the smart contract"""

    msg: bytes = betterproto.bytes_field(4)
    """Msg json encoded message to be passed to the contract as sudo"""


@dataclass(eq=False, repr=False)
class ExecuteContractProposal(betterproto.Message):
    """
    ExecuteContractProposal gov proposal content type to call execute on a
     contract.
    """

    title: str = betterproto.string_field(1)
    """Title is a short summary"""

    description: str = betterproto.string_field(2)
    """Description is a human readable text"""

    run_as: str = betterproto.string_field(3)
    """
    RunAs is the address that is passed to the contract's environment as sender
    """

    contract: str = betterproto.string_field(4)
    """Contract is the address of the smart contract"""

    msg: bytes = betterproto.bytes_field(5)
    """Msg json encoded message to be passed to the contract as execute"""

    funds: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(6)
    """Funds coins that are transferred to the contract on instantiation"""


@dataclass(eq=False, repr=False)
class UpdateAdminProposal(betterproto.Message):
    """
    UpdateAdminProposal gov proposal content type to set an admin for a contract.
    """

    title: str = betterproto.string_field(1)
    """Title is a short summary"""

    description: str = betterproto.string_field(2)
    """Description is a human readable text"""

    new_admin: str = betterproto.string_field(3)
    """NewAdmin address to be set"""

    contract: str = betterproto.string_field(4)
    """Contract is the address of the smart contract"""


@dataclass(eq=False, repr=False)
class ClearAdminProposal(betterproto.Message):
    """
    ClearAdminProposal gov proposal content type to clear the admin of a
     contract.
    """

    title: str = betterproto.string_field(1)
    """Title is a short summary"""

    description: str = betterproto.string_field(2)
    """Description is a human readable text"""

    contract: str = betterproto.string_field(3)
    """Contract is the address of the smart contract"""


@dataclass(eq=False, repr=False)
class PinCodesProposal(betterproto.Message):
    """
    PinCodesProposal gov proposal content type to pin a set of code ids in the
     wasmvm cache.
    """

    title: str = betterproto.string_field(1)
    """Title is a short summary"""

    description: str = betterproto.string_field(2)
    """Description is a human readable text"""

    code_ids: List[int] = betterproto.uint64_field(3)
    """CodeIDs references the new WASM codes"""


@dataclass(eq=False, repr=False)
class UnpinCodesProposal(betterproto.Message):
    """
    UnpinCodesProposal gov proposal content type to unpin a set of code ids in
     the wasmvm cache.
    """

    title: str = betterproto.string_field(1)
    """Title is a short summary"""

    description: str = betterproto.string_field(2)
    """Description is a human readable text"""

    code_ids: List[int] = betterproto.uint64_field(3)
    """CodeIDs references the WASM codes"""


@dataclass(eq=False, repr=False)
class AccessConfigUpdate(betterproto.Message):
    """
    AccessConfigUpdate contains the code id and the access config to be
     applied.
    """

    code_id: int = betterproto.uint64_field(1)
    """CodeID is the reference to the stored WASM code to be updated"""

    instantiate_permission: "AccessConfig" = betterproto.message_field(2)
    """InstantiatePermission to apply to the set of code ids"""


@dataclass(eq=False, repr=False)
class UpdateInstantiateConfigProposal(betterproto.Message):
    """
    UpdateInstantiateConfigProposal gov proposal content type to update
     instantiate config to a  set of code ids.
    """

    title: str = betterproto.string_field(1)
    """Title is a short summary"""

    description: str = betterproto.string_field(2)
    """Description is a human readable text"""

    access_config_updates: List["AccessConfigUpdate"] = betterproto.message_field(3)
    """
    AccessConfigUpdate contains the list of code ids and the access config
     to be applied.
    """


@dataclass(eq=False, repr=False)
class MsgIbcSend(betterproto.Message):
    """MsgIBCSend"""

    channel: str = betterproto.string_field(2)
    """the channel by which the packet will be sent"""

    timeout_height: int = betterproto.uint64_field(4)
    """
    Timeout height relative to the current block height.
     The timeout is disabled when set to 0.
    """

    timeout_timestamp: int = betterproto.uint64_field(5)
    """
    Timeout timestamp (in nanoseconds) relative to the current block timestamp.
     The timeout is disabled when set to 0.
    """

    data: bytes = betterproto.bytes_field(6)
    """
    Data is the payload to transfer. We must not make assumption what format or
     content is in here.
    """


@dataclass(eq=False, repr=False)
class MsgIbcCloseChannel(betterproto.Message):
    """MsgIBCCloseChannel port and channel need to be owned by the contract"""

    channel: str = betterproto.string_field(2)


class MsgStub(betterproto.ServiceStub):
    async def store_code(
        self,
        msg_store_code: "MsgStoreCode",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgStoreCodeResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Msg/StoreCode",
            msg_store_code,
            MsgStoreCodeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def instantiate_contract(
        self,
        msg_instantiate_contract: "MsgInstantiateContract",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgInstantiateContractResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Msg/InstantiateContract",
            msg_instantiate_contract,
            MsgInstantiateContractResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def execute_contract(
        self,
        msg_execute_contract: "MsgExecuteContract",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgExecuteContractResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Msg/ExecuteContract",
            msg_execute_contract,
            MsgExecuteContractResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def migrate_contract(
        self,
        msg_migrate_contract: "MsgMigrateContract",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgMigrateContractResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Msg/MigrateContract",
            msg_migrate_contract,
            MsgMigrateContractResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_admin(
        self,
        msg_update_admin: "MsgUpdateAdmin",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgUpdateAdminResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Msg/UpdateAdmin",
            msg_update_admin,
            MsgUpdateAdminResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def clear_admin(
        self,
        msg_clear_admin: "MsgClearAdmin",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgClearAdminResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Msg/ClearAdmin",
            msg_clear_admin,
            MsgClearAdminResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryStub(betterproto.ServiceStub):
    async def contract_info(
        self,
        query_contract_info_request: "QueryContractInfoRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryContractInfoResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/ContractInfo",
            query_contract_info_request,
            QueryContractInfoResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def contract_history(
        self,
        query_contract_history_request: "QueryContractHistoryRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryContractHistoryResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/ContractHistory",
            query_contract_history_request,
            QueryContractHistoryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def contracts_by_code(
        self,
        query_contracts_by_code_request: "QueryContractsByCodeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryContractsByCodeResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/ContractsByCode",
            query_contracts_by_code_request,
            QueryContractsByCodeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def all_contract_state(
        self,
        query_all_contract_state_request: "QueryAllContractStateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryAllContractStateResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/AllContractState",
            query_all_contract_state_request,
            QueryAllContractStateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def raw_contract_state(
        self,
        query_raw_contract_state_request: "QueryRawContractStateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryRawContractStateResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/RawContractState",
            query_raw_contract_state_request,
            QueryRawContractStateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def smart_contract_state(
        self,
        query_smart_contract_state_request: "QuerySmartContractStateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QuerySmartContractStateResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/SmartContractState",
            query_smart_contract_state_request,
            QuerySmartContractStateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def code(
        self,
        query_code_request: "QueryCodeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryCodeResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/Code",
            query_code_request,
            QueryCodeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def codes(
        self,
        query_codes_request: "QueryCodesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryCodesResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/Codes",
            query_codes_request,
            QueryCodesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def pinned_codes(
        self,
        query_pinned_codes_request: "QueryPinnedCodesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryPinnedCodesResponse":
        return await self._unary_unary(
            "/cosmwasm.wasm.v1.Query/PinnedCodes",
            query_pinned_codes_request,
            QueryPinnedCodesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgBase(ServiceBase):
    async def store_code(
        self, msg_store_code: "MsgStoreCode"
    ) -> "MsgStoreCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def instantiate_contract(
        self, msg_instantiate_contract: "MsgInstantiateContract"
    ) -> "MsgInstantiateContractResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def execute_contract(
        self, msg_execute_contract: "MsgExecuteContract"
    ) -> "MsgExecuteContractResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def migrate_contract(
        self, msg_migrate_contract: "MsgMigrateContract"
    ) -> "MsgMigrateContractResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_admin(
        self, msg_update_admin: "MsgUpdateAdmin"
    ) -> "MsgUpdateAdminResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def clear_admin(
        self, msg_clear_admin: "MsgClearAdmin"
    ) -> "MsgClearAdminResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_store_code(
        self, stream: "grpclib.server.Stream[MsgStoreCode, MsgStoreCodeResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.store_code(request)
        await stream.send_message(response)

    async def __rpc_instantiate_contract(
        self,
        stream: "grpclib.server.Stream[MsgInstantiateContract, MsgInstantiateContractResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.instantiate_contract(request)
        await stream.send_message(response)

    async def __rpc_execute_contract(
        self,
        stream: "grpclib.server.Stream[MsgExecuteContract, MsgExecuteContractResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.execute_contract(request)
        await stream.send_message(response)

    async def __rpc_migrate_contract(
        self,
        stream: "grpclib.server.Stream[MsgMigrateContract, MsgMigrateContractResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.migrate_contract(request)
        await stream.send_message(response)

    async def __rpc_update_admin(
        self, stream: "grpclib.server.Stream[MsgUpdateAdmin, MsgUpdateAdminResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_admin(request)
        await stream.send_message(response)

    async def __rpc_clear_admin(
        self, stream: "grpclib.server.Stream[MsgClearAdmin, MsgClearAdminResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.clear_admin(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmwasm.wasm.v1.Msg/StoreCode": grpclib.const.Handler(
                self.__rpc_store_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgStoreCode,
                MsgStoreCodeResponse,
            ),
            "/cosmwasm.wasm.v1.Msg/InstantiateContract": grpclib.const.Handler(
                self.__rpc_instantiate_contract,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgInstantiateContract,
                MsgInstantiateContractResponse,
            ),
            "/cosmwasm.wasm.v1.Msg/ExecuteContract": grpclib.const.Handler(
                self.__rpc_execute_contract,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgExecuteContract,
                MsgExecuteContractResponse,
            ),
            "/cosmwasm.wasm.v1.Msg/MigrateContract": grpclib.const.Handler(
                self.__rpc_migrate_contract,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgMigrateContract,
                MsgMigrateContractResponse,
            ),
            "/cosmwasm.wasm.v1.Msg/UpdateAdmin": grpclib.const.Handler(
                self.__rpc_update_admin,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgUpdateAdmin,
                MsgUpdateAdminResponse,
            ),
            "/cosmwasm.wasm.v1.Msg/ClearAdmin": grpclib.const.Handler(
                self.__rpc_clear_admin,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgClearAdmin,
                MsgClearAdminResponse,
            ),
        }


class QueryBase(ServiceBase):
    async def contract_info(
        self, query_contract_info_request: "QueryContractInfoRequest"
    ) -> "QueryContractInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contract_history(
        self, query_contract_history_request: "QueryContractHistoryRequest"
    ) -> "QueryContractHistoryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contracts_by_code(
        self, query_contracts_by_code_request: "QueryContractsByCodeRequest"
    ) -> "QueryContractsByCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def all_contract_state(
        self, query_all_contract_state_request: "QueryAllContractStateRequest"
    ) -> "QueryAllContractStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def raw_contract_state(
        self, query_raw_contract_state_request: "QueryRawContractStateRequest"
    ) -> "QueryRawContractStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def smart_contract_state(
        self, query_smart_contract_state_request: "QuerySmartContractStateRequest"
    ) -> "QuerySmartContractStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def code(self, query_code_request: "QueryCodeRequest") -> "QueryCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def codes(
        self, query_codes_request: "QueryCodesRequest"
    ) -> "QueryCodesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pinned_codes(
        self, query_pinned_codes_request: "QueryPinnedCodesRequest"
    ) -> "QueryPinnedCodesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_contract_info(
        self,
        stream: "grpclib.server.Stream[QueryContractInfoRequest, QueryContractInfoResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.contract_info(request)
        await stream.send_message(response)

    async def __rpc_contract_history(
        self,
        stream: "grpclib.server.Stream[QueryContractHistoryRequest, QueryContractHistoryResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.contract_history(request)
        await stream.send_message(response)

    async def __rpc_contracts_by_code(
        self,
        stream: "grpclib.server.Stream[QueryContractsByCodeRequest, QueryContractsByCodeResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.contracts_by_code(request)
        await stream.send_message(response)

    async def __rpc_all_contract_state(
        self,
        stream: "grpclib.server.Stream[QueryAllContractStateRequest, QueryAllContractStateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.all_contract_state(request)
        await stream.send_message(response)

    async def __rpc_raw_contract_state(
        self,
        stream: "grpclib.server.Stream[QueryRawContractStateRequest, QueryRawContractStateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.raw_contract_state(request)
        await stream.send_message(response)

    async def __rpc_smart_contract_state(
        self,
        stream: "grpclib.server.Stream[QuerySmartContractStateRequest, QuerySmartContractStateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.smart_contract_state(request)
        await stream.send_message(response)

    async def __rpc_code(
        self, stream: "grpclib.server.Stream[QueryCodeRequest, QueryCodeResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.code(request)
        await stream.send_message(response)

    async def __rpc_codes(
        self, stream: "grpclib.server.Stream[QueryCodesRequest, QueryCodesResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.codes(request)
        await stream.send_message(response)

    async def __rpc_pinned_codes(
        self,
        stream: "grpclib.server.Stream[QueryPinnedCodesRequest, QueryPinnedCodesResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.pinned_codes(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmwasm.wasm.v1.Query/ContractInfo": grpclib.const.Handler(
                self.__rpc_contract_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryContractInfoRequest,
                QueryContractInfoResponse,
            ),
            "/cosmwasm.wasm.v1.Query/ContractHistory": grpclib.const.Handler(
                self.__rpc_contract_history,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryContractHistoryRequest,
                QueryContractHistoryResponse,
            ),
            "/cosmwasm.wasm.v1.Query/ContractsByCode": grpclib.const.Handler(
                self.__rpc_contracts_by_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryContractsByCodeRequest,
                QueryContractsByCodeResponse,
            ),
            "/cosmwasm.wasm.v1.Query/AllContractState": grpclib.const.Handler(
                self.__rpc_all_contract_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryAllContractStateRequest,
                QueryAllContractStateResponse,
            ),
            "/cosmwasm.wasm.v1.Query/RawContractState": grpclib.const.Handler(
                self.__rpc_raw_contract_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryRawContractStateRequest,
                QueryRawContractStateResponse,
            ),
            "/cosmwasm.wasm.v1.Query/SmartContractState": grpclib.const.Handler(
                self.__rpc_smart_contract_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                QuerySmartContractStateRequest,
                QuerySmartContractStateResponse,
            ),
            "/cosmwasm.wasm.v1.Query/Code": grpclib.const.Handler(
                self.__rpc_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryCodeRequest,
                QueryCodeResponse,
            ),
            "/cosmwasm.wasm.v1.Query/Codes": grpclib.const.Handler(
                self.__rpc_codes,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryCodesRequest,
                QueryCodesResponse,
            ),
            "/cosmwasm.wasm.v1.Query/PinnedCodes": grpclib.const.Handler(
                self.__rpc_pinned_codes,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPinnedCodesRequest,
                QueryPinnedCodesResponse,
            ),
        }
