# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: cosmos/staking/v1beta1/authz.proto, cosmos/staking/v1beta1/genesis.proto, cosmos/staking/v1beta1/query.proto, cosmos/staking/v1beta1/staking.proto, cosmos/staking/v1beta1/tx.proto
# plugin: python-betterproto
# This file has been @generated

from dataclasses import dataclass
from datetime import (
    datetime,
    timedelta,
)
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....tendermint import types as ___tendermint_types__
from ...base import v1beta1 as __base_v1_beta1__
from ...base.query import v1beta1 as __base_query_v1_beta1__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class BondStatus(betterproto.Enum):
    """BondStatus is the status of a validator."""

    UNSPECIFIED = 0
    """UNSPECIFIED defines an invalid validator status."""

    UNBONDED = 1
    """UNBONDED defines a validator that is not bonded."""

    UNBONDING = 2
    """UNBONDING defines a validator that is unbonding."""

    BONDED = 3
    """BONDED defines a validator that is bonded."""


class AuthorizationType(betterproto.Enum):
    """
    AuthorizationType defines the type of staking module authorization type

     Since: cosmos-sdk 0.43
    """

    UNSPECIFIED = 0
    """
    AUTHORIZATION_TYPE_UNSPECIFIED specifies an unknown authorization type
    """

    DELEGATE = 1
    """
    AUTHORIZATION_TYPE_DELEGATE defines an authorization type for Msg/Delegate
    """

    UNDELEGATE = 2
    """
    AUTHORIZATION_TYPE_UNDELEGATE defines an authorization type for Msg/Undelegate
    """

    REDELEGATE = 3
    """
    AUTHORIZATION_TYPE_REDELEGATE defines an authorization type for Msg/BeginRedelegate
    """


@dataclass(eq=False, repr=False)
class HistoricalInfo(betterproto.Message):
    """
    HistoricalInfo contains header and validator information for a given block.
     It is stored as part of staking module's state, which persists the `n` most
     recent HistoricalInfo
     (`n` is set by the staking module's `historical_entries` parameter).
    """

    header: "___tendermint_types__.Header" = betterproto.message_field(1)
    valset: List["Validator"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class CommissionRates(betterproto.Message):
    """
    CommissionRates defines the initial commission rates to be used for creating
     a validator.
    """

    rate: str = betterproto.string_field(1)
    """rate is the commission rate charged to delegators, as a fraction."""

    max_rate: str = betterproto.string_field(2)
    """
    max_rate defines the maximum commission rate which validator can ever charge, as a fraction.
    """

    max_change_rate: str = betterproto.string_field(3)
    """
    max_change_rate defines the maximum daily increase of the validator commission, as a fraction.
    """


@dataclass(eq=False, repr=False)
class Commission(betterproto.Message):
    """Commission defines commission parameters for a given validator."""

    commission_rates: "CommissionRates" = betterproto.message_field(1)
    """
    commission_rates defines the initial commission rates to be used for creating a validator.
    """

    update_time: datetime = betterproto.message_field(2)
    """update_time is the last time the commission rate was changed."""


@dataclass(eq=False, repr=False)
class Description(betterproto.Message):
    """Description defines a validator description."""

    moniker: str = betterproto.string_field(1)
    """moniker defines a human-readable name for the validator."""

    identity: str = betterproto.string_field(2)
    """
    identity defines an optional identity signature (ex. UPort or Keybase).
    """

    website: str = betterproto.string_field(3)
    """website defines an optional website link."""

    security_contact: str = betterproto.string_field(4)
    """security_contact defines an optional email for security contact."""

    details: str = betterproto.string_field(5)
    """details define other optional details."""


@dataclass(eq=False, repr=False)
class Validator(betterproto.Message):
    """
    Validator defines a validator, together with the total amount of the
     Validator's bond shares and their exchange rate to coins. Slashing results in
     a decrease in the exchange rate, allowing correct calculation of future
     undelegations without iterating over delegators. When coins are delegated to
     this validator, the validator is credited with a delegation whose number of
     bond shares is based on the amount of coins delegated divided by the current
     exchange rate. Voting power can be calculated as total bonded shares
     multiplied by exchange rate.
    """

    operator_address: str = betterproto.string_field(1)
    """
    operator_address defines the address of the validator's operator; bech encoded in JSON.
    """

    consensus_pubkey: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        2
    )
    """
    consensus_pubkey is the consensus public key of the validator, as a Protobuf Any.
    """

    jailed: bool = betterproto.bool_field(3)
    """
    jailed defined whether the validator has been jailed from bonded status or not.
    """

    status: "BondStatus" = betterproto.enum_field(4)
    """status is the validator status (bonded/unbonding/unbonded)."""

    tokens: str = betterproto.string_field(5)
    """tokens define the delegated tokens (incl. self-delegation)."""

    delegator_shares: str = betterproto.string_field(6)
    """
    delegator_shares defines total shares issued to a validator's delegators.
    """

    description: "Description" = betterproto.message_field(7)
    """description defines the description terms for the validator."""

    unbonding_height: int = betterproto.int64_field(8)
    """
    unbonding_height defines, if unbonding, the height at which this validator has begun unbonding.
    """

    unbonding_time: datetime = betterproto.message_field(9)
    """
    unbonding_time defines, if unbonding, the min time for the validator to complete unbonding.
    """

    commission: "Commission" = betterproto.message_field(10)
    """commission defines the commission parameters."""

    min_self_delegation: str = betterproto.string_field(11)
    """
    min_self_delegation is the validator's self declared minimum self delegation.
    """


@dataclass(eq=False, repr=False)
class ValAddresses(betterproto.Message):
    """ValAddresses defines a repeated set of validator addresses."""

    addresses: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class DvPair(betterproto.Message):
    """
    DVPair is struct that just has a delegator-validator pair with no other data.
     It is intended to be used as a marshalable pointer. For example, a DVPair can
     be used to construct the key to getting an UnbondingDelegation from state.
    """

    delegator_address: str = betterproto.string_field(1)
    validator_address: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DvPairs(betterproto.Message):
    """DVPairs defines an array of DVPair objects."""

    pairs: List["DvPair"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DvvTriplet(betterproto.Message):
    """
    DVVTriplet is struct that just has a delegator-validator-validator triplet
     with no other data. It is intended to be used as a marshalable pointer. For
     example, a DVVTriplet can be used to construct the key to getting a
     Redelegation from state.
    """

    delegator_address: str = betterproto.string_field(1)
    validator_src_address: str = betterproto.string_field(2)
    validator_dst_address: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class DvvTriplets(betterproto.Message):
    """DVVTriplets defines an array of DVVTriplet objects."""

    triplets: List["DvvTriplet"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Delegation(betterproto.Message):
    """
    Delegation represents the bond with tokens held by an account. It is
     owned by one delegator, and is associated with the voting power of one
     validator.
    """

    delegator_address: str = betterproto.string_field(1)
    """delegator_address is the bech32-encoded address of the delegator."""

    validator_address: str = betterproto.string_field(2)
    """validator_address is the bech32-encoded address of the validator."""

    shares: str = betterproto.string_field(3)
    """shares define the delegation shares received."""


@dataclass(eq=False, repr=False)
class UnbondingDelegation(betterproto.Message):
    """
    UnbondingDelegation stores all of a single delegator's unbonding bonds
     for a single validator in an time-ordered list.
    """

    delegator_address: str = betterproto.string_field(1)
    """delegator_address is the bech32-encoded address of the delegator."""

    validator_address: str = betterproto.string_field(2)
    """validator_address is the bech32-encoded address of the validator."""

    entries: List["UnbondingDelegationEntry"] = betterproto.message_field(3)
    """entries are the unbonding delegation entries."""


@dataclass(eq=False, repr=False)
class UnbondingDelegationEntry(betterproto.Message):
    """
    UnbondingDelegationEntry defines an unbonding object with relevant metadata.
    """

    creation_height: int = betterproto.int64_field(1)
    """creation_height is the height which the unbonding took place."""

    completion_time: datetime = betterproto.message_field(2)
    """completion_time is the unix time for unbonding completion."""

    initial_balance: str = betterproto.string_field(3)
    """
    initial_balance defines the tokens initially scheduled to receive at completion.
    """

    balance: str = betterproto.string_field(4)
    """balance defines the tokens to receive at completion."""


@dataclass(eq=False, repr=False)
class RedelegationEntry(betterproto.Message):
    """
    RedelegationEntry defines a redelegation object with relevant metadata.
    """

    creation_height: int = betterproto.int64_field(1)
    """
    creation_height  defines the height which the redelegation took place.
    """

    completion_time: datetime = betterproto.message_field(2)
    """completion_time defines the unix time for redelegation completion."""

    initial_balance: str = betterproto.string_field(3)
    """
    initial_balance defines the initial balance when redelegation started.
    """

    shares_dst: str = betterproto.string_field(4)
    """
    shares_dst is the amount of destination-validator shares created by redelegation.
    """


@dataclass(eq=False, repr=False)
class Redelegation(betterproto.Message):
    """
    Redelegation contains the list of a particular delegator's redelegating bonds
     from a particular source validator to a particular destination validator.
    """

    delegator_address: str = betterproto.string_field(1)
    """delegator_address is the bech32-encoded address of the delegator."""

    validator_src_address: str = betterproto.string_field(2)
    """
    validator_src_address is the validator redelegation source operator address.
    """

    validator_dst_address: str = betterproto.string_field(3)
    """
    validator_dst_address is the validator redelegation destination operator address.
    """

    entries: List["RedelegationEntry"] = betterproto.message_field(4)
    """entries are the redelegation entries."""


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params defines the parameters for the staking module."""

    unbonding_time: timedelta = betterproto.message_field(1)
    """unbonding_time is the time duration of unbonding."""

    max_validators: int = betterproto.uint32_field(2)
    """max_validators is the maximum number of validators."""

    max_entries: int = betterproto.uint32_field(3)
    """
    max_entries is the max entries for either unbonding delegation or redelegation (per pair/trio).
    """

    historical_entries: int = betterproto.uint32_field(4)
    """historical_entries is the number of historical entries to persist."""

    bond_denom: str = betterproto.string_field(5)
    """bond_denom defines the bondable coin denomination."""


@dataclass(eq=False, repr=False)
class DelegationResponse(betterproto.Message):
    """
    DelegationResponse is equivalent to Delegation except that it contains a
     balance in addition to shares which is more suitable for client responses.
    """

    delegation: "Delegation" = betterproto.message_field(1)
    balance: "__base_v1_beta1__.Coin" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class RedelegationEntryResponse(betterproto.Message):
    """
    RedelegationEntryResponse is equivalent to a RedelegationEntry except that it
     contains a balance in addition to shares which is more suitable for client
     responses.
    """

    redelegation_entry: "RedelegationEntry" = betterproto.message_field(1)
    balance: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class RedelegationResponse(betterproto.Message):
    """
    RedelegationResponse is equivalent to a Redelegation except that its entries
     contain a balance in addition to shares which is more suitable for client
     responses.
    """

    redelegation: "Redelegation" = betterproto.message_field(1)
    entries: List["RedelegationEntryResponse"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Pool(betterproto.Message):
    """
    Pool is used for tracking bonded and not-bonded token supply of the bond
     denomination.
    """

    not_bonded_tokens: str = betterproto.string_field(1)
    bonded_tokens: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class MsgCreateValidator(betterproto.Message):
    """
    MsgCreateValidator defines a SDK message for creating a new validator.
    """

    description: "Description" = betterproto.message_field(1)
    commission: "CommissionRates" = betterproto.message_field(2)
    min_self_delegation: str = betterproto.string_field(3)
    delegator_address: str = betterproto.string_field(4)
    validator_address: str = betterproto.string_field(5)
    pubkey: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(6)
    value: "__base_v1_beta1__.Coin" = betterproto.message_field(7)


@dataclass(eq=False, repr=False)
class MsgCreateValidatorResponse(betterproto.Message):
    """
    MsgCreateValidatorResponse defines the Msg/CreateValidator response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgEditValidator(betterproto.Message):
    """
    MsgEditValidator defines a SDK message for editing an existing validator.
    """

    description: "Description" = betterproto.message_field(1)
    validator_address: str = betterproto.string_field(2)
    commission_rate: str = betterproto.string_field(3)
    """
    We pass a reference to the new commission rate and min self delegation as
     it's not mandatory to update. If not updated, the deserialized rate will be
     zero with no way to distinguish if an update was intended.
     REF: #2373
    """

    min_self_delegation: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class MsgEditValidatorResponse(betterproto.Message):
    """
    MsgEditValidatorResponse defines the Msg/EditValidator response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgDelegate(betterproto.Message):
    """
    MsgDelegate defines a SDK message for performing a delegation of coins
     from a delegator to a validator.
    """

    delegator_address: str = betterproto.string_field(1)
    validator_address: str = betterproto.string_field(2)
    amount: "__base_v1_beta1__.Coin" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class MsgDelegateResponse(betterproto.Message):
    """MsgDelegateResponse defines the Msg/Delegate response type."""

    pass


@dataclass(eq=False, repr=False)
class MsgBeginRedelegate(betterproto.Message):
    """
    MsgBeginRedelegate defines a SDK message for performing a redelegation
     of coins from a delegator and source validator to a destination validator.
    """

    delegator_address: str = betterproto.string_field(1)
    validator_src_address: str = betterproto.string_field(2)
    validator_dst_address: str = betterproto.string_field(3)
    amount: "__base_v1_beta1__.Coin" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class MsgBeginRedelegateResponse(betterproto.Message):
    """
    MsgBeginRedelegateResponse defines the Msg/BeginRedelegate response type.
    """

    completion_time: datetime = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MsgUndelegate(betterproto.Message):
    """
    MsgUndelegate defines a SDK message for performing an undelegation from a
     delegate and a validator.
    """

    delegator_address: str = betterproto.string_field(1)
    validator_address: str = betterproto.string_field(2)
    amount: "__base_v1_beta1__.Coin" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class MsgUndelegateResponse(betterproto.Message):
    """MsgUndelegateResponse defines the Msg/Undelegate response type."""

    completion_time: datetime = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryValidatorsRequest(betterproto.Message):
    """
    QueryValidatorsRequest is request type for Query/Validators RPC method.
    """

    status: str = betterproto.string_field(1)
    """status enables to query for validators matching a given status."""

    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryValidatorsResponse(betterproto.Message):
    """
    QueryValidatorsResponse is response type for the Query/Validators RPC method
    """

    validators: List["Validator"] = betterproto.message_field(1)
    """validators contains all the queried validators."""

    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryValidatorRequest(betterproto.Message):
    """
    QueryValidatorRequest is response type for the Query/Validator RPC method
    """

    validator_addr: str = betterproto.string_field(1)
    """validator_addr defines the validator address to query for."""


@dataclass(eq=False, repr=False)
class QueryValidatorResponse(betterproto.Message):
    """
    QueryValidatorResponse is response type for the Query/Validator RPC method
    """

    validator: "Validator" = betterproto.message_field(1)
    """validator defines the the validator info."""


@dataclass(eq=False, repr=False)
class QueryValidatorDelegationsRequest(betterproto.Message):
    """
    QueryValidatorDelegationsRequest is request type for the
     Query/ValidatorDelegations RPC method
    """

    validator_addr: str = betterproto.string_field(1)
    """validator_addr defines the validator address to query for."""

    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryValidatorDelegationsResponse(betterproto.Message):
    """
    QueryValidatorDelegationsResponse is response type for the
     Query/ValidatorDelegations RPC method
    """

    delegation_responses: List["DelegationResponse"] = betterproto.message_field(1)
    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryValidatorUnbondingDelegationsRequest(betterproto.Message):
    """
    QueryValidatorUnbondingDelegationsRequest is required type for the
     Query/ValidatorUnbondingDelegations RPC method
    """

    validator_addr: str = betterproto.string_field(1)
    """validator_addr defines the validator address to query for."""

    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryValidatorUnbondingDelegationsResponse(betterproto.Message):
    """
    QueryValidatorUnbondingDelegationsResponse is response type for the
     Query/ValidatorUnbondingDelegations RPC method.
    """

    unbonding_responses: List["UnbondingDelegation"] = betterproto.message_field(1)
    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryDelegationRequest(betterproto.Message):
    """
    QueryDelegationRequest is request type for the Query/Delegation RPC method.
    """

    delegator_addr: str = betterproto.string_field(1)
    """delegator_addr defines the delegator address to query for."""

    validator_addr: str = betterproto.string_field(2)
    """validator_addr defines the validator address to query for."""


@dataclass(eq=False, repr=False)
class QueryDelegationResponse(betterproto.Message):
    """
    QueryDelegationResponse is response type for the Query/Delegation RPC method.
    """

    delegation_response: "DelegationResponse" = betterproto.message_field(1)
    """delegation_responses defines the delegation info of a delegation."""


@dataclass(eq=False, repr=False)
class QueryUnbondingDelegationRequest(betterproto.Message):
    """
    QueryUnbondingDelegationRequest is request type for the
     Query/UnbondingDelegation RPC method.
    """

    delegator_addr: str = betterproto.string_field(1)
    """delegator_addr defines the delegator address to query for."""

    validator_addr: str = betterproto.string_field(2)
    """validator_addr defines the validator address to query for."""


@dataclass(eq=False, repr=False)
class QueryUnbondingDelegationResponse(betterproto.Message):
    """
    QueryDelegationResponse is response type for the Query/UnbondingDelegation
     RPC method.
    """

    unbond: "UnbondingDelegation" = betterproto.message_field(1)
    """unbond defines the unbonding information of a delegation."""


@dataclass(eq=False, repr=False)
class QueryDelegatorDelegationsRequest(betterproto.Message):
    """
    QueryDelegatorDelegationsRequest is request type for the
     Query/DelegatorDelegations RPC method.
    """

    delegator_addr: str = betterproto.string_field(1)
    """delegator_addr defines the delegator address to query for."""

    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryDelegatorDelegationsResponse(betterproto.Message):
    """
    QueryDelegatorDelegationsResponse is response type for the
     Query/DelegatorDelegations RPC method.
    """

    delegation_responses: List["DelegationResponse"] = betterproto.message_field(1)
    """
    delegation_responses defines all the delegations' info of a delegator.
    """

    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryDelegatorUnbondingDelegationsRequest(betterproto.Message):
    """
    QueryDelegatorUnbondingDelegationsRequest is request type for the
     Query/DelegatorUnbondingDelegations RPC method.
    """

    delegator_addr: str = betterproto.string_field(1)
    """delegator_addr defines the delegator address to query for."""

    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryDelegatorUnbondingDelegationsResponse(betterproto.Message):
    """
    QueryUnbondingDelegatorDelegationsResponse is response type for the
     Query/UnbondingDelegatorDelegations RPC method.
    """

    unbonding_responses: List["UnbondingDelegation"] = betterproto.message_field(1)
    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryRedelegationsRequest(betterproto.Message):
    """
    QueryRedelegationsRequest is request type for the Query/Redelegations RPC
     method.
    """

    delegator_addr: str = betterproto.string_field(1)
    """delegator_addr defines the delegator address to query for."""

    src_validator_addr: str = betterproto.string_field(2)
    """src_validator_addr defines the validator address to redelegate from."""

    dst_validator_addr: str = betterproto.string_field(3)
    """dst_validator_addr defines the validator address to redelegate to."""

    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(4)
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryRedelegationsResponse(betterproto.Message):
    """
    QueryRedelegationsResponse is response type for the Query/Redelegations RPC
     method.
    """

    redelegation_responses: List["RedelegationResponse"] = betterproto.message_field(1)
    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryDelegatorValidatorsRequest(betterproto.Message):
    """
    QueryDelegatorValidatorsRequest is request type for the
     Query/DelegatorValidators RPC method.
    """

    delegator_addr: str = betterproto.string_field(1)
    """delegator_addr defines the delegator address to query for."""

    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryDelegatorValidatorsResponse(betterproto.Message):
    """
    QueryDelegatorValidatorsResponse is response type for the
     Query/DelegatorValidators RPC method.
    """

    validators: List["Validator"] = betterproto.message_field(1)
    """validators defines the the validators' info of a delegator."""

    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryDelegatorValidatorRequest(betterproto.Message):
    """
    QueryDelegatorValidatorRequest is request type for the
     Query/DelegatorValidator RPC method.
    """

    delegator_addr: str = betterproto.string_field(1)
    """delegator_addr defines the delegator address to query for."""

    validator_addr: str = betterproto.string_field(2)
    """validator_addr defines the validator address to query for."""


@dataclass(eq=False, repr=False)
class QueryDelegatorValidatorResponse(betterproto.Message):
    """
    QueryDelegatorValidatorResponse response type for the
     Query/DelegatorValidator RPC method.
    """

    validator: "Validator" = betterproto.message_field(1)
    """validator defines the the validator info."""


@dataclass(eq=False, repr=False)
class QueryHistoricalInfoRequest(betterproto.Message):
    """
    QueryHistoricalInfoRequest is request type for the Query/HistoricalInfo RPC
     method.
    """

    height: int = betterproto.int64_field(1)
    """height defines at which height to query the historical info."""


@dataclass(eq=False, repr=False)
class QueryHistoricalInfoResponse(betterproto.Message):
    """
    QueryHistoricalInfoResponse is response type for the Query/HistoricalInfo RPC
     method.
    """

    hist: "HistoricalInfo" = betterproto.message_field(1)
    """hist defines the historical info at the given height."""


@dataclass(eq=False, repr=False)
class QueryPoolRequest(betterproto.Message):
    """QueryPoolRequest is request type for the Query/Pool RPC method."""

    pass


@dataclass(eq=False, repr=False)
class QueryPoolResponse(betterproto.Message):
    """QueryPoolResponse is response type for the Query/Pool RPC method."""

    pool: "Pool" = betterproto.message_field(1)
    """pool defines the pool info."""


@dataclass(eq=False, repr=False)
class QueryParamsRequest(betterproto.Message):
    """QueryParamsRequest is request type for the Query/Params RPC method."""

    pass


@dataclass(eq=False, repr=False)
class QueryParamsResponse(betterproto.Message):
    """
    QueryParamsResponse is response type for the Query/Params RPC method.
    """

    params: "Params" = betterproto.message_field(1)
    """params holds all the parameters of this module."""


@dataclass(eq=False, repr=False)
class StakeAuthorization(betterproto.Message):
    """
    StakeAuthorization defines authorization for delegate/undelegate/redelegate.

     Since: cosmos-sdk 0.43
    """

    max_tokens: "__base_v1_beta1__.Coin" = betterproto.message_field(1)
    """
    max_tokens specifies the maximum amount of tokens can be delegate to a validator. If it is
     empty, there is no spend limit and any amount of coins can be delegated.
    """

    allow_list: "StakeAuthorizationValidators" = betterproto.message_field(
        2, group="validators"
    )
    """
    allow_list specifies list of validator addresses to whom grantee can delegate tokens on behalf of granter's
     account.
    """

    deny_list: "StakeAuthorizationValidators" = betterproto.message_field(
        3, group="validators"
    )
    """
    deny_list specifies list of validator addresses to whom grantee can not delegate tokens.
    """

    authorization_type: "AuthorizationType" = betterproto.enum_field(4)
    """authorization_type defines one of AuthorizationType."""


@dataclass(eq=False, repr=False)
class StakeAuthorizationValidators(betterproto.Message):
    """Validators defines list of validator addresses."""

    address: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the staking module's genesis state."""

    params: "Params" = betterproto.message_field(1)
    """params defines all the paramaters of related to deposit."""

    last_total_power: bytes = betterproto.bytes_field(2)
    """
    last_total_power tracks the total amounts of bonded tokens recorded during
     the previous end block.
    """

    last_validator_powers: List["LastValidatorPower"] = betterproto.message_field(3)
    """
    last_validator_powers is a special index that provides a historical list
     of the last-block's bonded validators.
    """

    validators: List["Validator"] = betterproto.message_field(4)
    """delegations defines the validator set at genesis."""

    delegations: List["Delegation"] = betterproto.message_field(5)
    """delegations defines the delegations active at genesis."""

    unbonding_delegations: List["UnbondingDelegation"] = betterproto.message_field(6)
    """
    unbonding_delegations defines the unbonding delegations active at genesis.
    """

    redelegations: List["Redelegation"] = betterproto.message_field(7)
    """redelegations defines the redelegations active at genesis."""

    exported: bool = betterproto.bool_field(8)


@dataclass(eq=False, repr=False)
class LastValidatorPower(betterproto.Message):
    """LastValidatorPower required for validator set update logic."""

    address: str = betterproto.string_field(1)
    """address is the address of the validator."""

    power: int = betterproto.int64_field(2)
    """power defines the power of the validator."""


class MsgStub(betterproto.ServiceStub):
    async def create_validator(
        self,
        msg_create_validator: "MsgCreateValidator",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgCreateValidatorResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Msg/CreateValidator",
            msg_create_validator,
            MsgCreateValidatorResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def edit_validator(
        self,
        msg_edit_validator: "MsgEditValidator",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgEditValidatorResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Msg/EditValidator",
            msg_edit_validator,
            MsgEditValidatorResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delegate(
        self,
        msg_delegate: "MsgDelegate",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgDelegateResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Msg/Delegate",
            msg_delegate,
            MsgDelegateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def begin_redelegate(
        self,
        msg_begin_redelegate: "MsgBeginRedelegate",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgBeginRedelegateResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Msg/BeginRedelegate",
            msg_begin_redelegate,
            MsgBeginRedelegateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def undelegate(
        self,
        msg_undelegate: "MsgUndelegate",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgUndelegateResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Msg/Undelegate",
            msg_undelegate,
            MsgUndelegateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryStub(betterproto.ServiceStub):
    async def validators(
        self,
        query_validators_request: "QueryValidatorsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryValidatorsResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/Validators",
            query_validators_request,
            QueryValidatorsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def validator(
        self,
        query_validator_request: "QueryValidatorRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryValidatorResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/Validator",
            query_validator_request,
            QueryValidatorResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def validator_delegations(
        self,
        query_validator_delegations_request: "QueryValidatorDelegationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryValidatorDelegationsResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/ValidatorDelegations",
            query_validator_delegations_request,
            QueryValidatorDelegationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def validator_unbonding_delegations(
        self,
        query_validator_unbonding_delegations_request: "QueryValidatorUnbondingDelegationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryValidatorUnbondingDelegationsResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/ValidatorUnbondingDelegations",
            query_validator_unbonding_delegations_request,
            QueryValidatorUnbondingDelegationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delegation(
        self,
        query_delegation_request: "QueryDelegationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDelegationResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/Delegation",
            query_delegation_request,
            QueryDelegationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def unbonding_delegation(
        self,
        query_unbonding_delegation_request: "QueryUnbondingDelegationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryUnbondingDelegationResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/UnbondingDelegation",
            query_unbonding_delegation_request,
            QueryUnbondingDelegationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delegator_delegations(
        self,
        query_delegator_delegations_request: "QueryDelegatorDelegationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDelegatorDelegationsResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/DelegatorDelegations",
            query_delegator_delegations_request,
            QueryDelegatorDelegationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delegator_unbonding_delegations(
        self,
        query_delegator_unbonding_delegations_request: "QueryDelegatorUnbondingDelegationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDelegatorUnbondingDelegationsResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/DelegatorUnbondingDelegations",
            query_delegator_unbonding_delegations_request,
            QueryDelegatorUnbondingDelegationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def redelegations(
        self,
        query_redelegations_request: "QueryRedelegationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryRedelegationsResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/Redelegations",
            query_redelegations_request,
            QueryRedelegationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delegator_validators(
        self,
        query_delegator_validators_request: "QueryDelegatorValidatorsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDelegatorValidatorsResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/DelegatorValidators",
            query_delegator_validators_request,
            QueryDelegatorValidatorsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delegator_validator(
        self,
        query_delegator_validator_request: "QueryDelegatorValidatorRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDelegatorValidatorResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/DelegatorValidator",
            query_delegator_validator_request,
            QueryDelegatorValidatorResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def historical_info(
        self,
        query_historical_info_request: "QueryHistoricalInfoRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryHistoricalInfoResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/HistoricalInfo",
            query_historical_info_request,
            QueryHistoricalInfoResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def pool(
        self,
        query_pool_request: "QueryPoolRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryPoolResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/Pool",
            query_pool_request,
            QueryPoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def params(
        self,
        query_params_request: "QueryParamsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryParamsResponse":
        return await self._unary_unary(
            "/cosmos.staking.v1beta1.Query/Params",
            query_params_request,
            QueryParamsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgBase(ServiceBase):
    async def create_validator(
        self, msg_create_validator: "MsgCreateValidator"
    ) -> "MsgCreateValidatorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def edit_validator(
        self, msg_edit_validator: "MsgEditValidator"
    ) -> "MsgEditValidatorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegate(self, msg_delegate: "MsgDelegate") -> "MsgDelegateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def begin_redelegate(
        self, msg_begin_redelegate: "MsgBeginRedelegate"
    ) -> "MsgBeginRedelegateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def undelegate(
        self, msg_undelegate: "MsgUndelegate"
    ) -> "MsgUndelegateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create_validator(
        self,
        stream: "grpclib.server.Stream[MsgCreateValidator, MsgCreateValidatorResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_validator(request)
        await stream.send_message(response)

    async def __rpc_edit_validator(
        self,
        stream: "grpclib.server.Stream[MsgEditValidator, MsgEditValidatorResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.edit_validator(request)
        await stream.send_message(response)

    async def __rpc_delegate(
        self, stream: "grpclib.server.Stream[MsgDelegate, MsgDelegateResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.delegate(request)
        await stream.send_message(response)

    async def __rpc_begin_redelegate(
        self,
        stream: "grpclib.server.Stream[MsgBeginRedelegate, MsgBeginRedelegateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.begin_redelegate(request)
        await stream.send_message(response)

    async def __rpc_undelegate(
        self, stream: "grpclib.server.Stream[MsgUndelegate, MsgUndelegateResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.undelegate(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.staking.v1beta1.Msg/CreateValidator": grpclib.const.Handler(
                self.__rpc_create_validator,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgCreateValidator,
                MsgCreateValidatorResponse,
            ),
            "/cosmos.staking.v1beta1.Msg/EditValidator": grpclib.const.Handler(
                self.__rpc_edit_validator,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgEditValidator,
                MsgEditValidatorResponse,
            ),
            "/cosmos.staking.v1beta1.Msg/Delegate": grpclib.const.Handler(
                self.__rpc_delegate,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgDelegate,
                MsgDelegateResponse,
            ),
            "/cosmos.staking.v1beta1.Msg/BeginRedelegate": grpclib.const.Handler(
                self.__rpc_begin_redelegate,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgBeginRedelegate,
                MsgBeginRedelegateResponse,
            ),
            "/cosmos.staking.v1beta1.Msg/Undelegate": grpclib.const.Handler(
                self.__rpc_undelegate,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgUndelegate,
                MsgUndelegateResponse,
            ),
        }


class QueryBase(ServiceBase):
    async def validators(
        self, query_validators_request: "QueryValidatorsRequest"
    ) -> "QueryValidatorsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def validator(
        self, query_validator_request: "QueryValidatorRequest"
    ) -> "QueryValidatorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def validator_delegations(
        self, query_validator_delegations_request: "QueryValidatorDelegationsRequest"
    ) -> "QueryValidatorDelegationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def validator_unbonding_delegations(
        self,
        query_validator_unbonding_delegations_request: "QueryValidatorUnbondingDelegationsRequest",
    ) -> "QueryValidatorUnbondingDelegationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegation(
        self, query_delegation_request: "QueryDelegationRequest"
    ) -> "QueryDelegationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def unbonding_delegation(
        self, query_unbonding_delegation_request: "QueryUnbondingDelegationRequest"
    ) -> "QueryUnbondingDelegationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegator_delegations(
        self, query_delegator_delegations_request: "QueryDelegatorDelegationsRequest"
    ) -> "QueryDelegatorDelegationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegator_unbonding_delegations(
        self,
        query_delegator_unbonding_delegations_request: "QueryDelegatorUnbondingDelegationsRequest",
    ) -> "QueryDelegatorUnbondingDelegationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def redelegations(
        self, query_redelegations_request: "QueryRedelegationsRequest"
    ) -> "QueryRedelegationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegator_validators(
        self, query_delegator_validators_request: "QueryDelegatorValidatorsRequest"
    ) -> "QueryDelegatorValidatorsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegator_validator(
        self, query_delegator_validator_request: "QueryDelegatorValidatorRequest"
    ) -> "QueryDelegatorValidatorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def historical_info(
        self, query_historical_info_request: "QueryHistoricalInfoRequest"
    ) -> "QueryHistoricalInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pool(self, query_pool_request: "QueryPoolRequest") -> "QueryPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def params(
        self, query_params_request: "QueryParamsRequest"
    ) -> "QueryParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_validators(
        self,
        stream: "grpclib.server.Stream[QueryValidatorsRequest, QueryValidatorsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.validators(request)
        await stream.send_message(response)

    async def __rpc_validator(
        self,
        stream: "grpclib.server.Stream[QueryValidatorRequest, QueryValidatorResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.validator(request)
        await stream.send_message(response)

    async def __rpc_validator_delegations(
        self,
        stream: "grpclib.server.Stream[QueryValidatorDelegationsRequest, QueryValidatorDelegationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.validator_delegations(request)
        await stream.send_message(response)

    async def __rpc_validator_unbonding_delegations(
        self,
        stream: "grpclib.server.Stream[QueryValidatorUnbondingDelegationsRequest, QueryValidatorUnbondingDelegationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.validator_unbonding_delegations(request)
        await stream.send_message(response)

    async def __rpc_delegation(
        self,
        stream: "grpclib.server.Stream[QueryDelegationRequest, QueryDelegationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delegation(request)
        await stream.send_message(response)

    async def __rpc_unbonding_delegation(
        self,
        stream: "grpclib.server.Stream[QueryUnbondingDelegationRequest, QueryUnbondingDelegationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.unbonding_delegation(request)
        await stream.send_message(response)

    async def __rpc_delegator_delegations(
        self,
        stream: "grpclib.server.Stream[QueryDelegatorDelegationsRequest, QueryDelegatorDelegationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delegator_delegations(request)
        await stream.send_message(response)

    async def __rpc_delegator_unbonding_delegations(
        self,
        stream: "grpclib.server.Stream[QueryDelegatorUnbondingDelegationsRequest, QueryDelegatorUnbondingDelegationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delegator_unbonding_delegations(request)
        await stream.send_message(response)

    async def __rpc_redelegations(
        self,
        stream: "grpclib.server.Stream[QueryRedelegationsRequest, QueryRedelegationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.redelegations(request)
        await stream.send_message(response)

    async def __rpc_delegator_validators(
        self,
        stream: "grpclib.server.Stream[QueryDelegatorValidatorsRequest, QueryDelegatorValidatorsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delegator_validators(request)
        await stream.send_message(response)

    async def __rpc_delegator_validator(
        self,
        stream: "grpclib.server.Stream[QueryDelegatorValidatorRequest, QueryDelegatorValidatorResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delegator_validator(request)
        await stream.send_message(response)

    async def __rpc_historical_info(
        self,
        stream: "grpclib.server.Stream[QueryHistoricalInfoRequest, QueryHistoricalInfoResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.historical_info(request)
        await stream.send_message(response)

    async def __rpc_pool(
        self, stream: "grpclib.server.Stream[QueryPoolRequest, QueryPoolResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.pool(request)
        await stream.send_message(response)

    async def __rpc_params(
        self, stream: "grpclib.server.Stream[QueryParamsRequest, QueryParamsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.params(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.staking.v1beta1.Query/Validators": grpclib.const.Handler(
                self.__rpc_validators,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryValidatorsRequest,
                QueryValidatorsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/Validator": grpclib.const.Handler(
                self.__rpc_validator,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryValidatorRequest,
                QueryValidatorResponse,
            ),
            "/cosmos.staking.v1beta1.Query/ValidatorDelegations": grpclib.const.Handler(
                self.__rpc_validator_delegations,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryValidatorDelegationsRequest,
                QueryValidatorDelegationsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/ValidatorUnbondingDelegations": grpclib.const.Handler(
                self.__rpc_validator_unbonding_delegations,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryValidatorUnbondingDelegationsRequest,
                QueryValidatorUnbondingDelegationsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/Delegation": grpclib.const.Handler(
                self.__rpc_delegation,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegationRequest,
                QueryDelegationResponse,
            ),
            "/cosmos.staking.v1beta1.Query/UnbondingDelegation": grpclib.const.Handler(
                self.__rpc_unbonding_delegation,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryUnbondingDelegationRequest,
                QueryUnbondingDelegationResponse,
            ),
            "/cosmos.staking.v1beta1.Query/DelegatorDelegations": grpclib.const.Handler(
                self.__rpc_delegator_delegations,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegatorDelegationsRequest,
                QueryDelegatorDelegationsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/DelegatorUnbondingDelegations": grpclib.const.Handler(
                self.__rpc_delegator_unbonding_delegations,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegatorUnbondingDelegationsRequest,
                QueryDelegatorUnbondingDelegationsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/Redelegations": grpclib.const.Handler(
                self.__rpc_redelegations,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryRedelegationsRequest,
                QueryRedelegationsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/DelegatorValidators": grpclib.const.Handler(
                self.__rpc_delegator_validators,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegatorValidatorsRequest,
                QueryDelegatorValidatorsResponse,
            ),
            "/cosmos.staking.v1beta1.Query/DelegatorValidator": grpclib.const.Handler(
                self.__rpc_delegator_validator,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegatorValidatorRequest,
                QueryDelegatorValidatorResponse,
            ),
            "/cosmos.staking.v1beta1.Query/HistoricalInfo": grpclib.const.Handler(
                self.__rpc_historical_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryHistoricalInfoRequest,
                QueryHistoricalInfoResponse,
            ),
            "/cosmos.staking.v1beta1.Query/Pool": grpclib.const.Handler(
                self.__rpc_pool,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPoolRequest,
                QueryPoolResponse,
            ),
            "/cosmos.staking.v1beta1.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryParamsRequest,
                QueryParamsResponse,
            ),
        }
