# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: cosmos/bank/v1beta1/authz.proto, cosmos/bank/v1beta1/bank.proto, cosmos/bank/v1beta1/genesis.proto, cosmos/bank/v1beta1/query.proto, cosmos/bank/v1beta1/tx.proto
# plugin: python-betterproto
# This file has been @generated
import warnings
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ...base import v1beta1 as __base_v1_beta1__
from ...base.query import v1beta1 as __base_query_v1_beta1__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params defines the parameters for the bank module."""

    send_enabled: List["SendEnabled"] = betterproto.message_field(1)
    default_send_enabled: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class SendEnabled(betterproto.Message):
    """
    SendEnabled maps coin denom to a send_enabled status (whether a denom is
     sendable).
    """

    denom: str = betterproto.string_field(1)
    enabled: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class Input(betterproto.Message):
    """Input models transaction input."""

    address: str = betterproto.string_field(1)
    coins: List["__base_v1_beta1__.Coin"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Output(betterproto.Message):
    """Output models transaction outputs."""

    address: str = betterproto.string_field(1)
    coins: List["__base_v1_beta1__.Coin"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Supply(betterproto.Message):
    """
    Supply represents a struct that passively keeps track of the total supply
     amounts in the network.
     This message is deprecated now that supply is indexed by denom.
    """

    total: List["__base_v1_beta1__.Coin"] = betterproto.message_field(1)

    def __post_init__(self) -> None:
        warnings.warn("Supply is deprecated", DeprecationWarning)
        super().__post_init__()


@dataclass(eq=False, repr=False)
class DenomUnit(betterproto.Message):
    """
    DenomUnit represents a struct that describes a given
     denomination unit of the basic token.
    """

    denom: str = betterproto.string_field(1)
    """
    denom represents the string name of the given denom unit (e.g uatom).
    """

    exponent: int = betterproto.uint32_field(2)
    """
    exponent represents power of 10 exponent that one must
     raise the base_denom to in order to equal the given DenomUnit's denom
     1 denom = 1^exponent base_denom
     (e.g. with a base_denom of uatom, one can create a DenomUnit of 'atom' with
     exponent = 6, thus: 1 atom = 10^6 uatom).
    """

    aliases: List[str] = betterproto.string_field(3)
    """aliases is a list of string aliases for the given denom"""


@dataclass(eq=False, repr=False)
class Metadata(betterproto.Message):
    """
    Metadata represents a struct that describes
     a basic token.
    """

    description: str = betterproto.string_field(1)
    denom_units: List["DenomUnit"] = betterproto.message_field(2)
    """denom_units represents the list of DenomUnit's for a given coin"""

    base: str = betterproto.string_field(3)
    """
    base represents the base denom (should be the DenomUnit with exponent = 0).
    """

    display: str = betterproto.string_field(4)
    """
    display indicates the suggested denom that should be
     displayed in clients.
    """

    name: str = betterproto.string_field(5)
    """
    name defines the name of the token (eg: Cosmos Atom)
    
     Since: cosmos-sdk 0.43
    """

    symbol: str = betterproto.string_field(6)
    """
    symbol is the token symbol usually shown on exchanges (eg: ATOM). This can
     be the same as the display.
    
     Since: cosmos-sdk 0.43
    """


@dataclass(eq=False, repr=False)
class MsgSend(betterproto.Message):
    """
    MsgSend represents a message to send coins from one account to another.
    """

    from_address: str = betterproto.string_field(1)
    to_address: str = betterproto.string_field(2)
    amount: List["__base_v1_beta1__.Coin"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class MsgSendResponse(betterproto.Message):
    """MsgSendResponse defines the Msg/Send response type."""

    pass


@dataclass(eq=False, repr=False)
class MsgMultiSend(betterproto.Message):
    """
    MsgMultiSend represents an arbitrary multi-in, multi-out send message.
    """

    inputs: List["Input"] = betterproto.message_field(1)
    outputs: List["Output"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class MsgMultiSendResponse(betterproto.Message):
    """MsgMultiSendResponse defines the Msg/MultiSend response type."""

    pass


@dataclass(eq=False, repr=False)
class QueryBalanceRequest(betterproto.Message):
    """
    QueryBalanceRequest is the request type for the Query/Balance RPC method.
    """

    address: str = betterproto.string_field(1)
    """address is the address to query balances for."""

    denom: str = betterproto.string_field(2)
    """denom is the coin denom to query balances for."""


@dataclass(eq=False, repr=False)
class QueryBalanceResponse(betterproto.Message):
    """
    QueryBalanceResponse is the response type for the Query/Balance RPC method.
    """

    balance: "__base_v1_beta1__.Coin" = betterproto.message_field(1)
    """balance is the balance of the coin."""


@dataclass(eq=False, repr=False)
class QueryAllBalancesRequest(betterproto.Message):
    """
    QueryBalanceRequest is the request type for the Query/AllBalances RPC method.
    """

    address: str = betterproto.string_field(1)
    """address is the address to query balances for."""

    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryAllBalancesResponse(betterproto.Message):
    """
    QueryAllBalancesResponse is the response type for the Query/AllBalances RPC
     method.
    """

    balances: List["__base_v1_beta1__.Coin"] = betterproto.message_field(1)
    """balances is the balances of all the coins."""

    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QuerySpendableBalancesRequest(betterproto.Message):
    """
    QuerySpendableBalancesRequest defines the gRPC request structure for querying
     an account's spendable balances.
    """

    address: str = betterproto.string_field(1)
    """address is the address to query spendable balances for."""

    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(2)
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QuerySpendableBalancesResponse(betterproto.Message):
    """
    QuerySpendableBalancesResponse defines the gRPC response structure for querying
     an account's spendable balances.
    """

    balances: List["__base_v1_beta1__.Coin"] = betterproto.message_field(1)
    """balances is the spendable balances of all the coins."""

    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryTotalSupplyRequest(betterproto.Message):
    """
    QueryTotalSupplyRequest is the request type for the Query/TotalSupply RPC
     method.
    """

    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(1)
    """
    pagination defines an optional pagination for the request.
    
     Since: cosmos-sdk 0.43
    """


@dataclass(eq=False, repr=False)
class QueryTotalSupplyResponse(betterproto.Message):
    """
    QueryTotalSupplyResponse is the response type for the Query/TotalSupply RPC
     method
    """

    supply: List["__base_v1_beta1__.Coin"] = betterproto.message_field(1)
    """supply is the supply of the coins"""

    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)
    """
    pagination defines the pagination in the response.
    
     Since: cosmos-sdk 0.43
    """


@dataclass(eq=False, repr=False)
class QuerySupplyOfRequest(betterproto.Message):
    """
    QuerySupplyOfRequest is the request type for the Query/SupplyOf RPC method.
    """

    denom: str = betterproto.string_field(1)
    """denom is the coin denom to query balances for."""


@dataclass(eq=False, repr=False)
class QuerySupplyOfResponse(betterproto.Message):
    """
    QuerySupplyOfResponse is the response type for the Query/SupplyOf RPC method.
    """

    amount: "__base_v1_beta1__.Coin" = betterproto.message_field(1)
    """amount is the supply of the coin."""


@dataclass(eq=False, repr=False)
class QueryParamsRequest(betterproto.Message):
    """
    QueryParamsRequest defines the request type for querying x/bank parameters.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryParamsResponse(betterproto.Message):
    """
    QueryParamsResponse defines the response type for querying x/bank parameters.
    """

    params: "Params" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryDenomsMetadataRequest(betterproto.Message):
    """
    QueryDenomsMetadataRequest is the request type for the Query/DenomsMetadata RPC method.
    """

    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(1)
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryDenomsMetadataResponse(betterproto.Message):
    """
    QueryDenomsMetadataResponse is the response type for the Query/DenomsMetadata RPC
     method.
    """

    metadatas: List["Metadata"] = betterproto.message_field(1)
    """
    metadata provides the client information for all the registered tokens.
    """

    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryDenomMetadataRequest(betterproto.Message):
    """
    QueryDenomMetadataRequest is the request type for the Query/DenomMetadata RPC method.
    """

    denom: str = betterproto.string_field(1)
    """denom is the coin denom to query the metadata for."""


@dataclass(eq=False, repr=False)
class QueryDenomMetadataResponse(betterproto.Message):
    """
    QueryDenomMetadataResponse is the response type for the Query/DenomMetadata RPC
     method.
    """

    metadata: "Metadata" = betterproto.message_field(1)
    """
    metadata describes and provides all the client information for the requested token.
    """


@dataclass(eq=False, repr=False)
class SendAuthorization(betterproto.Message):
    """
    SendAuthorization allows the grantee to spend up to spend_limit coins from
     the granter's account.

     Since: cosmos-sdk 0.43
    """

    spend_limit: List["__base_v1_beta1__.Coin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the bank module's genesis state."""

    params: "Params" = betterproto.message_field(1)
    """params defines all the paramaters of the module."""

    balances: List["Balance"] = betterproto.message_field(2)
    """balances is an array containing the balances of all the accounts."""

    supply: List["__base_v1_beta1__.Coin"] = betterproto.message_field(3)
    """
    supply represents the total supply. If it is left empty, then supply will be calculated based on the provided
     balances. Otherwise, it will be used to validate that the sum of the balances equals this amount.
    """

    denom_metadata: List["Metadata"] = betterproto.message_field(4)
    """denom_metadata defines the metadata of the differents coins."""


@dataclass(eq=False, repr=False)
class Balance(betterproto.Message):
    """
    Balance defines an account address and balance pair used in the bank module's
     genesis state.
    """

    address: str = betterproto.string_field(1)
    """address is the address of the balance holder."""

    coins: List["__base_v1_beta1__.Coin"] = betterproto.message_field(2)
    """coins defines the different coins this balance holds."""


class MsgStub(betterproto.ServiceStub):
    async def send(
        self,
        msg_send: "MsgSend",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgSendResponse":
        return await self._unary_unary(
            "/cosmos.bank.v1beta1.Msg/Send",
            msg_send,
            MsgSendResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def multi_send(
        self,
        msg_multi_send: "MsgMultiSend",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgMultiSendResponse":
        return await self._unary_unary(
            "/cosmos.bank.v1beta1.Msg/MultiSend",
            msg_multi_send,
            MsgMultiSendResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryStub(betterproto.ServiceStub):
    async def balance(
        self,
        query_balance_request: "QueryBalanceRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryBalanceResponse":
        return await self._unary_unary(
            "/cosmos.bank.v1beta1.Query/Balance",
            query_balance_request,
            QueryBalanceResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def all_balances(
        self,
        query_all_balances_request: "QueryAllBalancesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryAllBalancesResponse":
        return await self._unary_unary(
            "/cosmos.bank.v1beta1.Query/AllBalances",
            query_all_balances_request,
            QueryAllBalancesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def spendable_balances(
        self,
        query_spendable_balances_request: "QuerySpendableBalancesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QuerySpendableBalancesResponse":
        return await self._unary_unary(
            "/cosmos.bank.v1beta1.Query/SpendableBalances",
            query_spendable_balances_request,
            QuerySpendableBalancesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def total_supply(
        self,
        query_total_supply_request: "QueryTotalSupplyRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryTotalSupplyResponse":
        return await self._unary_unary(
            "/cosmos.bank.v1beta1.Query/TotalSupply",
            query_total_supply_request,
            QueryTotalSupplyResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def supply_of(
        self,
        query_supply_of_request: "QuerySupplyOfRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QuerySupplyOfResponse":
        return await self._unary_unary(
            "/cosmos.bank.v1beta1.Query/SupplyOf",
            query_supply_of_request,
            QuerySupplyOfResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def params(
        self,
        query_params_request: "QueryParamsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryParamsResponse":
        return await self._unary_unary(
            "/cosmos.bank.v1beta1.Query/Params",
            query_params_request,
            QueryParamsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def denom_metadata(
        self,
        query_denom_metadata_request: "QueryDenomMetadataRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDenomMetadataResponse":
        return await self._unary_unary(
            "/cosmos.bank.v1beta1.Query/DenomMetadata",
            query_denom_metadata_request,
            QueryDenomMetadataResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def denoms_metadata(
        self,
        query_denoms_metadata_request: "QueryDenomsMetadataRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDenomsMetadataResponse":
        return await self._unary_unary(
            "/cosmos.bank.v1beta1.Query/DenomsMetadata",
            query_denoms_metadata_request,
            QueryDenomsMetadataResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgBase(ServiceBase):
    async def send(self, msg_send: "MsgSend") -> "MsgSendResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def multi_send(
        self, msg_multi_send: "MsgMultiSend"
    ) -> "MsgMultiSendResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_send(
        self, stream: "grpclib.server.Stream[MsgSend, MsgSendResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.send(request)
        await stream.send_message(response)

    async def __rpc_multi_send(
        self, stream: "grpclib.server.Stream[MsgMultiSend, MsgMultiSendResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.multi_send(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.bank.v1beta1.Msg/Send": grpclib.const.Handler(
                self.__rpc_send,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgSend,
                MsgSendResponse,
            ),
            "/cosmos.bank.v1beta1.Msg/MultiSend": grpclib.const.Handler(
                self.__rpc_multi_send,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgMultiSend,
                MsgMultiSendResponse,
            ),
        }


class QueryBase(ServiceBase):
    async def balance(
        self, query_balance_request: "QueryBalanceRequest"
    ) -> "QueryBalanceResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def all_balances(
        self, query_all_balances_request: "QueryAllBalancesRequest"
    ) -> "QueryAllBalancesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def spendable_balances(
        self, query_spendable_balances_request: "QuerySpendableBalancesRequest"
    ) -> "QuerySpendableBalancesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def total_supply(
        self, query_total_supply_request: "QueryTotalSupplyRequest"
    ) -> "QueryTotalSupplyResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def supply_of(
        self, query_supply_of_request: "QuerySupplyOfRequest"
    ) -> "QuerySupplyOfResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def params(
        self, query_params_request: "QueryParamsRequest"
    ) -> "QueryParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def denom_metadata(
        self, query_denom_metadata_request: "QueryDenomMetadataRequest"
    ) -> "QueryDenomMetadataResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def denoms_metadata(
        self, query_denoms_metadata_request: "QueryDenomsMetadataRequest"
    ) -> "QueryDenomsMetadataResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_balance(
        self, stream: "grpclib.server.Stream[QueryBalanceRequest, QueryBalanceResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.balance(request)
        await stream.send_message(response)

    async def __rpc_all_balances(
        self,
        stream: "grpclib.server.Stream[QueryAllBalancesRequest, QueryAllBalancesResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.all_balances(request)
        await stream.send_message(response)

    async def __rpc_spendable_balances(
        self,
        stream: "grpclib.server.Stream[QuerySpendableBalancesRequest, QuerySpendableBalancesResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.spendable_balances(request)
        await stream.send_message(response)

    async def __rpc_total_supply(
        self,
        stream: "grpclib.server.Stream[QueryTotalSupplyRequest, QueryTotalSupplyResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.total_supply(request)
        await stream.send_message(response)

    async def __rpc_supply_of(
        self,
        stream: "grpclib.server.Stream[QuerySupplyOfRequest, QuerySupplyOfResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.supply_of(request)
        await stream.send_message(response)

    async def __rpc_params(
        self, stream: "grpclib.server.Stream[QueryParamsRequest, QueryParamsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.params(request)
        await stream.send_message(response)

    async def __rpc_denom_metadata(
        self,
        stream: "grpclib.server.Stream[QueryDenomMetadataRequest, QueryDenomMetadataResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.denom_metadata(request)
        await stream.send_message(response)

    async def __rpc_denoms_metadata(
        self,
        stream: "grpclib.server.Stream[QueryDenomsMetadataRequest, QueryDenomsMetadataResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.denoms_metadata(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.bank.v1beta1.Query/Balance": grpclib.const.Handler(
                self.__rpc_balance,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryBalanceRequest,
                QueryBalanceResponse,
            ),
            "/cosmos.bank.v1beta1.Query/AllBalances": grpclib.const.Handler(
                self.__rpc_all_balances,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryAllBalancesRequest,
                QueryAllBalancesResponse,
            ),
            "/cosmos.bank.v1beta1.Query/SpendableBalances": grpclib.const.Handler(
                self.__rpc_spendable_balances,
                grpclib.const.Cardinality.UNARY_UNARY,
                QuerySpendableBalancesRequest,
                QuerySpendableBalancesResponse,
            ),
            "/cosmos.bank.v1beta1.Query/TotalSupply": grpclib.const.Handler(
                self.__rpc_total_supply,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryTotalSupplyRequest,
                QueryTotalSupplyResponse,
            ),
            "/cosmos.bank.v1beta1.Query/SupplyOf": grpclib.const.Handler(
                self.__rpc_supply_of,
                grpclib.const.Cardinality.UNARY_UNARY,
                QuerySupplyOfRequest,
                QuerySupplyOfResponse,
            ),
            "/cosmos.bank.v1beta1.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryParamsRequest,
                QueryParamsResponse,
            ),
            "/cosmos.bank.v1beta1.Query/DenomMetadata": grpclib.const.Handler(
                self.__rpc_denom_metadata,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDenomMetadataRequest,
                QueryDenomMetadataResponse,
            ),
            "/cosmos.bank.v1beta1.Query/DenomsMetadata": grpclib.const.Handler(
                self.__rpc_denoms_metadata,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDenomsMetadataRequest,
                QueryDenomsMetadataResponse,
            ),
        }
