"""
MERIT Storage

This module provides storage backends for MERIT systems, supporting
persistence of monitoring data, evaluation results, and other application data.
"""

# Import components from local modules
from .persistence import (
    BaseStorage,
    SQLiteStorage,
    DatabaseFactory
)

# Import specialized storage implementations
from .file_storage import FileStorage
from .mongodb_storage import MongoDBStorage

__all__ = [
    'BaseStorage',
    'SQLiteStorage',
    'FileStorage',
    'MongoDBStorage',
    'DatabaseFactory'
]
