# Generated by Django 3.2.12 on 2022-02-20 21:32

from django.db import migrations, models


def update_private_permission_sets(apps, schema_editor):
    PermSet = apps.get_model('restraint', 'PermSet')
    for perm_set in PermSet.objects.all():
        perm_set.is_private = True
        perm_set.save(update_fields=['is_private'])


class Migration(migrations.Migration):

    dependencies = [
        ('restraint', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='permset',
            name='is_private',
            field=models.BooleanField(default=False),
        ),
        migrations.RunPython(update_private_permission_sets)
    ]
