# Git Smart Squash

Transform your messy commit history into clean, logical commits that reviewers will love! 🎯

## Why Use Git Smart Squash?

Ever spent 30 minutes reorganizing commits before a PR? We've all been there. Git Smart Squash uses AI to automatically organize your changes into logical, well-structured commits in seconds.

### ✨ What It Does

**Before** (your typical feature branch):
```
* 7f8d9e0 fix tests
* 6c5b4a3 typo
* 5a4b3c2 more auth changes
* 4d3c2b1 WIP: working on auth
* 3c2b1a0 update tests
* 2b1a0f9 initial auth implementation
```

**After** (AI-organized commits):
```
* a1b2c3d feat: implement complete authentication system with JWT tokens
* e4f5g6h test: add comprehensive test coverage for auth endpoints
```

The AI analyzes your entire diff and groups related changes together, creating clean commit messages that follow conventional commit standards.

## 🚀 Quick Start (2 minutes)

### 1. Install

```bash
pip install git-smart-squash
```

### 2. Set up AI (choose one)

**Option A: Local AI (Free & Private) - Default for Privacy**
```bash
# Install Ollama from https://ollama.com
ollama serve
ollama pull devstral
```

**Option B: Cloud AI (if you have API keys)**
```bash
export OPENAI_API_KEY="your-key"      # or
export ANTHROPIC_API_KEY="your-key"   # or
export GEMINI_API_KEY="your-key"
```

### 3. Use It!

```bash
cd your-git-repo
git checkout your-feature-branch

# Preview what it will do (safe by default!)
git-smart-squash

# Apply the changes when ready
git-smart-squash --apply
```

That's it! Your commits are now beautifully organized. 🎉

## 💡 Common Use Cases

### "I need to clean up before PR review"
```bash
git-smart-squash         # See the plan (dry run by default)
git-smart-squash --apply # Apply it
```

### "I work with a different main branch"
```bash
git-smart-squash --base develop
```

### "I want to use a specific AI provider"
```bash
git-smart-squash --ai-provider openai
```

### "I use the short command"
```bash
gss  # Same as git-smart-squash
```

## 🛡️ Safety First

Don't worry - Git Smart Squash is designed to be safe:

- **Dry run by default** - always shows you the plan first
- **Always creates a backup branch** before making changes
- **Never pushes automatically** - you stay in control
- **Easy recovery** - your original commits are always saved

### If You Need to Undo

```bash
# Your original branch is always backed up
git branch | grep backup  # Find your backup
git reset --hard your-branch-backup-[timestamp]
```

## 🤖 AI Provider Options

| Provider | Cost | Privacy | Setup |
|----------|------|---------|-------|
| **Ollama** (default) | Free | 100% Local | `ollama pull devstral` |
| **OpenAI** | ~$0.01/use | Cloud | Set `OPENAI_API_KEY` |
| **Anthropic** | ~$0.01/use | Cloud | Set `ANTHROPIC_API_KEY` |
| **Gemini** | ~$0.01/use | Cloud | Set `GEMINI_API_KEY` |

The local Ollama option is perfect for most users - it's free, private, and works great!

## ⚙️ Advanced Configuration (Optional)

Want to customize? Create a config file:

**Project-specific** (`.git-smart-squash.yml` in your repo):
```yaml
ai:
  provider: openai  # Use OpenAI for this project
```

**Global default** (`~/.git-smart-squash.yml`):
```yaml
ai:
  provider: local   # Always use local AI by default
```

## 🔍 Troubleshooting

### "Ollama not found"
Install Ollama from https://ollama.com and run:
```bash
ollama serve
ollama pull devstral
```

### "No changes to reorganize"
Make sure you're on your feature branch with uncommitted work:
```bash
git status  # Should show differences from main
```

### "Large diff taking too long"
The AI might timeout on huge changes. Try:
- Breaking your work into smaller chunks
- Using `--base` with a more recent commit

### Need More Help?

Check out our [detailed documentation](https://github.com/your-username/git-smart-squash) or open an issue!

## 📚 Learn More

- **[Installation Options](https://github.com/your-username/git-smart-squash#installation)** - pipx, source install
- **[Advanced Usage](https://github.com/your-username/git-smart-squash/blob/main/FUNCTIONALITY.md)** - all CLI options
- **[How It Works](https://github.com/your-username/git-smart-squash/blob/main/OLLAMA_INTEGRATION.md)** - technical details
- **[Contributing](https://github.com/your-username/git-smart-squash/blob/main/CONTRIBUTING.md)** - help make it better!

## License

MIT License - see [LICENSE](LICENSE) file for details.

---

**Made with ❤️ for developers who want cleaner git history**

*PS: Your git log will never be the same! 🚀*
